/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.dcs.DCS;
import com.ibm.ws.dcs.common.DCSCoreStack;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.DCSMessageListener;
import com.ibm.ws.dcs.common.DCSNotificationsListener;
import com.ibm.ws.dcs.common.MemberAddress;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.ViewChangeEvent;
import com.ibm.ws.dcs.common.ViewChangeListener;
import com.ibm.ws.dcs.common.config.DCSCoreStackConfigMap;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.common.event.DCSInconsistentDefinedSetEvent;
import com.ibm.ws.dcs.common.event.DCSNotifyChangeDefinedDone;
import com.ibm.ws.dcs.common.event.DCSRcvNonDefinedMemberEvent;
import com.ibm.ws.dcs.common.event.DCSStateXchgUpdateEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSCongestionException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidMemberException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.coordinator.StateExchangeListener;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackInfoImpl;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackTransportType;
import com.ibm.ws.hamanager.coordinator.dcs.CoreStackMembershipManager;
import com.ibm.ws.hamanager.coordinator.dcs.DataStackManager;
import com.ibm.ws.hamanager.coordinator.dcs.DefinedSetUpdate;
import com.ibm.ws.hamanager.coordinator.dcs.MemberAuthenticatorImpl;
import com.ibm.ws.hamanager.coordinator.dcs.ProtocolChangeStateVersion;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.coordinator.vsmessages.AttentionRequiredMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupLocalMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.RetryableChainEventListener;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackListener;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class DCSPluginImpl
implements DCSPlugin,
DCSMessageListener,
DCSNotificationsListener,
ViewChangeListener,
RetryableChainEventListener {
    private static String svClassName = DCSPluginImpl.class.getName();
    private static final TraceComponent TC = Tr.register(DCSPluginImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private CoordinatorImpl ivCoordinator;
    private String ivMemberName;
    private String ivCoreGroupName;
    private QoS.QOSUnicast ivUnicastQOS;
    private Comparable ivViewID;
    private String[] ivViewMembers;
    private DCS ivDCS;
    private DCSCoreStack ivCoreStack;
    private boolean ivDefaultCoreStack;
    private CoreStackListener ivCSListener;
    private StateExchangeListener ivSEListener;
    private Map ivFDParms = new HashMap();
    private CoreStackInfoImpl ivCsi;
    private int ivHamWaitCount = 0;
    private CoreStackMembershipManager ivMemberManager;
    private DataStackManager ivDataStackManager;
    private MemberAuthenticatorImpl ivMemberAuthenticator;

    DCSPluginImpl(CoordinatorImpl coordinatorImpl, boolean bl, CoreStackListener coreStackListener, StateExchangeListener stateExchangeListener, CoreStackInfo coreStackInfo, CoreStackMemberInfo[] coreStackMemberInfoArray, StateBlob stateBlob, Version version) throws DataStackException {
        ChannelFrameworkService channelFrameworkService = null;
        this.ivCSListener = coreStackListener;
        this.ivSEListener = stateExchangeListener;
        try {
            CoreStackInfoImpl coreStackInfoImpl;
            this.ivMemberName = coreStackInfo.getServerName();
            this.ivCoreGroupName = coreStackInfo.getName();
            this.ivDefaultCoreStack = bl;
            this.ivCsi = coreStackInfoImpl = (CoreStackInfoImpl)coreStackInfo;
            CoreStackTransportType coreStackTransportType = coreStackInfoImpl.getTransportType();
            this.ivCoordinator = coordinatorImpl;
            this.ivMemberManager = new CoreStackMembershipManager(this.ivCsi, coreStackMemberInfoArray, version);
            this.ivDataStackManager = new DataStackManager();
            this.ivMemberAuthenticator = new MemberAuthenticatorImpl(this.ivCsi);
            DCSCoreStackConfigMap dCSCoreStackConfigMap = this.configCoreStack(coreStackInfoImpl, coreStackMemberInfoArray, stateBlob);
            Class<?> clazz = Class.forName("com.ibm.ws.dcs.vri.DCSImpl");
            this.ivDCS = (DCS)clazz.newInstance();
            this.ivCoreStack = this.ivDCS.getCoreStack(this.ivCoreGroupName, dCSCoreStackConfigMap);
            this.ivUnicastQOS = QoS.getUnicastQoS(QoS.VS_CURRENT, QoS.FIFO);
            this.ivViewMembers = new String[]{this.ivMemberName};
            this.ivCoreStack.setViewChangeListener(this);
            this.ivCoreStack.setHAMessageListener(this);
            this.ivCoreStack.setNotificationListener(this);
            this.ivViewID = this.ivCoreStack.start();
            if (coreStackTransportType.equals(CoreStackTransportType.CHANNEL_FW)) {
                String string = "DCSChannel";
                channelFrameworkService = Providers.getRuntimeProvider().getChannelFramework();
                channelFrameworkService.startChainsByAcceptorID(string, ChainStartMode.RETRY_EACH_ON_FAIL);
                channelFrameworkService.addGroupEventListener((ChainEventListener)this, string);
            }
            Tr.info(TC, "HMGR0001", new Object[]{this.ivCoreGroupName, new Integer(coreStackMemberInfoArray.length)});
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "255", this, new Object[]{channelFrameworkService});
            throw new DataStackException("Failure creating core stack", throwable);
        }
    }

    public Comparable getViewId() {
        return this.ivViewID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateCoreStack() {
        DCSCoreStack dCSCoreStack = null;
        DCSPluginImpl dCSPluginImpl = this;
        synchronized (dCSPluginImpl) {
            dCSCoreStack = this.getCoreStackReference();
            if (dCSCoreStack == null) {
                return;
            }
            this.ivCoreStack = null;
        }
        dCSCoreStack.requestTermination();
    }

    public synchronized int updateCoreStackMembership(CoreStackMemberInfo[] coreStackMemberInfoArray, int n) throws DataStackException {
        DCSCoreStack dCSCoreStack = this.getCoreStackReference();
        if (dCSCoreStack == null) {
            return n;
        }
        try {
            boolean bl = this.isViewLeader();
            DefinedSetUpdate definedSetUpdate = this.ivMemberManager.updateCoreStackMembership(coreStackMemberInfoArray, bl);
            String[] stringArray = definedSetUpdate.getMembersToRemove();
            if (stringArray != null) {
                this.ivDataStackManager.removeDataStackMembers(stringArray);
            }
            if (bl) {
                Map map;
                if (stringArray != null) {
                    dCSCoreStack.removeDefined(stringArray, n++);
                }
                if ((map = definedSetUpdate.getMembersToAdd()) != null) {
                    dCSCoreStack.addDefined(map, n++);
                }
            }
            return n;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "320", this);
            throw new DataStackException("Failure updating membership list", throwable);
        }
    }

    public synchronized int addDefined(CoreStackMemberInfo coreStackMemberInfo, int n) throws DataStackException {
        DCSCoreStack dCSCoreStack = this.getCoreStackReference();
        if (dCSCoreStack == null) {
            return n;
        }
        try {
            boolean bl = this.isViewLeader();
            Map map = this.ivMemberManager.addDefined(coreStackMemberInfo, bl);
            if (bl) {
                dCSCoreStack.addDefined(map, n++);
            }
            return n;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "344", this);
            throw new DataStackException("Failure adding defined member", throwable);
        }
    }

    public synchronized int removeDefined(String string, int n) throws DataStackException {
        DCSCoreStack dCSCoreStack = this.getCoreStackReference();
        if (dCSCoreStack == null) {
            return n;
        }
        try {
            boolean bl = this.isViewLeader();
            String[] stringArray = this.ivMemberManager.removeDefined(string, bl);
            this.ivDataStackManager.removeDataStackMembers(stringArray);
            if (bl) {
                dCSCoreStack.removeDefined(stringArray, n++);
            }
            return n;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "368", this);
            throw new DataStackException("Failure removing defined member", throwable);
        }
    }

    public synchronized void updateProtocolVersion(String string) throws DataStackException {
        DCSCoreStack dCSCoreStack = this.getCoreStackReference();
        if (dCSCoreStack == null) {
            return;
        }
        try {
            Object[] objectArray;
            int n = dCSCoreStack.getDCSProtocolVersion();
            int n2 = this.mapProtocolVersion(string);
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
                Tr.debug(TC, "updateProtocolVersion - map", objectArray);
            }
            if (n == n2) {
                return;
            }
            objectArray = new ProtocolChangeStateVersion(this.ivMemberName);
            boolean bl = this.isViewLeader();
            if (bl) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateProtocolVersion", new Object[]{new Integer(n2), objectArray});
                }
                this.ivCoreStack.setDCSProtocolVersion(n2, (StateVersion)objectArray);
            }
            this.ivDataStackManager.setDataStackProtocolVersion(n2, (StateVersion)objectArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "343", this);
            Tr.error(TC, "HMGR0108", new Object[]{"DCSPluginImpl", "updateProtocolVersion", throwable});
            throw new DataStackException("unrecoverable exception", throwable);
        }
    }

    public synchronized Set getCoreGroupMembers() {
        return this.ivMemberManager.getCoreGroupMembers();
    }

    public synchronized void sendMessage(String string, HAMMessage hAMMessage) throws DataStackException {
        if (string == null) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("message destination is null");
            throw new DataStackException("internal error", hAInternalStateException);
        }
        String[] stringArray = new String[]{string};
        this.sendMessage(stringArray, hAMMessage);
    }

    public synchronized void sendMessage(String[] stringArray, HAMMessage hAMMessage) throws DataStackException {
        DCSCoreStack dCSCoreStack;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "SendMessage - DCSPluginImpl", this.ivCoreStack);
        }
        if ((dCSCoreStack = this.getCoreStackReference()) == null) {
            return;
        }
        try {
            int n = stringArray.length;
            try {
                block7: for (int i = 0; i < n; ++i) {
                    DCSMessage dCSMessage = dCSCoreStack.createMessage();
                    dCSMessage.writeObject(hAMMessage);
                    while (true) {
                        try {
                            dCSCoreStack.sendMessage(stringArray[i], 2, dCSMessage, this.ivUnicastQOS, this.ivViewID);
                            continue block7;
                        }
                        catch (DCSCongestionException dCSCongestionException) {
                            FFDCFilter.processException((Throwable)dCSCongestionException, svClassName, "378", this);
                            Thread.currentThread();
                            Thread.yield();
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (DCSInvalidMemberException dCSInvalidMemberException) {
                FFDCFilter.processException((Throwable)dCSInvalidMemberException, svClassName, "386", this);
            }
        }
        catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
            FFDCFilter.processException((Throwable)dCSInvalidViewIDException, svClassName, "391", this);
            throw new DataStackMembershipChangingException("membership is changing", dCSInvalidViewIDException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "395", this);
            Tr.error(TC, "HMGR0122", new Object[]{hAMMessage.getDescription(), throwable});
            if (throwable instanceof OutOfMemoryError) {
                this.sendAttentionReqMsg("HMGR0122");
            }
            throw new DataStackException("unrecoverable exception", throwable);
        }
    }

    public synchronized void sendGroupMessage(MsgQoS msgQoS, String[] stringArray, GroupLocalMessage groupLocalMessage) throws DataStackException {
        DCSCoreStack dCSCoreStack;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "SendMessage - DCSPluginImpl");
        }
        if ((dCSCoreStack = this.getCoreStackReference()) == null) {
            return;
        }
        try {
            DCSMessage dCSMessage = dCSCoreStack.createMessage();
            dCSMessage.writeObject(groupLocalMessage);
            QoS.QOSMulticast qOSMulticast = this.getMulticastQoS(msgQoS);
            while (true) {
                try {
                    if (qOSMulticast.getGuaranteeType().equals(QoS.VS_CURRENT)) {
                        dCSCoreStack.sendMessage(stringArray, 2, dCSMessage, qOSMulticast, this.ivViewID);
                    } else {
                        dCSCoreStack.sendMessage(stringArray, 2, dCSMessage, qOSMulticast);
                    }
                }
                catch (DCSCongestionException dCSCongestionException) {
                    FFDCFilter.processException((Throwable)dCSCongestionException, svClassName, "433", this);
                    Thread.currentThread();
                    Thread.yield();
                    continue;
                }
                break;
            }
        }
        catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
            FFDCFilter.processException((Throwable)dCSInvalidViewIDException, svClassName, "440", this);
            throw new DataStackMembershipChangingException("membership is changing", dCSInvalidViewIDException);
        }
        catch (DCSInvalidMemberException dCSInvalidMemberException) {
            FFDCFilter.processException((Throwable)dCSInvalidMemberException, svClassName, "444", this);
            throw new DataStackMemberException("problem with a member", dCSInvalidMemberException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "448", this);
            Tr.error(TC, "HMGR0122", new Object[]{groupLocalMessage.getDescription(), throwable});
            throw new DataStackException("unrecoverable exception", throwable);
        }
    }

    public void handleViewChangeEvent(ViewChangeEvent viewChangeEvent, Comparable comparable) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "handleViewChangeEvent", new Object[]{viewChangeEvent, comparable});
        }
        DCSCoreStack dCSCoreStack = this.getCoreStackReference();
        switch (viewChangeEvent.getEventType()) {
            case 5: {
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{dCSCoreStack, new Boolean(this.ivDefaultCoreStack)};
                    Tr.debug(TC, "handleViewChangeEvent - TERMINATE", objectArray);
                }
                if (dCSCoreStack == null) {
                    this.ivCSListener.terminated(0);
                    break;
                }
                this.ivCSListener.terminated(1);
                break;
            }
            case 1: {
                if (dCSCoreStack == null) {
                    return;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "handleViewChangeEvent - COMPLETE_CURRENT", new Boolean(this.ivDefaultCoreStack));
                }
                this.ivCSListener.viewAboutToChange();
                this.ivCoordinator.viewAboutToChange();
                dCSCoreStack.handleViewChangeEventDone(viewChangeEvent);
                break;
            }
            case 4: {
                if (dCSCoreStack == null) {
                    return;
                }
                String[] stringArray = viewChangeEvent.getMembersNames();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "handleViewChangeEvent - NEW_VIEW_OK", new Object[]{this.ivViewID, comparable, new Boolean(this.ivDefaultCoreStack)});
                    Tr.debug(TC, "display old view with " + this.ivViewMembers.length + " members", this.ivViewMembers);
                    Tr.debug(TC, "display new view with " + stringArray.length + " members", stringArray);
                }
                this.ivViewID = comparable;
                this.ivViewMembers = stringArray;
                Arrays.sort(this.ivViewMembers);
                this.ivCoordinator.viewChangeCompleted(comparable, this.ivViewMembers);
                this.ivCSListener.viewChangeCompleted(this.ivViewMembers);
                dCSCoreStack.handleViewChangeEventDone(viewChangeEvent);
                break;
            }
            default: {
                Tr.error(TC, "HMGR0219", new Object[]{this.ivViewID, viewChangeEvent});
                return;
            }
        }
    }

    public synchronized void setStateExchangeBlob(StateBlob stateBlob) throws DataStackException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "setStateExchangeBlob", stateBlob);
        }
        try {
            DCSCoreStack dCSCoreStack = this.getCoreStackReference();
            if (dCSCoreStack == null) {
                return;
            }
            dCSCoreStack.setState(stateBlob);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "540", this);
            throw new DataStackException("Exception doing State Exchange", throwable);
        }
    }

    public synchronized void setSharedSecret(String string) {
        this.ivMemberAuthenticator.setSharedSecret(string);
    }

    public Throwable check() {
        return null;
    }

    public void onMessage(DCSMessage dCSMessage) {
        block7: {
            try {
                if (TC.isEntryEnabled()) {
                    Tr.entry(TC, "onMessage()", dCSMessage);
                }
                HAMMessage hAMMessage = (HAMMessage)dCSMessage.readObject();
                String string = hAMMessage.getSender();
                this.ivCoordinator.onMessage(string, hAMMessage);
                if (TC.isEntryEnabled()) {
                    Tr.exit(TC, "onMessage()");
                }
                if (this.ivCoordinator.outboundMessagesWaiting()) {
                    ++this.ivHamWaitCount;
                    if (this.ivHamWaitCount > 2) {
                        this.ivHamWaitCount = 0;
                        Thread.currentThread();
                        Thread.yield();
                    } else {
                        this.ivHamWaitCount = 0;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "594", this);
                Tr.error(TC, "HMGR0204", new Object[]{dCSMessage, throwable});
                if (!(throwable instanceof OutOfMemoryError)) break block7;
                this.sendAttentionReqMsg("HMGR0204");
            }
        }
    }

    public void notifyEvent(DCSExternalEvent dCSExternalEvent) {
        Object object;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "notifyEvent", new Object[]{dCSExternalEvent.getClass().getName(), dCSExternalEvent});
        }
        if (dCSExternalEvent instanceof DCSTerminationEvent) {
            object = this.getCoreStackReference();
            if (object == null) {
                return;
            }
            DCSTerminationEvent dCSTerminationEvent = (DCSTerminationEvent)dCSExternalEvent;
            Throwable throwable = dCSTerminationEvent.getTerminationReason();
        }
        if (dCSExternalEvent instanceof DCSInconsistentDefinedSetEvent) {
            object = (DCSInconsistentDefinedSetEvent)dCSExternalEvent;
            this.ivCSListener.inconsistentDefinedMembers(object.getMyset(), object.getSentSet());
            return;
        }
        if (dCSExternalEvent instanceof DCSNotifyChangeDefinedDone) {
            object = (DCSNotifyChangeDefinedDone)dCSExternalEvent;
            this.ivCSListener.changeDefinedCompleted(object.getContext());
            return;
        }
        if (dCSExternalEvent instanceof DCSRcvNonDefinedMemberEvent) {
            object = (DCSRcvNonDefinedMemberEvent)dCSExternalEvent;
            this.ivCSListener.undefinedMember(object.getBadMemberName(), null, 0);
            return;
        }
        if (dCSExternalEvent instanceof DCSStateXchgUpdateEvent) {
            if (this.ivSEListener != null) {
                object = (DCSStateXchgUpdateEvent)dCSExternalEvent;
                this.ivSEListener.stateReceived(object.getState());
            } else if (TC.isDebugEnabled()) {
                Tr.debug(TC, "notifyEvent", "ERROR: StateExchange on non-default core stack");
            }
        }
    }

    public void chainStartFailed(ChainData chainData, int n, int n2) {
        if (n2 == 0) {
            String string = chainData.getName();
            Tr.error(TC, "HMGR0157", new Object[]{string, new Integer(n)});
            this.ivCoordinator.getJVMController().panicJVM("The DCS chain failed to start, all retries exhausted");
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
    }

    public void chainStopped(ChainData chainData) {
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    public MemberInfoManager getMemberProvider() throws DataStackException {
        return this.ivCoreStack;
    }

    public DataStack createDataStack(String string, boolean bl, HAGroupImpl hAGroupImpl, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback, String[] stringArray) throws DataStackException {
        return this.ivDataStackManager.createDataStack(string, this.ivDCS, this, bl, hAGroupImpl, this.ivCsi, this.ivFDParms, dataStackCallback, syncDataReqCallback, stringArray);
    }

    public void deleteDataStack(String string) {
        this.ivDataStackManager.removeDataStack(string);
    }

    public void sendAttentionReqMsg(String string) {
        block4: {
            try {
                DCSCoreStack dCSCoreStack;
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Attempting to send AttentionRequired message to all members in the view.");
                }
                if ((dCSCoreStack = this.getCoreStackReference()) == null) {
                    return;
                }
                AttentionRequiredMsg attentionRequiredMsg = new AttentionRequiredMsg();
                attentionRequiredMsg.setSender(this.ivMemberName);
                attentionRequiredMsg.setReasonMsgID(string);
                DCSMessage dCSMessage = dCSCoreStack.createMessage(512);
                dCSMessage.writeObject(attentionRequiredMsg);
                dCSCoreStack.mcastMessage(2, dCSMessage);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "866", this);
                if (!TC.isDebugEnabled()) break block4;
                Tr.debug(TC, "The attempt to send an AttentionRequired message failed.", throwable);
            }
        }
    }

    private DCSCoreStackConfigMap configCoreStack(CoreStackInfoImpl coreStackInfoImpl, CoreStackMemberInfo[] coreStackMemberInfoArray, StateBlob stateBlob) throws HAException, ChannelFrameworkException {
        DCSCoreStackConfigMap dCSCoreStackConfigMap = new DCSCoreStackConfigMap();
        dCSCoreStackConfigMap.put("ThisMemberName", this.ivMemberName);
        Map map = this.ivMemberManager.getDefinedSet();
        dCSCoreStackConfigMap.put("DefinedSet", map);
        dCSCoreStackConfigMap.put("AddressResolver", this.ivMemberManager);
        if (stateBlob != null) {
            dCSCoreStackConfigMap.put("StateBlobInitialConfiguration", stateBlob);
        }
        int n = coreStackInfoImpl.getNumberOfThreads();
        int n2 = n / 4;
        int n3 = n - n2;
        dCSCoreStackConfigMap.put("DcsThreadsNum", new Integer(n3));
        this.configureTransport(coreStackInfoImpl, dCSCoreStackConfigMap, n2);
        dCSCoreStackConfigMap.put("FailureDetectorType", "BasicHBT");
        this.ivFDParms.put("HBTTimeoutPeriod", new Integer(coreStackInfoImpl.getFailureDetectorTimeout()));
        this.ivFDParms.put("HBTTransmissionIntervalMilliSec", new Integer(coreStackInfoImpl.getFailureDetectorTransmissionInterval()));
        dCSCoreStackConfigMap.put("FailureDetectorParameters", this.ivFDParms);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("useVirtualSynchronyMessaging", new Boolean(true));
        hashMap.put("enableVerificationMode", new Boolean(coreStackInfoImpl.getEnableTransportDiagnostics()));
        dCSCoreStackConfigMap.put("StackConstruction", hashMap);
        dCSCoreStackConfigMap.put("ExpectedBringupTimeSec", new Integer(coreStackInfoImpl.getMemberBringupTimeSecs()));
        dCSCoreStackConfigMap.put("CompletenessVsSpeed", new Integer(coreStackInfoImpl.getCompletenessVsSpeed()));
        int n4 = coreStackInfoImpl.getDataStackMemory();
        dCSCoreStackConfigMap.put("MaxStackMemoryMB", new Integer(n4));
        dCSCoreStackConfigMap.put("UseBufferPool", new Boolean(coreStackInfoImpl.getUsePooledMemory()));
        dCSCoreStackConfigMap.put("MessagingDirection", "Both");
        dCSCoreStackConfigMap.put("ExpectedMessagePayloadSizeBytes", new Integer(coreStackInfoImpl.getExpectedMessageSize()));
        String string = (String)coreStackInfoImpl.getProtocolVersions().get("DCS_PROTOCOL");
        int n5 = this.mapProtocolVersion(string);
        dCSCoreStackConfigMap.put("DCSProtocolVersion", new Integer(n5));
        dCSCoreStackConfigMap.put("CheckConfiguration", new Boolean(coreStackInfoImpl.getEnableCoreStackConfigChecks()));
        return dCSCoreStackConfigMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureTransport(CoreStackInfoImpl coreStackInfoImpl, DCSCoreStackConfigMap dCSCoreStackConfigMap, int n) throws HAException, ChannelFrameworkException {
        MemberAddress memberAddress = this.ivMemberManager.getAddress(this.ivMemberName);
        int n2 = this.ivMemberManager.getLocalBindingOption();
        String string = null;
        string = n2 == 2 ? "*" : memberAddress.getIp();
        String string2 = new Integer(memberAddress.getPort()).toString();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("TransportDirection", "Both");
        hashMap.put("MaxInstanceMemoryMbytes", new Integer(coreStackInfoImpl.getMaximumTransportMemorySize()));
        hashMap.put("NominalInstanceMemoryMbytes", new Integer(coreStackInfoImpl.getTransportBufferSize()));
        hashMap.put("SocketBufferSize", new Integer(coreStackInfoImpl.getSocketBufferSize()));
        hashMap.put("MessageAnnouncerThreadsNumber", new Integer(n));
        CoreStackTransportType coreStackTransportType = coreStackInfoImpl.getTransportType();
        if (coreStackTransportType.equals(CoreStackTransportType.MULTICAST)) {
            dCSCoreStackConfigMap.put("TransportType", "RealMulticast");
            Integer n3 = new Integer(coreStackInfoImpl.getMultiCastPort());
            String string3 = coreStackInfoImpl.getMulticastGroupRangeStart();
            String string4 = coreStackInfoImpl.getMultiCastGroupRangeEnd();
            int n4 = coreStackInfoImpl.getMultiCastTTL();
            hashMap.put("MulticastDataPort", n3);
            hashMap.put("MulticastGroupRangeStart", string3);
            hashMap.put("MulticastGroupRangeEnd", string4);
            hashMap.put("MulticastTTL", new Integer(n4));
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{string3, string4, n3, new Integer(n4)};
                Tr.debug(TC, "Configuring multicast", objectArray);
            }
            Tr.info(TC, "HMGR0006", new Object[]{this.ivCoreGroupName, string, n3, "Multicast"});
        } else {
            int n5 = coreStackInfoImpl.getDiscoveryIntervalSecs();
            int n6 = coreStackInfoImpl.getFirewallDiscoveryIntervalSecs();
            hashMap.put("MbuBasicDiscoveryIntervalSec", new Integer(n5));
            hashMap.put("MbuFwDiscoveryIntervalSec", new Integer(n6));
            hashMap.put("MbuMaxTokenSize", new Integer(coreStackInfoImpl.getSharedSecretTokenSize()));
            hashMap.put("MbuMemberAuthenticator", this.ivMemberAuthenticator);
            if (coreStackTransportType.equals(CoreStackTransportType.UNICAST)) {
                dCSCoreStackConfigMap.put("TransportType", "MulticastByUnicast");
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{new Integer(n5), new Integer(n6)};
                    Tr.debug(TC, "Configuring base unicast", objectArray);
                }
                Tr.info(TC, "HMGR0006", new Object[]{this.ivCoreGroupName, string, string2, "Unicast"});
            } else {
                if (!coreStackTransportType.equals(CoreStackTransportType.CHANNEL_FW)) throw new HAException("invalid transport type " + coreStackTransportType);
                CFEndPoint cFEndPoint = null;
                ChannelFrameworkService channelFrameworkService = Providers.getRuntimeProvider().getChannelFramework();
                try {
                    Object[] objectArray;
                    String string5 = coreStackInfoImpl.getChannelChainName();
                    cFEndPoint = channelFrameworkService.getEndPoint(string5);
                    if (cFEndPoint == null) {
                        String string6 = "Lookup of ChannelFramework CFEndpoint for chain " + string5 + " returned null";
                        throw new HAException(string6);
                    }
                    this.configureOutboundChain(string5, channelFrameworkService, cFEndPoint);
                    WSVirtualConnectionFactory wSVirtualConnectionFactory = null;
                    if (!cFEndPoint.isSSLEnabled()) {
                        wSVirtualConnectionFactory = cFEndPoint.getOutboundVCFactory();
                    } else {
                        Tr.info(TC, "HMGR0148", this.ivCoreGroupName);
                        objectArray = coreStackInfoImpl.getSSLProperties();
                        wSVirtualConnectionFactory = objectArray != null ? cFEndPoint.getOutboundVCFactory((Map)objectArray, true) : cFEndPoint.getOutboundVCFactory();
                    }
                    dCSCoreStackConfigMap.put("TransportType", "ChannelFramework");
                    hashMap.put("ChannelFrameWorkObject", channelFrameworkService);
                    hashMap.put("TcpChannelVCF", wSVirtualConnectionFactory);
                    if (TC.isDebugEnabled()) {
                        objectArray = new Object[]{channelFrameworkService, wSVirtualConnectionFactory, new Integer(n5), new Integer(n6)};
                        Tr.debug(TC, "Configuring channel framework", objectArray);
                    }
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    FFDCFilter.processException(channelFrameworkException, svClassName, "926", this, new Object[]{channelFrameworkService, cFEndPoint});
                    throw channelFrameworkException;
                }
            }
        }
        dCSCoreStackConfigMap.put("TransportConfiguration", hashMap);
    }

    private synchronized DCSCoreStack getCoreStackReference() {
        DCSCoreStack dCSCoreStack = this.ivCoreStack;
        if (dCSCoreStack == null && TC.isDebugEnabled()) {
            Tr.debug(TC, "coreStackAlreadyTerminated");
        }
        return dCSCoreStack;
    }

    private QoS.QOSMulticast getMulticastQoS(MsgQoS msgQoS) throws DCSException, DataStackException {
        if (msgQoS == MsgQoS.NONE) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL_NOSELF) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO, QoS.WITHOUT_SELF_DELIVERY);
        }
        if (msgQoS == MsgQoS.VS_CURRENT) {
            return QoS.getMulticastQoS(QoS.VS_CURRENT, QoS.FIFO);
        }
        throw new DataStackException("Invalid QoS type " + msgQoS + " specified ");
    }

    private boolean isViewLeader() throws DataStackException {
        try {
            String string = Providers.getConfigProvider().calculateViewLeader(this.ivViewMembers);
            boolean bl = this.ivMemberName.equals(string);
            return bl;
        }
        catch (HAException hAException) {
            throw new DataStackException("Failure calculating view leader", hAException);
        }
    }

    private void configureOutboundChain(String string, ChannelFrameworkService channelFrameworkService, CFEndPoint cFEndPoint) {
        try {
            ChainData chainData = channelFrameworkService.getChain(string);
            ChannelData[] channelDataArray = chainData.getChannelList();
            ChannelData channelData = channelDataArray[0];
            String string2 = channelData.getName();
            Map map = channelData.getPropertyBag();
            String string3 = (String)map.get("threadPoolName");
            if (string3 == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "WARNING: No thread pool configured for DCS inbound TCP channel.");
                }
                return;
            }
            WSChainData wSChainData = cFEndPoint.createOutboundChain();
            channelDataArray = wSChainData.getChannelList();
            ChannelData channelData2 = channelDataArray[channelDataArray.length - 1];
            String string4 = channelData2.getName();
            channelFrameworkService.updateChannelProperty(string4, "threadPoolName", string3);
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{string2, string4, string3};
                Tr.debug(TC, "configureOutboundChain", objectArray);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1033", this);
            Object[] objectArray = new Object[]{"DCSPluginImpl", "configureOutboundChain", throwable};
            Tr.error(TC, "HMGR0108", objectArray);
        }
    }

    private int mapProtocolVersion(String string) {
        int n = Version.getDCSProtocolVersionMapping(string);
        if (n < 10) {
            return 51001;
        }
        return 61002;
    }

    private String dumpView(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" : ");
        try {
            stringBuffer.append("View ID = ");
            stringBuffer.append(this.ivViewID);
            int n = this.ivViewMembers.length;
            stringBuffer.append(", View contains " + n + " Members : ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.ivViewMembers[i]);
                stringBuffer.append(" ");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1063", this);
            stringBuffer.append("... Error");
        }
        return stringBuffer.toString();
    }
}

