/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.coordinator.impl.DCSPluginImpl;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupLocalMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.SingleServerDataStackImpl;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackAlreadyCreatedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DCSPluginSingleServerImpl
implements DCSPlugin {
    private static String svClassName = DCSPluginImpl.class.getName();
    private static final TraceComponent TC = Tr.register(DCSPluginSingleServerImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private CoordinatorImpl ivCoordinator;
    private String ivCoreGroupName;
    private String ivServerName;
    private Comparable ivViewID;
    private String[] ivViewMembers;
    private Map ivDataStacks;
    private ArrayList ivMessageQueue;
    Thread ivDeliveryThread;
    private boolean ivServerShuttingDown = false;

    DCSPluginSingleServerImpl(CoordinatorImpl coordinatorImpl, String string, String string2) throws DataStackException {
        try {
            this.ivCoordinator = coordinatorImpl;
            this.ivCoreGroupName = string;
            this.ivServerName = string2;
            this.ivViewID = "1.0 Single Server View";
            this.ivViewMembers = new String[]{this.ivServerName};
            this.ivDataStacks = new HashMap();
            this.ivMessageQueue = new ArrayList();
            this.ivDeliveryThread = new Thread((Runnable)new DeliveryThread(), "DCS Plugin Delivery Thread");
            this.ivDeliveryThread.setDaemon(true);
            this.ivDeliveryThread.start();
            Tr.info(TC, "HMGR0005", this.ivCoreGroupName);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "94", this);
            throw new DataStackException("Failure creating core stack", throwable);
        }
    }

    public Comparable getViewId() {
        return this.ivViewID;
    }

    public void setStateExchangeBlob(StateBlob stateBlob) throws DataStackException {
        throw new DataStackException("StateExchange not supported on single server");
    }

    public int addDefined(CoreStackMemberInfo coreStackMemberInfo, int n) throws DataStackException {
        throw new DataStackException("addDefined not allowed on a single server");
    }

    public int removeDefined(String string, int n) throws DataStackException {
        throw new DataStackException("removeDefined not allowed on a single server");
    }

    public int updateCoreStackMembership(CoreStackMemberInfo[] coreStackMemberInfoArray, int n) throws DataStackException {
        throw new DataStackException("Updating core stack membership not possible on single server");
    }

    public void updateProtocolVersion(String string) throws DataStackException {
        throw new DataStackException("Updating protocol version not possible on single server");
    }

    public Set getCoreGroupMembers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.ivServerName);
        return Collections.unmodifiableSet(hashSet);
    }

    public void setSharedSecret(String string) {
    }

    public synchronized void sendMessage(String string, HAMMessage hAMMessage) throws DataStackException {
        if (this.ivServerShuttingDown) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Received a message to send, but we're shutting down. Throwing the data out.", hAMMessage);
            }
            return;
        }
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "SendMessage - Plugin Type = DCSPluginSingleServerImpl");
        }
        if (!this.ivServerName.equals(string)) {
            throw new DataStackException("Cannot send message to " + string + ", not this server (single server");
        }
        this.serializeAndSendMessage(hAMMessage);
    }

    public synchronized void sendMessage(String[] stringArray, HAMMessage hAMMessage) throws DataStackException {
        this.sendMessage(this.ivServerName, hAMMessage);
    }

    public void sendGroupMessage(MsgQoS msgQoS, String[] stringArray, GroupLocalMessage groupLocalMessage) throws DataStackException {
        if (stringArray == null || stringArray.length != 1) {
            throw new DataStackException("Invalid number of destinations");
        }
        this.sendMessage(stringArray[0], (HAMMessage)groupLocalMessage);
    }

    public void terminateCoreStack() {
        this.ivServerShuttingDown = true;
    }

    public MemberInfoManager getMemberProvider() throws DataStackException {
        throw new DataStackException("getMemberProvider not allowed on single server");
    }

    public DataStack createDataStack(String string, boolean bl, HAGroupImpl hAGroupImpl, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback, String[] stringArray) throws DataStackException {
        DataStack dataStack = (DataStack)this.ivDataStacks.get(string);
        if (dataStack != null) {
            throw new DataStackAlreadyCreatedException("A data stack with name " + string + " already exists");
        }
        dataStack = new SingleServerDataStackImpl(string, dataStackCallback, syncDataReqCallback, hAGroupImpl);
        this.ivDataStacks.put(string, dataStack);
        return dataStack;
    }

    public void deleteDataStack(String string) {
        this.ivDataStacks.remove(string);
    }

    public void sendAttentionReqMsg(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeAndSendMessage(HAMMessage hAMMessage) {
        ArrayList arrayList = this.ivMessageQueue;
        synchronized (arrayList) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(hAMMessage);
                objectOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.ivMessageQueue.add(byArray);
                this.ivMessageQueue.notify();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "215", this);
                System.out.println("FAILURE serializing message");
                throwable.printStackTrace(System.out);
            }
        }
    }

    private HAMMessage receiveAndDeserializeMessage(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        HAMMessage hAMMessage = (HAMMessage)objectInputStream.readObject();
        return hAMMessage;
    }

    private class DeliveryThread
    implements Runnable {
        private DeliveryThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!DCSPluginSingleServerImpl.this.ivServerShuttingDown) {
                try {
                    HAMMessage hAMMessage = null;
                    Object object = DCSPluginSingleServerImpl.this.ivMessageQueue;
                    synchronized (object) {
                        if (DCSPluginSingleServerImpl.this.ivMessageQueue.size() == 0) {
                            DCSPluginSingleServerImpl.this.ivMessageQueue.wait();
                        }
                        if (DCSPluginSingleServerImpl.this.ivServerShuttingDown) {
                            return;
                        }
                        byte[] byArray = (byte[])DCSPluginSingleServerImpl.this.ivMessageQueue.remove(0);
                        hAMMessage = DCSPluginSingleServerImpl.this.receiveAndDeserializeMessage(byArray);
                    }
                    object = hAMMessage.getSender();
                    DCSPluginSingleServerImpl.this.ivCoordinator.onMessage((String)object, hAMMessage);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, svClassName, "272", this);
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }
}

