/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.JMXCmdFailedException;
import com.ibm.websphere.hamanager.jmx.JMXTimedOutException;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.RPCResponseCollector;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXCoordinatorRPCMsg;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GenericCoordinatorMBean
extends RuntimeCollaborator {
    private static final String svClassName = GenericCoordinatorMBean.class.getName();
    protected static final TraceComponent TC = Tr.register(GenericCoordinatorMBean.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    CoordinatorImpl coordinator;
    String ivCellName;

    public GenericCoordinatorMBean(CoordinatorImpl coordinatorImpl) {
        this.coordinator = coordinatorImpl;
        this.ivCellName = AdminServiceFactory.getAdminService().getCellName();
    }

    public CoordinatorImpl getCoordinator() {
        return this.coordinator;
    }

    public String getCellName() {
        return this.ivCellName;
    }

    public Map rpcToActiveCoordinators(JMXCoordinatorRPCMsg jMXCoordinatorRPCMsg) {
        return this.processRPCrequest(this.coordinator.getActiveCoordinatorSet(), jMXCoordinatorRPCMsg);
    }

    public Map rpcToActiveCoordinator(String string, JMXCoordinatorRPCMsg jMXCoordinatorRPCMsg) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.processRPCrequest(hashSet, jMXCoordinatorRPCMsg);
    }

    private synchronized Map processRPCrequest(Set set, JMXCoordinatorRPCMsg jMXCoordinatorRPCMsg) {
        int n;
        RPCResponseCollector rPCResponseCollector = new RPCResponseCollector(set);
        this.coordinator.setClusterStateHolder(rPCResponseCollector);
        jMXCoordinatorRPCMsg.setCshVersion(rPCResponseCollector.getRequestID());
        try {
            n = Providers.getConfigProvider().getJMXCommandTimeout();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "131", this);
            n = 20;
        }
        int n2 = n / 2;
        if (TC.isEventEnabled()) {
            Tr.debug(TC, "JMX Command Timeout = " + n + " seconds (loop retries=" + n2 + ")");
        }
        try {
            RPCResponseCollector rPCResponseCollector2 = rPCResponseCollector;
            synchronized (rPCResponseCollector2) {
                if (set.size() == 1) {
                    this.coordinator.sendMessage((String)set.iterator().next(), (HAMMessage)jMXCoordinatorRPCMsg);
                } else {
                    this.coordinator.sendMessageToActiveCoordinators(jMXCoordinatorRPCMsg);
                }
                for (int i = n2; i >= 0; --i) {
                    if (!rPCResponseCollector.waitForCompletion(2000L)) continue;
                    this.coordinator.setClusterStateHolder(null);
                    return rPCResponseCollector.getCoordinatorResponses();
                }
                this.coordinator.setClusterStateHolder(null);
                throw new JMXTimedOutException();
            }
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "179", this);
            throw new JMXCmdFailedException("No active coordinators could be found.", hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "183", this);
            throw new JMXCmdFailedException("View is changing.  Retry command after view has settled.", dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "187", this);
            throw new JMXCmdFailedException("A send message problem has occured.", dataStackException);
        }
    }
}

