/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.BulletinBoardSubjectSnapshot;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.IndirectSubjectToPostMap;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.GlobalBulletinBoardStateManager;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.SubscriberUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.BulletinBoardSnapshotMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.BulletinBoardSubjectSnapshotImpl;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.bboard.BridgeFailoverEnablementListener;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardListener;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlobalBBoardBifurcatedStateManager
extends GlobalBulletinBoardStateManager {
    private static final TraceComponent TC = Tr.register(GlobalBBoardBifurcatedStateManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "GlobalBBoardBifurcatedStateManager";
    private CoordinatorImpl ivCoordinator;
    private boolean ivGlobalStateRebuildInProgress = true;
    private boolean ivBridgeRebuildInProgress = true;
    private boolean ivPendingBuildBridgeStateMessagesForGSR = false;
    private long ivRebuildStartTime;
    private IndirectSubjectToPostMap ivLocalSubjectDataMap;
    private IndirectSubjectToPostMap ivBridgeSubjectDataMap;
    private Map ivBridgeSubjectCoherencyTracker;
    private Map ivLocalSubscriptionsMap;
    private Map ivBridgeSubscriptionsMap;
    private Map ivUpdatesCache;
    private Map ivInitialSubscriberEmptySubjectCache;
    private Map ivUnsentGSRMessages;
    MessageCache ivMessageCache;
    Version ivProtocolVersion;
    private boolean ivCurrentlyActive;
    private BridgeStateManager ivBridgeStateManager;
    private Set ivCoreGroupMembers;
    private String[] ivActiveCoordinators;
    private Set ivLastSetOfBridgesCallbackWasMadeFor = null;
    private Set ivPreviouslyFiredActiveCoordinatorChange = null;

    GlobalBBoardBifurcatedStateManager(CoordinatorImpl coordinatorImpl, MessageCache messageCache, boolean bl, Version version, Set set, String[] stringArray) {
        this.ivActiveCoordinators = stringArray == null ? new String[0] : stringArray;
        this.ivCoordinator = coordinatorImpl;
        this.ivLocalSubjectDataMap = new IndirectSubjectToPostMap();
        this.ivBridgeSubjectDataMap = new IndirectSubjectToPostMap();
        this.ivInitialSubscriberEmptySubjectCache = new HashMap();
        this.ivLocalSubscriptionsMap = new TreeMap();
        this.ivBridgeSubscriptionsMap = new TreeMap();
        this.ivUnsentGSRMessages = new HashMap();
        this.ivUpdatesCache = new HashMap();
        this.ivMessageCache = messageCache;
        this.ivGlobalStateRebuildInProgress = false;
        this.ivListeners = new ArrayList(1);
        this.ivCurrentlyActive = bl;
        this.ivProtocolVersion = version;
        this.ivBridgeStateManager = new BridgeStateManager(this);
        this.ivCoreGroupMembers = set;
        this.ivBridgeSubjectCoherencyTracker = new HashMap();
        this.setWireProtocol();
    }

    public void installNewView(String[] stringArray, boolean bl, boolean bl2, String[] stringArray2) {
        this.ivActiveCoordinators = stringArray2;
        if (bl2) {
            this.ivBridgeStateManager.installNewView(stringArray, bl);
        }
    }

    void updateCoreGroupMembership(Set set) {
        this.ivCoreGroupMembers = set;
    }

    void fireActiveCoordinatorChange(Set set) {
        if (!this.ivListeners.isEmpty()) {
            boolean bl = true;
            if (this.ivPreviouslyFiredActiveCoordinatorChange != null && this.ivPreviouslyFiredActiveCoordinatorChange.size() == set.size() && this.ivPreviouslyFiredActiveCoordinatorChange.containsAll(set)) {
                bl = false;
            }
            Object[] objectArray = new Object[]{new Boolean(bl)};
            Tr.event(TC, "fireActiveCoordinatorChange - with registered listeners", objectArray);
            if (bl) {
                this.ivPreviouslyFiredActiveCoordinatorChange = new HashSet(set);
                ListenerCallback listenerCallback = new ListenerCallback(5, this.ivListeners, this.ivPreviouslyFiredActiveCoordinatorChange);
                UserCallbacks.executeCallback(listenerCallback);
            }
        } else {
            Tr.event(TC, "fireActiveCoordinatorChange - no registered listeners");
        }
    }

    synchronized boolean sendCachedMessages() {
        if (this.ivGlobalStateRebuildInProgress) {
            return false;
        }
        return this.doSendCachedMessages();
    }

    synchronized void startGSR(boolean bl) {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Rebuild is initiated", new Object[]{new Boolean(this.ivCurrentlyActive), new Boolean(bl)});
        }
        this.ivLocalSubjectDataMap.clear();
        this.ivBridgeSubjectDataMap.clear();
        this.ivLocalSubscriptionsMap.clear();
        this.ivBridgeSubscriptionsMap.clear();
        this.ivUnsentGSRMessages.clear();
        this.ivUpdatesCache.clear();
        this.setWireProtocol();
        if (this.ivCurrentlyActive && !bl) {
            if (this.ivListeners.size() > 0) {
                this.fireUnelected();
            }
        } else if (!this.ivCurrentlyActive && bl && this.ivListeners.size() > 0) {
            this.fireElected(this.ivListeners, null);
        }
        this.ivCurrentlyActive = bl;
        if (this.ivCurrentlyActive) {
            this.ivGlobalStateRebuildInProgress = true;
            this.startExplicitBridgeStateRebuild();
            this.ivRebuildStartTime = System.currentTimeMillis();
        }
    }

    synchronized boolean gsrRebuildComplete() throws HAInternalStateException {
        HAManagerPerf hAManagerPerf;
        if (TC.isEventEnabled()) {
            int n = this.calculateNumberOfSubscriptions(this.ivLocalSubscriptionsMap);
            int bl = this.calculateNumberOfSubscriptions(this.ivBridgeSubscriptionsMap);
            int set = this.calculateNumberOfPosts(this.ivLocalSubjectDataMap);
            int subjectInfoArray = this.calculateNumberOfPosts(this.ivBridgeSubjectDataMap);
            Object[] objectArray = new Object[]{new Integer(n), new Integer(bl), new Integer(set), new Integer(subjectInfoArray)};
            Tr.event(TC, "gsr Rebuild is complete", objectArray);
        }
        if ((hAManagerPerf = this.ivCoordinator.getPMI()) != null && hAManagerPerf.isBulletinBoardRebuildTimeEnabled()) {
            hAManagerPerf.bbRebuildComplete(System.currentTimeMillis() - this.ivRebuildStartTime);
        }
        this.buildLocalStateMessagesForGSR();
        if (this.ivPendingBuildBridgeStateMessagesForGSR) {
            this.buildBridgeStateMessagesForGSR();
            this.ivPendingBuildBridgeStateMessagesForGSR = false;
        }
        boolean bl = this.doSendCachedMessages();
        Set set = this.ivLocalSubscriptionsMap.keySet();
        SubjectInfo[] subjectInfoArray = new SubjectInfo[set.size()];
        subjectInfoArray = set.toArray(subjectInfoArray);
        this.fireSubscriptionChangedDemarcation(subjectInfoArray, 1);
        this.ivGlobalStateRebuildInProgress = false;
        return bl;
    }

    synchronized boolean bridgeRebuildComplete() {
        int n;
        if (TC.isEventEnabled()) {
            n = this.calculateNumberOfSubscriptions(this.ivLocalSubscriptionsMap);
            int n2 = this.calculateNumberOfSubscriptions(this.ivBridgeSubscriptionsMap);
            int n3 = this.calculateNumberOfPosts(this.ivLocalSubjectDataMap);
            int n4 = this.calculateNumberOfPosts(this.ivBridgeSubjectDataMap);
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)};
            Tr.event(TC, "Bridge Rebuild is complete", objectArray);
        }
        n = 0;
        if (!this.ivGlobalStateRebuildInProgress) {
            this.buildBridgeStateMessagesForGSR();
            n = this.sendCachedMessages() ? 1 : 0;
            if (n == 0) {
                this.ivMessageCache.activeCoordinatorMessagesToSend();
            }
        } else {
            this.ivPendingBuildBridgeStateMessagesForGSR = true;
        }
        this.ivBridgeRebuildInProgress = false;
        return n != 0;
    }

    synchronized void updateState(String string, HAMMessage hAMMessage, boolean bl) throws HAInternalStateException {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{string, new Boolean(this.ivGlobalStateRebuildInProgress), new Boolean(bl)};
            Tr.entry(TC, "updateState()", objectArray);
        }
        objectArray = (Object[])hAMMessage;
        Map map = objectArray.getModes();
        int n = (Integer)map.get("BULLETIN_BOARD_LOCAL");
        int n2 = (Integer)map.get("BULLETIN_BOARD_PROXY");
        this.updateBridgeState(n2, string, (ReportStateMsg)objectArray, this.ivBridgeRebuildInProgress);
        this.updateLocalState(n, string, (ReportStateMsg)objectArray, bl);
        HAManagerPerf hAManagerPerf = this.ivCoordinator.getPMI();
        if (hAManagerPerf != null) {
            hAManagerPerf.bbReportPopulation(this.ivLocalSubjectDataMap.size() + this.ivBridgeSubjectDataMap.size(), this.ivLocalSubscriptionsMap.size() + this.ivBridgeSubscriptionsMap.size());
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateState");
        }
    }

    private int calculateNumberOfSubscriptions(Map map) {
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            n += hashSet.size();
        }
        return n;
    }

    private int calculateNumberOfPosts(IndirectSubjectToPostMap indirectSubjectToPostMap) {
        int n = 0;
        Iterator iterator = indirectSubjectToPostMap.getValuesIterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            n += map.size();
        }
        return n;
    }

    private synchronized boolean doSendCachedMessages() {
        Object object;
        Object object2;
        Map.Entry entry;
        Iterator iterator;
        Object object3;
        if (TC.isEventEnabled()) {
            Object[] objectArray = new Object[]{new Boolean(this.ivGlobalStateRebuildInProgress), new Boolean(this.ivBridgeRebuildInProgress)};
            Tr.event(TC, "doSendCachedMessages()", objectArray);
        }
        this.sendPendingGSRMessages();
        boolean bl = true;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator2 = this.ivInitialSubscriberEmptySubjectCache.entrySet().iterator();
        while (iterator2.hasNext()) {
            object3 = iterator2.next();
            iterator = (SubjectInfoImpl)object3.getKey();
            entry = (Set)object3.getValue();
            object2 = entry.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                SubscriberUpdateMsg subscriberUpdateMsg = (SubscriberUpdateMsg)hashMap.get(object);
                if (subscriberUpdateMsg == null) {
                    subscriberUpdateMsg = new SubscriberUpdateMsg();
                    subscriberUpdateMsg.addEmptySubject((SubjectInfoImpl)((Object)iterator));
                    hashMap.put(object, subscriberUpdateMsg);
                    continue;
                }
                subscriberUpdateMsg.addEmptySubject((SubjectInfoImpl)((Object)iterator));
            }
            iterator2.remove();
        }
        object3 = this.ivUpdatesCache.entrySet().iterator();
        while (object3.hasNext()) {
            iterator = (Map.Entry)object3.next();
            entry = (String)iterator.getKey();
            object2 = (Map)iterator.getValue();
            object = (SubscriberUpdateMsg)hashMap.get(entry);
            if (object == null) {
                object = new SubscriberUpdateMsg();
            }
            if (!this.ivGlobalStateRebuildInProgress && !this.ivBridgeRebuildInProgress) {
                ((SubscriberUpdateMsg)object).setValues(2, 2, (Map)object2);
            } else if (this.ivGlobalStateRebuildInProgress) {
                if (this.ivBridgeRebuildInProgress) {
                    ((SubscriberUpdateMsg)object).setValues(1, 0, (Map)object2);
                } else {
                    ((SubscriberUpdateMsg)object).setValues(1, 1, (Map)object2);
                }
            } else if (this.ivBridgeStateManager.getState() == 3) {
                ((SubscriberUpdateMsg)object).setValues(2, 1, (Map)object2);
            } else {
                ((SubscriberUpdateMsg)object).setValues(2, 0, (Map)object2);
            }
            hashMap.put(entry, object);
            object3.remove();
        }
        iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object2 = (String)entry.getKey();
            object = (SubscriberUpdateMsg)entry.getValue();
            if (this.ivUnsentGSRMessages.containsKey(object2)) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doSendCachedMessages - GSR message in cache", object2);
                }
                bl = false;
                continue;
            }
            try {
                this.ivCoordinator.sendMessage((String)object2, (HAMMessage)object);
                iterator.remove();
            }
            catch (DataStackException dataStackException) {
                FFDCFilter.processException((Throwable)dataStackException, svClassName, "505", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doSendCachedMessages - Exception received during sendMessage", dataStackException);
                }
                bl = false;
            }
        }
        return bl;
    }

    private void updateLocalState(int n, String string, ReportStateMsg reportStateMsg, boolean bl) throws HAInternalStateException {
        switch (n) {
            case 0: {
                if (!bl) break;
                Tr.warning(TC, "HMGR0231", new Object[]{"local", "NODATA", string, "GlobalStateRebuild", "not-applicable"});
                break;
            }
            case 1: {
                if (bl) {
                    Tr.warning(TC, "HMGR0231", new Object[]{"local", "UPDATE", string, "GlobalStateRebuild", "not-applicable"});
                    break;
                }
                Map map = reportStateMsg.getLocalPosts();
                this.mergeLocalSubjects(string, map);
                this.updateLocalBulletinBoardSubscriptions(string, reportStateMsg.getLocalSubscribers());
                this.updateBridgeBulletinBoardSubscriptions(string, reportStateMsg.getProxySubscribers());
                break;
            }
            case 2: {
                this.replaceLocalPostValuesInSubject(string, reportStateMsg.getLocalPosts(), bl);
                this.updateLocalBulletinBoardSubscriptions(string, reportStateMsg.getLocalSubscribers());
                this.updateBridgeBulletinBoardSubscriptions(string, reportStateMsg.getProxySubscribers());
            }
        }
    }

    private void updateBridgeState(int n, String string, ReportStateMsg reportStateMsg, boolean bl) throws HAInternalStateException {
        if (n == 0) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "No bridge data to process", reportStateMsg);
            }
            return;
        }
        if (n == 2 || n == 4) {
            this.ivBridgeStateManager.bridgeConfigurationUpdated(string, reportStateMsg.getBridgeConfigurationData());
        }
        int n2 = this.ivBridgeStateManager.getState();
        block0 : switch (n2) {
            case 0: {
                Tr.error(TC, "HMGR0232", new Object[]{string, "currently configured"});
                if (!TC.isDebugEnabled()) break;
                Tr.debug(TC, "ignoring updateBridgeState message in UNSYNCHRONIZABLE state", reportStateMsg);
                break;
            }
            case 1: {
                Tr.error(TC, "HMGR0232", new Object[]{string, "in the current view"});
                if (!TC.isDebugEnabled()) break;
                Tr.debug(TC, "ignoring updateBridgeState message in SYNCHRONIZABLE state", reportStateMsg);
                break;
            }
            case 2: {
                if (this.ivBridgeStateManager.bridgeStateRebuildMessageExpectedFromSender(string)) {
                    switch (n) {
                        case 3: {
                            int n3 = this.ivBridgeStateManager.calculateNewState(string, n);
                            this.ivBridgeStateManager.setOwnedSubjects(string, reportStateMsg.getBridgeSubjects());
                            Map map = reportStateMsg.getProxyPosts();
                            this.replaceBridgePostValuesInSubject(string, map, true);
                            if (n3 != 3) break block0;
                            this.ivBridgeStateManager.checkBridgeSubjectsCoherency();
                            this.bridgeRebuildComplete();
                            break;
                        }
                        case 2: {
                            int n4 = this.ivBridgeStateManager.calculateNewState(string, n);
                            Map map = reportStateMsg.getProxyPosts();
                            this.replaceBridgePostValuesInSubject(string, map, true);
                            if (n4 != 3) break block0;
                            this.ivBridgeStateManager.checkBridgeSubjectsCoherency();
                            this.bridgeRebuildComplete();
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            if (!TC.isDebugEnabled()) break block0;
                            Tr.debug(TC, "ignoring updateBridgeState message in SYNCHRONIZING state", reportStateMsg);
                            break;
                        }
                    }
                    break;
                }
                switch (n) {
                    case 1: {
                        Map map = reportStateMsg.getProxyPosts();
                        this.mergeBridgeSubjects(string, map);
                        break block0;
                    }
                    case 2: {
                        Map map = reportStateMsg.getProxyPosts();
                        this.replaceBridgePostValuesInSubject(string, map, true);
                        break block0;
                    }
                }
                Tr.warning(TC, "HMGR0231", new Object[]{"bridge", ReportStateMsg.MODES[n], string, "UPDATE or GLOBAL_REBUILD", "synchronizing"});
                if (!TC.isDebugEnabled()) break;
                Tr.debug(TC, "ignoring updateBridgeState message in SYNCHRONIZING state", reportStateMsg);
                break;
            }
            case 3: {
                switch (n) {
                    case 1: {
                        Map map = reportStateMsg.getProxyPosts();
                        this.mergeBridgeSubjects(string, map);
                        break block0;
                    }
                    case 2: {
                        Map map = reportStateMsg.getProxyPosts();
                        this.replaceBridgePostValuesInSubject(string, map, true);
                        break block0;
                    }
                }
                Tr.warning(TC, "HMGR0231", new Object[]{"bridge", ReportStateMsg.MODES[n], string, "UPDATE or GLOBAL_REBUILD", "synchronized"});
                if (!TC.isDebugEnabled()) break;
                Tr.debug(TC, "ignoring updateBridgeState message in SYNCHRONIZED state", reportStateMsg);
            }
        }
    }

    private void updateBridgeCoherencyTracker(SubjectInfoImpl subjectInfoImpl, String string) {
        String string2;
        if (!this.ivBridgeRebuildInProgress && (string2 = this.ivBridgeSubjectCoherencyTracker.put(subjectInfoImpl, string)) != null && !string2.equals(string)) {
            String string3 = "Bridge Subject Ownership Contention detected between " + string + " and " + string2 + " for Subject " + subjectInfoImpl.getSubjectName();
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "updateBridgeCoherencyTracker", string3});
        }
    }

    synchronized void removeDeadServers(Set set) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadServers()", set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.ivUpdatesCache.remove(string);
            this.ivUnsentGSRMessages.remove(string);
        }
        this.removeDeadSubscriptions(set);
        this.removeDeadSubjects(set);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadServers()");
        }
    }

    synchronized void handleJMXRequest(BulletinBoardSnapshotMessage bulletinBoardSnapshotMessage) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Map map = this.getMergedGlobalState();
        Iterator iterator = map.keySet().iterator();
        boolean bl = bulletinBoardSnapshotMessage.getBoardName().length() != 0;
        boolean bl2 = bulletinBoardSnapshotMessage.getSubjectFilter().length() != 0;
        Pattern pattern = null;
        int n = 0;
        if (bulletinBoardSnapshotMessage.getMaxSubjects() <= 0) {
            bulletinBoardSnapshotMessage.setMaxSubjects(1);
        }
        if (bl2) {
            pattern = Pattern.compile(bulletinBoardSnapshotMessage.getSubjectFilter());
        }
        while (iterator.hasNext() && n < bulletinBoardSnapshotMessage.getMaxSubjects()) {
            object5 = (SubjectInfoImpl)iterator.next();
            if (bl && !((SubjectInfoImpl)object5).getBoardName().equals(bulletinBoardSnapshotMessage.getBoardName())) continue;
            boolean bl3 = true;
            if (pattern != null) {
                object4 = pattern.matcher(((SubjectInfoImpl)object5).getSubjectName());
                bl3 = object4.find();
            }
            if (!bl3) continue;
            object4 = null;
            object4 = new BulletinBoardSubjectSnapshotImpl();
            hashMap.put(object5, object4);
            ++n;
            object4.setSubjectName(((SubjectInfoImpl)object5).getSubjectName());
            object4.setBoardName(((SubjectInfoImpl)object5).getBoardName());
            object3 = (Map)map.get(object5);
            String[] stringArray = new String[object3.size()];
            object2 = new int[stringArray.length];
            object4.setPostSizes((int[])object2);
            object4.setPostingServers(stringArray);
            object = object3.keySet().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                String string;
                stringArray[n2] = string = (String)object.next();
                object2[n2] = false;
                BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)object3.get(string);
                Object object6 = object2;
                int n3 = n2++;
                object6[n3] = object6[n3] + bulletinBoardPost.getValue().length;
            }
        }
        object5 = this.getAllSubscribers();
        iterator = object5.keySet().iterator();
        String[] stringArray = new String[]{};
        object4 = new int[]{};
        while (iterator.hasNext()) {
            object3 = (BulletinBoardSubjectSnapshot[])iterator.next();
            if (bl && !((SubjectInfoImpl)object3).getBoardName().equals(bulletinBoardSnapshotMessage.getBoardName())) continue;
            boolean bl4 = true;
            if (pattern != null) {
                object2 = pattern.matcher(((SubjectInfoImpl)object3).getSubjectName());
                bl4 = ((Matcher)object2).find();
            }
            if (!bl4) continue;
            object2 = (BulletinBoardSubjectSnapshotImpl)hashMap.get(object3);
            if (object2 == null) {
                if (n == bulletinBoardSnapshotMessage.getMaxSubjects()) break;
                ++n;
                object2 = new BulletinBoardSubjectSnapshotImpl();
                ((BulletinBoardSubjectSnapshotImpl)object2).setBoardName(((SubjectInfoImpl)object3).getBoardName());
                ((BulletinBoardSubjectSnapshotImpl)object2).setSubjectName(((SubjectInfoImpl)object3).getSubjectName());
                ((BulletinBoardSubjectSnapshotImpl)object2).setPostingServers(stringArray);
                ((BulletinBoardSubjectSnapshotImpl)object2).setPostSizes((int[])object4);
                hashMap.put(object3, object2);
            }
            object = (Set)object5.get(object3);
            String[] stringArray2 = new String[object.size()];
            object.toArray(stringArray2);
            ((BulletinBoardSubjectSnapshotImpl)object2).setSubscribingServers(stringArray2);
        }
        object3 = new BulletinBoardSubjectSnapshot[hashMap.size()];
        hashMap.values().toArray((T[])object3);
        bulletinBoardSnapshotMessage.setSubjectSnapshot((BulletinBoardSubjectSnapshot[])object3);
    }

    synchronized void addListener(BulletinBoardListener bulletinBoardListener) {
        if (!this.ivListeners.contains(bulletinBoardListener)) {
            this.ivListeners.add(bulletinBoardListener);
            if (this.ivCurrentlyActive) {
                Set set = this.ivLocalSubscriptionsMap.keySet();
                SubjectInfo[] subjectInfoArray = new SubjectInfo[set.size()];
                subjectInfoArray = set.toArray(subjectInfoArray);
                ArrayList<BulletinBoardListener> arrayList = new ArrayList<BulletinBoardListener>();
                arrayList.add(bulletinBoardListener);
                this.fireElected(arrayList, subjectInfoArray);
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.ivActiveCoordinators));
                this.fireActiveCoordinatorChange(hashSet);
                if (!this.ivGlobalStateRebuildInProgress) {
                    this.fireBridgeMembershipChange(this.ivBridgeStateManager.getBridgesInCurrentView());
                    this.fireSubscriptionChangedDemarcation(subjectInfoArray, 0);
                }
            } else {
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.ivActiveCoordinators));
                this.fireActiveCoordinatorChange(hashSet);
            }
        }
    }

    private void fireElected(ArrayList arrayList, SubjectInfo[] subjectInfoArray) {
        ListenerCallback listenerCallback = new ListenerCallback(1, arrayList, subjectInfoArray);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireSubscriptionsChanged(SubjectInfo[] subjectInfoArray, SubjectInfo[] subjectInfoArray2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "addedSubscriptions", subjectInfoArray);
            Tr.debug(TC, "removedSubscriptions", subjectInfoArray2);
        }
        ListenerCallback listenerCallback = new ListenerCallback(2, this.ivListeners, subjectInfoArray, subjectInfoArray2);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireUnelected() {
        ListenerCallback listenerCallback = new ListenerCallback(0, this.ivListeners);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireSubscriptionChangedDemarcation(SubjectInfo[] subjectInfoArray, int n) {
        ListenerCallback listenerCallback = new ListenerCallback(3, this.ivListeners, subjectInfoArray, n);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireBridgeMembershipChange(Set set) {
        boolean bl = true;
        if (this.ivLastSetOfBridgesCallbackWasMadeFor != null && set.size() == this.ivLastSetOfBridgesCallbackWasMadeFor.size() && set.containsAll(this.ivLastSetOfBridgesCallbackWasMadeFor)) {
            bl = false;
        }
        if (bl) {
            this.ivLastSetOfBridgesCallbackWasMadeFor = new HashSet(set);
            ListenerCallback listenerCallback = new ListenerCallback(4, this.ivListeners, this.ivLastSetOfBridgesCallbackWasMadeFor);
            UserCallbacks.executeCallback(listenerCallback);
        }
    }

    private Map getMergedGlobalState() {
        Map map;
        SubjectInfoImpl subjectInfoImpl;
        TreeMap treeMap = new TreeMap();
        Iterator iterator = this.ivLocalSubjectDataMap.keySet().iterator();
        Iterator iterator2 = this.ivBridgeSubjectDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            subjectInfoImpl = (SubjectInfoImpl)iterator.next();
            map = new HashMap(this.ivLocalSubjectDataMap.get(subjectInfoImpl));
            treeMap.put(subjectInfoImpl, map);
        }
        while (iterator2.hasNext()) {
            subjectInfoImpl = (SubjectInfoImpl)iterator2.next();
            if (treeMap.containsKey(subjectInfoImpl)) {
                map = (Map)treeMap.get(subjectInfoImpl);
                Map map2 = this.ivBridgeSubjectDataMap.get(subjectInfoImpl);
                map.putAll(map2);
                continue;
            }
            map = new HashMap(this.ivBridgeSubjectDataMap.get(subjectInfoImpl));
            treeMap.put(subjectInfoImpl, map);
        }
        return treeMap;
    }

    private void setWireProtocol() {
    }

    private void sendLocalPostUpdatedNotification(SubjectInfoImpl subjectInfoImpl, String string, BulletinBoardPost bulletinBoardPost) {
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        Set set = this.getAllSubscribers(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashMap<String, BulletinBoardPost> hashMap;
                HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardPost>> hashMap2;
                String string2 = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "sendLocalPostUpdatedNotification", new Object[]{subjectInfoImpl, string, string2, bulletinBoardPost});
                }
                if ((hashMap2 = (HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardPost>>)this.ivUpdatesCache.get(string2)) == null) {
                    hashMap2 = new HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardPost>>();
                    this.ivUpdatesCache.put(string2, hashMap2);
                }
                if ((hashMap = (HashMap<String, BulletinBoardPost>)hashMap2.get(subjectInfoImpl)) == null) {
                    hashMap = new HashMap<String, BulletinBoardPost>();
                    hashMap2.put(subjectInfoImpl, hashMap);
                }
                hashMap.put(string, bulletinBoardPost);
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    private void sendBridgePostUpdatedNotification(SubjectInfoImpl subjectInfoImpl, Map map) {
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        Set set = (Set)this.ivLocalSubscriptionsMap.get(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "sendBridgePostUpdatedNotification", new Object[]{subjectInfoImpl, string, map});
                }
                HashMap hashMap = (HashMap)this.ivUpdatesCache.get(string);
                HashMap hashMap2 = new HashMap(map);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    this.ivUpdatesCache.put(string, hashMap);
                    hashMap.put(subjectInfoImpl, hashMap2);
                    continue;
                }
                Map map2 = (Map)hashMap.get(subjectInfoImpl);
                if (map2 == null) {
                    hashMap.put(subjectInfoImpl, hashMap2);
                    continue;
                }
                map2.putAll(map);
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    private void sendPostsToNewSubscriber(String string, SubjectInfoImpl subjectInfoImpl, boolean bl) {
        Object[] objectArray;
        HashMap<SubjectInfoImpl, Object[]> hashMap;
        Object object;
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        Map map = this.ivLocalSubjectDataMap.get(subjectInfoImpl);
        if (map != null) {
            object = new HashMap(map);
            this.ivInitialSubscriberEmptySubjectCache.remove(subjectInfoImpl);
            hashMap = (HashMap<SubjectInfoImpl, Object[]>)this.ivUpdatesCache.get(string);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.ivUpdatesCache.put(string, hashMap);
            }
            hashMap.put(subjectInfoImpl, (Object[])object);
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{subjectInfoImpl, string, object};
                Tr.debug(TC, "sendPostsToNewSubscriber - existing localState", objectArray);
            }
        } else if (bl) {
            if (TC.isDebugEnabled()) {
                object = new Object[]{subjectInfoImpl, string};
                Tr.debug(TC, "sendPostsToNewSubscriber - proxySubscriber and empty localState", object);
            }
            if ((object = (Set)this.ivInitialSubscriberEmptySubjectCache.get(subjectInfoImpl)) == null) {
                object = new HashSet();
                this.ivInitialSubscriberEmptySubjectCache.put(subjectInfoImpl, object);
            }
            object.add(string);
        }
        if (!this.ivBridgeRebuildInProgress && (object = this.ivBridgeSubjectDataMap.get(subjectInfoImpl)) != null) {
            hashMap = new HashMap<SubjectInfoImpl, Object[]>((Map<SubjectInfoImpl, Object[]>)object);
            objectArray = (Object[])this.ivUpdatesCache.get(string);
            if (objectArray == null) {
                objectArray = new HashMap();
                this.ivUpdatesCache.put(string, objectArray);
                objectArray.put(subjectInfoImpl, hashMap);
                if (TC.isDebugEnabled()) {
                    Object[] objectArray2 = new Object[]{subjectInfoImpl, string, hashMap};
                    Tr.debug(TC, "sendPostsToNewSubscriber - existing bridgeState, no cached updates", objectArray2);
                }
            } else {
                Map map2 = (Map)objectArray.get(subjectInfoImpl);
                if (map2 == null) {
                    objectArray.put(subjectInfoImpl, hashMap);
                } else {
                    map2.putAll(object);
                }
                if (TC.isDebugEnabled()) {
                    Object[] objectArray3 = new Object[]{subjectInfoImpl, string, hashMap, map2};
                    Tr.debug(TC, "sendPostsToNewSubscriber - existing bridgeState, previously cached updates", objectArray3);
                }
            }
        }
        this.ivMessageCache.activeCoordinatorMessagesToSend();
    }

    private void sendEmptySubjectToNewProxySubscriberWithOtherSubscriber(String string, SubjectInfoImpl subjectInfoImpl) {
        Object object;
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        if (TC.isDebugEnabled()) {
            object = new Object[]{subjectInfoImpl, string};
            Tr.debug(TC, "sendEmptySubjectToNewProxySubscriberWithOtherSubscriber - empty localState", object);
        }
        if ((object = (Object[])this.ivInitialSubscriberEmptySubjectCache.get(subjectInfoImpl)) == null) {
            object = new HashSet();
            this.ivInitialSubscriberEmptySubjectCache.put(subjectInfoImpl, object);
        }
        object.add(string);
        this.ivMessageCache.activeCoordinatorMessagesToSend();
    }

    private void buildLocalStateMessagesForGSR() {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildLocalStateMessagesForGSR initiated");
        }
        Iterator iterator = this.getAllSubscribers().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            Set set = (Set)entry.getValue();
            Map map = this.ivLocalSubjectDataMap.get(subjectInfoImpl);
            if (map == null) {
                if (this.ivBridgeSubscriptionsMap.containsKey(subjectInfoImpl)) {
                    Set set2 = (Set)this.ivBridgeSubscriptionsMap.get(subjectInfoImpl);
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "buildLocalStateMessagesForGSR - no posts for subject but adding to emptySubjects due to bridge subscriber for this subject", new Object[]{subjectInfoImpl, set2});
                    }
                    this.ivInitialSubscriberEmptySubjectCache.put(subjectInfoImpl, set2);
                    continue;
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "buildLocalStateMessagesForGSR - no posts for subject", subjectInfoImpl);
                continue;
            }
            this.mergePostsIntoUpdatesCache(subjectInfoImpl, set, map);
        }
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildLocalStateMessagesForGSR completed");
        }
    }

    private void buildBridgeStateMessagesForGSR() {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildBridgeStateMessagesForGSR initiated");
        }
        Iterator iterator = this.ivLocalSubscriptionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            Set set = (Set)entry.getValue();
            Map map = this.ivBridgeSubjectDataMap.get(subjectInfoImpl);
            this.mergePostsIntoUpdatesCache(subjectInfoImpl, set, map);
        }
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildBridgeStateMessagesForGSR completed");
        }
    }

    private void mergePostsIntoUpdatesCache(SubjectInfo subjectInfo, Set set, Map map) {
        HashMap hashMap = null;
        if (map == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "mergePostsIntoUpdatesCache - no posts for subject", subjectInfo);
            }
            hashMap = new HashMap();
        } else {
            hashMap = new HashMap(map);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashMap hashMap2 = (HashMap)this.ivUpdatesCache.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.ivUpdatesCache.put(string, hashMap2);
                hashMap2.put(subjectInfo, hashMap);
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergePostsIntoUpdatesCache - new forTarget", map);
                continue;
            }
            Map map2 = (Map)hashMap2.get(subjectInfo);
            if (map2 != null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergePostsIntoUpdatesCache - merge into existing forTarget", map);
                }
                map2.putAll(hashMap);
                continue;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "mergePostsIntoUpdatesCache - new into existing forTarget", map);
            }
            hashMap2.put(subjectInfo, hashMap);
        }
    }

    private void sendPendingGSRMessages() {
        String string = null;
        SubscriberUpdateMsg subscriberUpdateMsg = null;
        if (this.ivUnsentGSRMessages.size() != 0) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "sendPendingGSRMessages - GSR cache at entry", this.ivUnsentGSRMessages);
            }
            Iterator iterator = this.ivUnsentGSRMessages.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string = (String)entry.getKey();
                subscriberUpdateMsg = (SubscriberUpdateMsg)entry.getValue();
                try {
                    this.ivCoordinator.sendMessage(string, (HAMMessage)subscriberUpdateMsg);
                    iterator.remove();
                }
                catch (DataStackException dataStackException) {
                    FFDCFilter.processException((Throwable)dataStackException, svClassName, "608", this);
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "sendPendingGSRMessages - GSR cache at exit", this.ivUnsentGSRMessages);
            }
        }
    }

    private Set getAllSubscribers(SubjectInfo subjectInfo) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getAllSubscribers(Subject)", subjectInfo);
        }
        if (this.ivBridgeSubscriptionsMap.isEmpty()) {
            return (Set)this.ivLocalSubscriptionsMap.get(subjectInfo);
        }
        if (this.ivLocalSubscriptionsMap.isEmpty()) {
            return (Set)this.ivBridgeSubscriptionsMap.get(subjectInfo);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = (Set)this.ivLocalSubscriptionsMap.get(subjectInfo);
        Set set2 = (Set)this.ivBridgeSubscriptionsMap.get(subjectInfo);
        if (set != null) {
            hashSet.addAll(set);
        }
        if (set2 != null) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getAllSubscribers(subject)", new Integer(hashSet.size()));
        }
        return hashSet;
    }

    private Set getAllSubscribedSubjects() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Set set = this.ivBridgeSubscriptionsMap.keySet();
        Set set2 = this.ivLocalSubscriptionsMap.keySet();
        hashSet.addAll(set);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            SubjectInfo subjectInfo = (SubjectInfo)iterator.next();
            if (hashSet.contains(subjectInfo)) continue;
            hashSet.add(subjectInfo);
        }
        return hashSet;
    }

    private Map getAllSubscribers() {
        Object[] objectArray;
        Iterator<Object> iterator;
        Collection<Object> collection;
        Object object;
        if (TC.isEntryEnabled()) {
            Object[] objectArray2;
            int n = 0;
            int n2 = 0;
            object = this.ivBridgeSubscriptionsMap.values();
            collection = this.ivLocalSubscriptionsMap.values();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                objectArray = (Set)iterator.next();
                n2 += objectArray.size();
            }
            objectArray = collection.iterator();
            while (objectArray.hasNext()) {
                objectArray2 = (Object[])objectArray.next();
                n += objectArray2.size();
            }
            objectArray2 = new Object[]{new Integer(n), new Integer(n2)};
            Tr.entry(TC, "getAllSubscribers()", objectArray2);
        }
        if (this.ivBridgeSubscriptionsMap.isEmpty()) {
            return this.ivLocalSubscriptionsMap;
        }
        if (this.ivLocalSubscriptionsMap.isEmpty()) {
            return this.ivBridgeSubscriptionsMap;
        }
        TreeMap<Object, Collection<Object>> treeMap = new TreeMap<Object, Collection<Object>>();
        Iterator iterator2 = this.getAllSubscribedSubjects().iterator();
        while (iterator2.hasNext()) {
            object = (SubjectInfo)iterator2.next();
            collection = this.getAllSubscribers((SubjectInfo)object);
            treeMap.put(object, collection);
        }
        if (TC.isEntryEnabled()) {
            int n = 0;
            collection = treeMap.values();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                objectArray = (Set)iterator.next();
                n += objectArray.size();
            }
            objectArray = new Object[]{new Integer(n)};
            Tr.exit(TC, "getAllSubscribers()", objectArray);
        }
        return treeMap;
    }

    private void removeDeadSubscriptions(Set set) throws HAInternalStateException {
        SubjectInfo[] subjectInfoArray;
        SubjectInfo[] subjectInfoArray2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadSubscriptions", set);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.doRemoveDeadSubscriptions(this.ivLocalSubscriptionsMap, arrayList, arrayList2, set);
        Set set2 = this.filterOutNonBridgeServers(set);
        if (set2.size() > 0) {
            subjectInfoArray2 = new ArrayList();
            subjectInfoArray = new ArrayList();
            this.doRemoveDeadSubscriptions(this.ivBridgeSubscriptionsMap, (ArrayList)subjectInfoArray2, (ArrayList)subjectInfoArray, set2);
        }
        if (this.ivListeners.size() > 0 && arrayList2.size() > 0) {
            subjectInfoArray2 = new SubjectInfo[]{};
            subjectInfoArray = new SubjectInfo[arrayList2.size()];
            subjectInfoArray = arrayList2.toArray(subjectInfoArray);
            this.fireSubscriptionsChanged(subjectInfoArray2, subjectInfoArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadSubscriptions()");
        }
    }

    private Set filterOutNonBridgeServers(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.ivBridgeStateManager.ivConfiguredBridges.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void doRemoveDeadSubscriptions(Map map, ArrayList arrayList, ArrayList arrayList2, Set set) {
        Serializable serializable;
        Object object;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = (SubjectInfoImpl)iterator.next();
            serializable = (HashSet)map.get(object);
            Iterator iterator2 = ((HashSet)serializable).iterator();
            arrayList.clear();
            while (iterator2.hasNext()) {
                object2 = (String)iterator2.next();
                if (!set.contains(object2)) continue;
                arrayList.add(object2);
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                ((HashSet)serializable).remove(string);
            }
            if (((HashSet)serializable).size() != 0) continue;
            arrayList2.add(object);
        }
        object = arrayList2.iterator();
        while (object.hasNext()) {
            serializable = (SubjectInfoImpl)object.next();
            map.remove(serializable);
        }
    }

    private void removeDeadSubjects(Set set) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadSubject", set);
        }
        Iterator iterator = this.ivLocalSubjectDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!set.contains(string)) continue;
                iterator2.remove();
                this.sendLocalPostUpdatedNotification(subjectInfoImpl, string, null);
            }
            if (!hashMap.isEmpty()) continue;
            iterator.remove();
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadSubjects()");
        }
    }

    private void replaceLocalPostValuesInSubject(String string, Map map, boolean bl) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "replaceLocalPostValuesInSubject()", new Object[]{string, new Boolean(bl)});
        }
        if (!map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
                if (bl) {
                    this.replaceLocalPostDataInSubjectDuringGSR(string, subjectInfoImpl, bulletinBoardPost);
                    continue;
                }
                this.replaceLocalPostDataInSubjectNormal(string, subjectInfoImpl, bulletinBoardPost);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "replaceLocalPostValuesInSubject()");
        }
    }

    private void replaceLocalPostDataInSubjectDuringGSR(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost) throws HAInternalStateException {
        if (bulletinBoardPost == null) {
            Tr.error(TC, "HMGR0233", new Object[]{string, "local", subjectInfoImpl, "null", "normal"});
            return;
        }
        Map map = this.ivLocalSubjectDataMap.put(subjectInfoImpl, bulletinBoardPost);
        if (map != null) {
            Tr.error(TC, "HMGR0233", new Object[]{string, "local", subjectInfoImpl, "non-null", "prior"});
            return;
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, bulletinBoardPost, map};
            Tr.debug(TC, "replaceLocalPostDataInSubjectDuringGSR", objectArray);
        }
    }

    private void replaceLocalPostDataInSubjectNormal(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost) throws HAInternalStateException {
        Map map = this.ivLocalSubjectDataMap.get(subjectInfoImpl);
        if (bulletinBoardPost == null) {
            if (map == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "replaceLocalPostDataInSubjectNormal - clear nonexisting", new Object[]{string, subjectInfoImpl});
                }
            } else {
                this.ivLocalSubjectDataMap.clearPost(subjectInfoImpl, string);
                BulletinBoardPost bulletinBoardPost2 = (BulletinBoardPost)map.remove(string);
                if (bulletinBoardPost2 != null) {
                    this.sendLocalPostUpdatedNotification(subjectInfoImpl, string, null);
                }
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{string, subjectInfoImpl, bulletinBoardPost2};
                    Tr.debug(TC, "replaceLocalPostDataInSubjectNormal - clear", objectArray);
                }
            }
            return;
        }
        boolean bl = false;
        if (map == null) {
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, bulletinBoardPost, new Boolean(bl)};
            Tr.debug(TC, "replaceLocalPostDataInSubjectNormal - add", objectArray);
        }
        this.ivLocalSubjectDataMap.put(subjectInfoImpl, bulletinBoardPost);
        this.sendLocalPostUpdatedNotification(subjectInfoImpl, string, bulletinBoardPost);
    }

    private void replaceBridgePostValuesInSubject(String string, Map map, boolean bl) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "replaceBridgePostValuesInSubject()", new Object[]{string});
        }
        if (!map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                Map map2 = (Map)entry.getValue();
                if (bl) {
                    this.replaceBridgePostDataInSubjectDuringGSR(string, subjectInfoImpl, map2);
                    continue;
                }
                this.replaceBridgePostDataInSubjectNormal(string, subjectInfoImpl, map2);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "replaceBridgePostValuesInSubject()");
        }
    }

    private void replaceBridgePostDataInSubjectNormal(String string, SubjectInfoImpl subjectInfoImpl, Map map) throws HAInternalStateException {
        Map map2 = this.ivBridgeSubjectDataMap.get(subjectInfoImpl);
        if (map == null || map.isEmpty()) {
            if (map2 == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "replaceBridgePostDataInSubjectNormal - clear nonexisting", new Object[]{string, subjectInfoImpl});
                }
            } else {
                Object[] objectArray;
                Map map3 = this.ivBridgeSubjectDataMap.remove(subjectInfoImpl);
                if (map3 != null) {
                    this.sendBridgePostUpdatedNotification(subjectInfoImpl, null);
                }
                if (map != null) {
                    objectArray = "Empty posts for Subject " + subjectInfoImpl + " from server " + string;
                    Tr.error(TC, "HMGR0108", new Object[]{svClassName, "replaceBridgePostDataInSubjectNormal", objectArray});
                }
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{string, subjectInfoImpl, map3};
                    Tr.debug(TC, "replaceBridgePostDataInSubjectNormal - clear", objectArray);
                }
            }
            return;
        }
        boolean bl = false;
        if (map2 == null) {
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, map, new Boolean(bl)};
            Tr.debug(TC, "replaceBridgePostDataInSubjectNormal - add", objectArray);
        }
        this.ivBridgeSubjectDataMap.replace(subjectInfoImpl, map);
        this.sendBridgePostUpdatedNotification(subjectInfoImpl, map);
    }

    private void replaceBridgePostDataInSubjectDuringGSR(String string, SubjectInfoImpl subjectInfoImpl, Map map) throws HAInternalStateException {
        if (map == null) {
            Tr.error(TC, "HMGR0233", new Object[]{string, "bridge", subjectInfoImpl, "null", "normal"});
            return;
        }
        if (map.isEmpty()) {
            Tr.error(TC, "HMGR0233", new Object[]{string, "bridge", subjectInfoImpl, "non-null", "prior"});
            return;
        }
        Map map2 = this.ivBridgeSubjectDataMap.replace(subjectInfoImpl, map);
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, map, map2};
            Tr.debug(TC, "replaceBridgePostDataInSubjectDuringGSR", objectArray);
        }
    }

    private void updateLocalBulletinBoardSubscriptions(String string, Map map) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "updateLocalBulletinBoardSubscriptions()", new Object[]{string});
        }
        if (!map.isEmpty()) {
            Map map2 = this.ivLocalSubscriptionsMap;
            int n = map.size();
            ArrayList arrayList = new ArrayList(n);
            ArrayList arrayList2 = new ArrayList(n);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Set set;
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                boolean bl = (Boolean)entry.getValue();
                boolean bl2 = false;
                if (this.ivBridgeSubscriptionsMap.containsKey(subjectInfoImpl) && (set = (Set)this.ivBridgeSubscriptionsMap.get(subjectInfoImpl)).contains(string)) {
                    bl2 = true;
                }
                this.updateSubscriptionsForSubject(map2, string, subjectInfoImpl, bl, arrayList2, arrayList, false, bl2);
            }
            if (this.ivListeners.size() > 0) {
                int n2 = arrayList2.size();
                int n3 = arrayList.size();
                if (n2 > 0 || n3 > 0) {
                    SubjectInfo[] subjectInfoArray = new SubjectInfo[n2];
                    subjectInfoArray = arrayList2.toArray(subjectInfoArray);
                    SubjectInfo[] subjectInfoArray2 = new SubjectInfo[n3];
                    subjectInfoArray2 = arrayList.toArray(subjectInfoArray2);
                    this.fireSubscriptionsChanged(subjectInfoArray, subjectInfoArray2);
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateLocalBulletinBoardSubscriptions()");
        }
    }

    private void updateBridgeBulletinBoardSubscriptions(String string, Map map) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "updateBridgeBulletinBoardSubscriptions()", new Object[]{string});
        }
        if (!map.isEmpty()) {
            Map map2 = this.ivBridgeSubscriptionsMap;
            int n = map.size();
            ArrayList arrayList = new ArrayList(n);
            ArrayList arrayList2 = new ArrayList(n);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Set set;
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                boolean bl = (Boolean)entry.getValue();
                boolean bl2 = false;
                if (this.ivLocalSubscriptionsMap.containsKey(subjectInfoImpl) && (set = (Set)this.ivLocalSubscriptionsMap.get(subjectInfoImpl)).contains(string)) {
                    bl2 = true;
                }
                this.updateSubscriptionsForSubject(map2, string, subjectInfoImpl, bl, arrayList2, arrayList, true, bl2);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateBridgeBulletinBoardSubscriptions()");
        }
    }

    private void updateSubscriptionsForSubject(Map map, String string, SubjectInfoImpl subjectInfoImpl, boolean bl, ArrayList arrayList, ArrayList arrayList2, boolean bl2, boolean bl3) {
        HashSet<String> hashSet = null;
        hashSet = (HashSet<String>)map.get(subjectInfoImpl);
        if (bl) {
            Object[] objectArray;
            boolean bl4 = false;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                map.put(subjectInfoImpl, hashSet);
                bl4 = true;
                arrayList.add(subjectInfoImpl);
            }
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{subjectInfoImpl, string, new Boolean(bl4), new Boolean(bl3), new Boolean(bl2)};
                Tr.debug(TC, "updateSubscriptionsForSubject - add", objectArray);
            }
            hashSet.add(string);
            if (!bl3) {
                this.sendPostsToNewSubscriber(string, subjectInfoImpl, bl2);
            } else {
                Map map2;
                objectArray = this.ivLocalSubjectDataMap.get(subjectInfoImpl);
                if (objectArray == null && bl2 && (map2 = this.ivBridgeSubjectDataMap.get(subjectInfoImpl)) == null) {
                    this.sendEmptySubjectToNewProxySubscriberWithOtherSubscriber(string, subjectInfoImpl);
                }
            }
        } else if (hashSet == null) {
            Tr.debug(TC, "updateSubscriptionsForSubject - BUG", new Object[]{string, subjectInfoImpl});
        } else {
            boolean bl5 = false;
            hashSet.remove(string);
            if (hashSet.isEmpty()) {
                arrayList2.add(subjectInfoImpl);
                bl5 = true;
                map.remove(subjectInfoImpl);
            }
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{subjectInfoImpl, string, new Boolean(bl5)};
                Tr.debug(TC, "updateSubscriptionsForSubject - remove", objectArray);
            }
        }
    }

    private void mergeLocalSubjects(String string, Map map) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "mergeLocalSubjects()", new Object[]{string});
        }
        if (map.isEmpty()) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
            if (bulletinBoardPost == null) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergeLocalSubjects", bulletinBoardPost);
                continue;
            }
            this.mergeLocalSingleSubject(string, subjectInfoImpl, bulletinBoardPost);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeLocalSubjects()");
        }
    }

    private void mergeLocalSingleSubject(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost) {
        BulletinBoardPost bulletinBoardPost2;
        boolean bl = false;
        HashMap<String, BulletinBoardPost> hashMap = this.ivLocalSubjectDataMap.get(subjectInfoImpl);
        if (hashMap == null) {
            hashMap = new HashMap<String, BulletinBoardPost>();
            this.ivLocalSubjectDataMap.replace(subjectInfoImpl, hashMap);
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeLocalSingleSubject", new Object[]{string, subjectInfoImpl, bulletinBoardPost, new Boolean(bl)});
        }
        if ((bulletinBoardPost2 = (BulletinBoardPost)hashMap.get(string)) == null) {
            long l = bulletinBoardPost.getVersion();
            if (l == -1L) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergeLocalSingleSubject - removed", bulletinBoardPost);
                }
                if (hashMap.isEmpty()) {
                    this.ivLocalSubjectDataMap.remove(subjectInfoImpl);
                }
            } else {
                bulletinBoardPost2 = bulletinBoardPost;
                hashMap.put(string, bulletinBoardPost2);
                this.sendMergedLocalSubjectPostNotification(subjectInfoImpl, string, bulletinBoardPost);
            }
        } else {
            long l = bulletinBoardPost.getVersion();
            if (l == -1L) {
                Object v = hashMap.remove(string);
                boolean bl2 = false;
                if (hashMap.isEmpty()) {
                    this.ivLocalSubjectDataMap.remove(subjectInfoImpl);
                    bl2 = true;
                }
                if (v != null) {
                    this.sendMergedLocalSubjectPostNotification(subjectInfoImpl, string, bulletinBoardPost);
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergeLocalSingleSubject - removed", new Object[]{bulletinBoardPost, v, new Boolean(bl2)});
                }
            } else {
                BulletinBoardPost bulletinBoardPost3 = hashMap.put(string, bulletinBoardPost);
                this.sendMergedLocalSubjectPostNotification(subjectInfoImpl, string, bulletinBoardPost);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergeLocalSingleSubject - added", new Object[]{bulletinBoardPost, bulletinBoardPost3});
                }
            }
        }
    }

    private void mergeBridgeSubjects(String string, Map map) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "mergeBridgeSubjects()", new Object[]{string});
        }
        if (map.isEmpty()) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            Map map2 = (Map)entry.getValue();
            if (map2 == null || map2.isEmpty()) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergeBridgeSubjects", map2);
                continue;
            }
            this.mergeBridgeSingleSubject(string, subjectInfoImpl, map2);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeBridgeSubjects()");
        }
    }

    private void mergeBridgeSingleSubject(String string, SubjectInfoImpl subjectInfoImpl, Map map) {
        boolean bl = false;
        HashMap hashMap = this.ivBridgeSubjectDataMap.get(subjectInfoImpl);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.ivBridgeSubjectDataMap.replace(subjectInfoImpl, hashMap);
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeBridgeSingleSubject", new Object[]{string, subjectInfoImpl, map, new Boolean(bl), new Boolean(this.ivBridgeRebuildInProgress)});
        }
        if (hashMap.isEmpty()) {
            this.mergeBridgeInitialPost(map);
            if (map.isEmpty()) {
                this.ivBridgeSubjectDataMap.remove(subjectInfoImpl);
            } else {
                this.ivBridgeSubjectDataMap.replace(subjectInfoImpl, map);
            }
        } else {
            this.mergePostsIntoBridgeGlobalState(hashMap, map);
            if (hashMap.isEmpty()) {
                boolean bl2 = false;
                if (hashMap.isEmpty()) {
                    this.ivBridgeSubjectDataMap.remove(subjectInfoImpl);
                    bl2 = true;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergeBridgeSingleSubject - remove", new Object[]{new Boolean(bl2)});
                }
            }
        }
        this.updateBridgeCoherencyTracker(subjectInfoImpl, string);
        if (!map.isEmpty() && !this.ivBridgeRebuildInProgress) {
            this.sendMergedBridgeSubjectPostNotification(subjectInfoImpl, map);
        }
    }

    private void mergeBridgeInitialPost(Map map) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeBridgeInitialPost - received", map);
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
            long l = bulletinBoardPost.getVersion();
            if (l != -1L) continue;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "mergeBridgeInitialPost - removed", bulletinBoardPost);
            }
            iterator.remove();
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeBridgeInitialPost - returned", map);
        }
    }

    private void mergePostsIntoBridgeGlobalState(Map map, Map map2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergePostsIntoBridgeGlobalState", new Object[]{map, map2});
        }
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            BulletinBoardPost bulletinBoardPost;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            BulletinBoardPost bulletinBoardPost2 = (BulletinBoardPost)entry.getValue();
            long l = bulletinBoardPost2.getVersion();
            if (l == -1L) {
                bulletinBoardPost = (BulletinBoardPost)map.remove(string);
                if (bulletinBoardPost == null) {
                    iterator.remove();
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergePostsIntoBridgeGlobalState - removed", new Object[]{bulletinBoardPost2, bulletinBoardPost});
                continue;
            }
            bulletinBoardPost = map.put(string, bulletinBoardPost2);
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "mergePostsIntoBridgeGlobalState", new Object[]{bulletinBoardPost2, bulletinBoardPost});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergePostsIntoBridgeGlobalState - returning", map);
        }
    }

    private void sendMergedLocalSubjectPostNotification(SubjectInfoImpl subjectInfoImpl, String string, BulletinBoardPost bulletinBoardPost) {
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        Set set = this.getAllSubscribers(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashMap<String, BulletinBoardPost> hashMap;
                Object[] objectArray;
                String string2 = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{subjectInfoImpl, string, string2, bulletinBoardPost};
                    Tr.debug(TC, "sendMergedLocalSubjectPostNotification", objectArray);
                }
                if ((objectArray = (Object[])this.ivUpdatesCache.get(string2)) == null) {
                    objectArray = new HashMap();
                    this.ivUpdatesCache.put(string2, objectArray);
                }
                if ((hashMap = (HashMap<String, BulletinBoardPost>)objectArray.get(subjectInfoImpl)) == null) {
                    hashMap = new HashMap<String, BulletinBoardPost>();
                    objectArray.put(subjectInfoImpl, hashMap);
                }
                BulletinBoardPost bulletinBoardPost2 = hashMap.put(string, bulletinBoardPost);
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "sendMergedLocalSubjectPostNotification - existing", bulletinBoardPost2);
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    private void sendMergedBridgeSubjectPostNotification(SubjectInfoImpl subjectInfoImpl, Map map) {
        if (this.ivGlobalStateRebuildInProgress) {
            return;
        }
        Set set = this.getAllSubscribers(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashMap hashMap;
                Object[] objectArray;
                String string = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{subjectInfoImpl, string, map};
                    Tr.debug(TC, "sendMergedBridgeSubjectPostNotification", objectArray);
                }
                if ((objectArray = (Object[])this.ivUpdatesCache.get(string)) == null) {
                    objectArray = new HashMap();
                    this.ivUpdatesCache.put(string, objectArray);
                }
                if ((hashMap = (HashMap)objectArray.get(subjectInfoImpl)) == null) {
                    hashMap = new HashMap(map);
                    objectArray.put(subjectInfoImpl, hashMap);
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "sendMergedBridgeSubjectPostNotification - new", new Integer(map.size()));
                    }
                } else {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "sendMergedBridgeSubjectPostNotification - existing", new Integer(map.size()));
                    }
                    hashMap.putAll(map);
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "sendMergedBridgeSubjectPostNotification - merged", new Integer(hashMap.size()));
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    private synchronized void startExplicitBridgeStateRebuild() {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Bridge State Rebuild Started");
        }
        this.ivBridgeSubjectCoherencyTracker.clear();
        this.ivBridgeSubjectDataMap.clear();
        this.clearUpdatesCacheOfBridgeState();
        this.ivBridgeRebuildInProgress = true;
    }

    private synchronized void clearBridgeState() {
        if (TC.isEntryEnabled()) {
            Tr.event(TC, "clearBridgeState");
        }
        this.ivBridgeSubjectDataMap.clear();
        this.ivBridgeSubscriptionsMap.clear();
    }

    private void clearUpdatesCacheOfBridgeState() {
        Iterator iterator = this.ivUpdatesCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)this.ivUpdatesCache.get(string);
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                SubjectInfo subjectInfo = (SubjectInfo)iterator2.next();
                Map map2 = (Map)map.get(subjectInfo);
                Iterator iterator3 = map2.keySet().iterator();
                while (iterator3.hasNext()) {
                    String string2 = (String)iterator3.next();
                    if (this.ivCoreGroupMembers.contains(string2)) continue;
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "clearUpdatesCacheOfBridgeState - removing poster", new Object[]{subjectInfo, string2});
                    }
                    iterator3.remove();
                    if (!map2.isEmpty()) continue;
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "clearUpdatesCacheOfBridgeState - removing subject", new Object[]{subjectInfo});
                    }
                    iterator2.remove();
                }
            }
        }
    }

    class ListenerCallback
    implements UserCallback {
        private int ivOperation;
        private ArrayList ivListeners;
        private SubjectInfo[] ivSubjects;
        private SubjectInfo[] ivAdded;
        private SubjectInfo[] ivRemoved;
        private Set ivMembers;
        private int ivDemarcationDetail;
        private String ivUserCallbackName;

        ListenerCallback(int n, ArrayList arrayList, SubjectInfo[] subjectInfoArray, int n2) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivSubjects = subjectInfoArray;
            this.ivDemarcationDetail = n2;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList, Set set) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivMembers = set;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList, SubjectInfo[] subjectInfoArray) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivSubjects = subjectInfoArray;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList, SubjectInfo[] subjectInfoArray, SubjectInfo[] subjectInfoArray2) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivAdded = subjectInfoArray;
            this.ivRemoved = subjectInfoArray2;
            this.setUserCallbackName(arrayList);
        }

        public int getQueue(int n) {
            return 0;
        }

        public String toString() {
            if (this.ivOperation == 0) {
                return "Core Group Bridge Unelected callback";
            }
            if (this.ivOperation == 1) {
                return "Core Group Bridge Elected callback";
            }
            if (this.ivOperation == 2) {
                return "Core Group Bridge Changed callback";
            }
            return "Unknown Core Group Bridge callback";
        }

        public void doCallback() {
            int n = this.ivListeners.size();
            switch (this.ivOperation) {
                case 0: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".unelected()");
                        }
                        bridgeFailoverEnablementListener.unelected();
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".elected()");
                        }
                        bridgeFailoverEnablementListener.elected(this.ivSubjects);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".subscriptionsChanged()");
                        }
                        bridgeFailoverEnablementListener.subscriptionsChanged(this.ivAdded, this.ivRemoved);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".demarcated()");
                        }
                        bridgeFailoverEnablementListener.demarcateSubscriptionChangedCallbacks(this.ivSubjects, this.ivDemarcationDetail);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".bridgeMembershipChange()");
                        }
                        bridgeFailoverEnablementListener.bridgeMembershipChange(this.ivMembers);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < n; ++i) {
                        BridgeFailoverEnablementListener bridgeFailoverEnablementListener = (BridgeFailoverEnablementListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bridgeFailoverEnablementListener.getClass().getName() + ".activeCoordinatorChange()");
                        }
                        bridgeFailoverEnablementListener.activeCoordinatorChange(this.ivMembers);
                    }
                    break;
                }
            }
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }

        private void setUserCallbackName(ArrayList arrayList) {
            this.ivUserCallbackName = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                BulletinBoardListener bulletinBoardListener = (BulletinBoardListener)arrayList.get(i);
                this.ivUserCallbackName = this.ivUserCallbackName + bulletinBoardListener.getClass().getName() + " ";
            }
        }
    }

    private class BridgeStateManager {
        public static final int UNSYNCHRONIZABLE = 0;
        public static final int SYNCHRONIZABLE = 1;
        public static final int SYNCHRONIZING = 2;
        public static final int SYNCHRONIZED = 3;
        private final String[] STATES = new String[]{"UNSYNCHRONIZABLE", "SYNCHRONIZABLE", "SYNCHRONIZING", "SYNCHRONIZED"};
        private int ivCurrentState;
        private int ivNumberOfExpectedBSRMessages;
        private GlobalBBoardBifurcatedStateManager ivGlobalBulletinBoardStateManager;
        private Set ivBridgesThatHaveSentBSRMessages;
        private Set ivConfiguredBridges;
        private boolean ivAcceptBridgeMembership = true;
        private Set ivBridgesInPreviousView = new HashSet();
        private String[] ivCurrentViewMembers;
        private Map ivOwnedSubjectsByBridge = new HashMap();

        BridgeStateManager(GlobalBBoardBifurcatedStateManager globalBBoardBifurcatedStateManager2) {
            this.ivGlobalBulletinBoardStateManager = globalBBoardBifurcatedStateManager2;
            this.ivConfiguredBridges = new HashSet();
            this.ivNumberOfExpectedBSRMessages = 0;
            this.ivBridgesThatHaveSentBSRMessages = new HashSet();
            this.ivCurrentState = 0;
        }

        public boolean bridgeStateRebuildMessageExpectedFromSender(String string) {
            boolean bl = false;
            Set set = this.getBridgesInCurrentView();
            if (set.contains(string) && !this.ivBridgesThatHaveSentBSRMessages.contains(string)) {
                bl = true;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "stateRebuildMessageExpectedFromSender", new Object[]{new Boolean(bl), set, this.ivBridgesThatHaveSentBSRMessages});
            }
            return bl;
        }

        public void setOwnedSubjects(String string, Set set) {
            this.ivOwnedSubjectsByBridge.put(string, set);
        }

        public void checkBridgeSubjectsCoherency() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Set set = this.ivOwnedSubjectsByBridge.keySet();
            HashMap hashMap = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object3 = (Set)this.ivOwnedSubjectsByBridge.get(object4);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Set<Object> set2;
                    object = (SubjectInfo)object2.next();
                    if (hashMap.containsKey(object)) {
                        set2 = (Set)hashMap.get(object);
                        set2.add(object4);
                        continue;
                    }
                    set2 = new HashSet();
                    set2.add(object4);
                    hashMap.put(object, set2);
                }
            }
            object4 = hashMap.keySet();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (SubjectInfo)object3.next();
                object = (Set)hashMap.get(object2);
                if (object.size() <= 1) continue;
                Tr.error(TC, "HMGR0230", new Object[]{object2, object});
            }
            this.ivOwnedSubjectsByBridge.clear();
        }

        public void bridgeConfigurationUpdated(String string, Set set) {
            if (TC.isDebugEnabled()) {
                Tr.entry(TC, "bridgeConfigurationUpdated ", new Object[]{new Integer(set.size()), new Boolean(this.ivAcceptBridgeMembership)});
            }
            if (this.ivAcceptBridgeMembership) {
                this.ivConfiguredBridges = set;
                this.ivAcceptBridgeMembership = false;
                if (set.isEmpty()) {
                    this.ivCurrentState = 0;
                    GlobalBBoardBifurcatedStateManager.this.ivBridgeRebuildInProgress = false;
                    this.ivBridgesInPreviousView.clear();
                } else {
                    Set set2 = this.getBridgesInCurrentView();
                    if (set2.isEmpty()) {
                        this.ivCurrentState = 1;
                    } else {
                        this.ivCurrentState = 2;
                        this.ivBridgesThatHaveSentBSRMessages.clear();
                        this.ivNumberOfExpectedBSRMessages = set2.size();
                        this.ivBridgesInPreviousView = set2;
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "bridgeConfigurationUpdated - SYNCHRONIZING", new Integer(set2.size()));
                        }
                    }
                }
                GlobalBBoardBifurcatedStateManager.this.fireBridgeMembershipChange(this.ivBridgesInPreviousView);
            } else if (this.bridgeConfigurationIsInconsistent(set)) {
                String string2 = "Inconsistent bridge configuration was received from server " + string;
                Tr.error(TC, "HMGR0108", new Object[]{GlobalBBoardBifurcatedStateManager.svClassName, "bridgeConfigurationUpdated", string2});
            }
            if (TC.isDebugEnabled()) {
                Tr.exit(TC, "bridgeConfigurationUpdated ");
            }
        }

        private boolean bridgeConfigurationIsInconsistent(Set set) {
            boolean bl = true;
            if (this.ivConfiguredBridges.size() == set.size()) {
                boolean bl2 = true;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.ivConfiguredBridges.contains(string)) continue;
                    bl2 = false;
                    break;
                }
                bl = !bl2;
            }
            return bl;
        }

        void installNewView(String[] stringArray, boolean bl) {
            if (TC.isDebugEnabled()) {
                Tr.entry(TC, "BridgeStateManager.installNewView", new Object[]{new Boolean(bl), Arrays.asList(stringArray)});
            }
            this.ivCurrentViewMembers = stringArray;
            Set set = this.getBridgesInCurrentView();
            if (bl || set.isEmpty()) {
                this.ivAcceptBridgeMembership = true;
                this.ivBridgesInPreviousView = set;
                this.ivOwnedSubjectsByBridge.clear();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "installNewView - Accept bridge membership data", new Object[]{Arrays.asList(this.ivBridgesInPreviousView.toArray())});
                }
            } else {
                boolean bl2 = false;
                if (this.ivBridgesInPreviousView.size() != 0 && set.size() == 0) {
                    bl2 = true;
                }
                boolean bl3 = true;
                if (!bl2) {
                    if (this.ivBridgesInPreviousView.size() == set.size()) {
                        boolean bl4 = bl3 = !this.ivBridgesInPreviousView.containsAll(set);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "installNewView - sizes equal", new Object[]{new Boolean(bl3), Arrays.asList(this.ivBridgesInPreviousView.toArray()), Arrays.asList(set.toArray())});
                        }
                    } else if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "installNewView - sizes not equal", new Object[]{new Boolean(bl3), Arrays.asList(this.ivBridgesInPreviousView.toArray()), Arrays.asList(set.toArray())});
                    }
                    this.ivBridgesInPreviousView = set;
                    if (set.size() > 0) {
                        if (bl3) {
                            this.ivNumberOfExpectedBSRMessages = set.size();
                            this.ivCurrentState = 2;
                            if (!GlobalBBoardBifurcatedStateManager.this.ivGlobalStateRebuildInProgress) {
                                if (TC.isDebugEnabled()) {
                                    Tr.debug(TC, "installNewView - startExplicitFSR", new Integer(this.ivNumberOfExpectedBSRMessages));
                                }
                                GlobalBBoardBifurcatedStateManager.this.fireBridgeMembershipChange(set);
                                this.ivGlobalBulletinBoardStateManager.startExplicitBridgeStateRebuild();
                            } else if (TC.isDebugEnabled()) {
                                Tr.debug(TC, "installNewView - Implicit FSR", new Object[]{this.ivBridgesInPreviousView, set});
                            }
                            this.ivOwnedSubjectsByBridge.clear();
                            this.ivBridgesThatHaveSentBSRMessages.clear();
                        } else if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "installNewView - No Bridge membership change", new Object[]{this.ivBridgesInPreviousView, set});
                        }
                    } else if (this.ivConfiguredBridges.isEmpty()) {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "installNewView - UNSYNCHRONIZABLE");
                        }
                        GlobalBBoardBifurcatedStateManager.this.ivBridgeRebuildInProgress = false;
                        this.ivCurrentState = 0;
                    } else {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "installNewView - SYNCHRONIZABLE");
                        }
                        GlobalBBoardBifurcatedStateManager.this.fireBridgeMembershipChange(set);
                        this.ivCurrentState = 1;
                        this.ivOwnedSubjectsByBridge.clear();
                        this.ivBridgesThatHaveSentBSRMessages.clear();
                    }
                } else if (bl3) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "installNewView (all bridges died) - SYNCHRONIZABLE");
                    }
                    this.ivCurrentState = 1;
                    this.ivOwnedSubjectsByBridge.clear();
                    GlobalBBoardBifurcatedStateManager.this.clearBridgeState();
                }
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "BridgeStateManager.installNewView");
            }
        }

        int getState() {
            return this.ivCurrentState;
        }

        public int calculateNewState(String string, int n) {
            if (this.ivCurrentState == 2 && (n == 2 || n == 3)) {
                this.ivBridgesThatHaveSentBSRMessages.add(string);
                if (this.ivBridgesThatHaveSentBSRMessages.size() == this.ivNumberOfExpectedBSRMessages) {
                    this.ivCurrentState = 3;
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculateNewState", new Object[]{this.STATES[this.ivCurrentState], new Integer(this.ivNumberOfExpectedBSRMessages), new Integer(this.ivBridgesThatHaveSentBSRMessages.size())});
            }
            return this.ivCurrentState;
        }

        private Set getBridgesInCurrentView() {
            HashSet<String> hashSet = new HashSet<String>();
            if (this.ivConfiguredBridges.size() > 0) {
                for (int i = 0; i < this.ivCurrentViewMembers.length; ++i) {
                    if (!this.ivConfiguredBridges.contains(this.ivCurrentViewMembers[i])) continue;
                    hashSet.add(this.ivCurrentViewMembers[i]);
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getBridgesInCurrentView", new Object[]{Arrays.asList(this.ivCurrentViewMembers), Arrays.asList(this.ivConfiguredBridges.toArray()), Arrays.asList(hashSet.toArray())});
            }
            return hashSet;
        }
    }
}

