/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.BulletinBoardSubjectSnapshot;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.BulletinBoardServerPosts;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.GlobalBulletinBoardStateManager;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.BulletinBoardSubscriberUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.BulletinBoardSnapshotMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.BulletinBoardSubjectSnapshotImpl;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardListener;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlobalBBoardUnifiedStateManager
extends GlobalBulletinBoardStateManager {
    private static final TraceComponent TC = Tr.register(GlobalBBoardUnifiedStateManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "GlobalBBoardUnifiedStateManager";
    private CoordinatorImpl ivCoordinator;
    private boolean ivRebuildInProgress = true;
    private long ivRebuildStartTime;
    private Map ivSubjectDataMap;
    private Map ivSubscriptionMap;
    private Map ivCache;
    private Map ivUnsentGSRMessages;
    MessageCache ivMessageCache;
    Version ivProtocolVersion;
    private boolean ivActive;
    private boolean ivOptimizeUpdates = true;

    GlobalBBoardUnifiedStateManager(CoordinatorImpl coordinatorImpl, MessageCache messageCache, boolean bl, Version version) {
        this.ivCoordinator = coordinatorImpl;
        this.ivSubjectDataMap = new TreeMap();
        this.ivSubscriptionMap = new TreeMap();
        this.ivUnsentGSRMessages = new HashMap();
        this.ivCache = new HashMap();
        this.ivMessageCache = messageCache;
        this.ivRebuildInProgress = false;
        this.ivListeners = new ArrayList(1);
        this.ivActive = bl;
        this.ivProtocolVersion = version;
        this.setWireProtocol();
    }

    void updateCoreGroupMembership(Set set) {
    }

    void fireActiveCoordinatorChange(Set set) {
    }

    synchronized boolean sendCachedMessages() {
        if (this.ivRebuildInProgress) {
            return false;
        }
        this.sendPendingGSRMessages();
        return this.doSendCachedMessages();
    }

    synchronized void startGSR(boolean bl) {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Rebuild is initiated", new Object[]{new Boolean(this.ivActive), new Boolean(bl)});
        }
        this.ivSubjectDataMap.clear();
        this.ivSubscriptionMap.clear();
        this.ivUnsentGSRMessages.clear();
        this.ivCache.clear();
        this.setWireProtocol();
        if (this.ivActive && !bl) {
            if (this.ivListeners.size() > 0) {
                this.fireUnelected();
            }
        } else if (!this.ivActive && bl && this.ivListeners.size() > 0) {
            this.fireElected(this.ivListeners, null);
        }
        this.ivActive = bl;
        if (this.ivActive) {
            this.ivRebuildInProgress = true;
            this.ivRebuildStartTime = System.currentTimeMillis();
        }
    }

    synchronized boolean gsrRebuildComplete() throws HAInternalStateException {
        HAManagerPerf hAManagerPerf;
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Rebuild is complete");
        }
        if ((hAManagerPerf = this.ivCoordinator.getPMI()) != null && hAManagerPerf.isBulletinBoardRebuildTimeEnabled()) {
            hAManagerPerf.bbRebuildComplete(System.currentTimeMillis() - this.ivRebuildStartTime);
        }
        this.buildGlobalStateMessages();
        boolean bl = this.doSendCachedMessages();
        this.ivRebuildInProgress = false;
        return bl;
    }

    synchronized void updateState(String string, HAMMessage hAMMessage, boolean bl) throws HAInternalStateException {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{string, new Boolean(this.ivRebuildInProgress), new Boolean(bl)};
            Tr.entry(TC, "updateState()", objectArray);
        }
        objectArray = (Object[])hAMMessage;
        Map map = objectArray.getBulletinBoardValues();
        if (!this.ivOptimizeUpdates) {
            this.replaceSubjects(string, map, false);
        } else if (bl) {
            this.replaceSubjects(string, map, true);
        } else {
            this.mergeSubjects(string, map);
        }
        Map map2 = objectArray.getSubscribers();
        this.updateBulletinBoardSubscriptions(string, map2, false);
        HAManagerPerf hAManagerPerf = this.ivCoordinator.getPMI();
        if (hAManagerPerf != null) {
            hAManagerPerf.bbReportPopulation(this.ivSubjectDataMap.size(), this.ivSubscriptionMap.size());
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateState");
        }
    }

    synchronized void removeDeadServers(Set set) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadServers()", set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.ivCache.remove(string);
            this.ivUnsentGSRMessages.remove(string);
        }
        this.removeDeadSubscriptions(set);
        this.removeDeadSubjects(set);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadServers()");
        }
    }

    synchronized void handleJMXRequest(BulletinBoardSnapshotMessage bulletinBoardSnapshotMessage) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator = this.ivSubjectDataMap.keySet().iterator();
        boolean bl = bulletinBoardSnapshotMessage.getBoardName().length() != 0;
        boolean bl2 = bulletinBoardSnapshotMessage.getSubjectFilter().length() != 0;
        Pattern pattern = null;
        int n = 0;
        if (bulletinBoardSnapshotMessage.getMaxSubjects() <= 0) {
            bulletinBoardSnapshotMessage.setMaxSubjects(1);
        }
        if (bl2) {
            pattern = Pattern.compile(bulletinBoardSnapshotMessage.getSubjectFilter());
        }
        while (iterator.hasNext() && n < bulletinBoardSnapshotMessage.getMaxSubjects()) {
            stringArray = (String[])iterator.next();
            if (bl && !stringArray.getBoardName().equals(bulletinBoardSnapshotMessage.getBoardName())) continue;
            boolean bl3 = true;
            if (pattern != null) {
                object4 = pattern.matcher(stringArray.getSubjectName());
                bl3 = ((Matcher)object4).find();
            }
            if (!bl3) continue;
            object4 = null;
            object4 = new BulletinBoardSubjectSnapshotImpl();
            hashMap.put(stringArray, object4);
            ++n;
            ((BulletinBoardSubjectSnapshotImpl)object4).setSubjectName(stringArray.getSubjectName());
            ((BulletinBoardSubjectSnapshotImpl)object4).setBoardName(stringArray.getBoardName());
            Map map = (Map)this.ivSubjectDataMap.get(stringArray);
            object3 = new String[map.size()];
            object2 = new int[((String[])object3).length];
            ((BulletinBoardSubjectSnapshotImpl)object4).setPostSizes((int[])object2);
            ((BulletinBoardSubjectSnapshotImpl)object4).setPostingServers((String[])object3);
            object = map.keySet().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                String string;
                object3[n2] = string = (String)object.next();
                object2[n2] = false;
                BulletinBoardServerPosts bulletinBoardServerPosts = (BulletinBoardServerPosts)map.get(string);
                Iterator iterator2 = bulletinBoardServerPosts.values().iterator();
                while (iterator2.hasNext()) {
                    BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)iterator2.next();
                    Object object5 = object2;
                    int n3 = n2;
                    object5[n3] = object5[n3] + bulletinBoardPost.getValue().length;
                }
                ++n2;
            }
        }
        iterator = this.ivSubscriptionMap.keySet().iterator();
        stringArray = new String[]{};
        int[] nArray = new int[]{};
        while (iterator.hasNext()) {
            object4 = (BulletinBoardSubjectSnapshot[])iterator.next();
            if (bl && !((SubjectInfoImpl)object4).getBoardName().equals(bulletinBoardSnapshotMessage.getBoardName())) continue;
            boolean bl4 = true;
            if (pattern != null) {
                object3 = pattern.matcher(((SubjectInfoImpl)object4).getSubjectName());
                bl4 = object3.find();
            }
            if (!bl4) continue;
            object3 = (BulletinBoardSubjectSnapshotImpl)hashMap.get(object4);
            if (object3 == null) {
                if (n == bulletinBoardSnapshotMessage.getMaxSubjects()) break;
                ++n;
                object3 = new BulletinBoardSubjectSnapshotImpl();
                object3.setBoardName(((SubjectInfoImpl)object4).getBoardName());
                object3.setSubjectName(((SubjectInfoImpl)object4).getSubjectName());
                object3.setPostingServers(stringArray);
                object3.setPostSizes(nArray);
                hashMap.put(object4, object3);
            }
            object2 = (Set)this.ivSubscriptionMap.get(object4);
            object = new String[object2.size()];
            object2.toArray((T[])object);
            object3.setSubscribingServers((String[])object);
        }
        object4 = new BulletinBoardSubjectSnapshot[hashMap.size()];
        hashMap.values().toArray((T[])object4);
        bulletinBoardSnapshotMessage.setSubjectSnapshot((BulletinBoardSubjectSnapshot[])object4);
    }

    synchronized void addListener(BulletinBoardListener bulletinBoardListener) {
        if (!this.ivListeners.contains(bulletinBoardListener)) {
            this.ivListeners.add(bulletinBoardListener);
            if (this.ivActive) {
                Set set = this.ivSubscriptionMap.keySet();
                SubjectInfo[] subjectInfoArray = new SubjectInfo[set.size()];
                subjectInfoArray = set.toArray(subjectInfoArray);
                ArrayList<BulletinBoardListener> arrayList = new ArrayList<BulletinBoardListener>();
                arrayList.add(bulletinBoardListener);
                this.fireElected(arrayList, subjectInfoArray);
            }
        }
    }

    private void fireElected(ArrayList arrayList, SubjectInfo[] subjectInfoArray) {
        ListenerCallback listenerCallback = new ListenerCallback(1, arrayList, subjectInfoArray);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireSubscriptionsChanged(SubjectInfo[] subjectInfoArray, SubjectInfo[] subjectInfoArray2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "addedSubscriptions", subjectInfoArray);
            Tr.debug(TC, "removedSubscriptions", subjectInfoArray2);
        }
        ListenerCallback listenerCallback = new ListenerCallback(2, this.ivListeners, subjectInfoArray, subjectInfoArray2);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void fireUnelected() {
        ListenerCallback listenerCallback = new ListenerCallback(0, this.ivListeners);
        UserCallbacks.executeCallback(listenerCallback);
    }

    private void setWireProtocol() {
        int n = this.ivProtocolVersion.getHAMProtocolVersion();
        this.ivOptimizeUpdates = n >= 1;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "setWireProtocol", new Integer(n));
        }
    }

    private void sendSubjectPostNotification(SubjectInfoImpl subjectInfoImpl, String string, BulletinBoardServerPosts bulletinBoardServerPosts) {
        if (this.ivRebuildInProgress) {
            return;
        }
        Set set = (Set)this.ivSubscriptionMap.get(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashMap<String, BulletinBoardServerPosts> hashMap;
                HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardServerPosts>> hashMap2;
                String string2 = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "sendSubjectPostNotification", new Object[]{subjectInfoImpl, string, string2, bulletinBoardServerPosts});
                }
                if ((hashMap2 = (HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardServerPosts>>)this.ivCache.get(string2)) == null) {
                    hashMap2 = new HashMap<SubjectInfoImpl, HashMap<String, BulletinBoardServerPosts>>();
                    this.ivCache.put(string2, hashMap2);
                }
                if ((hashMap = (HashMap<String, BulletinBoardServerPosts>)hashMap2.get(subjectInfoImpl)) == null) {
                    hashMap = new HashMap<String, BulletinBoardServerPosts>();
                    hashMap2.put(subjectInfoImpl, hashMap);
                }
                hashMap.put(string, bulletinBoardServerPosts);
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    private void sendPostsToNewSubscriber(String string, SubjectInfoImpl subjectInfoImpl) {
        if (this.ivRebuildInProgress) {
            return;
        }
        Map map = (Map)this.ivSubjectDataMap.get(subjectInfoImpl);
        if (map == null) {
            return;
        }
        HashMap hashMap = new HashMap(map);
        HashMap hashMap2 = (HashMap)this.ivCache.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.ivCache.put(string, hashMap2);
        }
        hashMap2.put(subjectInfoImpl, hashMap);
        this.ivMessageCache.activeCoordinatorMessagesToSend();
    }

    private void buildGlobalStateMessages() {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildGlobalStateMessages initiated");
        }
        Iterator iterator = this.ivSubscriptionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            Set set = (Set)entry.getValue();
            Map map = (Map)this.ivSubjectDataMap.get(subjectInfoImpl);
            if (map == null) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "sendAllState - no posts for subject", subjectInfoImpl);
                continue;
            }
            HashMap hashMap = new HashMap(map);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                HashMap hashMap2 = (HashMap)this.ivCache.get(string);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    this.ivCache.put(string, hashMap2);
                }
                hashMap2.put(subjectInfoImpl, hashMap);
            }
        }
        if (TC.isEventEnabled()) {
            Tr.event(TC, "buildGlobalStateMessages completed");
        }
    }

    private void sendPendingGSRMessages() {
        String string = null;
        BulletinBoardSubscriberUpdateMsg bulletinBoardSubscriberUpdateMsg = null;
        if (this.ivUnsentGSRMessages.size() != 0) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "sendPendingGSRMessages - GSR cache at entry", this.ivUnsentGSRMessages);
            }
            Iterator iterator = this.ivUnsentGSRMessages.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string = (String)entry.getKey();
                bulletinBoardSubscriberUpdateMsg = (BulletinBoardSubscriberUpdateMsg)entry.getValue();
                try {
                    this.ivCoordinator.sendMessage(string, (HAMMessage)bulletinBoardSubscriberUpdateMsg);
                    iterator.remove();
                }
                catch (DataStackException dataStackException) {
                    FFDCFilter.processException((Throwable)dataStackException, svClassName, "608", this);
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "sendPendingGSRMessages - GSR cache at exit", this.ivUnsentGSRMessages);
            }
        }
    }

    private boolean doSendCachedMessages() {
        boolean bl = true;
        Iterator iterator = this.ivCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            if (this.ivUnsentGSRMessages.containsKey(string)) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doSendCachedMessages - GSR message in cache", string);
                }
                bl = false;
                continue;
            }
            try {
                this.ivCoordinator.sendMessage(string, (HAMMessage)new BulletinBoardSubscriberUpdateMsg(this.ivRebuildInProgress, map));
                iterator.remove();
            }
            catch (DataStackException dataStackException) {
                FFDCFilter.processException((Throwable)dataStackException, svClassName, "505", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doSendCachedMessages - Exception received during sendMessage", dataStackException);
                }
                bl = false;
            }
        }
        return bl;
    }

    private void removeDeadSubscriptions(Set set) throws HAInternalStateException {
        SubjectInfo[] subjectInfoArray;
        Serializable serializable;
        Object object;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadSubscriptions", set);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator iterator = this.ivSubscriptionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = (SubjectInfoImpl)iterator.next();
            serializable = (HashSet)this.ivSubscriptionMap.get(object);
            subjectInfoArray = ((HashSet)serializable).iterator();
            arrayList.clear();
            while (subjectInfoArray.hasNext()) {
                object2 = (String)subjectInfoArray.next();
                if (!set.contains(object2)) continue;
                arrayList.add(object2);
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                ((HashSet)serializable).remove(string);
            }
            if (((HashSet)serializable).size() != 0) continue;
            arrayList2.add(object);
        }
        object = arrayList2.iterator();
        while (object.hasNext()) {
            serializable = (SubjectInfoImpl)object.next();
            this.ivSubscriptionMap.remove(serializable);
        }
        if (this.ivListeners.size() > 0 && arrayList2.size() > 0) {
            serializable = new SubjectInfo[]{};
            subjectInfoArray = new SubjectInfo[arrayList2.size()];
            subjectInfoArray = arrayList2.toArray(subjectInfoArray);
            this.fireSubscriptionsChanged((SubjectInfo[])serializable, subjectInfoArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadSubscriptions()");
        }
    }

    private void removeDeadSubjects(Set set) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadSubject", set);
        }
        Iterator iterator = this.ivSubjectDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!set.contains(string)) continue;
                iterator2.remove();
                this.sendSubjectPostNotification(subjectInfoImpl, string, null);
            }
            if (!hashMap.isEmpty()) continue;
            iterator.remove();
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadSubjects()");
        }
    }

    private void replaceSubjects(String string, Map map, boolean bl) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "replaceSubjects()", new Object[]{string, new Boolean(this.ivOptimizeUpdates)});
        }
        if (!map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                BulletinBoardServerPosts bulletinBoardServerPosts = (BulletinBoardServerPosts)entry.getValue();
                if (bl) {
                    this.replaceSubjectDuringGSR(string, subjectInfoImpl, bulletinBoardServerPosts);
                    continue;
                }
                this.replaceSubjectNormal(string, subjectInfoImpl, bulletinBoardServerPosts);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "replaceSubjects()");
        }
    }

    private void replaceSubjectDuringGSR(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardServerPosts bulletinBoardServerPosts) throws HAInternalStateException {
        BulletinBoardServerPosts bulletinBoardServerPosts2;
        HashMap<String, BulletinBoardServerPosts> hashMap = (HashMap<String, BulletinBoardServerPosts>)this.ivSubjectDataMap.get(subjectInfoImpl);
        if (bulletinBoardServerPosts == null) {
            String string2 = "Null posts received for Subject " + subjectInfoImpl + " from server " + string;
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "replaceSubjectDuringGSR", string2});
            return;
        }
        if (bulletinBoardServerPosts.isEmpty()) {
            String string3 = "Empty posts received for Subject " + subjectInfoImpl + " from server " + string;
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "replaceSubjectDuringGSR", string3});
            return;
        }
        boolean bl = false;
        if (hashMap == null) {
            hashMap = new HashMap<String, BulletinBoardServerPosts>();
            this.ivSubjectDataMap.put(subjectInfoImpl, hashMap);
            bl = true;
        }
        if ((bulletinBoardServerPosts2 = hashMap.put(string, bulletinBoardServerPosts)) != null) {
            String string4 = "Existing posts for Subject " + subjectInfoImpl + " from server " + string;
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "replaceSubjectDuringGSR", string4});
            return;
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, bulletinBoardServerPosts, new Boolean(bl), bulletinBoardServerPosts2};
            Tr.debug(TC, "replaceSubjectDuringGSR", objectArray);
        }
    }

    private void replaceSubjectNormal(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardServerPosts bulletinBoardServerPosts) throws HAInternalStateException {
        HashMap<String, BulletinBoardServerPosts> hashMap = (HashMap<String, BulletinBoardServerPosts>)this.ivSubjectDataMap.get(subjectInfoImpl);
        if (bulletinBoardServerPosts == null || bulletinBoardServerPosts.isEmpty()) {
            if (hashMap == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "replaceSubjectNormal - clear nonexisting", new Object[]{string, subjectInfoImpl});
                }
            } else {
                Object[] objectArray;
                BulletinBoardServerPosts bulletinBoardServerPosts2 = (BulletinBoardServerPosts)hashMap.remove(string);
                boolean bl = hashMap.isEmpty();
                if (bl) {
                    this.ivSubjectDataMap.remove(subjectInfoImpl);
                }
                if (bulletinBoardServerPosts2 != null) {
                    this.sendSubjectPostNotification(subjectInfoImpl, string, null);
                }
                if (bulletinBoardServerPosts != null) {
                    objectArray = "Empty posts for Subject " + subjectInfoImpl + " from server " + string;
                    Tr.error(TC, "HMGR0108", new Object[]{svClassName, "replaceSubjectNormal", objectArray});
                }
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{string, subjectInfoImpl, new Boolean(bl), bulletinBoardServerPosts2};
                    Tr.debug(TC, "replaceSubjectNormal - clear", objectArray);
                }
            }
            return;
        }
        boolean bl = false;
        if (hashMap == null) {
            hashMap = new HashMap<String, BulletinBoardServerPosts>();
            this.ivSubjectDataMap.put(subjectInfoImpl, hashMap);
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, subjectInfoImpl, bulletinBoardServerPosts, new Boolean(bl)};
            Tr.debug(TC, "replaceSubjectNormal - add", objectArray);
        }
        hashMap.put(string, bulletinBoardServerPosts);
        this.sendSubjectPostNotification(subjectInfoImpl, string, bulletinBoardServerPosts);
    }

    private void updateBulletinBoardSubscriptions(String string, Map map, boolean bl) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "updateBulletinBoardSubscriptions()", new Object[]{string});
        }
        if (!map.isEmpty()) {
            Map map2 = this.ivSubscriptionMap;
            int n = map.size();
            ArrayList arrayList = new ArrayList(n);
            ArrayList arrayList2 = new ArrayList(n);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                boolean bl2 = (Boolean)entry.getValue();
                this.updateSubscriptionsForSubject(map2, string, subjectInfoImpl, bl2, arrayList2, arrayList);
            }
            if (this.ivListeners.size() > 0 && !bl) {
                int n2 = arrayList2.size();
                int n3 = arrayList.size();
                if (n2 > 0 || n3 > 0) {
                    SubjectInfo[] subjectInfoArray = new SubjectInfo[n2];
                    subjectInfoArray = arrayList2.toArray(subjectInfoArray);
                    SubjectInfo[] subjectInfoArray2 = new SubjectInfo[n3];
                    subjectInfoArray2 = arrayList.toArray(subjectInfoArray2);
                    this.fireSubscriptionsChanged(subjectInfoArray, subjectInfoArray2);
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateBulletinBoardSubscriptions()");
        }
    }

    private void updateSubscriptionsForSubject(Map map, String string, SubjectInfoImpl subjectInfoImpl, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        HashSet<String> hashSet = null;
        hashSet = (HashSet<String>)map.get(subjectInfoImpl);
        if (bl) {
            boolean bl2 = false;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                map.put(subjectInfoImpl, hashSet);
                bl2 = true;
                arrayList.add(subjectInfoImpl);
            }
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{subjectInfoImpl, string, new Boolean(bl2)};
                Tr.debug(TC, "updateSubscriptionsForSubject - add", objectArray);
            }
            hashSet.add(string);
            this.sendPostsToNewSubscriber(string, subjectInfoImpl);
        } else if (hashSet == null) {
            Tr.debug(TC, "updateSubscriptionsForSubject - BUG", new Object[]{string, subjectInfoImpl});
        } else {
            boolean bl3 = false;
            hashSet.remove(string);
            if (hashSet.isEmpty()) {
                arrayList2.add(subjectInfoImpl);
                bl3 = true;
                map.remove(subjectInfoImpl);
            }
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{subjectInfoImpl, string, new Boolean(bl3)};
                Tr.debug(TC, "updateSubscriptionsForSubject - remove", objectArray);
            }
        }
    }

    private void mergeSubjects(String string, Map map) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "mergeSubjects()", new Object[]{string});
        }
        if (map.isEmpty()) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            BulletinBoardServerPosts bulletinBoardServerPosts = (BulletinBoardServerPosts)entry.getValue();
            if (bulletinBoardServerPosts == null || bulletinBoardServerPosts.isEmpty()) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergeSubjects", bulletinBoardServerPosts);
                continue;
            }
            this.mergeSingleSubject(string, subjectInfoImpl, bulletinBoardServerPosts);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeSubjects()");
        }
    }

    private void mergeSingleSubject(String string, SubjectInfoImpl subjectInfoImpl, BulletinBoardServerPosts bulletinBoardServerPosts) {
        BulletinBoardServerPosts bulletinBoardServerPosts2;
        boolean bl = false;
        HashMap<String, BulletinBoardServerPosts> hashMap = (HashMap<String, BulletinBoardServerPosts>)this.ivSubjectDataMap.get(subjectInfoImpl);
        if (hashMap == null) {
            hashMap = new HashMap<String, BulletinBoardServerPosts>();
            this.ivSubjectDataMap.put(subjectInfoImpl, hashMap);
            bl = true;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeSingleSubject", new Object[]{string, subjectInfoImpl, bulletinBoardServerPosts, new Boolean(bl)});
        }
        if ((bulletinBoardServerPosts2 = (BulletinBoardServerPosts)hashMap.get(string)) == null) {
            this.mergeInitialPosts(bulletinBoardServerPosts);
            if (bulletinBoardServerPosts.isEmpty()) {
                if (hashMap.isEmpty()) {
                    this.ivSubjectDataMap.remove(subjectInfoImpl);
                }
            } else {
                bulletinBoardServerPosts2 = bulletinBoardServerPosts;
                hashMap.put(string, bulletinBoardServerPosts2);
            }
        } else {
            this.mergePostsIntoGlobalState(bulletinBoardServerPosts2, bulletinBoardServerPosts);
            if (bulletinBoardServerPosts2.isEmpty()) {
                hashMap.remove(string);
                boolean bl2 = false;
                if (hashMap.isEmpty()) {
                    this.ivSubjectDataMap.remove(subjectInfoImpl);
                    bl2 = true;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "mergeSingleSubject - remove", new Object[]{new Boolean(bl2)});
                }
            }
        }
        if (!bulletinBoardServerPosts.isEmpty()) {
            this.sendMergedSubjectPostNotification(subjectInfoImpl, string, bulletinBoardServerPosts);
        }
    }

    private void mergeInitialPosts(BulletinBoardServerPosts bulletinBoardServerPosts) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeInitialPosts - received", bulletinBoardServerPosts);
        }
        Map map = bulletinBoardServerPosts.getAndOwnEntries();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
            long l = bulletinBoardPost.getVersion();
            if (l != -1L) continue;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "mergeInitialPosts - removed", bulletinBoardPost);
            }
            iterator.remove();
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergeInitialPosts - returned", bulletinBoardServerPosts);
        }
    }

    private void mergePostsIntoGlobalState(BulletinBoardServerPosts bulletinBoardServerPosts, BulletinBoardServerPosts bulletinBoardServerPosts2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergePostsIntoGlobalState", new Object[]{bulletinBoardServerPosts, bulletinBoardServerPosts2});
        }
        Map map = bulletinBoardServerPosts2.getAndOwnEntries();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            BulletinBoardPost bulletinBoardPost;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            BulletinBoardPost bulletinBoardPost2 = (BulletinBoardPost)entry.getValue();
            long l = bulletinBoardPost2.getVersion();
            if (l == -1L) {
                bulletinBoardPost = bulletinBoardServerPosts.remove(string);
                if (bulletinBoardPost == null) {
                    iterator.remove();
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "mergePostsIntoGlobalState - removed", new Object[]{bulletinBoardPost2, bulletinBoardPost});
                continue;
            }
            bulletinBoardPost = bulletinBoardServerPosts.put(string, bulletinBoardPost2);
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "mergePostsIntoGlobalState", new Object[]{bulletinBoardPost2, bulletinBoardPost});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "mergePostsIntoGlobalState - returning", bulletinBoardServerPosts);
        }
    }

    private void sendMergedSubjectPostNotification(SubjectInfoImpl subjectInfoImpl, String string, BulletinBoardServerPosts bulletinBoardServerPosts) {
        if (this.ivRebuildInProgress) {
            return;
        }
        Set set = (Set)this.ivSubscriptionMap.get(subjectInfoImpl);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashMap<String, BulletinBoardServerPosts> hashMap;
                Object[] objectArray;
                String string2 = (String)iterator.next();
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{subjectInfoImpl, string, string2, bulletinBoardServerPosts};
                    Tr.debug(TC, "sendMergedSubjectPostNotification", objectArray);
                }
                if ((objectArray = (Object[])this.ivCache.get(string2)) == null) {
                    objectArray = new HashMap();
                    this.ivCache.put(string2, objectArray);
                }
                if ((hashMap = (HashMap<String, BulletinBoardServerPosts>)objectArray.get(subjectInfoImpl)) == null) {
                    hashMap = new HashMap<String, BulletinBoardServerPosts>();
                    objectArray.put(subjectInfoImpl, hashMap);
                }
                BulletinBoardServerPosts bulletinBoardServerPosts2 = (BulletinBoardServerPosts)hashMap.get(string);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "sendMergedSubjectPostNotification - existing", bulletinBoardServerPosts2);
                }
                if (bulletinBoardServerPosts2 == null) {
                    hashMap.put(string, bulletinBoardServerPosts);
                } else {
                    Map map = bulletinBoardServerPosts.getAndOwnEntries();
                    Set set2 = map.entrySet();
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        String string3 = (String)entry.getKey();
                        BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
                        bulletinBoardServerPosts2.put(string3, bulletinBoardPost);
                    }
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "sendMergedSubjectPostNotification - merged", bulletinBoardServerPosts2);
            }
            this.ivMessageCache.activeCoordinatorMessagesToSend();
        }
    }

    class ListenerCallback
    implements UserCallback {
        private int ivOperation;
        private ArrayList ivListeners;
        private SubjectInfo[] ivSubjects;
        private SubjectInfo[] ivAdded;
        private SubjectInfo[] ivRemoved;
        private String ivUserCallbackName;

        ListenerCallback(int n, ArrayList arrayList) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList, SubjectInfo[] subjectInfoArray) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivSubjects = subjectInfoArray;
            this.setUserCallbackName(arrayList);
        }

        ListenerCallback(int n, ArrayList arrayList, SubjectInfo[] subjectInfoArray, SubjectInfo[] subjectInfoArray2) {
            this.ivOperation = n;
            this.ivListeners = arrayList;
            this.ivAdded = subjectInfoArray;
            this.ivRemoved = subjectInfoArray2;
            this.setUserCallbackName(arrayList);
        }

        public int getQueue(int n) {
            return 0;
        }

        public String toString() {
            if (this.ivOperation == 0) {
                return "Core Group Bridge Unelected callback";
            }
            if (this.ivOperation == 1) {
                return "Core Group Bridge Elected callback";
            }
            if (this.ivOperation == 2) {
                return "Core Group Bridge Changed callback";
            }
            return "Unknown Core Group Bridge callback";
        }

        public void doCallback() {
            int n = this.ivListeners.size();
            switch (this.ivOperation) {
                case 0: {
                    for (int i = 0; i < n; ++i) {
                        BulletinBoardListener bulletinBoardListener = (BulletinBoardListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bulletinBoardListener.getClass().getName() + ".unelected()");
                        }
                        bulletinBoardListener.unelected();
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        BulletinBoardListener bulletinBoardListener = (BulletinBoardListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bulletinBoardListener.getClass().getName() + ".elected()");
                        }
                        bulletinBoardListener.elected(this.ivSubjects);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        BulletinBoardListener bulletinBoardListener = (BulletinBoardListener)this.ivListeners.get(i);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "doCallback - " + bulletinBoardListener.getClass().getName() + ".subscriptionsChanged()");
                        }
                        bulletinBoardListener.subscriptionsChanged(this.ivAdded, this.ivRemoved);
                    }
                    break;
                }
            }
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }

        private void setUserCallbackName(ArrayList arrayList) {
            this.ivUserCallbackName = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                BulletinBoardListener bulletinBoardListener = (BulletinBoardListener)arrayList.get(i);
                this.ivUserCallbackName = this.ivUserCallbackName + bulletinBoardListener.getClass().getName() + " ";
            }
        }
    }
}

