/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.websphere.hamanager.jmx.ServerWithActiveGroups;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.impl.AppGroupState;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.impl.jmx.ServerWithActiveGroupsImpl;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.vsmessages.ActiveCoordinatorMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupMemberActivationCmdMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportClusterProcessStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.CountActiveMembersOnServerMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.FindGroupName;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXActionMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXCoordinatorRPCMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXGroupData;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.MigrateActiveMemberMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.RetrieveMembersMsg;
import com.ibm.ws.hamanager.impl.MemberDataImpl;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class GlobalGroupStateManager {
    private static final TraceComponent TC = Tr.register(GlobalGroupStateManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "GlobalGroupStateManager";
    private CoordinatorImpl ivCoordinator;
    private long ivRebuildStartTime;
    private boolean ivRebuildInProgress;
    private Map ivGroupStateMap;
    private Map ivGroupUpdateMsgCache;
    private Map ivGroupActivationMsgCache;
    MessageCache ivMessageCache;

    GlobalGroupStateManager(CoordinatorImpl coordinatorImpl, MessageCache messageCache) {
        this.ivCoordinator = coordinatorImpl;
        this.ivMessageCache = messageCache;
        this.ivGroupStateMap = new TreeMap();
        this.ivGroupUpdateMsgCache = new HashMap();
        this.ivGroupActivationMsgCache = new HashMap();
        this.ivRebuildInProgress = false;
    }

    void handleJMXRequest(JMXCoordinatorRPCMsg jMXCoordinatorRPCMsg) {
        RetrieveMembersMsg retrieveMembersMsg;
        AppGroupState appGroupState;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "handleJMXRequest", jMXCoordinatorRPCMsg.getDescription());
        }
        if (jMXCoordinatorRPCMsg instanceof FindGroupName) {
            FindGroupName findGroupName = (FindGroupName)jMXCoordinatorRPCMsg;
            GroupName groupName = findGroupName.getGroupName();
            boolean bl = findGroupName.sendMemberData();
            ArrayList<JMXGroupData> arrayList = new ArrayList<JMXGroupData>();
            ArrayList arrayList2 = null;
            arrayList2 = this.findGroups(groupName, findGroupName.getMaxGroupsPerCoordinator());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                GroupName groupName2 = (GroupName)iterator.next();
                try {
                    arrayList.add(this.getJMXGroupData(groupName2, bl));
                }
                catch (HAInternalStateException hAInternalStateException) {
                    FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "163", this);
                    Tr.error(TC, "HMGR0108", new Object[]{this.getClass().getName(), "handleJMXRequest", hAInternalStateException});
                }
            }
            findGroupName.getGroupNamesFound().addAll(arrayList2);
            findGroupName.getGroupMapList().addAll(arrayList);
        } else if (jMXCoordinatorRPCMsg instanceof CountActiveMembersOnServerMsg) {
            CountActiveMembersOnServerMsg countActiveMembersOnServerMsg = (CountActiveMembersOnServerMsg)jMXCoordinatorRPCMsg;
            countActiveMembersOnServerMsg.setResults(this.countActiveGroupsOnServers(countActiveMembersOnServerMsg.getMatchset(), countActiveMembersOnServerMsg.getMaxActiveGroupsPerServer()));
        } else if (jMXCoordinatorRPCMsg instanceof RetrieveMembersMsg && (appGroupState = (AppGroupState)this.ivGroupStateMap.get((retrieveMembersMsg = (RetrieveMembersMsg)jMXCoordinatorRPCMsg).getGroupName())) != null) {
            retrieveMembersMsg.getMemberData().putAll(appGroupState.getMemberMap());
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "handleJMXRequest");
        }
    }

    JMXGroupData getJMXGroupData(GroupName groupName, boolean bl) throws HAInternalStateException {
        Object object;
        JMXGroupData jMXGroupData = new JMXGroupData();
        String[] stringArray = null;
        try {
            object = this.ivCoordinator.getPolicyManager().findHAPolicyRuleForGroup(groupName);
            stringArray = new String[]{object.getRuleName()};
        }
        catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
            FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "209", this);
            stringArray = new String[]{};
        }
        catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
            FFDCFilter.processException((Throwable)duplicatePoliciesMatchGroupException, svClassName, "214", this);
            stringArray = new String[duplicatePoliciesMatchGroupException.getMatchingRules().length];
            System.arraycopy(duplicatePoliciesMatchGroupException.getMatchingRules(), 0, stringArray, 0, duplicatePoliciesMatchGroupException.getMatchingRules().length);
        }
        jMXGroupData.setPolicyRules(stringArray);
        object = (AppGroupState)this.ivGroupStateMap.get(groupName);
        GroupPolicy groupPolicy = ((AppGroupState)object).getPolicy();
        if (groupPolicy != null) {
            if (!groupPolicy.isQuorumRequired()) {
                jMXGroupData.setQuorumState(0);
            } else if (((AppGroupState)object).hasQuorum(false)) {
                jMXGroupData.setQuorumState(2);
            } else {
                jMXGroupData.setQuorumState(1);
            }
        } else {
            jMXGroupData.setQuorumState(-1);
        }
        if (bl) {
            jMXGroupData.setMemberMap(((AppGroupState)object).getMemberMap());
        }
        return jMXGroupData;
    }

    ArrayList findGroups(GroupName groupName, int n) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "findGroups - max allowed return size=" + n);
        }
        ArrayList<GroupName> arrayList = new ArrayList<GroupName>();
        Map map = groupName != null ? groupName.getGroupProperties() : null;
        Iterator iterator = this.ivGroupStateMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext() && (n <= 0 || n2 < n)) {
            GroupName groupName2 = (GroupName)iterator.next();
            try {
                if (map != null) {
                    if (!MapUtils.isMap1ProperSupersetOfMap2(groupName2.getGroupProperties(), map)) continue;
                    arrayList.add(groupName2);
                    ++n2;
                    continue;
                }
                arrayList.add(groupName2);
                ++n2;
            }
            catch (HAInternalStateException hAInternalStateException) {
                FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "298", this);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "findGroups - returning " + arrayList.size() + " matching groups.");
        }
        return arrayList;
    }

    void handleMoveActiveMember(MigrateActiveMemberMsg migrateActiveMemberMsg) throws HAException {
        GroupName groupName = migrateActiveMemberMsg.getGroupName();
        String string = migrateActiveMemberMsg.getOldActiveMember();
        String string2 = migrateActiveMemberMsg.getFutureActiveMember();
        AppGroupState appGroupState = null;
        try {
            appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
            appGroupState.migrateActiveMember(string, string2);
        }
        catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
            FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, svClassName, "328", this);
            throw new HAException("Unable to process group status change", notPossibleAtThisTimeException);
        }
    }

    ServerWithActiveGroups[] countActiveGroupsOnServers(GroupName groupName, int n) {
        GroupName[] groupNameArray;
        Object object;
        Object object2;
        ServerWithActiveGroups[] serverWithActiveGroupsArray;
        Object object3;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = this.findGroups(groupName, -1);
        for (int i = arrayList.size() - 1; i > -1; --i) {
            object3 = (GroupName)arrayList.get(i);
            serverWithActiveGroupsArray = (AppGroupState)this.ivGroupStateMap.get(object3);
            object2 = serverWithActiveGroupsArray.getMemberMap();
            object = object2.keySet().iterator();
            while (object.hasNext()) {
                groupNameArray = (GroupName[])object.next();
                MemberDataImpl memberDataImpl = (MemberDataImpl)object2.get(groupNameArray);
                if (!memberDataImpl.getState().equals(GroupMemberState.ACTIVATED)) continue;
                if (!hashMap.containsKey(groupNameArray)) {
                    hashMap.put(groupNameArray, new ArrayList());
                }
                ArrayList arrayList2 = (ArrayList)hashMap.get(groupNameArray);
                arrayList2.add(object3);
            }
        }
        ArrayList<ServerWithActiveGroups[]> arrayList3 = new ArrayList<ServerWithActiveGroups[]>(10);
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            serverWithActiveGroupsArray = new ServerWithActiveGroupsImpl();
            arrayList3.add(serverWithActiveGroupsArray);
            object2 = (String)object3.next();
            serverWithActiveGroupsArray.setFullyQualifiedServerName((String)object2);
            object = (ArrayList)hashMap.get(object2);
            groupNameArray = new GroupName[((ArrayList)object).size()];
            ((ArrayList)object).toArray(groupNameArray);
            serverWithActiveGroupsArray.setActiveGroups(groupNameArray);
        }
        serverWithActiveGroupsArray = new ServerWithActiveGroups[arrayList3.size()];
        arrayList3.toArray(serverWithActiveGroupsArray);
        return serverWithActiveGroupsArray;
    }

    void handleJMXActionMsg(JMXActionMsg jMXActionMsg) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "handleJMXActionMsg", new Object[]{"Command=" + jMXActionMsg.getCommandAsString(), "ServerName=" + jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()});
        }
        if (this.ivRebuildInProgress) {
            Object[] objectArray = new Object[]{jMXActionMsg.getCommandAsString(), jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
            Tr.warning(TC, "HMGR1227", objectArray);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "handleJMXActionMsg");
            }
            return;
        }
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(jMXActionMsg.getGroupName());
        if (appGroupState == null) {
            Object[] objectArray = new Object[]{jMXActionMsg.getCommandAsString(), jMXActionMsg.getGroupName()};
            Tr.warning(TC, "HMGR1225", objectArray);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "handleJMXActionMsg");
            }
            return;
        }
        try {
            int n = jMXActionMsg.getCommand();
            if (jMXActionMsg.isGroupAction()) {
                switch (n) {
                    case 20: {
                        this.disableGroup(jMXActionMsg.getGroupName());
                        break;
                    }
                    case 10: {
                        this.enableGroup(jMXActionMsg.getGroupName(), false);
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{jMXActionMsg.getGroupName(), jMXActionMsg.getServerName(), jMXActionMsg.getCommandAsString()};
                        Tr.error(TC, "HMGR5012", objectArray);
                        throw new HAInternalStateException("An invalid JMX group action was detected");
                    }
                }
            } else {
                MemberDataImpl memberDataImpl = appGroupState.getMember(jMXActionMsg.getServerName());
                if (memberDataImpl == null) {
                    Object[] objectArray = new Object[]{jMXActionMsg.getCommandAsString(), jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
                    Tr.warning(TC, "HMGR1226", objectArray);
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "handleJMXActionMsg");
                    }
                    return;
                }
                switch (n) {
                    case 1: {
                        this.enableGroupMember(jMXActionMsg.getGroupName(), jMXActionMsg.getServerName(), false);
                        break;
                    }
                    case 2: {
                        this.disableGroupMember(jMXActionMsg.getGroupName(), jMXActionMsg.getServerName(), false);
                        break;
                    }
                    case 3: {
                        appGroupState.makeMemberActive(memberDataImpl.getMemberId());
                        break;
                    }
                    case 4: {
                        appGroupState.makeMemberIdle(memberDataImpl.getMemberId());
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{jMXActionMsg.getGroupName(), jMXActionMsg.getServerName(), jMXActionMsg.getCommandAsString()};
                        Tr.error(TC, "HMGR5012", objectArray);
                        throw new HAInternalStateException("An invalid JMX member action was detected");
                    }
                }
            }
        }
        catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
            FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, svClassName, "485", this);
            Object[] objectArray = new Object[]{jMXActionMsg.getCommandAsString(), jMXActionMsg.getServerName(), jMXActionMsg.getGroupName(), notPossibleAtThisTimeException.getMessage()};
            Tr.warning(TC, "HMGR1228", objectArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "handleJMXActionMsg");
        }
    }

    void startRebuild(boolean bl) {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Rebuild is initiated");
        }
        this.ivGroupStateMap.clear();
        this.ivGroupUpdateMsgCache.clear();
        this.ivGroupActivationMsgCache.clear();
        if (bl) {
            this.ivRebuildInProgress = true;
            this.ivRebuildStartTime = System.currentTimeMillis();
        }
    }

    boolean rebuildComplete() throws HAInternalStateException {
        Object object;
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Rebuild is complete");
        }
        if (this.ivRebuildInProgress && (object = this.ivCoordinator.getPMI()) != null && object.isGroupServiceRebuildTimeEnabled()) {
            object.groupServicesRebuildComplete(System.currentTimeMillis() - this.ivRebuildStartTime);
        }
        this.ivRebuildInProgress = false;
        object = this.ivGroupStateMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            GroupName groupName = (GroupName)entry.getKey();
            AppGroupState appGroupState = (AppGroupState)entry.getValue();
            if (appGroupState.isGroupDisabled()) {
                this.sendRebuildCompleteGroupDisableMessage(appGroupState);
            }
            this.sendGroupUpdateMessage(groupName, appGroupState);
        }
        this.runAllPolicies(true);
        return this.sendCachedGroupMessages();
    }

    void runAllPolicies(boolean bl) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "runAllPolicies()");
        }
        Iterator iterator = this.ivGroupStateMap.keySet().iterator();
        while (iterator.hasNext()) {
            GroupName groupName = (GroupName)iterator.next();
            AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
            appGroupState.applyPolicy(bl);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "runAllPolicies()");
        }
    }

    boolean runPolicy(GroupName groupName, boolean bl) {
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
        if (appGroupState == null) {
            Tr.info(TC, "HMGR0210", groupName);
            return true;
        }
        return appGroupState.applyPolicy(bl);
    }

    void enableGroup(GroupName groupName, boolean bl) throws NotPossibleAtThisTimeException {
        if (this.ivRebuildInProgress) {
            throw new NotPossibleAtThisTimeException("enableGroup not allowed during rebuild");
        }
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
        if (appGroupState == null) {
            return;
        }
        boolean bl2 = appGroupState.enableGroup();
        if (bl2) {
            appGroupState.applyPolicy(bl);
        }
    }

    void enableGroupMember(GroupName groupName, String string, boolean bl) throws NotPossibleAtThisTimeException {
        if (this.ivRebuildInProgress) {
            throw new NotPossibleAtThisTimeException("enableGroupMember not allowed during rebuild");
        }
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
        if (appGroupState == null) {
            return;
        }
        boolean bl2 = appGroupState.enableMember(string);
        if (bl2) {
            appGroupState.applyPolicy(bl);
        }
    }

    void disableGroup(GroupName groupName) throws NotPossibleAtThisTimeException {
        if (this.ivRebuildInProgress) {
            throw new NotPossibleAtThisTimeException("disableGroup not allowed during rebuild");
        }
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
        if (appGroupState == null) {
            return;
        }
        appGroupState.disableGroup();
    }

    void disableGroupMember(GroupName groupName, String string, boolean bl) throws NotPossibleAtThisTimeException {
        if (this.ivRebuildInProgress) {
            throw new NotPossibleAtThisTimeException("disableGroupMember not allowed during rebuild");
        }
        AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
        if (appGroupState == null) {
            return;
        }
        boolean bl2 = appGroupState.disableMember(string);
        appGroupState.applyPolicy(bl);
    }

    void disableQuorumSensitiveGroupsForCluster(String string) {
        Iterator iterator = this.ivGroupStateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AppGroupState appGroupState = (AppGroupState)entry.getValue();
            appGroupState.disableGroupIfQuorumSensitive();
        }
    }

    void updateState(String string, ReportStateMsg reportStateMsg) throws HAInternalStateException {
        this.doUpdateState(string, reportStateMsg.getHAGroupData());
    }

    void updateState(String string, ReportClusterProcessStateMsg reportClusterProcessStateMsg) throws HAInternalStateException {
        this.doUpdateState(string, reportClusterProcessStateMsg.getCurrentState());
    }

    void doUpdateState(String string, Map map) throws HAInternalStateException {
        Serializable serializable;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "doUpdateState()", new Object[]{new Boolean(this.ivRebuildInProgress)});
        }
        if (map.isEmpty()) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "doUpdateState()", "nothing to do");
            }
            return;
        }
        ArrayList<GroupName> arrayList = new ArrayList<GroupName>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry entry = iterator.next();
            GroupName groupName = (GroupName)entry.getKey();
            serializable = (GroupState)entry.getValue();
            MemberDataImpl memberDataImpl = serializable.getMember();
            AppGroupState appGroupState = (AppGroupState)this.ivGroupStateMap.get(groupName);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doUpdateState - processing entry", new Object[]{groupName, memberDataImpl});
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (memberDataImpl == null) {
                bl = this.removeMember(groupName, appGroupState, string);
                if (bl) {
                    bl2 = true;
                    bl3 = true;
                } else {
                    bl3 = false;
                    bl2 = false;
                    arrayList.add(groupName);
                }
            } else if (appGroupState == null) {
                appGroupState = this.addFirstMember(groupName, memberDataImpl, string);
                bl2 = true;
                bl3 = true;
            } else {
                bl = appGroupState.addOrReplaceMember(string, memberDataImpl);
                bl3 = true;
                if (bl) {
                    bl2 = true;
                }
            }
            if (this.ivRebuildInProgress) continue;
            if (bl2) {
                this.sendGroupUpdateMessage(groupName, appGroupState);
            }
            if (!bl3) continue;
            appGroupState.applyPolicy(false);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            serializable = (GroupName)arrayList.get(i);
            this.ivGroupStateMap.remove(serializable);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "doUpdateState()");
        }
    }

    void removeDeadServers(Set set) throws HAInternalStateException {
        Object object;
        Object object2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadServers()", set);
        }
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            this.ivGroupUpdateMsgCache.remove(object2);
            this.ivGroupActivationMsgCache.remove(object2);
        }
        iterator = this.ivGroupStateMap.entrySet().iterator();
        object2 = new ArrayList();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry entry = (Map.Entry)iterator.next();
            GroupName groupName = (GroupName)entry.getKey();
            object = (AppGroupState)entry.getValue();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "removeDeadServers - processing GroupName", groupName);
            }
            if (!(bl = ((AppGroupState)object).removeDeadMembers(set))) continue;
            if (!((AppGroupState)object).containsMembers()) {
                ((ArrayList)object2).add(groupName);
                continue;
            }
            if (TC.isEventEnabled()) {
                Tr.event(TC, "removeDeadServers - running policy on group ", object);
            }
            this.sendGroupUpdateMessage(groupName, (AppGroupState)object);
            ((AppGroupState)object).applyPolicy(false);
        }
        int n = ((ArrayList)object2).size();
        for (int i = n - 1; i >= 0; --i) {
            object = (GroupName)((ArrayList)object2).get(i);
            if (TC.isEventEnabled()) {
                Tr.event(TC, "removeDeadServers - removing Group with no members", object);
            }
            this.ivGroupStateMap.remove(object);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadServers()");
        }
    }

    boolean sendCachedGroupMessages() {
        ActiveCoordinatorMessage activeCoordinatorMessage;
        Map.Entry entry;
        if (this.ivRebuildInProgress) {
            return false;
        }
        int n = this.ivGroupUpdateMsgCache.size();
        int n2 = this.ivGroupActivationMsgCache.size();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendingCachedGroupMessages", new Object[]{new Integer(n), new Integer(n2)});
        }
        if (n == 0 && n2 == 0) {
            return true;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        Set set = this.ivGroupUpdateMsgCache.entrySet();
        Iterator iterator = set.iterator();
        try {
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                activeCoordinatorMessage = (GroupUpdateMsg)entry.getValue();
                this.ivCoordinator.sendMessage(string, (HAMMessage)activeCoordinatorMessage);
                arrayList.add(string);
            }
            bl = true;
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "958", this);
            Tr.error(TC, "HMGR0201", new Object[]{"GroupUpdateMessage", string, dataStackException});
        }
        if (!bl) {
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                string = (String)arrayList.get(i);
                this.ivGroupUpdateMsgCache.remove(string);
            }
            return false;
        }
        this.ivGroupUpdateMsgCache.clear();
        arrayList.clear();
        set = this.ivGroupActivationMsgCache.entrySet();
        iterator = set.iterator();
        try {
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                activeCoordinatorMessage = (GroupMemberActivationCmdMsg)entry.getValue();
                this.ivCoordinator.sendMessage(string, (HAMMessage)activeCoordinatorMessage);
                arrayList.add(string);
            }
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "987", this);
            Tr.error(TC, "HMGR0201", new Object[]{"GroupMemberActivationCmdMsg", string, dataStackException});
            bl = false;
        }
        if (bl) {
            this.ivGroupActivationMsgCache.clear();
        } else {
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                string = (String)arrayList.get(i);
                this.ivGroupActivationMsgCache.remove(string);
            }
        }
        return bl;
    }

    void reloadPolicies() {
        Set set = this.ivGroupStateMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            GroupName groupName = (GroupName)entry.getKey();
            AppGroupState appGroupState = (AppGroupState)entry.getValue();
            GroupPolicy groupPolicy = null;
            try {
                groupPolicy = this.ivCoordinator.getPolicyManager().createPolicyForGroup(groupName);
            }
            catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
                FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "1026", this);
                Tr.warning(TC, "HMGR0301", groupName);
            }
            catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
                FFDCFilter.processException((Throwable)duplicatePoliciesMatchGroupException, svClassName, "1030", this);
                String string = StringUtils.convertStringArrayToString(duplicatePoliciesMatchGroupException.getMatchingRules());
                Tr.warning(TC, "HMGR0302", new Object[]{groupName, string});
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, svClassName, "1036", this);
                Tr.error(TC, "HMGR0211", new Object[]{groupName, "reload configuration", hAException});
            }
            appGroupState.setPolicy(groupPolicy);
        }
    }

    void requestMemberStateChange(GroupName groupName, String string, GroupMemberState groupMemberState) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "requestMemberStateChange", new Object[]{string, groupName, groupMemberState, new Boolean(this.ivRebuildInProgress)});
        }
        if (this.ivRebuildInProgress) {
            return;
        }
        GroupMemberActivationCmdMsg groupMemberActivationCmdMsg = (GroupMemberActivationCmdMsg)this.ivGroupActivationMsgCache.get(string);
        if (groupMemberActivationCmdMsg == null) {
            groupMemberActivationCmdMsg = new GroupMemberActivationCmdMsg();
            this.ivGroupActivationMsgCache.put(string, groupMemberActivationCmdMsg);
            groupMemberActivationCmdMsg.addCommand(groupName, groupMemberState);
            this.ivMessageCache.activeCoordinatorMessagesToSend();
            return;
        }
        if (!groupMemberActivationCmdMsg.isCommandPending(groupName)) {
            groupMemberActivationCmdMsg.addCommand(groupName, groupMemberState);
            this.ivMessageCache.activeCoordinatorMessagesToSend();
            return;
        }
        this.sendCachedGroupMessages();
        groupMemberActivationCmdMsg = new GroupMemberActivationCmdMsg();
        this.ivGroupActivationMsgCache.put(string, groupMemberActivationCmdMsg);
        groupMemberActivationCmdMsg.addCommand(groupName, groupMemberState);
        this.ivMessageCache.activeCoordinatorMessagesToSend();
    }

    private void sendGroupUpdateMessage(GroupName groupName, AppGroupState appGroupState) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendGroupUpdateMessage()", new Object[]{groupName, new Boolean(this.ivRebuildInProgress), appGroupState});
        }
        if (this.ivRebuildInProgress) {
            return;
        }
        MemberData[] memberDataArray = appGroupState.getMembers();
        int n = memberDataArray.length;
        for (int i = 0; i < n; ++i) {
            String string = memberDataArray[i].getServerHostingMember();
            GroupUpdateMsg groupUpdateMsg = (GroupUpdateMsg)this.ivGroupUpdateMsgCache.get(string);
            if (groupUpdateMsg == null) {
                groupUpdateMsg = new GroupUpdateMsg();
                this.ivGroupUpdateMsgCache.put(string, groupUpdateMsg);
            }
            groupUpdateMsg.addEntry(groupName, memberDataArray);
        }
        this.ivMessageCache.activeCoordinatorMessagesToSend();
    }

    private void sendRebuildCompleteGroupDisableMessage(AppGroupState appGroupState) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendGroupDisableMessage", new Object[]{new Boolean(this.ivRebuildInProgress), appGroupState});
        }
        GroupName groupName = appGroupState.getGroupName();
        MemberDataImpl[] memberDataImplArray = appGroupState.getMembers();
        int n = memberDataImplArray.length;
        for (int i = 0; i < n; ++i) {
            String string = memberDataImplArray[i].getServerHostingMember();
            GroupMemberActivationCmdMsg groupMemberActivationCmdMsg = (GroupMemberActivationCmdMsg)this.ivGroupActivationMsgCache.get(string);
            if (groupMemberActivationCmdMsg == null) {
                groupMemberActivationCmdMsg = new GroupMemberActivationCmdMsg();
                this.ivGroupActivationMsgCache.put(string, groupMemberActivationCmdMsg);
            }
            groupMemberActivationCmdMsg.addCommand(groupName, GroupMemberState.GROUP_DISABLED);
        }
    }

    private boolean removeMember(GroupName groupName, AppGroupState appGroupState, String string) {
        if (appGroupState == null) {
            Tr.info(TC, "HMGR0212", new Object[]{string, groupName});
            return false;
        }
        MemberData memberData = appGroupState.removeMember(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeMember - removed MemberData", memberData);
        }
        if (appGroupState.containsMembers()) {
            return true;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeMember - empty AppGroupState", appGroupState);
        }
        return false;
    }

    private AppGroupState addFirstMember(GroupName groupName, MemberDataImpl memberDataImpl, String string) {
        GroupPolicy groupPolicy = null;
        try {
            groupPolicy = this.ivCoordinator.getPolicyManager().createPolicyForGroup(groupName);
        }
        catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
            FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "1227", this);
            Tr.warning(TC, "HMGR0301", groupName);
        }
        catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
            FFDCFilter.processException((Throwable)duplicatePoliciesMatchGroupException, svClassName, "1231", this);
            String string2 = StringUtils.convertStringArrayToString(duplicatePoliciesMatchGroupException.getMatchingRules());
            Tr.warning(TC, "HMGR0302", new Object[]{groupName, string2});
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "1237", this);
            Tr.error(TC, "HMGR0211", new Object[]{groupName, string, hAException});
        }
        AppGroupState appGroupState = new AppGroupState(this.ivCoordinator, this, groupName, groupPolicy, string, memberDataImpl);
        this.ivGroupStateMap.put(groupName, appGroupState);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "addFirstMember - created new AppGroupState for group", new Object[]{groupName, appGroupState});
        }
        return appGroupState;
    }
}

