/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.coordinator.HAPolicyManager;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.impl.HAPolicyRuleImpl;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.PolicyCannotInitializeException;
import com.ibm.ws.hamanager.coordinator.policy.impl.AllActivePolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.NOOPPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyFactory;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HAPolicyManagerImpl
implements HAPolicyManager {
    private static final TraceComponent TC = Tr.register(HAPolicyManagerImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = HAPolicyManagerImpl.class.getName();
    private String ivCoreGroupName;
    private Map ivRuleMap;

    HAPolicyManagerImpl(String string, boolean bl) throws HAException {
        this.ivCoreGroupName = string;
        this.ivRuleMap = bl ? Providers.getConfigProvider().getPolicyRules() : new HashMap();
        this.createDefaultPolicies();
    }

    public synchronized void removePolicyRule(String string) {
        this.ivRuleMap.remove(string);
    }

    public HAPolicyRule findHAPolicyRuleForGroup(GroupName groupName) throws NoPolicyDefinedForGroupException, HAInternalStateException, DuplicatePoliciesMatchGroupException {
        return this.getHARuleForGroupName(groupName);
    }

    public synchronized GroupPolicy createPolicyForGroup(GroupName groupName) throws NoPolicyDefinedForGroupException, HAInternalStateException, PolicyCannotInitializeException, DuplicatePoliciesMatchGroupException {
        HAPolicyRuleImpl hAPolicyRuleImpl = this.getHARuleForGroupName(groupName);
        GroupPolicyFactory groupPolicyFactory = hAPolicyRuleImpl.getGroupPolicyFactory();
        GroupPolicy groupPolicy = groupPolicyFactory.create(groupName, hAPolicyRuleImpl);
        return groupPolicy;
    }

    synchronized boolean merge(Map map) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "merging policy information");
        }
        try {
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            HashMap<String, HAPolicyRuleImpl> hashMap = new HashMap<String, HAPolicyRuleImpl>();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                HAPolicyRuleImpl hAPolicyRuleImpl = (HAPolicyRuleImpl)entry.getValue();
                hashMap.put(string, hAPolicyRuleImpl);
            }
            this.ivRuleMap = hashMap;
            this.createDefaultPolicies();
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "172", this);
            Tr.error(TC, "HMGR0083", new Object[]{"HAPolicies", throwable});
            return false;
        }
    }

    public ArrayList getAllHARulesForGroupName(GroupName groupName) throws HAInternalStateException {
        ArrayList<HAPolicyRuleImpl> arrayList = new ArrayList<HAPolicyRuleImpl>();
        ArrayList arrayList2 = new ArrayList();
        Collection collection = this.ivRuleMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HAPolicyRuleImpl hAPolicyRuleImpl = (HAPolicyRuleImpl)iterator.next();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Comparing group name to match set", new Object[]{groupName, hAPolicyRuleImpl});
            }
            if (!hAPolicyRuleImpl.matchesGroupName(groupName)) continue;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "found rule match", hAPolicyRuleImpl);
            }
            arrayList.add(hAPolicyRuleImpl);
        }
        return arrayList;
    }

    private HAPolicyRuleImpl getHARuleForGroupName(GroupName groupName) throws NoPolicyDefinedForGroupException, DuplicatePoliciesMatchGroupException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getHARuleForGroupName()", groupName);
        }
        try {
            HAPolicyRuleImpl hAPolicyRuleImpl;
            ArrayList arrayList = this.getAllHARulesForGroupName(groupName);
            int n = arrayList.size();
            if (n < 1) {
                throw new NoPolicyDefinedForGroupException("no rule set match found for keys in GroupName " + groupName);
            }
            if (n == 1) {
                return (HAPolicyRuleImpl)arrayList.get(0);
            }
            int n2 = -1;
            int n3 = -1;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                hAPolicyRuleImpl = (HAPolicyRuleImpl)arrayList.get(i);
                int n4 = hAPolicyRuleImpl.getMatchSetCardinality();
                if (n4 > n3) {
                    n2 = i;
                    n3 = n4;
                    bl = false;
                    continue;
                }
                if (n4 != n3) continue;
                bl = true;
            }
            if (bl) {
                HAPolicyRuleImpl hAPolicyRuleImpl2 = (HAPolicyRuleImpl)arrayList.get(0);
                hAPolicyRuleImpl = (HAPolicyRuleImpl)arrayList.get(1);
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    HAPolicyRuleImpl hAPolicyRuleImpl3 = (HAPolicyRuleImpl)arrayList.get(i);
                    stringArray[i] = hAPolicyRuleImpl3.getRuleName();
                }
                throw new DuplicatePoliciesMatchGroupException(groupName, stringArray);
            }
            if (n2 == -1) {
                throw new HAInternalStateException("error in getHARuleForGroupName");
            }
            HAPolicyRuleImpl hAPolicyRuleImpl4 = (HAPolicyRuleImpl)arrayList.get(n2);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "getHARuleForGroupName()", hAPolicyRuleImpl4);
            }
            return hAPolicyRuleImpl4;
        }
        catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
            FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "279", this);
            throw noPolicyDefinedForGroupException;
        }
        catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
            FFDCFilter.processException((Throwable)duplicatePoliciesMatchGroupException, svClassName, "283", this);
            throw duplicatePoliciesMatchGroupException;
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "288", this);
            throw hAInternalStateException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "293", this);
            throw new HAInternalStateException("unexpected exception looking up HARule for group ", throwable);
        }
    }

    private void createDefaultPolicies() {
        String string = null;
        try {
            int n = Providers.getConfigProvider().getPolicyDefaultIsAliveTime();
            string = "DefaultNOOPPolicy";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("policy", string);
            String string2 = NOOPPolicyFactory.factoryName;
            HAPolicyRuleImpl hAPolicyRuleImpl = new HAPolicyRuleImpl(string, string2, hashMap, null, false, n);
            this.ivRuleMap.put(string, hAPolicyRuleImpl);
            string = "DefaultNoQuorumOneOfNPolicy";
            hashMap = new HashMap();
            hashMap.put("policy", string);
            string2 = OneOfNPolicyFactory.factoryName;
            hAPolicyRuleImpl = new HAPolicyRuleImpl(string, string2, hashMap, null, false, n);
            this.ivRuleMap.put(string, hAPolicyRuleImpl);
            string = "DefaultAllActivePolicy";
            hashMap = new HashMap();
            hashMap.put("policy", string);
            string2 = AllActivePolicyFactory.factoryName;
            hAPolicyRuleImpl = new HAPolicyRuleImpl(string, string2, hashMap, null, false, n);
            this.ivRuleMap.put(string, hAPolicyRuleImpl);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "421", this);
            Tr.error(TC, "HMGR0048", new Object[]{string, hAException});
        }
    }
}

