/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicyFactory;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public final class HAPolicyRuleImpl
implements Serializable,
HAPolicyRule {
    private static final long serialVersionUID = -1208532968796779234L;
    private static final TraceComponent TC = Tr.register(HAPolicyRuleImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = HAPolicyRuleImpl.class.getName();
    private String ivPolicyName;
    private Map ivMatchSet;
    private GroupPolicyFactory ivFactory;
    private int ivIsAlivePeriodSec = 0;
    private boolean ivQuorumNeeded = false;
    private Map ivCustomProperties;
    private String[] ivServers = null;
    private String ivOSClusterName = null;
    private String ivOSResourceGroupName = null;
    private String[] ivPreferredServers = null;
    private boolean ivFailback = false;
    private boolean ivPreferredOnly = false;
    private int ivNumActive = 0;
    private String ivHandlerName = null;

    public HAPolicyRuleImpl(String string, String string2, Map map, Map map2, boolean bl, int n) throws HAException {
        this.ivFactory = this.createFactoryInstance(string2);
        this.ivMatchSet = Collections.unmodifiableMap(map);
        this.ivCustomProperties = map2;
        this.ivPolicyName = string;
        this.ivQuorumNeeded = bl;
        this.ivIsAlivePeriodSec = n;
    }

    public HAPolicyRuleImpl() {
    }

    public GroupPolicyFactory getGroupPolicyFactory() {
        return this.ivFactory;
    }

    public Map getMatchSet() {
        return this.ivMatchSet;
    }

    public Map getCustomProperties() {
        return this.ivCustomProperties;
    }

    public String getRuleName() {
        return this.ivPolicyName;
    }

    public boolean isQuorumNeeded() {
        return this.ivQuorumNeeded;
    }

    public void setQuorumNeeded(boolean bl) {
        this.ivQuorumNeeded = bl;
    }

    public int getIsAlivePeriodSec() {
        return this.ivIsAlivePeriodSec;
    }

    public String[] getServerAttributes() {
        return this.ivServers;
    }

    public void setServerAttributes(String[] stringArray) {
        this.ivServers = stringArray;
    }

    public String[] getPreferredServerAttributes() {
        return this.ivPreferredServers;
    }

    public void setPreferredServerAttributes(String[] stringArray) {
        this.ivPreferredServers = stringArray;
    }

    public boolean isForcePreferred() {
        return this.ivFailback;
    }

    public void setForcePreferred(boolean bl) {
        this.ivFailback = bl;
    }

    public boolean getPreferredOnly() {
        return this.ivPreferredOnly;
    }

    public void setPreferredOnly(boolean bl) {
        this.ivPreferredOnly = bl;
    }

    public int getNumActive() {
        return this.ivNumActive;
    }

    public void setNumActive(int n) {
        this.ivNumActive = n;
    }

    public String getHandlerName() {
        return this.ivHandlerName;
    }

    public void setHandlerName(String string) {
        this.ivHandlerName = string;
    }

    public String getOSClusterName() {
        return this.ivOSClusterName;
    }

    public void setOSClusterName(String string) {
        this.ivOSClusterName = string;
    }

    public String getOSResourceGroupName() {
        return this.ivOSResourceGroupName;
    }

    public void setOSResourceGroupName(String string) {
        this.ivOSResourceGroupName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Rule Name ");
        stringBuffer.append(this.ivPolicyName);
        try {
            stringBuffer.append(DebugUtils.dumpMap("Match Set ", this.ivMatchSet));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "308", this);
            stringBuffer.append("Error dumping match set");
        }
        return stringBuffer.toString();
    }

    public boolean merge(HAPolicyRuleImpl hAPolicyRuleImpl) throws HAInternalStateException {
        boolean bl = false;
        boolean bl2 = MapUtils.compareMaps(this.ivMatchSet, hAPolicyRuleImpl.ivMatchSet);
        if (!bl2) {
            this.ivMatchSet = hAPolicyRuleImpl.ivMatchSet;
            bl = true;
        }
        if (this.ivIsAlivePeriodSec != hAPolicyRuleImpl.ivIsAlivePeriodSec) {
            this.ivIsAlivePeriodSec = hAPolicyRuleImpl.ivIsAlivePeriodSec;
            bl = true;
        }
        if (this.ivQuorumNeeded != hAPolicyRuleImpl.ivQuorumNeeded) {
            this.ivQuorumNeeded = hAPolicyRuleImpl.ivQuorumNeeded;
            bl = true;
        }
        if (!(bl2 = MapUtils.compareMaps(this.ivCustomProperties, hAPolicyRuleImpl.ivCustomProperties))) {
            bl = true;
        }
        if (this.ivServers != null) {
            bl2 = StringUtils.compareStringArraysForContentEquality(this.ivServers, hAPolicyRuleImpl.ivServers);
            if (bl2) {
                return bl;
            }
            this.ivServers = hAPolicyRuleImpl.ivServers;
            return true;
        }
        if (this.ivOSClusterName != null) {
            if (!this.ivOSClusterName.equals(hAPolicyRuleImpl.ivOSClusterName)) {
                this.ivOSClusterName = hAPolicyRuleImpl.ivOSClusterName;
                this.ivOSResourceGroupName = hAPolicyRuleImpl.ivOSResourceGroupName;
                return true;
            }
            if (!this.ivOSResourceGroupName.equals(hAPolicyRuleImpl.ivOSResourceGroupName)) {
                this.ivOSResourceGroupName = hAPolicyRuleImpl.ivOSResourceGroupName;
                return true;
            }
            return bl;
        }
        if (this.ivFailback != hAPolicyRuleImpl.ivFailback) {
            this.ivFailback = hAPolicyRuleImpl.ivFailback;
            bl = true;
        }
        if (this.ivPreferredOnly != hAPolicyRuleImpl.ivPreferredOnly) {
            this.ivPreferredOnly = hAPolicyRuleImpl.ivPreferredOnly;
            bl = true;
        }
        if (this.ivNumActive != hAPolicyRuleImpl.ivNumActive) {
            this.ivNumActive = hAPolicyRuleImpl.ivNumActive;
            bl = true;
        }
        if (this.ivHandlerName != null && !this.ivHandlerName.equals(hAPolicyRuleImpl.ivHandlerName)) {
            this.ivHandlerName = hAPolicyRuleImpl.ivHandlerName;
            bl = true;
        }
        if (!(bl2 = StringUtils.compareStringArraysForExactEquality(this.ivPreferredServers, hAPolicyRuleImpl.ivPreferredServers))) {
            this.ivPreferredServers = hAPolicyRuleImpl.ivPreferredServers;
            return true;
        }
        return bl;
    }

    boolean matchesGroupName(GroupName groupName) throws HAInternalStateException {
        Map map = groupName.getGroupProperties();
        return MapUtils.isMap1ProperSupersetOfMap2(map, this.ivMatchSet);
    }

    int getMatchSetCardinality() {
        return this.ivMatchSet.size();
    }

    public int hashCode() {
        return this.ivPolicyName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            HAPolicyRuleImpl hAPolicyRuleImpl = (HAPolicyRuleImpl)object;
            if (!this.ivPolicyName.equals(hAPolicyRuleImpl.ivPolicyName)) {
                return false;
            }
            if (!this.ivFactory.equals(hAPolicyRuleImpl.ivFactory)) {
                return false;
            }
            if (!((Object)this.ivMatchSet).equals(hAPolicyRuleImpl.ivMatchSet)) {
                return false;
            }
            return !(this.ivCustomProperties == null ? hAPolicyRuleImpl.ivCustomProperties != null : !((Object)this.ivCustomProperties).equals(hAPolicyRuleImpl.ivCustomProperties));
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, svClassName, "485", this);
            return false;
        }
    }

    private GroupPolicyFactory createFactoryInstance(String string) throws HAException {
        try {
            Class<?> clazz = Class.forName(string);
            if (!GroupPolicyFactory.class.isAssignableFrom(clazz)) {
                Tr.error(TC, "HMGR0046", string);
                throw new HAException(string + " does not implement GroupPolicyFactory");
            }
            GroupPolicyFactory groupPolicyFactory = (GroupPolicyFactory)clazz.newInstance();
            return groupPolicyFactory;
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "512", this);
            throw hAException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, svClassName, "516", this);
            Tr.error(TC, "HMGR0047", new Object[]{string, classNotFoundException});
            throw new HAException("", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, svClassName, "521", this);
            Tr.error(TC, "HMGR0047", new Object[]{string, instantiationException});
            throw new HAException("", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, svClassName, "526", this);
            Tr.error(TC, "HMGR0047", new Object[]{string, illegalAccessException});
            throw new HAException("", illegalAccessException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = "<null>";
        this.ivPolicyName = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        this.ivMatchSet = MapUtils.readMapFromStream(objectInputStream);
        this.ivIsAlivePeriodSec = objectInputStream.readInt();
        this.ivQuorumNeeded = objectInputStream.readBoolean();
        this.ivCustomProperties = MapUtils.readMapFromStream(objectInputStream);
        this.ivServers = StringUtils.readStringArrayFromStream(objectInputStream);
        this.ivOSClusterName = objectInputStream.readUTF();
        if (this.ivOSClusterName.equals(string)) {
            this.ivOSClusterName = null;
        }
        this.ivOSResourceGroupName = objectInputStream.readUTF();
        if (this.ivOSResourceGroupName.equals(string)) {
            this.ivOSResourceGroupName = null;
        }
        this.ivPreferredServers = StringUtils.readStringArrayFromStream(objectInputStream);
        this.ivFailback = objectInputStream.readBoolean();
        this.ivPreferredOnly = objectInputStream.readBoolean();
        this.ivNumActive = objectInputStream.readInt();
        this.ivHandlerName = objectInputStream.readUTF();
        if (this.ivHandlerName.equals(string)) {
            this.ivHandlerName = null;
        }
        try {
            this.ivFactory = this.createFactoryInstance(string2);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "570", this);
            throw new IOException("PolicyFactory name error");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = "<null>";
        objectOutputStream.writeUTF(this.ivPolicyName);
        objectOutputStream.writeUTF(this.ivFactory.getClass().getName());
        MapUtils.writeMapToStream(objectOutputStream, this.ivMatchSet);
        objectOutputStream.writeInt(this.ivIsAlivePeriodSec);
        objectOutputStream.writeBoolean(this.ivQuorumNeeded);
        MapUtils.writeMapToStream(objectOutputStream, this.ivCustomProperties);
        StringUtils.writeStringArrayToStream(objectOutputStream, this.ivServers);
        if (this.ivOSClusterName == null) {
            objectOutputStream.writeUTF(string);
        } else {
            objectOutputStream.writeUTF(this.ivOSClusterName);
        }
        if (this.ivOSResourceGroupName == null) {
            objectOutputStream.writeUTF(string);
        } else {
            objectOutputStream.writeUTF(this.ivOSResourceGroupName);
        }
        StringUtils.writeStringArrayToStream(objectOutputStream, this.ivPreferredServers);
        objectOutputStream.writeBoolean(this.ivFailback);
        objectOutputStream.writeBoolean(this.ivPreferredOnly);
        objectOutputStream.writeInt(this.ivNumActive);
        if (this.ivHandlerName == null) {
            objectOutputStream.writeUTF(string);
        } else {
            objectOutputStream.writeUTF(this.ivHandlerName);
        }
    }
}

