/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.BulletinBoardServerPosts;
import com.ibm.ws.hamanager.bboard.IndirectSubjectToPostMap;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportClusterProcessStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MessageCache {
    private static final TraceComponent TC = Tr.register(MessageCache.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private CoordinatorImpl ivCoordinator;
    private int ivSendGroupChangeTime = 250;
    private int ivNumberActives;
    private ReportClusterProcessStateMsg[] ivUpdates;
    private ReportStateMsg[] ivUpdates2;
    private boolean ivEnabled;
    private boolean ivCacheDirty;
    private boolean ivACRebuildInProgress;
    private boolean ivACWriteNeeded;
    private boolean ivProxyRebuildInProgress;
    private Alarm ivAlarm;
    private boolean ivAlarmRunning;
    private Version ivVersion;

    MessageCache(CoordinatorImpl coordinatorImpl, Version version, int n, int n2) {
        this.ivCoordinator = coordinatorImpl;
        this.ivNumberActives = n;
        this.ivSendGroupChangeTime = n2;
        this.ivEnabled = true;
        this.ivCacheDirty = false;
        this.ivACRebuildInProgress = false;
        this.ivACWriteNeeded = false;
        this.ivProxyRebuildInProgress = false;
        this.ivAlarm = null;
        this.ivAlarmRunning = false;
        this.ivVersion = version;
        this.ivUpdates = new ReportClusterProcessStateMsg[n];
        this.ivUpdates2 = new ReportStateMsg[n];
    }

    public synchronized void sendGroupStateUpdate(GroupName groupName, GroupState groupState) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(groupName);
        int n2 = this.ivVersion.getHAMProtocolVersion();
        if (n2 < 5) {
            if (this.ivUpdates[n] == null) {
                this.ivUpdates[n] = new ReportClusterProcessStateMsg();
            }
            this.ivUpdates[n].getCurrentState().put(groupName, groupState);
        } else {
            if (this.ivUpdates2[n] == null) {
                this.ivUpdates2[n] = new ReportStateMsg();
            }
            this.ivUpdates2[n].addHAGroupData(groupName, groupState);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sentGroupStateUpdate - Adding group data", new Object[]{groupName, groupState, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public void sendPostUpdate(SubjectInfo subjectInfo, BulletinBoardServerPosts bulletinBoardServerPosts) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates[n] == null) {
            this.ivUpdates[n] = new ReportClusterProcessStateMsg();
        }
        this.ivUpdates[n].getBulletinBoardValues().put(subjectInfo, bulletinBoardServerPosts);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendSubjectUpdates - Adding post data", new Object[]{subjectInfo, bulletinBoardServerPosts, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public void sendPostUpdate(SubjectInfo subjectInfo, BulletinBoardPost bulletinBoardPost) {
        Map map;
        BulletinBoardServerPosts bulletinBoardServerPosts;
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates[n] == null) {
            this.ivUpdates[n] = new ReportClusterProcessStateMsg();
        }
        if ((bulletinBoardServerPosts = (BulletinBoardServerPosts)(map = this.ivUpdates[n].getBulletinBoardValues()).get(subjectInfo)) == null) {
            bulletinBoardServerPosts = new BulletinBoardServerPosts();
            map.put(subjectInfo, bulletinBoardServerPosts);
        }
        bulletinBoardServerPosts.put(bulletinBoardPost.getOriginalServer(), bulletinBoardPost);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendSubjectUpdates - Adding optimized post data", new Object[]{subjectInfo, bulletinBoardPost, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public void sendLocalPostUpdate(SubjectInfo subjectInfo, BulletinBoardPost bulletinBoardPost) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates2[n] == null) {
            this.ivUpdates2[n] = new ReportStateMsg();
        }
        this.ivUpdates2[n].addBulletinBoardLocalPost(subjectInfo, bulletinBoardPost);
        this.ivUpdates2[n].setBulletinBoardLocalMode(1);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendLocalPostUpdate - Adding post data", new Object[]{subjectInfo, bulletinBoardPost, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public void sendProxyPostUpdate(SubjectInfo subjectInfo, BulletinBoardPost bulletinBoardPost) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates2[n] == null) {
            this.ivUpdates2[n] = new ReportStateMsg();
        }
        this.ivUpdates2[n].addBulletinBoardProxyPost(subjectInfo, bulletinBoardPost);
        if (!this.ivProxyRebuildInProgress) {
            this.ivUpdates2[n].setBulletinBoardProxyMode(1);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendProxyPostUpdate - Adding post data", new Object[]{subjectInfo, bulletinBoardPost, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public synchronized void sendSubscriptionUpdate(SubjectInfo subjectInfo, Boolean bl) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates[n] == null) {
            this.ivUpdates[n] = new ReportClusterProcessStateMsg();
        }
        this.ivUpdates[n].getSubscribers().put(subjectInfo, bl);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendSubscriptionUpdates - Adding subscription data", new Object[]{subjectInfo, bl, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public synchronized void sendLocalSubscriptionUpdate(SubjectInfo subjectInfo, Boolean bl) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates2[n] == null) {
            this.ivUpdates2[n] = new ReportStateMsg();
        }
        this.ivUpdates2[n].addBulletinBoardLocalSubscriber(subjectInfo, bl);
        this.ivUpdates2[n].setBulletinBoardLocalMode(1);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendLocalSubscriptionUpdates - Adding subscription data", new Object[]{subjectInfo, bl, new Integer(n)});
        }
        this.scheduleAlarm();
    }

    public synchronized void sendProxySubscriptionUpdate(SubjectInfo subjectInfo, Boolean bl) {
        if (this.ivNumberActives == 0) {
            return;
        }
        int n = this.getActiveCoordinatorIndex(subjectInfo);
        if (this.ivUpdates2[n] == null) {
            this.ivUpdates2[n] = new ReportStateMsg();
        }
        this.ivUpdates2[n].addBulletinBoardProxySubscriber(subjectInfo, bl);
        this.ivUpdates2[n].setBulletinBoardLocalMode(1);
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{subjectInfo, bl, new Integer(n)};
            Tr.debug(TC, "sendProxySubscriptionUpdates - Adding subscription data", objectArray);
        }
        this.scheduleAlarm();
    }

    public synchronized void bridgeRebuildComplete(IndirectSubjectToPostMap indirectSubjectToPostMap, Set set) {
        int n;
        Object object;
        Object object2;
        int n2;
        if (this.ivNumberActives == 0) {
            return;
        }
        for (n2 = 0; n2 < this.ivNumberActives; ++n2) {
            if (this.ivUpdates2[n2] == null) {
                this.ivUpdates2[n2] = new ReportStateMsg();
            }
            this.ivUpdates2[n2].setBulletinBoardProxyMode(3);
        }
        this.ivProxyRebuildInProgress = true;
        if (indirectSubjectToPostMap.size() > 0) {
            Iterator iterator = indirectSubjectToPostMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (SubjectInfoImpl)iterator.next();
                object = indirectSubjectToPostMap.get((SubjectInfoImpl)object2);
                if (object.isEmpty()) {
                    if (!TC.isEventEnabled()) continue;
                    Tr.event(TC, "bridgeRebuildComplete - ignoring post", new Object[]{object2, "No proxy posts"});
                    continue;
                }
                n = ((SubjectInfoImpl)object2).getActiveCoordinatorIndex(this.ivNumberActives);
                if (TC.isEventEnabled()) {
                    Object[] objectArray = new Object[]{object2, object, new Integer(n)};
                    Tr.event(TC, "bridgeRebuildComplete - adding proxy posts", objectArray);
                }
                this.ivUpdates2[n].addBulletinBoardProxyPostMap((SubjectInfo)object2, (Map)object);
            }
        }
        if (!set.isEmpty()) {
            if (this.ivNumberActives == 1) {
                this.ivUpdates2[0].addBridgeOwnedSubjects(set);
            } else {
                for (n2 = 0; n2 < this.ivNumberActives; ++n2) {
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        object = (SubjectInfoImpl)object2.next();
                        n = ((SubjectInfoImpl)object).getActiveCoordinatorIndex(this.ivNumberActives);
                        this.ivUpdates2[n].addBridgeOwnedSubject((SubjectInfo)object);
                    }
                }
            }
        }
        this.scheduleAlarm();
    }

    public synchronized void clearAllMessages() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "clearLocalMessages");
        }
        this.ivUpdates = new ReportClusterProcessStateMsg[this.ivNumberActives];
        this.ivUpdates2 = new ReportStateMsg[this.ivNumberActives];
    }

    public synchronized void clearBridgeState() {
        int n = 0;
        for (int i = 0; i < this.ivNumberActives; ++i) {
            if (this.ivUpdates2[i] == null) continue;
            n += this.ivUpdates2[i].flushProxyState();
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "clearBridgeState", new Integer(n));
        }
        this.ivProxyRebuildInProgress = false;
    }

    synchronized void rebuildComplete() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "rebuildComplete");
        }
        this.ivACRebuildInProgress = false;
    }

    synchronized void activeCoordinatorMessagesToSend() {
        if (this.ivACRebuildInProgress) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ignoring active coordinator message");
            }
            return;
        }
        this.ivACWriteNeeded = true;
        this.scheduleAlarm();
    }

    synchronized void activeCoordinatorMessagesSent() {
        this.ivACWriteNeeded = false;
    }

    synchronized HAMMessage[] getCachedMessages() {
        HAMMessage[] hAMMessageArray;
        int n;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getting messages from the message cache");
        }
        if ((n = this.ivVersion.getHAMProtocolVersion()) < 5) {
            hAMMessageArray = this.ivUpdates;
            this.ivUpdates = new ReportClusterProcessStateMsg[this.ivNumberActives];
        } else {
            hAMMessageArray = this.ivUpdates2;
            this.ivUpdates2 = new ReportStateMsg[this.ivNumberActives];
        }
        this.ivCacheDirty = false;
        return hAMMessageArray;
    }

    void unsendableMessages(HAMMessage[] hAMMessageArray) {
        if (this.ivVersion.getHAMProtocolVersion() < 5) {
            this.ivUpdates = (ReportClusterProcessStateMsg[])hAMMessageArray;
        } else {
            this.ivUpdates2 = (ReportStateMsg[])hAMMessageArray;
        }
        this.scheduleAlarm();
    }

    synchronized void globalStateRebuildRequired(int n) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "global state rebuild required");
        }
        this.ivNumberActives = n;
        this.ivACRebuildInProgress = true;
        this.ivACWriteNeeded = false;
        this.ivProxyRebuildInProgress = false;
        this.ivUpdates = new ReportClusterProcessStateMsg[n];
        this.ivUpdates2 = new ReportStateMsg[n];
        this.ivCacheDirty = false;
    }

    synchronized void partialStateRebuildRequired() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "disableActiveCoordinatorMessageSend");
        }
        this.ivACRebuildInProgress = true;
        this.ivACWriteNeeded = false;
    }

    synchronized void disableCache() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "disabling message cache");
        }
        this.ivEnabled = false;
        if (!this.ivAlarmRunning && this.ivAlarm != null) {
            this.ivAlarm.cancel();
            this.ivAlarm = null;
        }
    }

    synchronized void enableCache() {
        boolean bl = false;
        if (this.ivACWriteNeeded) {
            bl = true;
        } else {
            for (int i = 0; i < this.ivNumberActives; ++i) {
                if (this.ivUpdates[i] == null && this.ivUpdates2[i] == null) continue;
                bl = true;
                break;
            }
        }
        this.ivEnabled = true;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "enabling cache", new Boolean(bl));
        }
        this.ivCacheDirty = false;
        if (bl) {
            this.scheduleAlarm();
        }
    }

    private final int getActiveCoordinatorIndex(Object object) {
        return HAMUtil.calculateCoordinatorIndex(object, this.ivNumberActives);
    }

    private final void scheduleAlarm() {
        if (this.ivCacheDirty || !this.ivEnabled) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "schedule alarm", new Object[]{new Boolean(this.ivEnabled), new Boolean(this.ivCacheDirty)});
            }
            return;
        }
        this.ivCacheDirty = true;
        if (!this.ivAlarmRunning) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "scheduling alarm");
            }
            this.ivAlarm = AlarmManager.createNonDeferrable(this.ivSendGroupChangeTime, new MessageDeliverer());
        }
    }

    private final class MessageDeliverer
    implements AlarmListener {
        private MessageDeliverer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            boolean bl;
            MessageCache messageCache = MessageCache.this;
            synchronized (messageCache) {
                MessageCache.this.ivAlarm = null;
                if (!MessageCache.this.ivEnabled) {
                    MessageCache.this.ivAlarmRunning = false;
                    return;
                }
                MessageCache.this.ivAlarmRunning = true;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "message delivery thread running");
            }
            if (bl = MessageCache.this.ivCoordinator.sendCachedUpdates()) {
                MessageCache.this.ivProxyRebuildInProgress = false;
            }
            MessageCache messageCache2 = MessageCache.this;
            synchronized (messageCache2) {
                MessageCache.this.ivAlarmRunning = false;
                if (!MessageCache.this.ivEnabled) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "MessageCache alarm - cache has been disabled");
                    }
                    return;
                }
                if (MessageCache.this.ivCacheDirty || !bl) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "reschedule same alarm");
                    }
                    MessageCache.this.ivAlarm = AlarmManager.createNonDeferrable(MessageCache.this.ivSendGroupChangeTime, this);
                }
            }
        }
    }
}

