/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RPCResponseCollector {
    protected static final TraceComponent TC = Tr.register(RPCResponseCollector.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    static int lastRequestID = 0;
    int requestID;
    private Map responses = new HashMap();
    private Set expectedResponseServers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCResponseCollector(Set set) {
        this.expectedResponseServers = set;
        Class clazz = RPCResponseCollector.class;
        synchronized (clazz) {
            this.requestID = ++lastRequestID;
        }
    }

    public Map getCoordinatorResponses() {
        return this.responses;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public synchronized void notifyAllStatesReceived() {
        if (TC.isEventEnabled()) {
            Tr.debug(TC, "RPCResponseCollector.notifyAll() called.");
        }
        this.notifyAll();
    }

    public synchronized boolean addResponse(String string, Object object) {
        this.responses.put(string, object);
        this.expectedResponseServers.remove(string);
        if (TC.isEventEnabled()) {
            Tr.debug(TC, "addResponse - expectedResponseServers.size()=" + this.expectedResponseServers.size());
        }
        if (this.expectedResponseServers.size() == 0) {
            this.notifyAllStatesReceived();
            return true;
        }
        return false;
    }

    boolean isComplete() {
        return this.expectedResponseServers.size() == 0;
    }

    public synchronized boolean waitForCompletion(long l) {
        try {
            if (TC.isEventEnabled()) {
                Tr.debug(TC, "RPCResponseCollector.wait() called.");
            }
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.hamanager.coordinator.impl.RPCResponseCollector.waitForCompletion", "119", this);
        }
        return this.isComplete();
    }
}

