/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl.jmx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.hamanager.jmx.CoordinatorJMX;
import com.ibm.websphere.hamanager.jmx.CoreGroupInfo;
import com.ibm.websphere.hamanager.jmx.CoreGroupManager;
import com.ibm.websphere.hamanager.jmx.GroupData;
import com.ibm.websphere.hamanager.jmx.GroupMemberData;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.websphere.hamanager.jmx.JMXCmdFailedException;
import com.ibm.websphere.hamanager.jmx.JMXIllegalGroupNameException;
import com.ibm.websphere.hamanager.jmx.JMXInvalidParameterException;
import com.ibm.websphere.hamanager.jmx.JMXNoActiveCoordinatorException;
import com.ibm.websphere.hamanager.jmx.JMXTimedOutException;
import com.ibm.websphere.hamanager.jmx.ServerWithActiveGroups;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.GenericCoordinatorMBean;
import com.ibm.ws.hamanager.coordinator.impl.jmx.CoreGroupInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.jmx.CoreGroupManagerImpl;
import com.ibm.ws.hamanager.coordinator.impl.jmx.GroupDataImpl;
import com.ibm.ws.hamanager.coordinator.impl.jmx.GroupMemberDataImpl;
import com.ibm.ws.hamanager.coordinator.impl.jmx.ServerWithActiveGroupsImpl;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.MOfNPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.NOOPPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyFactory;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.FindGroupName;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXActionMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXGroupData;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.ResetQuorumProvidersMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.RetrieveMembersMsg;
import com.ibm.ws.hamanager.impl.MemberDataImpl;
import com.ibm.ws.hamanager.runtime.CoordinatorComponentImpl;
import com.ibm.ws.hamanager.runtime.config.StateBlobBuilder;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAMapException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class CoordinatorJMXImpl
extends GenericCoordinatorMBean
implements CoordinatorJMX {
    protected static final TraceComponent TC = Tr.register(CoordinatorJMXImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "com.ibm.ws.hamanager.coordinator.impl.jmx.CoordinatorJMXImpl";
    private static final String GROUPNAME_WILDCARD = "*";
    private CoordinatorComponentImpl ivCoordinatorComponentImpl;
    private final boolean ivSupportsDynamicCGReload = true;
    private final boolean ivSingleServerMode;

    public CoordinatorJMXImpl(CoordinatorImpl coordinatorImpl, CoordinatorComponentImpl coordinatorComponentImpl, boolean bl) {
        super(coordinatorImpl);
        this.ivCoordinatorComponentImpl = coordinatorComponentImpl;
        this.ivSingleServerMode = bl;
    }

    public boolean supportsDynamicCGReload() {
        return true;
    }

    public boolean isInSingleServerMode() {
        return this.ivSingleServerMode;
    }

    public CoreGroupInfo getCoreGroupInfo() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getCoreGroupInfo");
        }
        Set set = this.getCoordinator().getActiveCoordinatorSet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        CoreGroupInfoImpl coreGroupInfoImpl = new CoreGroupInfoImpl();
        CoreGroupManager[] coreGroupManagerArray = new CoreGroupManager[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            CoreGroupManagerImpl coreGroupManagerImpl = new CoreGroupManagerImpl();
            coreGroupManagerImpl.serverName = stringArray[i];
            coreGroupManagerArray[i] = coreGroupManagerImpl;
        }
        coreGroupInfoImpl.managers = coreGroupManagerArray;
        coreGroupInfoImpl.servers = this.getCoordinator().getCurrentViewMembers();
        coreGroupInfoImpl.name = this.getCoordinator().getCoreGroupName();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getCoreGroupInfo", coreGroupInfoImpl);
        }
        return coreGroupInfoImpl;
    }

    public GroupData[] queryGroupState(String string, Integer n, Boolean bl) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "queryGroupState", new Object[]{string, n, bl});
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"groupNameProps"};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: groupNameProps parameter is null.");
            throw new JMXIllegalGroupNameException(string2);
        }
        if (n == null) {
            Object[] objectArray = new Object[]{"maxGroupsPerCoordinator"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: maxGroupsPerCoordinator parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        if (bl == null) {
            Object[] objectArray = new Object[]{"includeMemberData"};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: includeMemberData parameter is null.");
            throw new JMXInvalidParameterException(string4);
        }
        Iterator iterator = this.findGroupStateForMatchset(string, n, bl);
        GroupData[] groupDataArray = new GroupData[]{};
        if (iterator != null) {
            ArrayList<GroupDataImpl> arrayList = new ArrayList<GroupDataImpl>(10);
            while (iterator.hasNext()) {
                FindGroupName findGroupName = (FindGroupName)iterator.next();
                List list = findGroupName.getGroupNamesFound();
                List list2 = findGroupName.getGroupMapList();
                for (int i = list.size() - 1; i > -1; --i) {
                    GroupName groupName = (GroupName)list.get(i);
                    GroupDataImpl groupDataImpl = new GroupDataImpl();
                    arrayList.add(groupDataImpl);
                    groupDataImpl.setGroupName(groupName);
                    JMXGroupData jMXGroupData = (JMXGroupData)list2.get(i);
                    groupDataImpl.setPolicyNames(jMXGroupData.getPolicyRules());
                    groupDataImpl.setQuorumState(jMXGroupData.getQuorumState());
                    GroupMemberData[] groupMemberDataArray = new GroupMemberData[]{};
                    if (bl.booleanValue()) {
                        Map map = jMXGroupData.getMemberMap();
                        Iterator iterator2 = map.keySet().iterator();
                        ArrayList<GroupMemberDataImpl> arrayList2 = new ArrayList<GroupMemberDataImpl>(10);
                        while (iterator2.hasNext()) {
                            GroupMemberDataImpl groupMemberDataImpl = new GroupMemberDataImpl();
                            arrayList2.add(groupMemberDataImpl);
                            String string5 = (String)iterator2.next();
                            groupMemberDataImpl.setFullyQualifiedServerName(string5);
                            MemberDataImpl memberDataImpl = (MemberDataImpl)map.get(string5);
                            groupMemberDataImpl.setState(memberDataImpl.getState());
                            groupMemberDataImpl.setMemberProperties(memberDataImpl.getMemberId().getMemberProperties());
                        }
                        groupMemberDataArray = new GroupMemberData[arrayList2.size()];
                        arrayList2.toArray(groupMemberDataArray);
                    }
                    groupDataImpl.setMemberData(groupMemberDataArray);
                }
            }
            groupDataArray = new GroupData[arrayList.size()];
            arrayList.toArray(groupDataArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "queryGroupState - returned data length = " + groupDataArray.length);
        }
        return groupDataArray;
    }

    public GroupMemberData[] retrieveGroupMembers(GroupName groupName) {
        String string;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "retrieveGroupMembers", groupName);
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string2);
        }
        GroupMemberData[] groupMemberDataArray = new GroupMemberData[]{};
        RetrieveMembersMsg retrieveMembersMsg = new RetrieveMembersMsg(false, groupName);
        try {
            string = this.getCoordinator().getActiveCoordinator(groupName);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "205", this);
            String string3 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray = new Object[]{string3};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray, "No active coordinators for core group " + string3 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string4);
        }
        Map map = this.rpcToActiveCoordinator(string, retrieveMembersMsg);
        retrieveMembersMsg = (RetrieveMembersMsg)map.values().iterator().next();
        Map map2 = retrieveMembersMsg.getMemberData();
        if (map2.size() > 0) {
            Iterator iterator = map2.keySet().iterator();
            ArrayList<GroupMemberDataImpl> arrayList = new ArrayList<GroupMemberDataImpl>(10);
            while (iterator.hasNext()) {
                GroupMemberDataImpl groupMemberDataImpl = new GroupMemberDataImpl();
                arrayList.add(groupMemberDataImpl);
                String string5 = (String)iterator.next();
                groupMemberDataImpl.setFullyQualifiedServerName(string5);
                MemberDataImpl memberDataImpl = (MemberDataImpl)map2.get(string5);
                groupMemberDataImpl.setState(memberDataImpl.getState());
                groupMemberDataImpl.setMemberProperties(memberDataImpl.getMemberId().getMemberProperties());
            }
            groupMemberDataArray = new GroupMemberData[arrayList.size()];
            arrayList.toArray(groupMemberDataArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "retrieveGroupMembers - returned data length = " + groupMemberDataArray.length);
        }
        return groupMemberDataArray;
    }

    public ServerWithActiveGroups[] queryCountActiveGroupsOnServers(String string, Integer n) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "queryCountActiveGroupsOnServers", new Object[]{string, n});
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"groupNameProps"};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: groupNameProps parameter is null.");
            throw new JMXIllegalGroupNameException(string2);
        }
        if (n == null) {
            Object[] objectArray = new Object[]{"maxGroupsPerCoordinator"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: maxGroupsPerCoordinator parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        ServerWithActiveGroups[] serverWithActiveGroupsArray = new ServerWithActiveGroups[]{};
        Iterator iterator = this.findGroupStateForMatchset(string, n, true);
        if (iterator != null) {
            GroupName[] groupNameArray;
            Serializable serializable;
            Object object;
            Object object2;
            Serializable serializable2;
            HashMap hashMap = new HashMap();
            while (iterator.hasNext()) {
                serializable2 = (FindGroupName)iterator.next();
                object2 = ((FindGroupName)serializable2).getGroupNamesFound();
                object = ((FindGroupName)serializable2).getGroupMapList();
                for (int i = object2.size() - 1; i > -1; --i) {
                    serializable = (GroupName)object2.get(i);
                    groupNameArray = (GroupName[])object.get(i);
                    Map map = groupNameArray.getMemberMap();
                    Iterator iterator2 = map.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String string4 = (String)iterator2.next();
                        MemberDataImpl memberDataImpl = (MemberDataImpl)map.get(string4);
                        if (!memberDataImpl.getState().equals(GroupMemberState.ACTIVATED)) continue;
                        if (!hashMap.containsKey(string4)) {
                            hashMap.put(string4, new ArrayList());
                        }
                        ArrayList arrayList = (ArrayList)hashMap.get(string4);
                        arrayList.add(serializable);
                    }
                }
            }
            serializable2 = new ArrayList(10);
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = new ServerWithActiveGroupsImpl();
                ((ArrayList)serializable2).add(object);
                String string5 = (String)object2.next();
                ((ServerWithActiveGroupsImpl)object).setFullyQualifiedServerName(string5);
                serializable = (ArrayList)hashMap.get(string5);
                groupNameArray = new GroupName[((ArrayList)serializable).size()];
                ((ArrayList)serializable).toArray(groupNameArray);
                ((ServerWithActiveGroupsImpl)object).setActiveGroups(groupNameArray);
            }
            this.getCoordinator().setClusterStateHolder(null);
            serverWithActiveGroupsArray = new ServerWithActiveGroups[((ArrayList)serializable2).size()];
            ((ArrayList)serializable2).toArray(serverWithActiveGroupsArray);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "queryCountActiveGroupsOnServers - returned data length = " + serverWithActiveGroupsArray.length);
        }
        return serverWithActiveGroupsArray;
    }

    public void enableMember(GroupName groupName, String string, String string2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "enableMember", new Object[]{groupName, string, string2});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"nodeName"};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: nodeName parameter is null.");
            throw new JMXInvalidParameterException(string4);
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"serverName"};
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: serverName parameter is null.");
            throw new JMXInvalidParameterException(string5);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(1, groupName, this.getCellName(), string, string2);
        Object[] objectArray = new Object[]{"enableMember", jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
        Tr.info(TC, "HMGR1202", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "332", this);
            String string6 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string6};
            String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string6 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string7, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "336", this);
            String string8 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string8, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "339", this);
            String string9 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string9, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "enableMember");
        }
    }

    public void disableMember(GroupName groupName, String string, String string2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "disableMember", new Object[]{groupName, string, string2});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"nodeName"};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: nodeName parameter is null.");
            throw new JMXInvalidParameterException(string4);
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"serverName"};
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: serverName parameter is null.");
            throw new JMXInvalidParameterException(string5);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(2, groupName, this.getCellName(), string, string2);
        Object[] objectArray = new Object[]{"disableMember", jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
        Tr.info(TC, "HMGR1202", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "381", this);
            String string6 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string6};
            String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string6 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string7, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "385", this);
            String string8 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string8, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "388", this);
            String string9 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string9, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "disableMember");
        }
    }

    public void activateMember(GroupName groupName, String string, String string2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "activateMember", new Object[]{groupName, string, string2});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"nodeName"};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: nodeName parameter is null.");
            throw new JMXInvalidParameterException(string4);
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"serverName"};
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: serverName parameter is null.");
            throw new JMXInvalidParameterException(string5);
        }
        if (!this.isNoOpPolicy(groupName)) {
            Object[] objectArray = new Object[]{"No Operation"};
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1304", objectArray, "HMGR1304E: The GroupName parameter must specify a group governed by a No Operation policy.");
            throw new JMXInvalidParameterException(string6);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(3, groupName, this.getCellName(), string, string2);
        Object[] objectArray = new Object[]{"activateMember", jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
        Tr.info(TC, "HMGR1202", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "429", this);
            String string7 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string7};
            String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string7 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string8, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "433", this);
            String string9 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string9, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "436", this);
            String string10 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string10, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "activateMember");
        }
    }

    public void deactivateMember(GroupName groupName, String string, String string2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "deactivateMember", new Object[]{groupName, string, string2});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string3);
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"nodeName"};
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: nodeName parameter is null.");
            throw new JMXInvalidParameterException(string4);
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"serverName"};
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: serverName parameter is null.");
            throw new JMXInvalidParameterException(string5);
        }
        if (!this.isNoOpPolicy(groupName)) {
            Object[] objectArray = new Object[]{"No Operation"};
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1304", objectArray, "HMGR1304E: The GroupName parameter must specify a group governed by a No Operation policy.");
            throw new JMXInvalidParameterException(string6);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(4, groupName, this.getCellName(), string, string2);
        Object[] objectArray = new Object[]{"deactivateMember", jMXActionMsg.getServerName(), jMXActionMsg.getGroupName()};
        Tr.info(TC, "HMGR1202", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "478", this);
            String string7 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string7};
            String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string7 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string8, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "482", this);
            String string9 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string9, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "485", this);
            String string10 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string10, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "deactivateMember");
        }
    }

    public void enableGroup(GroupName groupName) throws JMXTimedOutException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "enableGroup", new Object[]{groupName});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(10, groupName);
        Object[] objectArray = new Object[]{"enableGroup", groupName};
        Tr.info(TC, "HMGR1201", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "521", this);
            String string = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string + " could be found.");
            throw new JMXNoActiveCoordinatorException(string2, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "525", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "528", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "enableGroup");
        }
    }

    public void disableGroup(GroupName groupName) throws JMXTimedOutException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "disableGroup", new Object[]{groupName});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string);
        }
        JMXActionMsg jMXActionMsg = new JMXActionMsg(20, groupName);
        Object[] objectArray = new Object[]{"disableGroup", groupName};
        Tr.info(TC, "HMGR1201", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinator(groupName, jMXActionMsg);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "564", this);
            String string = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string + " could be found.");
            throw new JMXNoActiveCoordinatorException(string2, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "568", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "571", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "disableGroup");
        }
    }

    public GroupName createGroupName(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "createGroupName", string);
        }
        if (string == null) {
            Object[] objectArray = new Object[]{"groupNameProps"};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: groupNameProps parameter is null.");
            throw new JMXIllegalGroupNameException(string2);
        }
        GroupName groupName = this.getGroupNameFromString(string);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "createGroupName", groupName);
        }
        return groupName;
    }

    public void migrateActiveMember(GroupName groupName, String string, String string2, String string3, String string4) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "migrateActiveMember", new Object[]{groupName, string, string2, string3, string4});
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string5);
        }
        if (string == null || string2 == null) {
            Object[] objectArray = new Object[]{"currActiveMemberNodeName or currActiveMemberServerName"};
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: currActiveMemberNodeName or currActiveMemberServerName parameter is null.");
            throw new JMXInvalidParameterException(string6);
        }
        if (string3 == null || string4 == null) {
            Object[] objectArray = new Object[]{"futureActiveMemberNodeName or futureActiveMemberServerName"};
            String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: futureActiveMemberNodeName or futureActiveMemberServerName parameter is null.");
            throw new JMXInvalidParameterException(string7);
        }
        if (!this.isPreferredServerPolicy(groupName)) {
            Object[] objectArray = new Object[]{"One of N or M of N"};
            String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1304", objectArray, "HMGR1304E: The GroupName parameter must specify a group governed by a One of N or M of N policy.");
            throw new JMXInvalidParameterException(string8);
        }
        String string9 = HAMUtil.createFullyQualifiedServerName(this.getCellName(), string, string2);
        String string10 = HAMUtil.createFullyQualifiedServerName(this.getCellName(), string3, string4);
        Object[] objectArray = new Object[]{"migrateActiveMember", string9, string10, groupName};
        Tr.info(TC, "HMGR1203", objectArray);
        try {
            GroupMemberData[] groupMemberDataArray = this.retrieveGroupMembers(groupName);
            if (groupMemberDataArray.length == 0) {
                String string11 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1305", "HMGR1305E: The specified group does not exist.");
                throw new JMXInvalidParameterException(string11);
            }
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < groupMemberDataArray.length; ++i) {
                GroupMemberData groupMemberData = groupMemberDataArray[i];
                if (groupMemberData.getFullyQualifiedServerName().equalsIgnoreCase(string9)) {
                    bl = true;
                    if (!groupMemberData.getMemberState().equals(GroupMemberState.ACTIVATED)) {
                        objectArray = new Object[]{string9, "ACTIVATED"};
                        String string12 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1307", objectArray, "HMGR1307E: The member " + string9 + " is not in ACTIVATED state.");
                        throw new JMXInvalidParameterException(string12);
                    }
                }
                if (groupMemberData.getFullyQualifiedServerName().equalsIgnoreCase(string10)) {
                    bl2 = true;
                    if (!groupMemberData.getMemberState().equals(GroupMemberState.IDLE)) {
                        objectArray = new Object[]{string10, "IDLE"};
                        String string13 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1307", objectArray, "HMGR1307E: The member " + string10 + " is not in IDLE state.");
                        throw new JMXInvalidParameterException(string13);
                    }
                }
                if (bl && bl2) break;
            }
            if (!bl) {
                objectArray = new Object[]{string9};
                String string14 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1306", objectArray, "HMGR1306E: The specified member " + string9 + " does not exist.");
                throw new JMXInvalidParameterException(string14);
            }
            if (!bl2) {
                objectArray = new Object[]{string10};
                String string15 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1306", objectArray, "HMGR1306E: The specified member " + string10 + " does not exist.");
                throw new JMXInvalidParameterException(string15);
            }
            this.getCoordinator().moveActiveMemberForGroup(groupName, string9, string10);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "657", this);
            String string16 = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string16};
            String string17 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string16 + " could be found.");
            throw new JMXNoActiveCoordinatorException(string17, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "661", this);
            String string18 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string18, dataStackMembershipChangingException);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "664", this);
            String string19 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string19, hAException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "migrateActiveMember");
        }
    }

    public String[] resolvePolicyForGroup(GroupName groupName) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "resolvePolicyForGroup", groupName);
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string);
        }
        try {
            HAPolicyRule hAPolicyRule = this.getCoordinator().getPolicyManager().findHAPolicyRuleForGroup(groupName);
            String[] stringArray = new String[]{hAPolicyRule.getRuleName()};
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "resolvePolicyForGroup - returned data length = " + stringArray.length);
            }
            return stringArray;
        }
        catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
            FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "694", this);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "resolvePolicyForGroup - returned data length = 0");
            }
            return new String[0];
        }
        catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
            FFDCFilter.processException((Throwable)duplicatePoliciesMatchGroupException, svClassName, "701", this);
            String[] stringArray = new String[duplicatePoliciesMatchGroupException.getMatchingRules().length];
            System.arraycopy(duplicatePoliciesMatchGroupException.getMatchingRules(), 0, stringArray, 0, duplicatePoliciesMatchGroupException.getMatchingRules().length);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "resolvePolicyForGroup - returned data length = " + stringArray.length);
            }
            return stringArray;
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "710", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1308", "HMGR1308E: An unexpected failure occurred.");
            throw new JMXCmdFailedException(string, hAInternalStateException);
        }
    }

    public void runPolicy(GroupName groupName) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "runPolicy", groupName);
        }
        if (groupName == null) {
            Object[] objectArray = new Object[]{"GroupName"};
            String string = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1300", objectArray, "HMGR1300E: GroupName parameter is null.");
            throw new JMXInvalidParameterException(string);
        }
        Object[] objectArray = new Object[]{"runPolicy", groupName};
        Tr.info(TC, "HMGR1201", objectArray);
        try {
            this.getCoordinator().requestCheckGroup(groupName);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "734", this);
            String string = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string + " could be found.");
            throw new JMXNoActiveCoordinatorException(string2, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "738", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string, dataStackMembershipChangingException);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "741", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string, dataStackException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "runPolicy");
        }
    }

    public void resetQuorumProviders() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "resetQuorumProviders");
        }
        Object[] objectArray = new Object[]{"resetQuorumProviders"};
        Tr.info(TC, "HMGR1200", objectArray);
        try {
            this.getCoordinator().sendMessageToActiveCoordinators(ResetQuorumProvidersMsg.MSG);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "765", this);
            String string = this.getCoordinator().getCoreGroupName();
            Object[] objectArray2 = new Object[]{string};
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1301", objectArray2, "No active coordinators for core group " + string + " could be found.");
            throw new JMXNoActiveCoordinatorException(string2, hAInternalStateException);
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "769", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1302", "HMGR1302E: View is changing. Retry command after the view has stabilized.");
            throw new JMXCmdFailedException(string, dataStackMembershipChangingException);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "773", this);
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1303", "HMGR1303E: A send message problem has occurred.");
            throw new JMXCmdFailedException(string, hAException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "resetQuorumProviders");
        }
    }

    public void updateRuntimeConfig(Serializable serializable) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "updateRuntimeConfig");
        }
        if (!(serializable instanceof StateBlob)) {
            throw new JMXInvalidParameterException("Invalid parameter type.");
        }
        this.ivCoordinatorComponentImpl.coreGroupConfigurationAvailable((StateBlob)serializable);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "updateRuntimeConfig");
        }
    }

    public Serializable getCoreGroupConfig(String string) {
        try {
            return StateBlobBuilder.buildBlob(string, false, true);
        }
        catch (HAException hAException) {
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "649", this);
        }
        return null;
    }

    private Iterator findGroupStateForMatchset(String string, int n, boolean bl) {
        GroupName groupName = string.equals(GROUPNAME_WILDCARD) ? null : this.getGroupNameFromString(string);
        FindGroupName findGroupName = new FindGroupName(false, groupName, n, bl);
        Map map = this.rpcToActiveCoordinators(findGroupName);
        Iterator iterator = map.values().iterator();
        return iterator;
    }

    private final GroupName getGroupNameFromString(String string) {
        String string2;
        Object object;
        Object object2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getGroupNameFromString()", string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashMap<String, String> hashMap = new HashMap<String, String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            if (((String)object2).indexOf("=") == -1) continue;
            object = new StringTokenizer((String)object2, "=");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3;
                try {
                    string2 = ((StringTokenizer)object).nextToken();
                    string3 = ((StringTokenizer)object).nextToken();
                    hashMap.put(string2, string3);
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, svClassName, "868", this);
                    string3 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1309", "HMGR1309E: The group name string is invalid.");
                    throw new JMXIllegalGroupNameException(string3, noSuchElementException);
                }
            }
        }
        object2 = null;
        try {
            object = this.getCoordinator().getGroupManager();
            object2 = object.createGroupName(hashMap);
        }
        catch (HAMapException hAMapException) {
            FFDCFilter.processException((Throwable)hAMapException, svClassName, "882", this);
            string2 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1309", "HMGR1309E: The group name string is invalid.");
            throw new JMXIllegalGroupNameException(string2, hAMapException);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "886", this);
            string2 = TraceNLS.getStringFromBundle("com.ibm.ws.hamanager.nls.HAManagerMessages", "HMGR1308", "HMGR1308E: An unexpected failure occurred.");
            throw new JMXCmdFailedException(string2, hAException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getGroupNameFromString()", object2);
        }
        return object2;
    }

    private boolean isNoOpPolicy(GroupName groupName) {
        boolean bl = false;
        try {
            HAPolicyRule hAPolicyRule = this.getCoordinator().getPolicyManager().findHAPolicyRuleForGroup(groupName);
            GroupPolicyFactory groupPolicyFactory = hAPolicyRule.getGroupPolicyFactory();
            if (groupPolicyFactory instanceof NOOPPolicyFactory) {
                return true;
            }
        }
        catch (HAException hAException) {
            // empty catch block
        }
        return bl;
    }

    private boolean isPreferredServerPolicy(GroupName groupName) {
        boolean bl = false;
        try {
            HAPolicyRule hAPolicyRule = this.getCoordinator().getPolicyManager().findHAPolicyRuleForGroup(groupName);
            GroupPolicyFactory groupPolicyFactory = hAPolicyRule.getGroupPolicyFactory();
            if (groupPolicyFactory instanceof OneOfNPolicyFactory || groupPolicyFactory instanceof MOfNPolicyFactory) {
                return true;
            }
        }
        catch (HAException hAException) {
            // empty catch block
        }
        return bl;
    }
}

