/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.policy.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.MemberActivationController;
import com.ibm.ws.hamanager.coordinator.policy.PolicyCannotInitializeException;
import com.ibm.ws.hamanager.coordinator.policy.impl.BasePolicyImpl;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import com.ibm.wsspi.hamanager.policy.AllActivePolicy;

public class AllActivePolicyImpl
extends BasePolicyImpl
implements AllActivePolicy,
GroupPolicy {
    private static final TraceComponent TC = Tr.register(AllActivePolicyImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");

    public AllActivePolicyImpl(GroupName groupName, HAPolicyRule hAPolicyRule) throws PolicyCannotInitializeException {
        super(groupName, hAPolicyRule);
    }

    public boolean checkGroup(MemberData[] memberDataArray, MemberActivationController memberActivationController) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "checkGroup()", new Object[]{"GroupName=[" + this.groupName + "]", "Number of members=" + memberDataArray.length, memberActivationController});
        }
        boolean bl = false;
        for (int i = 0; i < memberDataArray.length; ++i) {
            if (!memberDataArray[i].getState().equals(GroupMemberState.IDLE)) continue;
            bl = true;
            try {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "IDLE member found. Try activating member.");
                }
                memberActivationController.makeMemberActive(memberDataArray[i].getMemberId());
                continue;
            }
            catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
                FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, "com.ibm.ws.hamanager.coordinator.policy.impl.AllActivePolicyImpl.checkGroup", "96", this);
                Object[] objectArray = new Object[]{this.groupName, notPossibleAtThisTimeException.toString()};
                Tr.audit(TC, "HMGR1107", objectArray);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "checkGroup", String.valueOf(!bl));
        }
        return !bl;
    }

    public void stop() {
    }
}

