/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.policy.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.MemberActivationController;
import com.ibm.ws.hamanager.coordinator.policy.PolicyCannotInitializeException;
import com.ibm.ws.hamanager.coordinator.policy.impl.BasePolicyImpl;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import com.ibm.wsspi.hamanager.policy.MOfNPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MOfNPolicyImpl
extends BasePolicyImpl
implements MOfNPolicy,
GroupPolicy {
    private static final TraceComponent TC = Tr.register(MOfNPolicyImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private boolean actionTaken = false;
    private String[] preferredServers;
    private String[] policyPreferredServers;
    private String[] groupNamePreferredServers;

    public MOfNPolicyImpl(GroupName groupName, HAPolicyRule hAPolicyRule) throws PolicyCannotInitializeException {
        super(groupName, hAPolicyRule);
        String string = (String)groupName.getGroupProperties().get("GN_PS");
        this.groupNamePreferredServers = string != null ? this.parseServerListProperty(string) : null;
    }

    public boolean checkGroup(MemberData[] memberDataArray, MemberActivationController memberActivationController) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "checkGroup()", new Object[]{"GroupName=[" + this.groupName + "]", "Number of members=" + memberDataArray.length, memberActivationController});
        }
        try {
            boolean bl;
            boolean bl2;
            block42: {
                CurrentGroupState currentGroupState;
                int n;
                block40: {
                    block44: {
                        int n2;
                        block43: {
                            block45: {
                                int n3;
                                block46: {
                                    block41: {
                                        int n4;
                                        bl2 = this.rule.isForcePreferred();
                                        bl = this.rule.getPreferredOnly();
                                        n = this.rule.getNumActive();
                                        this.policyPreferredServers = this.rule.getPreferredServerAttributes();
                                        this.preferredServers = this.policyPreferredServers != null ? this.policyPreferredServers : (this.groupNamePreferredServers != null ? this.groupNamePreferredServers : new String[0]);
                                        currentGroupState = new CurrentGroupState(memberDataArray, this.preferredServers);
                                        if (bl) {
                                            n4 = this.deactivateNonPreferredMembers(-1, currentGroupState, memberDataArray, memberActivationController);
                                        }
                                        if (memberDataArray.length <= n) break block40;
                                        if (currentGroupState.currentTotalActive < n) {
                                            n4 = n - currentGroupState.currentTotalActive;
                                            if (currentGroupState.availablePreferred > 0) {
                                                int n5;
                                                if (bl2 && currentGroupState.availablePreferred > n4) {
                                                    n4 += this.deactivateNonPreferredMembers(-1, currentGroupState, memberDataArray, memberActivationController);
                                                    n4 += this.deactivatePreferredMembers(n, currentGroupState, memberDataArray, memberActivationController);
                                                }
                                                if ((n5 = this.activatePreferredMembers(n4, currentGroupState, memberDataArray, memberActivationController)) < n4) {
                                                    if (bl) {
                                                        if (TC.isEntryEnabled()) {
                                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested not active, all preferred activated.");
                                                        }
                                                    } else {
                                                        this.activateAnyMembers(n4, memberDataArray, memberActivationController);
                                                        if (TC.isEntryEnabled()) {
                                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested not active, activating any members");
                                                        }
                                                    }
                                                } else if (TC.isEntryEnabled()) {
                                                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested not active, activated preferred members");
                                                }
                                            } else if (bl) {
                                                if (TC.isEntryEnabled()) {
                                                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested not active, all preferred activated.");
                                                }
                                            } else {
                                                this.activateAnyMembers(n4, memberDataArray, memberActivationController);
                                                if (TC.isEntryEnabled()) {
                                                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested not active, activating any members");
                                                }
                                            }
                                            return false;
                                        }
                                        if (currentGroupState.currentTotalActive != n) break block41;
                                        if (bl2 && currentGroupState.availablePreferred > 0) {
                                            n4 = 0;
                                            if (currentGroupState.currentTotalActive - currentGroupState.activePreferred > 0) {
                                                n4 = this.deactivateNonPreferredMembers(currentGroupState.availablePreferred, currentGroupState, memberDataArray, memberActivationController);
                                            }
                                            if (n4 < currentGroupState.availablePreferred) {
                                                n4 += this.deactivatePreferredMembers(n, currentGroupState, memberDataArray, memberActivationController);
                                            }
                                            if (n4 > 0) {
                                                int n6 = this.activatePreferredMembers(n4, currentGroupState, memberDataArray, memberActivationController);
                                                if (n6 < n4) {
                                                    if (bl) {
                                                        if (TC.isEntryEnabled()) {
                                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested were active, all preferred activated.");
                                                        }
                                                    } else {
                                                        this.activateAnyMembers(n4, memberDataArray, memberActivationController);
                                                        if (TC.isEntryEnabled()) {
                                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested were active, activating any members");
                                                        }
                                                    }
                                                } else if (TC.isEntryEnabled()) {
                                                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested were active, activated preferred members");
                                                }
                                                return false;
                                            }
                                        }
                                        break block42;
                                    }
                                    Object[] objectArray = new Object[]{this.groupName};
                                    Tr.audit(TC, "HMGR1106", objectArray);
                                    n2 = currentGroupState.currentTotalActive - n;
                                    if (!bl2 || currentGroupState.preferredServerList.isEmpty()) break block43;
                                    int n7 = this.deactivateNonPreferredMembers(n2, currentGroupState, memberDataArray, memberActivationController);
                                    n2 -= n7;
                                    n7 = this.deactivatePreferredMembers(n, currentGroupState, memberDataArray, memberActivationController);
                                    if (currentGroupState.currentTotalActive >= n) break block44;
                                    n3 = n - currentGroupState.currentTotalActive;
                                    int n8 = this.activatePreferredMembers(n3, currentGroupState, memberDataArray, memberActivationController);
                                    if (n8 >= n3) break block45;
                                    if (!bl) break block46;
                                    if (TC.isEntryEnabled()) {
                                        Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] too many were active, all preferred activated.");
                                    }
                                    break block44;
                                }
                                this.activateAnyMembers(n3, memberDataArray, memberActivationController);
                                if (!TC.isEntryEnabled()) break block44;
                                Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] too many were active, activating any members");
                                break block44;
                            }
                            if (!TC.isEntryEnabled()) break block44;
                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] requested were active, activated preferred members");
                            break block44;
                        }
                        for (int i = 0; i < n2; ++i) {
                            memberActivationController.makeAnyActiveMemberIdle();
                        }
                    }
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] too many active.");
                    }
                    break block42;
                }
                if (currentGroupState.currentTotalActive == n) {
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "checkGroup(): true - [preferredOnly=" + bl + " failback=" + bl2 + "] policy is compliant, number of group members = requested active.");
                    }
                    return true;
                }
                if (bl) {
                    this.activatePreferredMembers(-1, currentGroupState, memberDataArray, memberActivationController);
                } else {
                    this.activateAnyMembers(-1, memberDataArray, memberActivationController);
                }
                if (TC.isEntryEnabled()) {
                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + bl + " failback=" + bl2 + "] number of group members <= requested active, All possible activated.");
                }
                return false;
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "checkGroup(): true - [preferredOnly=" + bl + " failback=" + bl2 + "] policy is compliant, no changes required.");
            }
            return true;
        }
        catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
            FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, "com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyImpl.checkGroup", "349", this);
            Object[] objectArray = new Object[]{this.groupName, notPossibleAtThisTimeException.toString()};
            Tr.audit(TC, "HMGR1107", objectArray);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "checkGroup() NotPossibleAtThisTimeException false");
            }
            return false;
        }
    }

    public void stop() {
    }

    private int activateAnyMembers(int n, MemberData[] memberDataArray, MemberActivationController memberActivationController) throws NotPossibleAtThisTimeException, HAInternalStateException {
        int n2 = 0;
        for (int i = 0; i < memberDataArray.length; ++i) {
            if (memberDataArray[i].getState().equals(GroupMemberState.IDLE)) {
                memberActivationController.makeAnyIdleMemberActive();
                ++n2;
            }
            if (n2 == n) break;
        }
        return n2;
    }

    private int activatePreferredMembers(int n, CurrentGroupState currentGroupState, MemberData[] memberDataArray, MemberActivationController memberActivationController) throws NotPossibleAtThisTimeException, HAInternalStateException {
        int n2 = 0;
        Iterator iterator = currentGroupState.preferredServerList.iterator();
        while (iterator.hasNext()) {
            GroupMember groupMember = (GroupMember)iterator.next();
            if (memberDataArray[groupMember.getIndex()].getState().equals(GroupMemberState.IDLE)) {
                memberActivationController.makeMemberActive(memberDataArray[groupMember.getIndex()].getMemberId());
                ++n2;
                ((CurrentGroupState)currentGroupState).activeIndex[groupMember.getIndex()] = true;
                currentGroupState.currentTotalActive++;
                currentGroupState.activePreferred++;
            }
            if (n2 != n) continue;
            break;
        }
        return n2;
    }

    private int deactivateNonPreferredMembers(int n, CurrentGroupState currentGroupState, MemberData[] memberDataArray, MemberActivationController memberActivationController) throws NotPossibleAtThisTimeException, HAInternalStateException {
        int n2 = 0;
        if (currentGroupState.activeNonPreferred > 0) {
            for (int i = 0; i < currentGroupState.activeIndex.length; ++i) {
                if (!currentGroupState.activeIndex[i] || currentGroupState.preferredIndex[i]) continue;
                memberActivationController.makeMemberIdle(memberDataArray[i].getMemberId());
                ((CurrentGroupState)currentGroupState).activeIndex[i] = false;
                currentGroupState.currentTotalActive--;
                currentGroupState.activeNonPreferred--;
                if (++n2 == n) break;
            }
        }
        return n2;
    }

    private int deactivatePreferredMembers(int n, CurrentGroupState currentGroupState, MemberData[] memberDataArray, MemberActivationController memberActivationController) throws NotPossibleAtThisTimeException, HAInternalStateException {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        Iterator iterator = currentGroupState.preferredServerList.iterator();
        while (iterator.hasNext()) {
            GroupMember groupMember = (GroupMember)iterator.next();
            GroupMemberState groupMemberState = memberDataArray[groupMember.getIndex()].getState();
            if (groupMemberState.equals(GroupMemberState.ACTIVATED)) {
                ++n3;
                if (bl) {
                    memberActivationController.makeMemberIdle(memberDataArray[groupMember.getIndex()].getMemberId());
                    ++n2;
                    ((CurrentGroupState)currentGroupState).activeIndex[groupMember.getIndex()] = false;
                    currentGroupState.currentTotalActive--;
                    currentGroupState.activePreferred--;
                }
            } else if (groupMemberState.equals(GroupMemberState.IDLE) || groupMemberState.equals(GroupMemberState.ACTIVATING)) {
                ++n3;
            }
            if (n3 != n) continue;
            bl = true;
        }
        return n2;
    }

    private class GroupMember {
        private String serverName;
        private int index;

        GroupMember(String string, int n) {
            this.serverName = string;
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String string) {
            this.serverName = string;
        }
    }

    private class CurrentGroupState {
        private boolean[] activeIndex;
        private boolean[] preferredIndex;
        private boolean[] idlePreferredIndex;
        private int currentTotalActive = 0;
        private int activePreferred = 0;
        private int activeNonPreferred = 0;
        private int availablePreferred = 0;
        private List preferredServerList;

        CurrentGroupState(MemberData[] memberDataArray, String[] stringArray) {
            int n;
            this.activeIndex = new boolean[memberDataArray.length];
            this.preferredIndex = new boolean[memberDataArray.length];
            this.idlePreferredIndex = new boolean[memberDataArray.length];
            this.preferredServerList = new ArrayList(stringArray.length);
            for (n = 0; n < memberDataArray.length; ++n) {
                if (!memberDataArray[n].getState().equals(GroupMemberState.ACTIVATED) && !memberDataArray[n].getState().equals(GroupMemberState.ACTIVATING)) continue;
                ++this.currentTotalActive;
                this.activeIndex[n] = true;
            }
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < memberDataArray.length; ++i) {
                    if (!stringArray[n].equalsIgnoreCase(memberDataArray[i].getMemberId().getServerName())) continue;
                    this.preferredServerList.add(new GroupMember(memberDataArray[i].getMemberId().getServerName(), i));
                    this.preferredIndex[i] = true;
                    if (this.activeIndex[i]) {
                        ++this.activePreferred;
                        continue;
                    }
                    if (!memberDataArray[i].getState().equals(GroupMemberState.IDLE)) continue;
                    ++this.availablePreferred;
                    this.idlePreferredIndex[i] = true;
                }
            }
            this.activeNonPreferred = this.currentTotalActive - this.activePreferred;
        }
    }
}

