/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.policy.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.MemberActivationController;
import com.ibm.ws.hamanager.coordinator.policy.PolicyCannotInitializeException;
import com.ibm.ws.hamanager.coordinator.policy.impl.BasePolicyImpl;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import com.ibm.wsspi.hamanager.policy.OneOfNPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OneOfNPolicyImpl
extends BasePolicyImpl
implements OneOfNPolicy,
GroupPolicy {
    private static final TraceComponent TC = Tr.register(OneOfNPolicyImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final int REQUIRED_ACTIVE = 1;
    private String[] preferredServers;
    private String[] policyPreferredServers;
    private String[] groupNamePreferredServers;
    private boolean forcePreferred;
    private boolean activatePreferredOnly;

    public OneOfNPolicyImpl(GroupName groupName, HAPolicyRule hAPolicyRule) throws PolicyCannotInitializeException {
        super(groupName, hAPolicyRule);
        String string = (String)groupName.getGroupProperties().get("GN_PS");
        this.groupNamePreferredServers = string != null ? this.parseServerListProperty(string) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkGroup(MemberData[] memberDataArray, MemberActivationController memberActivationController) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "checkGroup()", new Object[]{"GroupName=[" + this.groupName + "]", "Number of members=" + memberDataArray.length, memberActivationController});
        }
        try {
            block37: {
                boolean[] blArray;
                block35: {
                    GroupMember groupMember;
                    block36: {
                        int n;
                        int n2;
                        this.forcePreferred = this.rule.isForcePreferred();
                        this.activatePreferredOnly = this.rule.getPreferredOnly();
                        this.policyPreferredServers = this.rule.getPreferredServerAttributes();
                        this.preferredServers = this.policyPreferredServers != null ? this.policyPreferredServers : (this.groupNamePreferredServers != null ? this.groupNamePreferredServers : new String[0]);
                        blArray = new boolean[memberDataArray.length];
                        boolean[] blArray2 = new boolean[memberDataArray.length];
                        int n3 = 0;
                        int n4 = -1;
                        int n5 = 0;
                        int n6 = 0;
                        ArrayList<GroupMember> arrayList = new ArrayList<GroupMember>(this.preferredServers.length);
                        for (n2 = 0; n2 < memberDataArray.length; ++n2) {
                            if (!memberDataArray[n2].getState().equals(GroupMemberState.ACTIVATED) && !memberDataArray[n2].getState().equals(GroupMemberState.ACTIVATING)) continue;
                            ++n3;
                            blArray[n2] = true;
                            n4 = n2;
                        }
                        n2 = 0;
                        while (true) {
                            if (n2 < this.preferredServers.length) {
                            } else {
                                if (n3 == 0) {
                                    if (this.activatePreferredOnly && n6 < 1) {
                                        if (TC.isEntryEnabled()) {
                                            Tr.exit(TC, "checkGroup(): true - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] policy compliant, no preferred available to activate");
                                        }
                                        return true;
                                    }
                                    if (n6 > 0) {
                                        GroupMember groupMember2 = this.findMostPreferred(arrayList, memberDataArray, new GroupMemberState[]{GroupMemberState.IDLE});
                                        memberActivationController.makeMemberActive(memberDataArray[groupMember2.getIndex()].getMemberId());
                                        if (TC.isEntryEnabled()) {
                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] none active so preferred was activated.");
                                        }
                                        return false;
                                    }
                                    memberActivationController.makeAnyIdleMemberActive();
                                    if (TC.isEntryEnabled()) {
                                        Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] none active so any was activated.");
                                    }
                                    return false;
                                }
                                if (n3 == 1) {
                                    if (this.activatePreferredOnly && n5 == 0) {
                                        memberActivationController.makeMemberIdle(memberDataArray[n4].getMemberId());
                                        if (TC.isEntryEnabled()) {
                                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] deactivated non-preferred");
                                        }
                                        return false;
                                    }
                                    if (this.forcePreferred && n6 > 0) {
                                        if (blArray2[n4]) {
                                            GroupMember groupMember3 = this.findMostPreferred(arrayList, memberDataArray, new GroupMemberState[]{GroupMemberState.ACTIVATED, GroupMemberState.IDLE, GroupMemberState.ACTIVATING});
                                            if (!blArray[groupMember3.getIndex()]) {
                                                memberActivationController.makeMemberIdle(memberDataArray[n4].getMemberId());
                                                if (TC.isEntryEnabled()) {
                                                    Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] deactivate current preferred.");
                                                }
                                                return false;
                                            }
                                        } else {
                                            memberActivationController.makeMemberIdle(memberDataArray[n4].getMemberId());
                                            if (TC.isEntryEnabled()) {
                                                Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] deactivate current.");
                                            }
                                            return false;
                                        }
                                    }
                                } else {
                                    Object[] objectArray = new Object[]{this.groupName};
                                    Tr.audit(TC, "HMGR1106", objectArray);
                                    if (this.activatePreferredOnly && n5 == 0) {
                                        break;
                                    }
                                    if ((this.activatePreferredOnly || this.forcePreferred) && !arrayList.isEmpty()) {
                                        groupMember = this.findMostPreferred(arrayList, memberDataArray, new GroupMemberState[]{GroupMemberState.ACTIVATED, GroupMemberState.IDLE, GroupMemberState.ACTIVATING});
                                        if (!blArray[groupMember.getIndex()]) break block35;
                                        break block36;
                                    }
                                    n = 0;
                                    if (n >= n3 - 1) break block37;
                                    memberActivationController.makeAnyActiveMemberIdle();
                                    break block37;
                                }
                                if (TC.isEntryEnabled()) {
                                    Tr.exit(TC, "checkGroup(): true - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] policy is compliant, no changes required.");
                                }
                                return true;
                            }
                            for (n = 0; n < memberDataArray.length; ++n) {
                                if (!this.preferredServers[n2].equalsIgnoreCase(memberDataArray[n].getMemberId().getServerName())) continue;
                                arrayList.add(new GroupMember(memberDataArray[n].getMemberId().getServerName(), n));
                                blArray2[n] = true;
                                if (blArray[n]) {
                                    ++n5;
                                    continue;
                                }
                                if (!memberDataArray[n].getState().equals(GroupMemberState.IDLE)) continue;
                                ++n6;
                            }
                            ++n2;
                        }
                        for (n = 0; n < blArray.length; ++n) {
                            if (!blArray[n]) continue;
                            memberActivationController.makeMemberIdle(memberDataArray[n].getMemberId());
                            break;
                        }
                        if (TC.isEntryEnabled()) {
                            Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] deactivated non-preferred member.");
                        }
                        return false;
                    }
                    for (int i = 0; i < blArray.length; ++i) {
                        if (i == groupMember.getIndex() || !blArray[i]) continue;
                        memberActivationController.makeMemberIdle(memberDataArray[i].getMemberId());
                        break block37;
                    }
                    break block37;
                }
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    memberActivationController.makeMemberIdle(memberDataArray[i].getMemberId());
                    break;
                }
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] deactivate excess member.");
            }
            return false;
        }
        catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
            FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, "com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyImpl.checkGroup", "394", this);
            Object[] objectArray = new Object[]{this.groupName, notPossibleAtThisTimeException.toString()};
            Tr.audit(TC, "HMGR1107", objectArray);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "checkGroup(): false - [preferredOnly=" + this.activatePreferredOnly + " failback=" + this.forcePreferred + "] NotPossibleAtThisTimeException");
            }
            return false;
        }
    }

    public void stop() {
    }

    private GroupMember findMostPreferred(List list, MemberData[] memberDataArray, GroupMemberState[] groupMemberStateArray) {
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                GroupMember groupMember = (GroupMember)iterator.next();
                for (int i = 0; i < groupMemberStateArray.length; ++i) {
                    if (!memberDataArray[groupMember.getIndex()].getState().equals(groupMemberStateArray[i])) continue;
                    return groupMember;
                }
            }
        }
        return null;
    }

    private class GroupMember {
        private String serverName;
        private int index;

        GroupMember(String string, int n) {
            this.serverName = string;
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String string) {
            this.serverName = string;
        }
    }
}

