/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.policy.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.MemberActivationController;
import com.ibm.ws.hamanager.coordinator.policy.PolicyCannotInitializeException;
import com.ibm.ws.hamanager.coordinator.policy.impl.BasePolicyImpl;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import com.ibm.wsspi.hamanager.policy.StaticPolicy;

public class StaticPolicyImpl
extends BasePolicyImpl
implements StaticPolicy,
GroupPolicy {
    private static final TraceComponent TC = Tr.register(StaticPolicyImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private String[] servers;
    private String[] policyServers;
    private String[] groupNameServers;

    public StaticPolicyImpl(GroupName groupName, HAPolicyRule hAPolicyRule) throws PolicyCannotInitializeException {
        super(groupName, hAPolicyRule);
        String string = (String)groupName.getGroupProperties().get("GN_PS");
        this.groupNameServers = string != null ? this.parseServerListProperty(string) : null;
    }

    public boolean checkGroup(MemberData[] memberDataArray, MemberActivationController memberActivationController) throws HAInternalStateException {
        Object[] objectArray;
        int n;
        int n2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "checkGroup()", new Object[]{"GroupName=[" + this.groupName + "]", "Number of members=" + memberDataArray.length, memberActivationController});
        }
        this.policyServers = this.rule.getServerAttributes();
        this.servers = this.policyServers != null ? this.policyServers : (this.groupNameServers != null ? this.groupNameServers : new String[0]);
        boolean bl = true;
        boolean bl2 = true;
        for (n2 = 0; n2 < memberDataArray.length; ++n2) {
            if (!memberDataArray[n2].getState().equals(GroupMemberState.ACTIVATED) && !memberDataArray[n2].getState().equals(GroupMemberState.ACTIVATING)) continue;
            n = 0;
            for (int i = 0; i < this.servers.length; ++i) {
                if (!memberDataArray[n2].getMemberId().getServerName().equalsIgnoreCase(this.servers[i])) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            bl = false;
            bl2 = false;
            if (!memberDataArray[n2].getState().equals(GroupMemberState.ACTIVATED)) continue;
            try {
                memberActivationController.makeMemberIdle(memberDataArray[n2].getMemberId());
                continue;
            }
            catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
                FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, "com.ibm.ws.hamanager.coordinator.policy.impl.StaticPolicyImpl.checkGroup", "104", this);
                objectArray = new Object[]{this.groupName, notPossibleAtThisTimeException.toString()};
                Tr.audit(TC, "HMGR1107", objectArray);
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < this.servers.length; ++n2) {
                for (n = 0; n < memberDataArray.length; ++n) {
                    if (!this.servers[n2].equalsIgnoreCase(memberDataArray[n].getMemberId().getServerName()) || !memberDataArray[n].getState().equals(GroupMemberState.IDLE)) continue;
                    try {
                        memberActivationController.makeMemberActive(memberDataArray[n].getMemberId());
                        bl = false;
                        continue;
                    }
                    catch (NotPossibleAtThisTimeException notPossibleAtThisTimeException) {
                        FFDCFilter.processException((Throwable)notPossibleAtThisTimeException, "com.ibm.ws.hamanager.coordinator.policy.impl.StaticPolicyImpl.checkGroup", "101", this);
                        objectArray = new Object[]{this.groupName, notPossibleAtThisTimeException.toString()};
                        Tr.audit(TC, "HMGR1107", objectArray);
                    }
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "checkGroup", String.valueOf(bl));
        }
        return bl;
    }

    public void stop() {
    }
}

