/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.vsmessages;

import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.vsmessages.ActiveCoordinatorMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.GroupName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GroupUpdateMsg
extends ActiveCoordinatorMessage {
    private static final long serialVersionUID = -7437389450140720756L;
    private HashMap ivElements;

    public GroupUpdateMsg() {
        this.ivVersion = HAMMessage.INITIAL;
        this.ivElements = new HashMap();
    }

    public String getDescription() {
        return "GroupUpdateMsg";
    }

    public void addEntry(GroupName groupName, MemberData[] memberDataArray) {
        this.ivElements.put(groupName, memberDataArray);
    }

    public Map getEntries() {
        return this.ivElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GROUPUPDATEMSG: ");
        try {
            Iterator iterator = this.ivElements.keySet().iterator();
            while (iterator.hasNext()) {
                GroupName groupName = (GroupName)iterator.next();
                MemberData[] memberDataArray = (MemberData[])this.ivElements.get(groupName);
                stringBuffer.append(groupName.toString());
                stringBuffer.append(" / ");
                int n = memberDataArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("member[" + i + "]=");
                    stringBuffer.append(memberDataArray[i].toString());
                    stringBuffer.append(" ");
                }
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            stringBuffer.append("...error");
            return stringBuffer.toString();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(objectInputStream);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
        this.ivElements = MapUtils.readMapFromStream(objectInputStream2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivElements);
        objectOutputStream2.flush();
        gZIPOutputStream.finish();
    }
}

