/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.vsmessages;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.bboard.BulletinBoardServerPosts;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.impl.GroupNameImpl;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.GroupName;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ReportClusterProcessStateMsg
extends HAMMessage {
    private static final long serialVersionUID = -4640309507916831312L;
    private Map ivGroupState;
    private Map ivBulletinBoardValues;
    private Map ivBulletinBoardSubscribers;

    public ReportClusterProcessStateMsg() {
        this.ivVersion = HAMMessage.INITIAL;
        this.ivGroupState = new HashMap();
        this.ivBulletinBoardValues = new HashMap();
        this.ivBulletinBoardSubscribers = new HashMap();
    }

    public String getDescription() {
        return "ReportClusterProcessStateMsg";
    }

    public Map getCurrentState() {
        return this.ivGroupState;
    }

    public Map getBulletinBoardValues() {
        return this.ivBulletinBoardValues;
    }

    public Map getSubscribers() {
        return this.ivBulletinBoardSubscribers;
    }

    public String toString() {
        Object object;
        Serializable serializable;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REPORT.CLUSTER.STATE.MSG | currentState ==> ");
        if (!this.ivBulletinBoardValues.isEmpty()) {
            try {
                stringBuffer.append("BulletinBoardPostUpdateData {");
                object2 = this.ivBulletinBoardValues.keySet().iterator();
                while (object2.hasNext()) {
                    serializable = (SubjectInfoImpl)object2.next();
                    stringBuffer.append("(" + ((SubjectInfoImpl)serializable).toString() + " :: ");
                    if (this.ivBulletinBoardValues.get(serializable) == null) {
                        stringBuffer.append("null");
                    } else {
                        object = (BulletinBoardServerPosts)this.ivBulletinBoardValues.get(serializable);
                        stringBuffer.append(((BulletinBoardServerPosts)object).toString());
                    }
                    stringBuffer.append(")");
                }
                stringBuffer.append("}");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "151", this);
                stringBuffer.append("...error, unexpected exception received while attempting to stringify BBoard diagnostic data");
                return stringBuffer.toString();
            }
        }
        if (!this.ivGroupState.isEmpty()) {
            try {
                stringBuffer.append("GroupStateUpdateData {");
                object = this.ivGroupState.entrySet().iterator();
                while (object.hasNext()) {
                    stringBuffer.append("(");
                    object2 = object.next();
                    serializable = (GroupName)object2.getKey();
                    GroupState groupState = (GroupState)object2.getValue();
                    stringBuffer.append(serializable.toString());
                    stringBuffer.append("::");
                    stringBuffer.append(groupState.toString());
                    stringBuffer.append(")");
                }
                stringBuffer.append("}");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "174", this);
                stringBuffer.append("...error, unexpected exception received while attempting to stringify GroupStateUpdateData diagnostic data");
                return stringBuffer.toString();
            }
        }
        if (!this.ivBulletinBoardSubscribers.isEmpty()) {
            try {
                stringBuffer.append("BulletinBoardSubscriberUpdateData {");
                object = this.ivBulletinBoardSubscribers.keySet().iterator();
                while (object.hasNext()) {
                    stringBuffer.append("(");
                    object2 = (SubjectInfoImpl)((Object)object.next());
                    stringBuffer.append(((SubjectInfoImpl)object2).toString() + " :: ");
                    serializable = (Boolean)this.ivBulletinBoardSubscribers.get(object2);
                    if (serializable == null) {
                        stringBuffer.append("null");
                    } else {
                        boolean bl = (Boolean)serializable;
                        stringBuffer.append(bl);
                    }
                    stringBuffer.append(")");
                }
                stringBuffer.append("}");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "198", this);
                stringBuffer.append("...error, unexpected exception received while attempting to stringify BulletinBoardSubscriberUpdateData diagnostic data");
                return stringBuffer.toString();
            }
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(objectInputStream);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
        this.readGroupState(objectInputStream2);
        this.ivBulletinBoardValues = MapUtils.readMapFromStream(objectInputStream2);
        this.ivBulletinBoardSubscribers = MapUtils.readMapFromStream(objectInputStream2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
        this.writeGroupState(objectOutputStream2);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivBulletinBoardValues);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivBulletinBoardSubscribers);
        objectOutputStream2.flush();
        gZIPOutputStream.finish();
    }

    private void readGroupState(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ivGroupState = new HashMap();
        int n = objectInput.readInt();
        if (n == -1) {
            return;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                GroupNameImpl groupNameImpl = (GroupNameImpl)objectInput.readObject();
                GroupState groupState = (GroupState)objectInput.readObject();
                this.ivGroupState.put(groupNameImpl, groupState);
            }
        }
    }

    private void writeGroupState(ObjectOutput objectOutput) throws IOException {
        if (this.ivGroupState == null) {
            objectOutput.writeInt(-1);
        } else {
            int n = this.ivGroupState.size();
            objectOutput.writeInt(n);
            Set set = this.ivGroupState.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                GroupNameImpl groupNameImpl = (GroupNameImpl)entry.getKey();
                GroupState groupState = (GroupState)entry.getValue();
                objectOutput.writeObject(groupNameImpl);
                objectOutput.writeObject(groupState);
            }
        }
    }
}

