/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.vsmessages;

import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.impl.GroupNameImpl;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ReportStateMsg
extends HAMMessage {
    private static final long serialVersionUID = -3035858430136885766L;
    public static final String BULLETIN_BOARD_LOCAL = "BULLETIN_BOARD_LOCAL";
    public static final String BULLETIN_BOARD_PROXY = "BULLETIN_BOARD_PROXY";
    public static final transient int NODATA = 0;
    public static final transient int UPDATE = 1;
    public static final transient int GLOBAL_REBUILD = 2;
    public static final transient int EXPLICIT_BRIDGE_REBUILD = 3;
    public static final transient int DEFERRED = 4;
    public static final String[] MODES = new String[]{"NODATA", "UPDATE", "GLOBAL_REBUILD", "EXPLICIT_BRIDGE_REBUILD", "DEFERRED"};
    private transient Map ivModes;
    private transient Map ivGroupState;
    private transient Map ivLocalPosts;
    private transient Map ivProxyPosts;
    private transient Map ivLocalBulletinBoardSubscribers;
    private transient Map ivProxyBulletinBoardSubscribers;
    private transient Set ivConfiguredBridges;
    private transient Set ivSubjectsOwnedByBridge;

    public ReportStateMsg() {
        this.ivVersion = HAMMessage.INITIAL;
        this.ivModes = new HashMap();
        this.ivModes.put(BULLETIN_BOARD_LOCAL, new Integer(0));
        this.ivModes.put(BULLETIN_BOARD_PROXY, new Integer(0));
        this.ivGroupState = new HashMap();
        this.ivLocalPosts = new HashMap();
        this.ivProxyPosts = new HashMap();
        this.ivLocalBulletinBoardSubscribers = new HashMap();
        this.ivProxyBulletinBoardSubscribers = new HashMap();
        this.ivConfiguredBridges = new HashSet();
        this.ivSubjectsOwnedByBridge = new HashSet();
    }

    public Map getModes() {
        return this.ivModes;
    }

    public void setBulletinBoardLocalMode(int n) {
        this.ivModes.put(BULLETIN_BOARD_LOCAL, new Integer(n));
    }

    public void setBulletinBoardProxyMode(int n) {
        this.ivModes.put(BULLETIN_BOARD_PROXY, new Integer(n));
        if (n == 3) {
            this.ivProxyPosts.clear();
        }
    }

    public int flushProxyState() {
        this.ivModes.put(BULLETIN_BOARD_PROXY, new Integer(0));
        int n = this.ivProxyPosts.size();
        this.ivProxyPosts.clear();
        return n;
    }

    public void addHAGroupData(GroupName groupName, GroupState groupState) {
        this.ivGroupState.put(groupName, groupState);
    }

    public void addBulletinBoardLocalPost(SubjectInfo subjectInfo, BulletinBoardPost bulletinBoardPost) {
        this.ivLocalPosts.put(subjectInfo, bulletinBoardPost);
    }

    public void setBridgeConfigurationData(Set set) {
        this.ivConfiguredBridges = set;
    }

    public Set getBridgeConfigurationData() {
        return this.ivConfiguredBridges;
    }

    public void addBulletinBoardProxyPost(SubjectInfo subjectInfo, BulletinBoardPost bulletinBoardPost) {
        HashMap<String, BulletinBoardPost> hashMap = (HashMap<String, BulletinBoardPost>)this.ivProxyPosts.get(subjectInfo);
        if ((Integer)this.ivModes.get(BULLETIN_BOARD_PROXY) == 3 && bulletinBoardPost.getVersion() == -1L) {
            if (hashMap != null) {
                hashMap.remove(bulletinBoardPost.getOriginalServer());
                if (hashMap.isEmpty()) {
                    this.ivProxyPosts.remove(subjectInfo);
                }
            }
            return;
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, BulletinBoardPost>();
            this.ivProxyPosts.put(subjectInfo, hashMap);
        }
        hashMap.put(bulletinBoardPost.getOriginalServer(), bulletinBoardPost);
    }

    public void addBulletinBoardProxyPostMap(SubjectInfo subjectInfo, Map map) {
        this.ivProxyPosts.put(subjectInfo, map);
    }

    public void addBulletinBoardLocalSubscriber(SubjectInfo subjectInfo, Boolean bl) {
        this.ivLocalBulletinBoardSubscribers.put(subjectInfo, bl);
    }

    public void addBulletinBoardProxySubscriber(SubjectInfo subjectInfo, Boolean bl) {
        this.ivProxyBulletinBoardSubscribers.put(subjectInfo, bl);
    }

    public void addBridgeOwnedSubjects(Set set) {
        this.ivSubjectsOwnedByBridge = set;
    }

    public void addBridgeOwnedSubject(SubjectInfo subjectInfo) {
        this.ivSubjectsOwnedByBridge.add(subjectInfo);
    }

    public Set getBridgeSubjects() {
        return this.ivSubjectsOwnedByBridge;
    }

    public String getDescription() {
        return "ReportStateMsg";
    }

    public Map getHAGroupData() {
        return this.ivGroupState;
    }

    public Map getLocalPosts() {
        return this.ivLocalPosts;
    }

    public Map getProxyPosts() {
        return this.ivProxyPosts;
    }

    public Map getLocalSubscribers() {
        return this.ivLocalBulletinBoardSubscribers;
    }

    public Map getProxySubscribers() {
        return this.ivProxyBulletinBoardSubscribers;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REPORT.STATE.MSG | currentState ==> ");
        stringBuffer.append("LocalMode {" + MODES[(Integer)this.ivModes.get(BULLETIN_BOARD_LOCAL)] + "}:");
        stringBuffer.append("ProxyMode {" + MODES[(Integer)this.ivModes.get(BULLETIN_BOARD_PROXY)] + "}:");
        stringBuffer.append("LocalPosts {" + this.ivLocalPosts.size() + "}:");
        stringBuffer.append("ProxyPosts {" + this.ivProxyPosts.size() + "}:");
        stringBuffer.append("LocalSubscribers {" + this.ivLocalBulletinBoardSubscribers.size() + "}:");
        stringBuffer.append("ProxySubscribers {" + this.ivProxyBulletinBoardSubscribers.size() + "}:");
        stringBuffer.append("ConfiguredBridges {" + this.ivConfiguredBridges.size() + "}:");
        stringBuffer.append("GroupStateUpdateData {" + this.ivGroupState.size() + "}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
        this.writeGroupState(objectOutputStream2);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivModes);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivLocalPosts);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivProxyPosts);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivLocalBulletinBoardSubscribers);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivProxyBulletinBoardSubscribers);
        HAMUtil.writeSetToStream(objectOutputStream2, this.ivConfiguredBridges);
        HAMUtil.writeSetToStream(objectOutputStream2, this.ivSubjectsOwnedByBridge);
        objectOutputStream2.flush();
        gZIPOutputStream.finish();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        GZIPInputStream gZIPInputStream = new GZIPInputStream(objectInputStream);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
        this.readGroupState(objectInputStream2);
        this.ivModes = MapUtils.readMapFromStream(objectInputStream2);
        this.ivLocalPosts = MapUtils.readMapFromStream(objectInputStream2);
        this.ivProxyPosts = MapUtils.readMapFromStream(objectInputStream2);
        this.ivLocalBulletinBoardSubscribers = MapUtils.readMapFromStream(objectInputStream2);
        this.ivProxyBulletinBoardSubscribers = MapUtils.readMapFromStream(objectInputStream2);
        this.ivConfiguredBridges = HAMUtil.readSetFromStream(objectInputStream2);
        this.ivSubjectsOwnedByBridge = HAMUtil.readSetFromStream(objectInputStream2);
    }

    private void readGroupState(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ivGroupState = new HashMap();
        int n = objectInput.readInt();
        if (n == -1) {
            return;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                GroupNameImpl groupNameImpl = (GroupNameImpl)objectInput.readObject();
                GroupState groupState = (GroupState)objectInput.readObject();
                this.ivGroupState.put(groupNameImpl, groupState);
            }
        }
    }

    private void writeGroupState(ObjectOutput objectOutput) throws IOException {
        if (this.ivGroupState == null) {
            objectOutput.writeInt(-1);
        } else {
            int n = this.ivGroupState.size();
            objectOutput.writeInt(n);
            Set set = this.ivGroupState.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                GroupNameImpl groupNameImpl = (GroupNameImpl)entry.getKey();
                GroupState groupState = (GroupState)entry.getValue();
                objectOutput.writeObject(groupNameImpl);
                objectOutput.writeObject(groupState);
            }
        }
    }
}

