/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.vsmessages.bboard;

import com.ibm.ejs.ras.Traceable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.MapUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SubscriberUpdateMsg
extends HAMMessage
implements Traceable {
    private static final long serialVersionUID = -2395516214076137372L;
    public static final transient int NODATA = 0;
    public static final transient int REPLACE = 1;
    public static final transient int MERGE = 2;
    private static final transient String[] MODES = new String[]{"NODATA", "REPLACE", "MERGE"};
    private static final transient String LOCAL_MODE = "LOCAL_MODE";
    private static final transient String PROXY_MODE = "PROXY_MODE";
    private transient Map ivModes;
    private transient Map ivValues;
    private transient Set ivEmptySubjects = new HashSet();

    public SubscriberUpdateMsg() {
        this.ivValues = new HashMap();
        this.ivModes = new HashMap();
        this.ivModes.put(LOCAL_MODE, new Integer(0));
        this.ivModes.put(PROXY_MODE, new Integer(0));
    }

    public int getLocalMode() {
        return (Integer)this.ivModes.get(LOCAL_MODE);
    }

    public int getProxyMode() {
        return (Integer)this.ivModes.get(PROXY_MODE);
    }

    public void setValues(int n, int n2, Map map) {
        this.ivValues = map;
        this.ivModes.put(LOCAL_MODE, new Integer(n));
        this.ivModes.put(PROXY_MODE, new Integer(n2));
    }

    public void addEmptySubject(SubjectInfoImpl subjectInfoImpl) {
        this.ivEmptySubjects.add(subjectInfoImpl);
    }

    public String getDescription() {
        return "SubscriberUpdateMsg";
    }

    public Map getData() {
        return this.ivValues;
    }

    public Set getEmptySubjects() {
        return this.ivEmptySubjects;
    }

    public String toString() {
        return this.getDescription() + " LocalMode:" + MODES[this.getLocalMode()] + ", ForeignMode:" + MODES[this.getProxyMode()];
    }

    public String toTraceString() {
        Object object;
        String string = DebugUtils.getNewLine();
        String string2 = "          ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubscriberUpdateMsg : LocalMessageMode = ");
        stringBuffer.append(MODES[this.getLocalMode()]);
        stringBuffer.append(", SubscriberUpdateMsg : ProxyMessageMode = ");
        stringBuffer.append(MODES[this.getProxyMode()]);
        Iterator iterator = this.ivValues.entrySet().iterator();
        String string3 = "";
        String string4 = "";
        while (iterator.hasNext()) {
            try {
                object = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)object.getKey();
                Map map = (Map)object.getValue();
                stringBuffer.append(string);
                stringBuffer.append("    Subject : ");
                stringBuffer.append(subjectInfoImpl);
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    string3 = k != null ? k.getClass().getName() : "null";
                    string4 = v != null ? v.getClass().getName() : "null";
                    String string5 = (String)k;
                    BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)v;
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    if (bulletinBoardPost == null) {
                        stringBuffer.append(string5 + " = null,");
                        continue;
                    }
                    stringBuffer.append(bulletinBoardPost);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.coordinator.vsmessages.bboard.SubscriberUpdateMsg.toTraceString", "184", this);
                stringBuffer.append("Malformed data structure: exception received -> " + Arrays.asList(throwable.getStackTrace()));
                stringBuffer.append(string);
                stringBuffer.append("keyClassName = " + string3 + ", valueClassName = " + string4);
            }
        }
        stringBuffer.append(string);
        if (!this.ivEmptySubjects.isEmpty()) {
            stringBuffer.append(this.ivEmptySubjects.size() + " empty Subjects:");
            stringBuffer.append(string);
            stringBuffer.append(string2);
            object = this.ivEmptySubjects.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append("No Empty Subjects");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivModes);
        MapUtils.writeMapToStream(objectOutputStream2, this.ivValues);
        HAMUtil.writeSetToStream(objectOutputStream2, this.ivEmptySubjects);
        objectOutputStream2.flush();
        gZIPOutputStream.finish();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        GZIPInputStream gZIPInputStream = new GZIPInputStream(objectInputStream);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
        this.ivModes = MapUtils.readMapFromStream(objectInputStream2);
        this.ivValues = MapUtils.readMapFromStream(objectInputStream2);
        this.ivEmptySubjects = HAMUtil.readSetFromStream(objectInputStream2);
    }
}

