/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.vsmessages.jmx;

import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.GroupName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JMXActionMsg
extends HAMMessage {
    private static final long serialVersionUID = 6863725680774014566L;
    public static final int CMD_ENABLE_MEMBER = 1;
    public static final int CMD_DISABLE_MEMBER = 2;
    public static final int CMD_ACTIVATE_MEMBER = 3;
    public static final int CMD_DEACTIVATE_MEMBER = 4;
    public static final int CMD_ENABLE_GROUP = 10;
    public static final int CMD_DISABLE_GROUP = 20;
    private static final int GROUP_CMD_MIN_RANGE = 10;
    private int ivCmd;
    private GroupName ivGroupName;
    private String ivServerName;
    private boolean ivGroupAction;

    public JMXActionMsg(int n, GroupName groupName, String string, String string2, String string3) {
        this.ivVersion = HAMMessage.INITIAL;
        this.ivCmd = n;
        this.ivGroupName = groupName;
        this.ivServerName = HAMUtil.createFullyQualifiedServerName(string, string2, string3);
        this.ivGroupAction = this.ivCmd >= 10;
    }

    public JMXActionMsg(int n, GroupName groupName) {
        this.ivVersion = HAMMessage.INITIAL;
        this.ivCmd = n;
        this.ivGroupName = groupName;
        this.ivServerName = null;
        this.ivGroupAction = this.ivCmd >= 10;
    }

    public String getDescription() {
        return "JMX Action Requested: Command=" + this.getCommandAsString();
    }

    public int getCommand() {
        return this.ivCmd;
    }

    public String getCommandAsString() {
        switch (this.ivCmd) {
            case 1: {
                return "CMD_ENABLE_MEMBER";
            }
            case 2: {
                return "CMD_DISABLE_MEMBER";
            }
            case 3: {
                return "CMD_ACTIVATE_MEMBER";
            }
            case 4: {
                return "CMD_DEACTIVATE_MEMBER";
            }
            case 10: {
                return "CMD_ENABLE_GROUP";
            }
            case 20: {
                return "CMD_DISABLE_GROUP";
            }
        }
        return "CMD_UNKNOWN";
    }

    public GroupName getGroupName() {
        return this.ivGroupName;
    }

    public String getServerName() {
        return this.ivServerName;
    }

    public boolean isGroupAction() {
        return this.ivGroupAction;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

