/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.datastack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.DCS;
import com.ibm.ws.dcs.common.DCSDataStack;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.DCSMessageListener;
import com.ibm.ws.dcs.common.DCSNotificationsListener;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.ViewApprover;
import com.ibm.ws.dcs.common.ViewChangeEvent;
import com.ibm.ws.dcs.common.ViewChangeListener;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.config.DCSDataStackConfigMap;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.common.event.DCSTransmitterCongestionEvent;
import com.ibm.ws.dcs.common.exception.DCSCongestionException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.drsmodule.DRSDataStack;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackInfoImpl;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackTransportType;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackClosedException;
import com.ibm.wsspi.hamanager.datastack.DataStackCongestionException;
import com.ibm.wsspi.hamanager.datastack.DataStackEvent;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DataStackImpl
implements DataStack,
DCSMessageListener,
DCSNotificationsListener,
ViewChangeListener,
ViewApprover {
    private static final TraceComponent svTc = Tr.register(DataStackImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = DataStackImpl.class.getName();
    public static final String DSTYPE_BASE = "BASE";
    public static final String DSTYPE_SYNC = "SYNC";
    private static final Class baseDataStackClass = DCSDataStack.class;
    private static final Class drsDataStackClass = DRSDataStack.class;
    private DCSPlugin ivDCSPlugin;
    protected DCSDataStack ivStack;
    protected String ivDataStackName;
    protected HAGroupImpl ivHAGroup = null;
    private DataStackCallback ivCallback;
    private Comparable ivViewID;
    private String ivServerName;
    private String[] ivDataStackMembers;
    private boolean ivDCSStable = true;
    private GroupMemberId ivLocalMember;
    private byte[] ivLocalMemberBytes;
    private GroupMemberId[] ivEligibleProcessList;
    private Map ivGMIdHistory;
    private GroupMemberId[] ivLastRequestViewEPL;
    private boolean ivViewLeaderPreviousView;
    private boolean terminateInProgress = false;
    private boolean ivUnicastTransport = true;

    public DataStackImpl(DCS dCS, DCSPlugin dCSPlugin, String string, String string2, boolean bl, HAGroupImpl hAGroupImpl, CoreStackInfoImpl coreStackInfoImpl, Map map, String[] stringArray, DataStackCallback dataStackCallback) throws DataStackException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "DataStackImpl", new Object[]{string, string2, String.valueOf(bl), stringArray, hAGroupImpl});
        }
        try {
            this.ivDCSPlugin = dCSPlugin;
            this.ivHAGroup = hAGroupImpl;
            this.ivDataStackName = string;
            this.ivCallback = dataStackCallback;
            this.ivUnicastTransport = true;
            CoreStackTransportType coreStackTransportType = coreStackInfoImpl.getTransportType();
            if (coreStackTransportType.equals(CoreStackTransportType.MULTICAST)) {
                this.ivUnicastTransport = false;
            }
            this.ivServerName = hAGroupImpl.getMemberName().getServerName();
            this.ivDataStackMembers = new String[]{this.ivServerName};
            this.ivLocalMember = this.ivHAGroup.getMemberName();
            this.ivLocalMemberBytes = this.preserializeLocalMember(this.ivLocalMember);
            this.ivEligibleProcessList = new GroupMemberId[]{this.ivLocalMember};
            this.ivLastRequestViewEPL = this.ivEligibleProcessList;
            this.ivGMIdHistory = new HashMap();
            this.ivGMIdHistory.put(this.ivServerName, this.ivLocalMember);
            this.ivViewLeaderPreviousView = true;
            DCSDataStackConfigMap dCSDataStackConfigMap = this.createDataStackConfiguration(bl, string2, coreStackInfoImpl, map);
            this.ivStack = dCS.getDCSDataStack(string, stringArray, dCSDataStackConfigMap, this.ivDCSPlugin.getMemberProvider());
            this.ivStack.setApplicationMessageListener(this);
            this.ivStack.setNotificationListener(this);
            this.ivStack.setViewApprover(this);
            this.ivStack.setViewChangeListener(this);
            this.ivViewID = this.ivStack.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "196", this);
            Object[] objectArray = new Object[]{string, throwable};
            Tr.error(svTc, "HMGR0401", objectArray);
            throw new DataStackException("Creation of the DataStack=" + string + " failed", throwable);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "DataStackImpl");
        }
    }

    private DCSDataStackConfigMap createDataStackConfiguration(boolean bl, String string, CoreStackInfo coreStackInfo, Map map) {
        DCSDataStackConfigMap dCSDataStackConfigMap = new DCSDataStackConfigMap();
        Class clazz = string != DSTYPE_SYNC ? baseDataStackClass : drsDataStackClass;
        dCSDataStackConfigMap.put("DataStackType", clazz);
        dCSDataStackConfigMap.put("FailureDetectorType", "BasicHBT");
        dCSDataStackConfigMap.put("FailureDetectorParameters", map);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (bl) {
            hashMap.put("useVirtualSynchronyMessaging", new Boolean(true));
        } else {
            hashMap.put("useVirtualSynchronyMessaging", new Boolean(false));
        }
        hashMap.put("enableVerificationMode", new Boolean(coreStackInfo.getEnableTransportDiagnostics()));
        dCSDataStackConfigMap.put("StackConstruction", hashMap);
        Integer n = new Integer(coreStackInfo.getMemberBringupTimeSecs());
        Integer n2 = new Integer(coreStackInfo.getCompletenessVsSpeed());
        dCSDataStackConfigMap.put("ExpectedBringupTimeSec", n);
        dCSDataStackConfigMap.put("CompletenessVsSpeed", n2);
        int n3 = coreStackInfo.getDataStackMemory();
        dCSDataStackConfigMap.put("MaxStackMemoryMB", new Integer(n3));
        dCSDataStackConfigMap.put("UseBufferPool", new Boolean(coreStackInfo.getUsePooledMemory()));
        dCSDataStackConfigMap.put("MessagingDirection", "Both");
        dCSDataStackConfigMap.put("ExpectedMessagePayloadSizeBytes", new Integer(coreStackInfo.getExpectedMessageSize()));
        return dCSDataStackConfigMap;
    }

    private byte[] preserializeLocalMember(GroupMemberId groupMemberId) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        int n = byteArrayOutputStream.size();
        byteArrayOutputStream.write(170);
        byteArrayOutputStream.write(187);
        byteArrayOutputStream.write(204);
        byteArrayOutputStream.write(221);
        int n2 = byteArrayOutputStream.size();
        objectOutputStream.writeObject(groupMemberId);
        objectOutputStream.flush();
        int n3 = byteArrayOutputStream.size();
        int n4 = n3 - n2;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray[n++] = (byte)(n4 & 0xFF);
        byArray[n++] = (byte)((n4 >>>= 8) & 0xFF);
        byArray[n++] = (byte)((n4 >>>= 8) & 0xFF);
        byArray[n++] = (byte)((n4 >>>= 8) & 0xFF);
        return byArray;
    }

    public String getDataStackName() {
        return this.ivDataStackName;
    }

    public synchronized void sendMessage(String string, MsgQoS msgQoS, String string2, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage - P2P (datastack=" + this.ivDataStackName + ")", new Object[]{string2, string, msgQoS, byArray});
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (string == null) {
            throw new HAParameterRejectedException("A null target is not allowed");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (string2 == null) {
            throw new HAParameterRejectedException("A null channel is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        try {
            DCSMessage dCSMessage = this.getMessage(dCSDataStack, byArray, string2);
            if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
                QoS.QOSUnicast qOSUnicast = QoS.getUnicastQoS(QoS.VS_CURRENT, QoS.FIFO);
                dCSDataStack.sendMessage(string, 1, dCSMessage, qOSUnicast, this.ivViewID);
            } else if (this.ivUnicastTransport) {
                String[] stringArray = new String[]{string};
                this.sendSubgroupMessageViaUnicastChannel(dCSDataStack, stringArray, msgQoS, dCSMessage);
            } else {
                String[] stringArray = new String[]{string};
                this.sendSubgroupMessageViaMulticastChannel(dCSDataStack, stringArray, msgQoS, dCSMessage);
            }
        }
        catch (DCSMemberIsNotDefinedException dCSMemberIsNotDefinedException) {
            FFDCFilter.processException((Throwable)dCSMemberIsNotDefinedException, svClassName, "372", this);
            throw new DataStackMemberException("The target member is not known.", dCSMemberIsNotDefinedException);
        }
        catch (DCSMemberIsNotInViewException dCSMemberIsNotInViewException) {
            FFDCFilter.processException((Throwable)dCSMemberIsNotInViewException, svClassName, "376", this);
            throw new DataStackMembershipChangingException("The target member is not currently in view.", dCSMemberIsNotInViewException);
        }
        catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
            FFDCFilter.processException((Throwable)dCSInvalidViewIDException, svClassName, "380", this);
            throw new DataStackMembershipChangingException("membership is changing", dCSInvalidViewIDException);
        }
        catch (DCSCongestionException dCSCongestionException) {
            FFDCFilter.processException((Throwable)dCSCongestionException, svClassName, "384", this);
            throw new DataStackCongestionException("The message path is congested.", dCSCongestionException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "388", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
            Tr.error(svTc, "HMGR0402", objectArray);
            if (throwable instanceof OutOfMemoryError) {
                this.ivDCSPlugin.sendAttentionReqMsg("HMGR0402");
            }
            throw new DataStackException("Unexpected exception in DataStack.sendMessage-subgroup", throwable);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage - subgroup (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void sendMessage(String[] stringArray, MsgQoS msgQoS, String string, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage - subgroup (datastack=" + this.ivDataStackName + ")", new Object[]{string, msgQoS, byArray});
            Tr.debug(svTc, "destinations", stringArray);
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new HAParameterRejectedException("A null or empty target array is not allowed");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS_CURRENT qos is not allowed on subgroup send");
        }
        if (string == null) {
            throw new HAParameterRejectedException("A null channel is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        try {
            DCSMessage dCSMessage = this.getMessage(dCSDataStack, byArray, string);
            if (this.ivUnicastTransport) {
                this.sendSubgroupMessageViaUnicastChannel(dCSDataStack, stringArray, msgQoS, dCSMessage);
            } else {
                this.sendSubgroupMessageViaMulticastChannel(dCSDataStack, stringArray, msgQoS, dCSMessage);
            }
        }
        catch (DCSMemberIsNotDefinedException dCSMemberIsNotDefinedException) {
            FFDCFilter.processException((Throwable)dCSMemberIsNotDefinedException, svClassName, "444", this);
            throw new DataStackMemberException("The target member is not known.", dCSMemberIsNotDefinedException);
        }
        catch (DCSMemberIsNotInViewException dCSMemberIsNotInViewException) {
            FFDCFilter.processException((Throwable)dCSMemberIsNotInViewException, svClassName, "448", this);
            throw new DataStackMembershipChangingException("The target member is not currently in view.", dCSMemberIsNotInViewException);
        }
        catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
            FFDCFilter.processException((Throwable)dCSInvalidViewIDException, svClassName, "452", this);
            throw new DataStackMembershipChangingException("membership is changing", dCSInvalidViewIDException);
        }
        catch (DCSCongestionException dCSCongestionException) {
            FFDCFilter.processException((Throwable)dCSCongestionException, svClassName, "456", this);
            throw new DataStackCongestionException("The message path is congested.", dCSCongestionException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "460", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
            Tr.error(svTc, "HMGR0402", objectArray);
            if (throwable instanceof OutOfMemoryError) {
                this.ivDCSPlugin.sendAttentionReqMsg("HMGR0402");
            }
            throw new DataStackException("Unexpected exception in DataStack.sendMessage-subgroup", throwable);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage - subgroup (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void sendMessage(MsgQoS msgQoS, String string, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")", new Object[]{string, msgQoS, byArray});
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS_CURRENT qos is not allowed on group send");
        }
        if (string == null) {
            throw new HAParameterRejectedException("A null channel is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        try {
            DCSMessage dCSMessage = this.getMessage(dCSDataStack, byArray, string);
            if (this.ivUnicastTransport) {
                this.sendSubgroupMessageViaUnicastChannel(dCSDataStack, this.ivDataStackMembers, msgQoS, dCSMessage);
            } else {
                QoS.QOSMulticast qOSMulticast = this.getMulticastQoS(msgQoS);
                dCSDataStack.mcastMessage(1, dCSMessage, qOSMulticast);
            }
        }
        catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
            FFDCFilter.processException((Throwable)dCSInvalidViewIDException, svClassName, "514", this);
            throw new DataStackMembershipChangingException("membership is changing", dCSInvalidViewIDException);
        }
        catch (DCSCongestionException dCSCongestionException) {
            FFDCFilter.processException((Throwable)dCSCongestionException, svClassName, "518", this);
            throw new DataStackCongestionException("The message path is congested.", dCSCongestionException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "522", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
            Tr.error(svTc, "HMGR0402", objectArray);
            if (throwable instanceof OutOfMemoryError) {
                this.ivDCSPlugin.sendAttentionReqMsg("HMGR0402");
            }
            throw new DataStackException("Unexpected exception in DataStack.sendMessage", throwable);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void terminateDataStack() {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "terminateDataStack (datastack=" + this.ivDataStackName + ")");
        }
        if ((dCSDataStack = this.getDataStackReference()) == null || this.terminateInProgress) {
            return;
        }
        String string = this.ivDataStackName;
        dCSDataStack.requestTermination();
        this.terminateInProgress = true;
        this.ivDCSPlugin.deleteDataStack(string);
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "terminateDataStack (datastack=" + string + ")");
        }
    }

    public void onMessage(DCSMessage dCSMessage) {
        block5: {
            if (svTc.isEntryEnabled()) {
                Tr.entry(svTc, "onMessage (datastack=" + this.ivDataStackName + ")", dCSMessage);
            }
            try {
                GroupMemberId groupMemberId = (GroupMemberId)dCSMessage.readObject();
                String string = dCSMessage.readString();
                int n = dCSMessage.readInt();
                byte[] byArray = new byte[n];
                dCSMessage.readBytes(byArray);
                DataStackCallback dataStackCallback = this.ivCallback;
                if (dataStackCallback != null) {
                    dataStackCallback.dataStackMessageReceived(groupMemberId, string, byArray);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "585", this);
                Object[] objectArray = new Object[]{this.ivDataStackName, dCSMessage, throwable};
                Tr.error(svTc, "HMGR0404", objectArray);
                if (!(throwable instanceof OutOfMemoryError)) break block5;
                this.ivDCSPlugin.sendAttentionReqMsg("HMGR0404");
            }
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "onMessage (datastack=" + this.ivDataStackName + ")");
        }
    }

    public void removeMembers(String[] stringArray) {
        if (!this.isDataStackViewLeader()) {
            return;
        }
    }

    public synchronized void updateProtocolVersion(int n, StateVersion stateVersion) throws DataStackException {
        DCSDataStack dCSDataStack = this.getDataStackReference();
        if (dCSDataStack == null || !this.isDataStackViewLeader()) {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "updateProtocolVersion - no action", this.ivDataStackName);
            }
            return;
        }
        try {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "updateProtocolVersion", new Object[]{new Integer(n), stateVersion});
            }
            dCSDataStack.setDCSProtocolVersion(n, stateVersion);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "628", this);
            Tr.error(svTc, "HMGR0108", new Object[]{"DataStackImpl", "updateProtocolVersion", throwable});
            throw new DataStackException("unrecoverable exception", throwable);
        }
    }

    public Throwable check() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewChangeEvent(ViewChangeEvent viewChangeEvent, Comparable comparable) {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "handleViewChangeEvent (datastack=" + this.ivDataStackName + ")", new Object[]{viewChangeEvent, comparable});
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            return;
        }
        switch (viewChangeEvent.getEventType()) {
            case 5: {
                DataStackCallback dataStackCallback;
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "handleViewChangeEvent", "TERMINATE: Data Stack = " + this.ivDataStackName);
                }
                this.ivHAGroup.deleteDataStack();
                dCSDataStack.handleViewChangeEventDone(viewChangeEvent);
                DataStackImpl dataStackImpl = this;
                synchronized (dataStackImpl) {
                    this.ivStack = null;
                    dataStackCallback = this.ivCallback;
                    this.ivCallback = null;
                    this.ivDataStackName = null;
                }
                try {
                    dataStackCallback.dataStackTerminated();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, svClassName, "650", this);
                    Object[] objectArray = new Object[]{this.ivDataStackName, "terminated()", throwable};
                    Tr.error(svTc, "HMGR0403", objectArray);
                }
                break;
            }
            case 1: {
                DataStackCallback dataStackCallback;
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "handleViewChangeEvent - completeCurrent");
                }
                if ((dataStackCallback = this.ivCallback) != null) {
                    dataStackCallback.dataStackViewAboutToChange();
                }
                DataStackImpl dataStackImpl = this;
                synchronized (dataStackImpl) {
                    this.ivDCSStable = false;
                }
                dCSDataStack.handleViewChangeEventDone(viewChangeEvent);
                break;
            }
            case 4: {
                GroupMemberId[] groupMemberIdArray;
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "handleViewChangeEvent- newViewOK", new Boolean(this.ivViewLeaderPreviousView));
                }
                dCSDataStack.handleViewChangeEventDone(viewChangeEvent);
                DataStackImpl dataStackImpl = this;
                synchronized (dataStackImpl) {
                    this.ivViewID = comparable;
                    this.ivDataStackMembers = viewChangeEvent.getMembersNames();
                    Arrays.sort(this.ivDataStackMembers);
                    this.ivDCSStable = true;
                    groupMemberIdArray = this.getHAMMemberList();
                    if (groupMemberIdArray.length == this.ivDataStackMembers.length) {
                        this.handleStaleEPL(dCSDataStack);
                    } else {
                        groupMemberIdArray = this.handleIncompatibleMemberships(dCSDataStack, groupMemberIdArray.length);
                    }
                }
                DataStackCallback dataStackCallback = this.ivCallback;
                if (dataStackCallback == null) break;
                dataStackCallback.dataStackMembershipChanged(groupMemberIdArray);
                break;
            }
            default: {
                return;
            }
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "handleViewChangeEvent (datastack=" + this.ivDataStackName + ")");
        }
    }

    public void notifyEvent(DCSExternalEvent dCSExternalEvent) {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "notifyEvent (datastack=" + this.ivDataStackName + ")", dCSExternalEvent);
        }
        try {
            if (dCSExternalEvent instanceof DCSTransmitterCongestionEvent) {
                DataStackCallback dataStackCallback;
                DCSTransmitterCongestionEvent dCSTransmitterCongestionEvent = (DCSTransmitterCongestionEvent)dCSExternalEvent;
                DataStackEvent dataStackEvent = null;
                DCSTransmitterCongestionEvent.CongestionWaterMark congestionWaterMark = dCSTransmitterCongestionEvent.getWatermark();
                if (congestionWaterMark.equals(DCSTransmitterCongestionEvent.GREEN_LINE)) {
                    dataStackEvent = DataStackEvent.LOW_WATERMARK_REACHED;
                    if (svTc.isEventEnabled()) {
                        Tr.event(svTc, "LOW_WATERMARK_REACHED");
                    }
                } else if (congestionWaterMark.equals(DCSTransmitterCongestionEvent.YELLOW_LINE)) {
                    dataStackEvent = DataStackEvent.MEDIUM_WATERMARK_REACHED;
                    if (svTc.isEventEnabled()) {
                        Tr.event(svTc, "MEDIUM_WATERMARK_REACHED");
                    }
                } else if (congestionWaterMark.equals(DCSTransmitterCongestionEvent.RED_LINE)) {
                    dataStackEvent = DataStackEvent.HIGH_WATERMARK_REACHED;
                    if (svTc.isEventEnabled()) {
                        Tr.event(svTc, "HIGH_WATERMARK_REACHED");
                    }
                } else {
                    throw new DataStackException("Unknown DCSEvent " + congestionWaterMark.getClass().getName());
                }
                if ((dataStackCallback = this.ivCallback) != null) {
                    dataStackCallback.dataStackEvent(dataStackEvent);
                }
            }
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "762", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, dCSExternalEvent};
            Tr.error(svTc, "HMGR0405", objectArray);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "notifyEvent (datastack=" + this.ivDataStackName + ")");
        }
    }

    public void approvePartialNewView(ViewId viewId, String[] stringArray, int n) {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "approvePartialNewView (datastack=" + this.ivDataStackName + ")", new Object[]{viewId, "Number of members in view=" + stringArray.length, String.valueOf(n)});
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            return;
        }
        try {
            dCSDataStack.partialViewApproved(viewId, this.ivDataStackName.hashCode());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "835", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, "partialViewApproved()", throwable};
            Tr.error(svTc, "HMGR0406", objectArray);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "approvePartialNewView (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void requestNewView(GroupMemberId[] groupMemberIdArray) {
        DCSDataStack dCSDataStack;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "requestNewView (datastack=" + this.ivDataStackName + ")", " current ViewID=" + this.ivViewID);
            Tr.entry(svTc, "updated membership", groupMemberIdArray);
        }
        if ((dCSDataStack = this.getDataStackReference()) == null) {
            return;
        }
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            this.ivGMIdHistory.put(groupMemberIdArray[i].getServerName(), groupMemberIdArray[i]);
        }
        this.ivEligibleProcessList = groupMemberIdArray;
        if (this.isDataStackViewLeader()) {
            try {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "This member is datastack leader.  Proceed to requestView() call.");
                }
                if (this.ivDCSStable) {
                    String[] stringArray = HAMUtil.getServerNames(this.ivEligibleProcessList);
                    this.ivLastRequestViewEPL = this.ivEligibleProcessList;
                    dCSDataStack.requestView(stringArray, this.ivDataStackName.hashCode(), this.ivViewID);
                    if (svTc.isDebugEnabled()) {
                        Tr.debug(svTc, "requestView() completed.");
                    }
                } else if (this.ivLastRequestViewEPL == null) {
                    if (svTc.isDebugEnabled()) {
                        Tr.debug(svTc, "View is changing, ivLastRequestViewEPL is null, cannot invoke requestView() at this time");
                    }
                    this.ivLastRequestViewEPL = new GroupMemberId[0];
                } else if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "View is changing, cannot invoke requestView() at this time");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "896", this);
                Object[] objectArray = new Object[]{this.ivDataStackName, "requestView()", throwable};
                Tr.error(svTc, "HMGR0406", objectArray);
            }
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "requestNewView (datastack=" + this.ivDataStackName + ")", this.ivViewID);
        }
    }

    private synchronized DCSDataStack getDataStackReference() {
        DCSDataStack dCSDataStack = this.ivStack;
        if (dCSDataStack == null && svTc.isDebugEnabled()) {
            Tr.debug(svTc, "dataStackAlreadyTerminated");
        }
        return dCSDataStack;
    }

    private void sendSubgroupMessageViaUnicastChannel(DCSDataStack dCSDataStack, String[] stringArray, MsgQoS msgQoS, DCSMessage dCSMessage) throws DCSException, DataStackException {
        QoS.QOSUnicast qOSUnicast = this.getUnicastQoS(msgQoS);
        if (msgQoS == MsgQoS.NORMAL_NOSELF) {
            stringArray = StringUtils.removeElementAndAllDupsFromStringArray(stringArray, this.ivServerName);
        }
        if (stringArray.length == 0) {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "sendSubgroupMessageViaUnicastChannel - target is self", stringArray);
            }
            return;
        }
        if (stringArray.length == 1) {
            String string = stringArray[0];
            dCSDataStack.sendMessage(string, 1, dCSMessage, qOSUnicast);
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "sendSubgroupMessageViaUnicastChannel - single", string);
            }
        } else {
            dCSDataStack.sendMessage(stringArray, 1, dCSMessage, (QoS)qOSUnicast);
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "sendMessageViaUnicastChannel - multiple", stringArray);
            }
        }
    }

    private void sendSubgroupMessageViaMulticastChannel(DCSDataStack dCSDataStack, String[] stringArray, MsgQoS msgQoS, DCSMessage dCSMessage) throws DCSException, DataStackException {
        QoS.QOSMulticast qOSMulticast = this.getMulticastQoS(msgQoS);
        if (qOSMulticast.getGuaranteeType().equals(QoS.VS_CURRENT)) {
            dCSDataStack.sendMessage(stringArray, 1, dCSMessage, qOSMulticast, this.ivViewID);
        } else {
            dCSDataStack.sendMessage(stringArray, 1, dCSMessage, qOSMulticast);
        }
    }

    private String[] removeSelfFromTargets(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        boolean bl = false;
        String[] stringArray2 = new String[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            if (string.equals(this.ivServerName)) {
                bl = true;
                continue;
            }
            stringArray2[n2++] = string;
        }
        if (bl) {
            stringArray2[n - 2] = stringArray[n - 1];
            return stringArray2;
        }
        if (stringArray[n - 1].equals(this.ivServerName)) {
            return stringArray2;
        }
        return stringArray;
    }

    private QoS.QOSMulticast getMulticastQoS(MsgQoS msgQoS) throws DCSException, DataStackException {
        if (msgQoS == MsgQoS.NONE) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL_NOSELF) {
            return QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO, QoS.WITHOUT_SELF_DELIVERY);
        }
        if (msgQoS == MsgQoS.VS_CURRENT) {
            return QoS.getMulticastQoS(QoS.VS_CURRENT, QoS.FIFO);
        }
        throw new DataStackException("Invalid QoS type " + msgQoS + " specified ");
    }

    private QoS.QOSUnicast getUnicastQoS(MsgQoS msgQoS) throws DCSException, DataStackException {
        if (msgQoS == MsgQoS.NONE) {
            return QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL) {
            return QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.NORMAL_NOSELF) {
            return QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        if (msgQoS == MsgQoS.VS_CURRENT) {
            return QoS.getUnicastQoS(QoS.VS_CURRENT, QoS.FIFO);
        }
        throw new DataStackException("Invalid QoS type " + msgQoS + " specified ");
    }

    private boolean isDataStackViewLeader() {
        return this.ivServerName.equalsIgnoreCase(this.ivDataStackMembers[0]);
    }

    private DCSMessage getMessage(DCSDataStack dCSDataStack, byte[] byArray, String string) throws DCSException {
        int n = byArray.length;
        DCSMessage dCSMessage = dCSDataStack.createMessage(n + this.ivLocalMemberBytes.length + 512);
        dCSMessage.writeBytes(this.ivLocalMemberBytes);
        dCSMessage.writeString(string);
        dCSMessage.writeInt(n);
        dCSMessage.writeBytes(byArray);
        return dCSMessage;
    }

    private GroupMemberId[] getHAMMemberList() {
        int n = this.ivDataStackMembers.length;
        ArrayList<GroupMemberId> arrayList = new ArrayList<GroupMemberId>(n);
        for (int i = 0; i < n; ++i) {
            GroupMemberId groupMemberId = (GroupMemberId)this.ivGMIdHistory.get(this.ivDataStackMembers[i]);
            if (groupMemberId == null) {
                int n2 = this.ivDataStackMembers.length;
                int n3 = this.ivEligibleProcessList.length;
                String string = this.ivDataStackMembers[i];
                String string2 = "No GroupMemberId found for server " + string + ", EPL size = " + n3 + ", view size = " + n2;
                Tr.error(svTc, "HMGR0108", new Object[]{"DataStackImpl", "NEW_VIEW_OK", string2});
                return new GroupMemberId[0];
            }
            arrayList.add(groupMemberId);
        }
        GroupMemberId[] groupMemberIdArray = new GroupMemberId[arrayList.size()];
        groupMemberIdArray = arrayList.toArray(groupMemberIdArray);
        return groupMemberIdArray;
    }

    private GroupMemberId[] handleIncompatibleMemberships(DCSDataStack dCSDataStack, int n) {
        this.ivLastRequestViewEPL = new GroupMemberId[]{this.ivLocalMember};
        this.ivViewLeaderPreviousView = true;
        try {
            dCSDataStack.requestView(new String[]{this.ivServerName}, this.ivDataStackName.hashCode(), this.ivViewID);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1232", this);
            Object[] objectArray = new Object[]{"DataStackImpl", "NEW_VIEW_OK - recovery failed", throwable};
            Tr.error(svTc, "HMGR0108", objectArray);
        }
        return this.ivLastRequestViewEPL;
    }

    private void handleStaleEPL(DCSDataStack dCSDataStack) {
        if (!this.isDataStackViewLeader()) {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "handleStaleEPL", "non-leader, nothing to do");
            }
            this.ivLastRequestViewEPL = null;
            this.ivViewLeaderPreviousView = false;
            return;
        }
        try {
            if (!this.ivViewLeaderPreviousView) {
                this.ivLastRequestViewEPL = this.ivEligibleProcessList;
                String[] stringArray = HAMUtil.getServerNames(this.ivEligibleProcessList);
                dCSDataStack.requestView(stringArray, this.ivDataStackName.hashCode(), this.ivViewID);
                this.ivViewLeaderPreviousView = true;
                return;
            }
            this.ivViewLeaderPreviousView = true;
            if (this.ivLastRequestViewEPL == null) {
                return;
            }
            if (HAMUtil.compareGroupMemberIdArrays(this.ivLastRequestViewEPL, this.ivEligibleProcessList)) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "View Leader in previous View. - EPLs match, nothing to do");
                }
                this.ivLastRequestViewEPL = null;
            } else {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "View Leader in previous View. EPL mismatch, do requestView", this.ivEligibleProcessList);
                }
                this.ivLastRequestViewEPL = this.ivEligibleProcessList;
                String[] stringArray = HAMUtil.getServerNames(this.ivEligibleProcessList);
                dCSDataStack.requestView(stringArray, this.ivDataStackName.hashCode(), this.ivViewID);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1273", this);
            Tr.error(svTc, "HMGR0108", new Object[]{svClassName, "handleStaleEPL", throwable});
        }
    }
}

