/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.datastack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.DataStackImpl;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.datastack.SyncDataStack;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.datastack.DataStackClosedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;

public class SingleServerDataStackImpl
implements SyncDataStack {
    private static final TraceComponent svTc = Tr.register(SingleServerDataStackImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = DataStackImpl.class.getName();
    private HAGroupImpl ivHAGroup = null;
    private String ivDataStackName;
    private GroupMemberId ivMemberId;
    private DataStackCallback ivCallback;
    private SyncDataReqCallback ivSyncDataCallback;
    private boolean ivStackClosed = false;

    public SingleServerDataStackImpl(String string, DataStackCallback dataStackCallback, HAGroupImpl hAGroupImpl) throws DataStackException {
        this.ivDataStackName = string;
        this.ivCallback = dataStackCallback;
        this.ivHAGroup = hAGroupImpl;
        try {
            this.ivMemberId = this.ivHAGroup.getMemberName();
        }
        catch (HAGroupLeftException hAGroupLeftException) {
            FFDCFilter.processException((Throwable)hAGroupLeftException, svClassName, "87", this);
            throw new DataStackException("The HAGroup has been left", hAGroupLeftException);
        }
    }

    public SingleServerDataStackImpl(String string, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback, HAGroupImpl hAGroupImpl) throws DataStackException {
        this(string, dataStackCallback, hAGroupImpl);
        this.ivSyncDataCallback = syncDataReqCallback;
    }

    public String getDataStackName() {
        return this.ivDataStackName;
    }

    public synchronized void sendMessage(String string, MsgQoS msgQoS, String string2, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage - P2P (datastack=" + this.ivDataStackName + ")", new Object[]{string, msgQoS, byArray});
        }
        if (this.ivStackClosed) {
            throw new DataStackClosedException("The DataStack has been previously terminated");
        }
        if (string == null) {
            throw new HAParameterRejectedException("A null target is not allowed");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (!string.equals(this.ivMemberId.getServerName())) {
            throw new DataStackMemberException("A target member is not a member of the datastack");
        }
        if (!msgQoS.equals(MsgQoS.NORMAL_NOSELF)) {
            this.returnToSender(byArray);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void sendMessage(String[] stringArray, MsgQoS msgQoS, String string, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage - subgroup (datastack=" + this.ivDataStackName + ")", new Object[]{stringArray, msgQoS, byArray});
        }
        if (this.ivStackClosed) {
            throw new DataStackClosedException("The DataStack has been previously terminated");
        }
        if (stringArray == null) {
            throw new HAParameterRejectedException("A null target is not allowed");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (stringArray.length != 1) {
            throw new DataStackMemberException("A target member is not a member of the datastack");
        }
        if (!stringArray[0].equals(this.ivMemberId.getServerName())) {
            throw new DataStackMemberException("A target member is not a member of the datastack");
        }
        if (!msgQoS.equals(MsgQoS.NORMAL_NOSELF)) {
            this.returnToSender(byArray);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")");
        }
    }

    public synchronized void sendMessage(MsgQoS msgQoS, String string, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")", new Object[]{msgQoS, byArray});
        }
        if (this.ivStackClosed) {
            throw new DataStackClosedException("The DataStack has been previously terminated");
        }
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (!msgQoS.equals(MsgQoS.NORMAL_NOSELF)) {
            this.returnToSender(byArray);
        }
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "sendMessage (datastack=" + this.ivDataStackName + ")");
        }
    }

    public void terminateDataStack() {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "terminateDataStack (datastack=" + this.ivDataStackName + ")");
        }
        this.ivStackClosed = true;
        this.ivCallback.dataStackTerminated();
        this.ivCallback = null;
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "terminateDataStack (datastack=" + this.ivDataStackName + ")");
        }
    }

    public byte[] requestData(byte[] byArray, long l) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "requestData - multi (datastack=" + this.ivDataStackName + ")", new Object[]{byArray, String.valueOf(l)});
        }
        if (this.ivStackClosed) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null request message is not allowed");
        }
        if (l < 0L) {
            throw new HAParameterRejectedException("A negative timeout value is not allowed");
        }
        byte[] byArray2 = this.getData(byArray, l);
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "requestData (datastack=" + this.ivDataStackName + ")", String.valueOf(byArray2));
        }
        return byArray2;
    }

    public byte[] requestData(GroupMemberId groupMemberId, byte[] byArray, long l) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "requestData - single (datastack=" + this.ivDataStackName + ")", new Object[]{groupMemberId, byArray, String.valueOf(l)});
        }
        if (this.ivStackClosed) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("A null target is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null request message is not allowed");
        }
        if (l < 0L) {
            throw new HAParameterRejectedException("A negative timeout value is not allowed");
        }
        if (!groupMemberId.equals(this.ivMemberId)) {
            throw new DataStackMemberException("The target member is not a member of the datastack");
        }
        byte[] byArray2 = this.getData(byArray, l);
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "hasData (datastack=" + this.ivDataStackName + ")", String.valueOf(byArray2));
        }
        return byArray2;
    }

    private void returnToSender(byte[] byArray) {
        this.ivCallback.dataStackMessageReceived(this.ivMemberId, this.ivDataStackName, byArray);
    }

    private byte[] getData(byte[] byArray, long l) throws DataStackException {
        Object object = new Object();
        SyncStackDataThread syncStackDataThread = new SyncStackDataThread(byArray, object);
        Object object2 = object;
        synchronized (object2) {
            try {
                syncStackDataThread.start();
                object.wait(l);
                return syncStackDataThread.getResponse();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "273", this);
                Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
                Tr.error(svTc, "HMGR0407", objectArray);
                throw new DataStackException("Synchronous data request (single member) exception", throwable);
            }
        }
    }

    private class SyncStackDataThread
    extends Thread {
        private byte[] ivRequest;
        private byte[] ivResponse;
        Object ivWaitNotify;

        SyncStackDataThread(byte[] byArray, Object object) {
            this.ivRequest = byArray;
            this.ivWaitNotify = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.ivWaitNotify;
            synchronized (object) {
                this.ivResponse = SingleServerDataStackImpl.this.ivSyncDataCallback.getData(SingleServerDataStackImpl.this, this.ivRequest);
                this.ivWaitNotify.notifyAll();
            }
        }

        byte[] getResponse() {
            return this.ivResponse;
        }
    }
}

