/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.datastack;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.DCS;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.drsmodule.DRSDataStack;
import com.ibm.ws.dcs.drsmodule.DataRequestListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.DataStackImpl;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.datastack.SyncDataStack;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.datastack.DataStackClosedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.util.Map;

public class SyncDataStackImpl
extends DataStackImpl
implements SyncDataStack,
DataRequestListener {
    private static TraceComponent svTc = Tr.register(SyncDataStackImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = SyncDataStackImpl.class.getName();
    private DRSDataStack ivStack;
    private SyncDataReqCallback ivSyncDataCallback;

    public SyncDataStackImpl(DCS dCS, DCSPlugin dCSPlugin, String string, String string2, boolean bl, HAGroupImpl hAGroupImpl, CoreStackInfoImpl coreStackInfoImpl, Map map, String[] stringArray, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback) throws DataStackException {
        super(dCS, dCSPlugin, string, string2, bl, hAGroupImpl, coreStackInfoImpl, map, stringArray, dataStackCallback);
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "SyncDataStackImpl", string);
        }
        this.ivStack = (DRSDataStack)((DataStackImpl)this).ivStack;
        this.ivSyncDataCallback = syncDataReqCallback;
        this.ivStack.setDataRequestListener(this);
        if (svTc.isEntryEnabled()) {
            Tr.exit(svTc, "SyncDataStackImpl", string);
        }
    }

    public byte[] requestData(byte[] byArray, long l) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "requestData - multi (datastack=" + this.ivDataStackName + ")", new Object[]{byArray, String.valueOf(l)});
        }
        if (((DataStackImpl)this).ivStack == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null request message is not allowed");
        }
        if (l < 0L) {
            throw new HAParameterRejectedException("A negative timeout value is not allowed");
        }
        try {
            byte[] byArray2;
            GroupMemberId groupMemberId;
            DCSMessage dCSMessage = this.ivStack.createMessage();
            dCSMessage.writeInt(byArray.length);
            dCSMessage.writeBytes(byArray);
            DCSMessage dCSMessage2 = this.ivStack.createMessage();
            dCSMessage2 = this.ivStack.dataRequest(dCSMessage, l);
            if (dCSMessage2 == null) {
                groupMemberId = null;
                byArray2 = null;
            } else {
                groupMemberId = (GroupMemberId)dCSMessage2.readObject();
                int n = dCSMessage2.readInt();
                byArray2 = new byte[n];
                dCSMessage2.readBytes(byArray2);
            }
            if (svTc.isEntryEnabled()) {
                String string = groupMemberId == null ? "null" : groupMemberId.getServerName();
                String string2 = byArray2 == null ? "null" : String.valueOf(byArray2.length);
                Tr.exit(svTc, "requestData - multi (datastack=" + this.ivDataStackName + "): source=" + string + ", data length=" + string2);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "131", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
            Tr.error(svTc, "HMGR0407", objectArray);
            throw new DataStackException("Synchronous data request (all members) exception", throwable);
        }
    }

    public byte[] requestData(GroupMemberId groupMemberId, byte[] byArray, long l) throws DataStackException, HAParameterRejectedException {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "requestData - single (datastack=" + this.ivDataStackName + ")", new Object[]{groupMemberId, byArray, String.valueOf(l)});
        }
        if (((DataStackImpl)this).ivStack == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("A null target is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null request message is not allowed");
        }
        if (l < 0L) {
            throw new HAParameterRejectedException("A negative timeout value is not allowed");
        }
        try {
            byte[] byArray2;
            GroupMemberId groupMemberId2;
            DCSMessage dCSMessage = this.ivStack.createMessage();
            dCSMessage.writeInt(byArray.length);
            dCSMessage.writeBytes(byArray);
            DCSMessage dCSMessage2 = this.ivStack.createMessage();
            dCSMessage2 = this.ivStack.dataRequest(groupMemberId.getServerName(), dCSMessage, l);
            if (dCSMessage2 == null) {
                groupMemberId2 = null;
                byArray2 = null;
            } else {
                groupMemberId2 = (GroupMemberId)dCSMessage2.readObject();
                int n = dCSMessage2.readInt();
                byArray2 = new byte[n];
                dCSMessage2.readBytes(byArray2);
            }
            if (svTc.isEntryEnabled()) {
                String string = groupMemberId2 == null ? "null" : groupMemberId2.getServerName();
                String string2 = byArray2 == null ? "null" : String.valueOf(byArray2.length);
                Tr.exit(svTc, "requestData - single (datastack=" + this.ivDataStackName + "): source=" + string + ", data length=" + string2);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "193", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, throwable};
            Tr.error(svTc, "HMGR0407", objectArray);
            throw new DataStackException("Synchronous data request (single member) exception", throwable);
        }
    }

    public boolean hasData(DCSMessage dCSMessage) {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "hasData (datastack=" + this.ivDataStackName + ")", dCSMessage);
        }
        try {
            int n = dCSMessage.readInt();
            byte[] byArray = new byte[n];
            dCSMessage.readBytes(byArray);
            try {
                boolean bl = this.ivSyncDataCallback.hasData(this, byArray);
                if (svTc.isEntryEnabled()) {
                    Tr.exit(svTc, "hasData (datastack=" + this.ivDataStackName + ")", String.valueOf(bl));
                }
                return bl;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "226", this);
                Object[] objectArray = new Object[]{this.ivDataStackName, "hasData()", throwable};
                Tr.error(svTc, "HMGR0403", objectArray);
                return false;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "234", this);
            Object[] objectArray = new Object[]{this.ivDataStackName, "hasData()", throwable};
            Tr.error(svTc, "HMGR0408", objectArray);
            return false;
        }
    }

    public DCSMessage getData(DCSMessage dCSMessage) {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "getData (datastack=" + this.ivDataStackName + ")", dCSMessage);
        }
        DCSMessage dCSMessage2 = null;
        int n = dCSMessage.readInt();
        Object[] objectArray = new byte[n];
        dCSMessage.readBytes((byte[])objectArray);
        try {
            byte[] byArray = this.ivSyncDataCallback.getData(this, (byte[])objectArray);
            if (byArray != null) {
                try {
                    dCSMessage2 = this.ivStack.createMessage();
                    dCSMessage2.writeObject(this.ivHAGroup.getMemberName());
                    dCSMessage2.writeInt(byArray.length);
                    dCSMessage2.writeBytes(byArray);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, svClassName, "275", this);
                    Object[] objectArray2 = new Object[]{this.ivDataStackName, "getData()", throwable};
                    Tr.error(svTc, "HMGR0408", objectArray2);
                    if (svTc.isEntryEnabled()) {
                        Tr.exit(svTc, "getData (datastack=" + this.ivDataStackName + ")", dCSMessage2);
                    }
                    return dCSMessage2;
                }
            }
            if (svTc.isEntryEnabled()) {
                Tr.exit(svTc, "getData (datastack=" + this.ivDataStackName + ")", dCSMessage2);
            }
            return dCSMessage2;
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException(throwable, svClassName, "293", this);
                Object[] objectArray3 = new Object[]{this.ivDataStackName, "getData()", throwable};
                Tr.error(svTc, "HMGR0403", objectArray3);
                if (svTc.isEntryEnabled()) {
                    Tr.exit(svTc, "getData (datastack=" + this.ivDataStackName + ")", dCSMessage2);
                }
                return dCSMessage2;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, svClassName, "304", this);
                objectArray = new Object[]{this.ivDataStackName, "getData()", throwable2};
                Tr.error(svTc, "HMGR0408", objectArray);
                if (svTc.isEntryEnabled()) {
                    Tr.exit(svTc, "getData (datastack=" + this.ivDataStackName + ")", dCSMessage2);
                }
                return dCSMessage2;
            }
        }
    }
}

