/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.impl.GroupMemberIdImpl;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupLocalMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.DataStackImpl;
import com.ibm.ws.hamanager.datastack.SingleServerDataStackImpl;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.datastack.SyncDataStack;
import com.ibm.ws.hamanager.impl.HAManagerImpl;
import com.ibm.ws.hamanager.impl.MemberDataImpl;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.datastack.DataStackAlreadyCreatedException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.Arrays;

public class HAGroupImpl
implements HAGroup,
AsynchOperationComplete {
    private static final TraceComponent TC = Tr.register(HAGroupImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "com.ibm.ws.hamanager.impl.LocalGroupMembers";
    static final int svMayActivate = 0;
    static final int svMayActivateCancelled = 1;
    static final int svActivate = 2;
    static final int svDeactivate = 3;
    static final int svOnMessage = 4;
    static final int svMembershipChanged = 5;
    static final int svIsAlive = 6;
    private HAManagerImpl ivHaManager;
    private GroupName ivGroupName;
    private GroupMemberIdImpl ivGmid;
    private MemberDataImpl ivMember;
    private HAGroupCallback ivAppCallback;
    private long ivStartTime;
    private GroupMemberState ivNextState;
    private GroupMemberState ivFinalState;
    private HAPolicyRule ivPolicyRule;
    private GroupMemberId[] ivMembers = null;
    private boolean ivIsAlivePingSent;
    private DataStack ivDataStack = null;
    private boolean ivInitialMembershipChange = true;
    private boolean ivUserDisabled = false;
    static /* synthetic */ Class class$com$ibm$ws$hamanager$impl$HAGroupImpl$HAGroupUserCallback;

    public HAGroupImpl(HAManagerImpl hAManagerImpl, GroupName groupName, HAPolicyRule hAPolicyRule, MemberDataImpl memberDataImpl, HAGroupCallback hAGroupCallback) {
        this.ivMember = memberDataImpl;
        this.ivGmid = (GroupMemberIdImpl)this.ivMember.getMemberId();
        this.ivAppCallback = hAGroupCallback;
        this.ivHaManager = hAManagerImpl;
        this.ivGroupName = groupName;
        this.ivMembers = new GroupMemberId[]{this.ivGmid};
        this.ivPolicyRule = hAPolicyRule;
        this.ivStartTime = System.currentTimeMillis();
        this.ivIsAlivePingSent = false;
    }

    public void deleteDataStack() {
        this.ivDataStack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(Object object, Object object2) throws HAParameterRejectedException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "success()", new Object[]{object, object2});
        }
        try {
            Object object3 = this;
            synchronized (object3) {
                if (this.ivMember == null) {
                    Tr.info(TC, "HMGR0126", new Object[]{"success", this.ivGroupName});
                    return;
                }
                if (object == null || object != this) {
                    Object[] objectArray = new Object[]{"success", this.ivGroupName, object, this};
                    Tr.error(TC, "HMGR0128", objectArray);
                    throw new HAParameterRejectedException("Callback context is null");
                }
                GroupMemberState groupMemberState = this.ivMember.getState();
                if (!this.isMemberDisabled(groupMemberState)) {
                    this.ivMember.setState(this.ivNextState);
                }
            }
            if (this.ivNextState.equals(this.ivFinalState)) {
                this.ivHaManager.localGroupStateChanged(this);
            } else if (this.ivNextState.equals(GroupMemberState.ACTIVATED)) {
                this.ivNextState = GroupMemberState.IDLE;
                this.ivMember.setState(GroupMemberState.DEACTIVATING);
                object3 = new HAGroupUserCallback(3);
                UserCallbacks.executeCallback((UserCallback)object3);
            } else {
                this.ivMember.setState(this.ivFinalState);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "161", this);
            Tr.error(TC, "HMGR0109", new Object[]{svClassName, "success", throwable});
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "success()");
        }
    }

    public void failed(Object object, String string, Object object2) throws HAParameterRejectedException {
        Tr.info(TC, "HMGR0124", new Object[]{this.ivGroupName, string, object2});
        this.failed0(object, string);
    }

    public void failed(Object object, String string, Throwable throwable, Object object2) throws HAParameterRejectedException {
        Tr.info(TC, "HMGR0125", new Object[]{this.ivGroupName, string, object2, throwable});
        this.failed0(object, string);
    }

    private void failed0(Object object, String string) throws HAParameterRejectedException {
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"failed", this.ivGroupName});
            return;
        }
        if (object == null || object != this) {
            Object[] objectArray = new Object[]{"failure", this.ivGroupName, object, this};
            Tr.error(TC, "HMGR0128", objectArray);
            throw new HAParameterRejectedException("Callback context is incorrect");
        }
        if (this.isMemberDisabled(this.ivMember.getState())) {
            return;
        }
        try {
            this.disableMember("disable called internally, the reason is " + string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "218", this);
            Tr.error(TC, "HMGR0109", new Object[]{svClassName, "failed", throwable});
        }
    }

    public GroupName getGroupName() {
        return this.ivGroupName;
    }

    public GroupMemberId getMemberName() throws HAGroupLeftException {
        this.check();
        return this.ivGmid;
    }

    public synchronized GroupMemberState getMemberState() {
        if (this.ivMember == null) {
            return GroupMemberState.LEFT;
        }
        return this.ivMember.getState();
    }

    public String getVersionString() throws HAGroupLeftException {
        this.check();
        return this.ivGmid.getVersionString();
    }

    public void setVersionString(String string) throws HAGroupLeftException, HAParameterRejectedException {
        this.check();
        if (string == null) {
            throw new HAParameterRejectedException("Version cannot be null");
        }
        this.ivGmid.setVersionString(string);
        this.ivHaManager.localGroupStateChanged(this);
    }

    public void leave() throws HAGroupLeftException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "leave", this);
        }
        if (this.ivDataStack != null) {
            throw new HAInternalStateException("DataStack still exists.  DataStack must be terminated before leaving the group.");
        }
        this.check();
        this.ivHaManager.localGroupMembershipChanged(this, true);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableMember() throws HAGroupLeftException, HAIllegalRequestException {
        HAGroupImpl hAGroupImpl = this;
        synchronized (hAGroupImpl) {
            this.check();
            GroupMemberState groupMemberState = this.ivMember.getState();
            if (!groupMemberState.equals(GroupMemberState.DISABLED)) {
                throw new HAIllegalRequestException("The member is not disabled");
            }
            this.ivMember.setState(GroupMemberState.IDLE);
            this.ivUserDisabled = false;
        }
        this.ivHaManager.localGroupStateChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMember(String string) throws HAGroupLeftException, HAIllegalRequestException {
        Tr.info(TC, "HMGR0129", new Object[]{this.ivGroupName, string});
        HAGroupImpl hAGroupImpl = this;
        synchronized (hAGroupImpl) {
            this.check();
            GroupMemberState groupMemberState = this.ivMember.getState();
            if (this.isMemberDisabled(groupMemberState)) {
                throw new HAIllegalRequestException("The member is already disabled");
            }
            this.ivUserDisabled = true;
            if (this.ivFinalState != null && this.ivFinalState.equals(GroupMemberState.GROUP_DISABLED)) {
                this.ivNextState = GroupMemberState.GROUP_DISABLED;
                this.ivMember.setState(GroupMemberState.GROUP_DISABLED);
            } else {
                this.ivNextState = GroupMemberState.DISABLED;
                this.ivFinalState = GroupMemberState.DISABLED;
                this.ivMember.setState(GroupMemberState.DISABLED);
            }
        }
        this.ivHaManager.localGroupStateChanged(this);
    }

    public DataStack createDataStack(String string, boolean bl, DataStackCallback dataStackCallback) throws HAException {
        return this.createDataStack(string, bl, dataStackCallback, null);
    }

    public SyncDataStack createSyncDataStack(String string, boolean bl, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback) throws HAException {
        if (syncDataReqCallback == null) {
            throw new HAParameterRejectedException("A null SyncDataReqCallback is not allowed.");
        }
        return (SyncDataStack)this.createDataStack(string, bl, dataStackCallback, syncDataReqCallback);
    }

    private synchronized DataStack createDataStack(String string, boolean bl, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback) throws HAException {
        if (this.ivDataStack != null) {
            throw new DataStackAlreadyCreatedException("Data stack = " + this.ivDataStack.getDataStackName() + " is already associated with group " + this.ivGroupName);
        }
        if (string == null) {
            throw new HAParameterRejectedException("A null data stack name is not allowed.");
        }
        if (dataStackCallback == null) {
            throw new HAParameterRejectedException("A null DataStackCallback is not allowed.");
        }
        String[] stringArray = this.getCurrentMemberServers();
        this.ivDataStack = this.ivHaManager.getCoordinator().createDataStack(string, bl, this, dataStackCallback, syncDataReqCallback, stringArray);
        return this.ivDataStack;
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId groupMemberId, byte[] byArray) throws HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null MsgQoS is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("a null destination array is not allowed.");
        }
        this.check();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendMessagePTP - destination: " + groupMemberId + ", qos: " + msgQoS + ", message size = " + byArray.length);
        }
        if (msgQoS == MsgQoS.NORMAL_NOSELF && groupMemberId.getServerName().equals(this.ivGmid.getServerName())) {
            return;
        }
        String[] stringArray = new String[]{groupMemberId.getServerName()};
        GroupMemberId groupMemberId2 = this.ivMember.getMemberId();
        GroupLocalMessage groupLocalMessage = new GroupLocalMessage(this.ivGroupName, groupMemberId2, byArray);
        this.ivHaManager.getCoordinator().sendGroupMessage(msgQoS, stringArray, groupLocalMessage);
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId[] groupMemberIdArray, byte[] byArray) throws HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null MsgQoS is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (groupMemberIdArray == null) {
            throw new HAParameterRejectedException("a null destination array is not allowed.");
        }
        this.check();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendMessageSubgroup - destinations: " + Arrays.toString(groupMemberIdArray) + ", qos: " + msgQoS + ", message size = " + byArray.length);
        }
        String[] stringArray = HAMUtil.getServerNames(groupMemberIdArray);
        if (msgQoS == MsgQoS.NORMAL_NOSELF && (stringArray = StringUtils.removeElementAndAllDupsFromStringArray(stringArray, this.ivGmid.getServerName())).length == 0) {
            return;
        }
        GroupMemberId groupMemberId = this.ivMember.getMemberId();
        GroupLocalMessage groupLocalMessage = new GroupLocalMessage(this.ivGroupName, groupMemberId, byArray);
        this.ivHaManager.getCoordinator().sendGroupMessage(msgQoS, stringArray, groupLocalMessage);
    }

    public void sendMessage(MsgQoS msgQoS, byte[] byArray) throws HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null MsgQoS is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        this.check();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendMessageGroup: " + msgQoS + ", message size = " + byArray.length);
        }
        String[] stringArray = this.getCurrentMemberServers();
        if (msgQoS == MsgQoS.NORMAL_NOSELF && (stringArray = StringUtils.removeElementAndAllDupsFromStringArray(stringArray, this.ivGmid.getServerName())).length == 0) {
            return;
        }
        GroupMemberId groupMemberId = this.ivMember.getMemberId();
        GroupLocalMessage groupLocalMessage = new GroupLocalMessage(this.ivGroupName, groupMemberId, byArray);
        this.ivHaManager.getCoordinator().sendGroupMessage(msgQoS, stringArray, groupLocalMessage);
    }

    public boolean isHardwareQuorumEnforced() throws NoPolicyDefinedForGroupException, DuplicatePoliciesMatchGroupException, HAInternalStateException, IllegalStateException {
        if (!this.ivGroupName.getGroupProperties().containsKey("IBM_hc")) {
            throw new IllegalStateException("HAGroup doesn't have a WAS_CLUSTER key");
        }
        return this.ivHaManager.isHardwareQuorumEnforced(this.ivGroupName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("< ivMember  ==> ");
        stringBuffer.append(this.ivMember);
        stringBuffer.append("> ");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doActivateMember() {
        try {
            HAGroupImpl hAGroupImpl = this;
            synchronized (hAGroupImpl) {
                if (this.ivMember == null) {
                    Tr.info(TC, "HMGR0126", new Object[]{"doActivateMember", this.ivGroupName});
                    return;
                }
                if (this.ivUserDisabled) {
                    Tr.info(TC, "HMGR0127", this.ivGroupName);
                    return;
                }
                if (!this.ivNextState.equals(GroupMemberState.ACTIVATED)) {
                    Tr.error(TC, "HMGR0105", new Object[]{this.ivGroupName, this.ivGmid, this.ivNextState, new Exception("stack trace")});
                    return;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "activateMember", new Object[]{this.ivGroupName, this.ivMember, this.ivNextState});
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doCallback - " + this.ivAppCallback.getClass().getCanonicalName() + ".memberIsActivated()");
            }
            this.ivAppCallback.memberIsActivated(this.ivGroupName, this, this);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "439", this);
            Tr.error(TC, "HMGR0107", new Object[]{this.ivGroupName, throwable});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDeactivateMember() {
        try {
            HAGroupImpl hAGroupImpl = this;
            synchronized (hAGroupImpl) {
                if (this.ivMember == null) {
                    Tr.info(TC, "HMGR0126", new Object[]{"doDeactivateMember", this.ivGroupName});
                    return;
                }
                if (this.ivUserDisabled) {
                    Tr.info(TC, "HMGR0127", this.ivGroupName);
                    return;
                }
                if (!this.ivNextState.equals(GroupMemberState.IDLE)) {
                    Tr.error(TC, "HMGR0105", new Object[]{this.ivGroupName, this.ivGmid, this.ivNextState, new Exception("stack trace")});
                    return;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "deactivateMember", new Object[]{this.ivGroupName, this.ivGmid, this.ivNextState});
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doCallback - " + this.ivAppCallback.getClass().getCanonicalName() + ".memberDeactivated()");
            }
            this.ivAppCallback.memberDeactivate(this.ivGroupName, this, this);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "479", this);
            Tr.error(TC, "HMGR0107", new Object[]{this.ivGroupName, throwable});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOnMessage(GroupMemberId groupMemberId, byte[] byArray) {
        try {
            HAGroupImpl hAGroupImpl = this;
            synchronized (hAGroupImpl) {
                if (this.ivMember == null) {
                    Tr.info(TC, "HMGR0126", new Object[]{"doOnMessage", this.ivGroupName});
                    return;
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doCallback - " + this.ivAppCallback.getClass().getCanonicalName() + ".onMessage()");
            }
            this.ivAppCallback.onMessage(groupMemberId, byArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "479", this);
            Tr.error(TC, "HMGR0107", new Object[]{this.ivGroupName, throwable});
            return;
        }
    }

    void doMembershipChanged(GroupMemberId[] groupMemberIdArray) {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doCallback - " + this.ivAppCallback.getClass().getName() + ".membershipChanged()");
            }
            this.ivAppCallback.membershipChanged(this.ivGroupName, groupMemberIdArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "541", this);
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "doMembershipChanged", throwable});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIsAlive() {
        if (this.ivIsAlivePingSent) {
            Tr.info(TC, "HMGR0131", this.ivGroupName);
            this.ivHaManager.getCoordinator().getJVMController().panicJVM("isAlive thread hung");
        }
        try {
            HAGroupImpl hAGroupImpl = this;
            synchronized (hAGroupImpl) {
                if (this.ivMember == null) {
                    Tr.info(TC, "HMGR0126", new Object[]{"doIsAlive", this.ivGroupName});
                    return;
                }
                GroupMemberState groupMemberState = this.ivMember.getState();
                if (groupMemberState.equals(GroupMemberState.DISABLED) || groupMemberState.equals(GroupMemberState.IDLE)) {
                    return;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doIsAlive", new Object[]{this.ivGroupName, groupMemberState});
                }
            }
            try {
                this.ivIsAlivePingSent = true;
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doCallback - " + this.ivAppCallback.getClass().getCanonicalName() + ".isAlive()");
                }
                boolean bl = this.ivAppCallback.isAlive(this.ivGroupName);
                this.ivIsAlivePingSent = false;
                if (!bl) {
                    Tr.info(TC, "HMGR0130", this.ivGroupName);
                    this.ivHaManager.getCoordinator().getJVMController().panicJVM("component requested panic from isAlive");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "659", this);
                Tr.info(TC, "HMGR0132", new Object[]{this.ivGroupName, throwable});
                this.ivHaManager.getCoordinator().getJVMController().panicJVM("isAlive threw exception");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "439", this);
            Tr.error(TC, "HMGR0107", new Object[]{this.ivGroupName, throwable});
            return;
        }
    }

    synchronized void doLeave() {
        this.ivMember = null;
    }

    synchronized void activate() {
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"activateMember", this.ivGroupName});
            return;
        }
        if (this.ivUserDisabled) {
            Tr.info(TC, "HMGR0127", this.ivGroupName);
            return;
        }
        GroupMemberState groupMemberState = this.ivMember.getState();
        if (!groupMemberState.equals(GroupMemberState.IDLE)) {
            Tr.error(TC, "HMGR0105", new Object[]{this.ivGroupName, this.ivGmid, groupMemberState, new Exception("stack trace")});
            return;
        }
        this.ivNextState = GroupMemberState.ACTIVATED;
        this.ivFinalState = GroupMemberState.ACTIVATED;
        this.ivMember.setState(GroupMemberState.ACTIVATING);
        HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(2);
        UserCallbacks.executeCallback(hAGroupUserCallback);
    }

    synchronized void deactivate() {
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"deactivateMember", this.ivGroupName});
            return;
        }
        if (this.ivUserDisabled) {
            Tr.info(TC, "HMGR0127", this.ivGroupName);
            return;
        }
        GroupMemberState groupMemberState = this.ivMember.getState();
        if (!groupMemberState.equals(GroupMemberState.ACTIVATED)) {
            Tr.error(TC, "HMGR0105", new Object[]{this.ivGroupName, this.ivGmid, groupMemberState, new Exception("stack trace")});
            return;
        }
        this.ivNextState = GroupMemberState.IDLE;
        this.ivFinalState = GroupMemberState.IDLE;
        this.ivMember.setState(GroupMemberState.DEACTIVATING);
        HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(3);
        UserCallbacks.executeCallback(hAGroupUserCallback);
    }

    synchronized void adminEnable() {
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"adminDisable", this.ivGroupName});
            return;
        }
        GroupMemberState groupMemberState = this.ivMember.getState();
        if (this.isMemberDisabled(groupMemberState)) {
            this.ivUserDisabled = false;
            this.ivMember.setState(GroupMemberState.IDLE);
        } else {
            Object[] objectArray = new Object[]{this.ivGroupName, groupMemberState};
            Tr.error(TC, "HMGR0159", objectArray);
        }
    }

    synchronized void adminDisable(GroupMemberState groupMemberState) {
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"adminDisable", this.ivGroupName});
            return;
        }
        if (this.ivUserDisabled) {
            this.ivMember.setState(groupMemberState);
            Tr.info(TC, "HMGR0127", this.ivGroupName);
            return;
        }
        GroupMemberState groupMemberState2 = this.ivMember.getState();
        if (groupMemberState2.equals(GroupMemberState.IDLE)) {
            this.ivMember.setState(groupMemberState);
            return;
        }
        if (groupMemberState2.equals(GroupMemberState.ACTIVATING) || groupMemberState2.equals(GroupMemberState.DEACTIVATING)) {
            this.ivFinalState = groupMemberState;
            return;
        }
        this.ivNextState = GroupMemberState.IDLE;
        this.ivFinalState = groupMemberState;
        this.ivMember.setState(groupMemberState);
        HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(3);
        UserCallbacks.executeCallback(hAGroupUserCallback);
    }

    synchronized void membershipChanged(GroupMemberId[] groupMemberIdArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "membershipChanged()", groupMemberIdArray);
        }
        if (this.ivMember == null) {
            Tr.info(TC, "HMGR0126", new Object[]{"doMembershipChanged", this.ivGroupName});
            return;
        }
        GroupMemberId[] groupMemberIdArray2 = this.ivMembers;
        this.ivMembers = groupMemberIdArray;
        if (this.ivInitialMembershipChange) {
            this.ivInitialMembershipChange = false;
        } else {
            boolean bl = HAMUtil.compareGroupMemberIdArrays(groupMemberIdArray2, this.ivMembers);
            if (bl) {
                return;
            }
        }
        if (this.ivDataStack != null) {
            if (!(this.ivDataStack instanceof SingleServerDataStackImpl)) {
                ((DataStackImpl)this.ivDataStack).requestNewView(this.ivMembers);
            }
        } else {
            HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(groupMemberIdArray);
            UserCallbacks.executeCallback(hAGroupUserCallback);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "membershipChanged()");
        }
    }

    synchronized void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(groupMemberId, byArray);
        UserCallbacks.executeCallback(hAGroupUserCallback);
    }

    synchronized void isAlive() {
        HAGroupUserCallback hAGroupUserCallback = new HAGroupUserCallback(6);
        UserCallbacks.executeCallback(hAGroupUserCallback);
    }

    int getIsAliveTime() {
        if (this.ivPolicyRule == null) {
            return -1;
        }
        return this.ivPolicyRule.getIsAlivePeriodSec();
    }

    long getStartTime() {
        return this.ivStartTime;
    }

    GroupMemberId getGroupMemberId() {
        return this.ivGmid;
    }

    boolean isAlivePending() {
        return this.ivIsAlivePingSent;
    }

    synchronized boolean isQuorumSensitiveWithActiveMember() {
        if (this.ivMember == null) {
            return false;
        }
        if (this.ivPolicyRule == null) {
            return false;
        }
        if (!this.ivPolicyRule.isQuorumNeeded()) {
            return false;
        }
        GroupMemberState groupMemberState = this.ivMember.getState();
        return groupMemberState.equals(GroupMemberState.ACTIVATING) || groupMemberState.equals(GroupMemberState.ACTIVATED) || groupMemberState.equals(GroupMemberState.DEACTIVATING);
    }

    synchronized GroupState getGroupState() {
        return new GroupState(this.ivStartTime, this.ivMember);
    }

    synchronized void updatePolicy(HAPolicyRule hAPolicyRule) {
        this.ivPolicyRule = hAPolicyRule;
    }

    public synchronized GroupMemberId[] getCurrentMembers() {
        return this.ivMembers;
    }

    synchronized String[] getCurrentMemberServers() throws HAInternalStateException {
        try {
            String[] stringArray = HAMUtil.getServerNames(this.ivMembers);
            return stringArray;
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException((Throwable)hAParameterRejectedException, svClassName, "1181", this);
            HAInternalStateException hAInternalStateException = new HAInternalStateException("HAGroup - ivMembers is null or contains null entries.");
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "getCurrentMemberServers", hAInternalStateException});
            throw hAInternalStateException;
        }
    }

    synchronized void shutdown() {
        if (this.ivDataStack != null) {
            this.ivDataStack.terminateDataStack();
        }
    }

    private boolean isMemberDisabled(GroupMemberState groupMemberState) {
        if (groupMemberState.equals(GroupMemberState.DISABLED)) {
            return true;
        }
        return groupMemberState.equals(GroupMemberState.GROUP_DISABLED);
    }

    private void check() throws HAGroupLeftException {
        if (this.ivMember == null) {
            throw new HAGroupLeftException("Method called on an HAGroup that has already been left");
        }
    }

    private class HAGroupUserCallback
    implements UserCallback {
        private HAGroupImpl ivGroup;
        private int ivOperation;
        private GroupMemberId ivSender;
        private byte[] ivMessage;
        private GroupMemberId[] ivCallbackMembers;
        private String ivUserCallbackName;

        HAGroupUserCallback(int n) {
            this.ivGroup = HAGroupImpl.this;
            this.ivOperation = n;
            this.ivUserCallbackName = HAGroupImpl.this.ivAppCallback.getClass().getName();
        }

        HAGroupUserCallback(GroupMemberId groupMemberId, byte[] byArray) {
            this.ivGroup = HAGroupImpl.this;
            this.ivOperation = 4;
            this.ivMessage = byArray;
            this.ivSender = groupMemberId;
            this.ivUserCallbackName = HAGroupImpl.this.ivAppCallback.getClass().getName();
        }

        HAGroupUserCallback(GroupMemberId[] groupMemberIdArray) {
            this.ivGroup = HAGroupImpl.this;
            this.ivOperation = 5;
            this.ivCallbackMembers = groupMemberIdArray;
            this.ivUserCallbackName = HAGroupImpl.this.ivAppCallback.getClass().getName();
        }

        public String toString() {
            return "HAGroupCallback: " + this.ivGroup.getGroupName().toString();
        }

        public void doCallback() {
            switch (this.ivOperation) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.ivGroup.doActivateMember();
                    break;
                }
                case 3: {
                    this.ivGroup.doDeactivateMember();
                    break;
                }
                case 4: {
                    this.ivGroup.doOnMessage(this.ivSender, this.ivMessage);
                    break;
                }
                case 5: {
                    this.ivGroup.doMembershipChanged(this.ivCallbackMembers);
                    break;
                }
                case 6: {
                    this.ivGroup.doIsAlive();
                    break;
                }
                default: {
                    HAInternalStateException hAInternalStateException = new HAInternalStateException("HAGroupUserCallback.doCallback() - unknown operation = " + this.ivOperation);
                    FFDCFilter.processException((Throwable)hAInternalStateException, (class$com$ibm$ws$hamanager$impl$HAGroupImpl$HAGroupUserCallback == null ? (class$com$ibm$ws$hamanager$impl$HAGroupImpl$HAGroupUserCallback = HAGroupImpl.class$("com.ibm.ws.hamanager.impl.HAGroupImpl$HAGroupUserCallback")) : class$com$ibm$ws$hamanager$impl$HAGroupImpl$HAGroupUserCallback).getName(), "1264", this);
                    Tr.error(TC, "HMGR0143", hAInternalStateException);
                }
            }
        }

        public int getQueue(int n) {
            int n2 = Math.abs(this.ivGroup.hashCode());
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n2 % n;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getQueue() - HAGroup hashcode=" + n2 + ", number of queues=" + n + ", hc % numberOfQueues=" + n3);
            }
            return n3;
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }
    }
}

