/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.HAManager;
import com.ibm.ws.hamanager.coordinator.Coordinator;
import com.ibm.ws.hamanager.coordinator.HAManagerCoordinatorCallback;
import com.ibm.ws.hamanager.coordinator.HAPolicyManager;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.impl.GroupMemberIdImpl;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupLocalMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupMemberActivationCmdMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupState;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportClusterProcessStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.ws.hamanager.impl.MemberDataImpl;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupMemberAlreadyExistsException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HAManagerImpl
implements HAManager,
HAManagerCoordinatorCallback {
    private static final TraceComponent TC = Tr.register(HAManagerImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "HAManagerImpl";
    private HAManagerPerf ivPmi;
    private String ivServerName;
    private Coordinator ivCoordinator;
    private Map ivLocalGroups = new TreeMap();
    private MessageCache ivMessageCache;
    IsAliveManager ivPinger;

    public HAManagerImpl(Coordinator coordinator, String string, String string2, MessageCache messageCache, int n, boolean bl) throws HAInternalStateException {
        this.ivCoordinator = coordinator;
        this.ivMessageCache = messageCache;
        this.ivServerName = string2;
        this.ivPinger = new IsAliveManager(string, n, bl);
        this.ivCoordinator.setHAManagerCallback(this);
    }

    public Coordinator getCoordinator() {
        return this.ivCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAGroup joinGroup(GroupName groupName, Map map, HAGroupCallback hAGroupCallback) throws HAException {
        if (TC.isEntryEnabled()) {
            Object[] objectArray = new Object[]{groupName, DebugUtils.dumpMap("member", map)};
            Tr.entry(TC, "joinGroup()", objectArray);
        }
        if (groupName == null) {
            throw new HAParameterRejectedException("a null GroupName object is not allowed");
        }
        if (map == null) {
            throw new HAParameterRejectedException("a null member properties Map is not allowed");
        }
        if (hAGroupCallback == null) {
            throw new HAParameterRejectedException("a null HAGroupCallback object is not allowed");
        }
        if (!map.isEmpty()) {
            MapUtils.validateUserMap(map, "memberProps");
        }
        try {
            long l = System.currentTimeMillis();
            map.put("_ham.serverid", this.ivServerName);
            GroupMemberIdImpl groupMemberIdImpl = new GroupMemberIdImpl(this.ivServerName, map, "");
            MemberDataImpl memberDataImpl = new MemberDataImpl(groupMemberIdImpl, l);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "joinGroup - created MemberData for new member", memberDataImpl);
            }
            HAGroupImpl hAGroupImpl = null;
            HAManagerImpl hAManagerImpl = this;
            synchronized (hAManagerImpl) {
                hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                if (hAGroupImpl != null) {
                    throw new HAGroupMemberAlreadyExistsException("The member already exists");
                }
                HAPolicyManager hAPolicyManager = this.ivCoordinator.getPolicyManager();
                HAPolicyRule hAPolicyRule = null;
                try {
                    hAPolicyRule = hAPolicyManager.findHAPolicyRuleForGroup(groupName);
                }
                catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
                    FFDCFilter.processException((Throwable)noPolicyDefinedForGroupException, svClassName, "178", this);
                    Tr.warning(TC, "HMGR0301", groupName);
                }
                catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
                    String string = StringUtils.convertStringArrayToString(duplicatePoliciesMatchGroupException.getMatchingRules());
                    Tr.warning(TC, "HMGR0302", new Object[]{duplicatePoliciesMatchGroupException.getGroup(), string});
                }
                hAGroupImpl = new HAGroupImpl(this, groupName, hAPolicyRule, memberDataImpl, hAGroupCallback);
                this.ivLocalGroups.put(groupName, hAGroupImpl);
                this.ivPinger.addGroup(hAGroupImpl);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "created HAGroup for group", groupName);
                }
                this.localGroupMembershipChanged(hAGroupImpl, false);
            }
            if (this.ivPmi != null) {
                this.ivPmi.groupJoin(this.ivLocalGroups.size());
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "joinGroup()", hAGroupImpl);
            }
            return hAGroupImpl;
        }
        catch (HAException hAException) {
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "204", this);
            Tr.error(TC, "HMGR0111", new Object[]{groupName, map, throwable});
            throw new HAInternalStateException("Unexpected exception in joinGroup", throwable);
        }
    }

    public String getServerID() {
        return this.ivServerName;
    }

    public void getStateForAllGroups(ReportStateMsg[] reportStateMsgArray) {
        if (this.ivLocalGroups.size() > 0) {
            int n = reportStateMsgArray.length;
            Set set = this.ivLocalGroups.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                GroupName groupName = (GroupName)iterator.next();
                HAGroupImpl hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                GroupState groupState = hAGroupImpl.getGroupState();
                int n2 = this.getActiveCoordinatorIndex(groupName, n);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "Active Co-ordinator for group " + groupName + " is " + n2);
                }
                reportStateMsgArray[n2].addHAGroupData(groupName, groupState);
            }
        }
    }

    public void getStateForAllGroups(ReportClusterProcessStateMsg[] reportClusterProcessStateMsgArray) {
        if (this.ivLocalGroups.size() > 0) {
            int n = reportClusterProcessStateMsgArray.length;
            Set set = this.ivLocalGroups.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                GroupName groupName = (GroupName)iterator.next();
                HAGroupImpl hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                GroupState groupState = hAGroupImpl.getGroupState();
                int n2 = this.getActiveCoordinatorIndex(groupName, n);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "Active Co-ordinator for group " + groupName + " is " + n2);
                }
                reportClusterProcessStateMsgArray[n2].getCurrentState().put(groupName, groupState);
            }
        }
    }

    public void setPMI(HAManagerPerf hAManagerPerf) {
        this.ivPmi = hAManagerPerf;
    }

    public synchronized boolean hasActiveMembersInMinorityPartition() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "hasActiveMembersInMinorityPartition");
        }
        Iterator iterator = this.ivLocalGroups.values().iterator();
        while (iterator.hasNext()) {
            HAGroupImpl hAGroupImpl = (HAGroupImpl)iterator.next();
            String string = (String)hAGroupImpl.getGroupName().getGroupProperties().get("IBM_hc");
            if (string == null || !hAGroupImpl.isQuorumSensitiveWithActiveMember() || this.ivCoordinator.doesClusterHaveQuorum(string, false, false)) continue;
            Tr.error(TC, "HMGR0117", new Object[]{hAGroupImpl.getGroupName(), hAGroupImpl.getCurrentMembers()});
            return true;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "hasActiveMembersInMinorityPartition false");
        }
        return false;
    }

    public void groupStateUpdate(GroupMemberActivationCmdMsg groupMemberActivationCmdMsg) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "groupStateUpdate");
        }
        Map map = groupMemberActivationCmdMsg.getCommands();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            GroupName groupName = (GroupName)entry.getKey();
            GroupMemberState groupMemberState = (GroupMemberState)entry.getValue();
            if (GroupMemberState.ACTIVATING.equals(groupMemberState)) {
                this.activateLocalMember(groupName);
                continue;
            }
            if (GroupMemberState.DEACTIVATING.equals(groupMemberState)) {
                this.deactivateLocalMember(groupName);
                continue;
            }
            if (GroupMemberState.IDLE.equals(groupMemberState)) {
                this.enableLocalMember(groupName);
                continue;
            }
            if (GroupMemberState.DISABLED.equals(groupMemberState)) {
                this.disableLocalMember(groupName, GroupMemberState.DISABLED);
                continue;
            }
            if (GroupMemberState.GROUP_DISABLED.equals(groupMemberState)) {
                this.disableLocalMember(groupName, GroupMemberState.GROUP_DISABLED);
                continue;
            }
            Tr.error(TC, "HMGR0160", new Object[]{groupName, groupMemberState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void groupMembershipUpdate(GroupUpdateMsg groupUpdateMsg) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "groupUpdate()", groupUpdateMsg);
        }
        try {
            Map map = groupUpdateMsg.getEntries();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                GroupName groupName = (GroupName)iterator.next();
                MemberData[] memberDataArray = (MemberData[])map.get(groupName);
                GroupMemberId[] groupMemberIdArray = new GroupMemberId[memberDataArray.length];
                for (int i = 0; i < memberDataArray.length; ++i) {
                    object = memberDataArray[i];
                    groupMemberIdArray[i] = object.getMemberId();
                }
                HAManagerImpl hAManagerImpl = this;
                synchronized (hAManagerImpl) {
                    object = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                    if (object == null) {
                        Tr.info(TC, "HMGR0123", groupName);
                    } else {
                        ((HAGroupImpl)object).membershipChanged(groupMemberIdArray);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "566", this);
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "groupUpdate", throwable});
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "groupUpdate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String string, GroupLocalMessage groupLocalMessage) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "onMessage()", new Object[]{string, groupLocalMessage});
        }
        try {
            byte[] byArray = groupLocalMessage.getMessage();
            GroupName groupName = groupLocalMessage.getTargetGroup();
            GroupMemberId groupMemberId = groupLocalMessage.getSendingMember();
            HAManagerImpl hAManagerImpl = this;
            synchronized (hAManagerImpl) {
                HAGroupImpl hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                if (hAGroupImpl != null) {
                    hAGroupImpl.onMessage(groupMemberId, byArray);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "598", this);
            Tr.error(TC, "HMGR0108", new Object[]{svClassName, "onMessage", throwable});
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "onMessage()");
        }
    }

    public synchronized void reloadPolicies() {
        HAPolicyManager hAPolicyManager = this.ivCoordinator.getPolicyManager();
        Iterator iterator = this.ivLocalGroups.values().iterator();
        while (iterator.hasNext()) {
            HAGroupImpl hAGroupImpl = (HAGroupImpl)iterator.next();
            GroupName groupName = hAGroupImpl.getGroupName();
            HAPolicyRule hAPolicyRule = null;
            try {
                hAPolicyRule = hAPolicyManager.findHAPolicyRuleForGroup(groupName);
            }
            catch (NoPolicyDefinedForGroupException noPolicyDefinedForGroupException) {
                Tr.warning(TC, "HMGR0301", groupName);
            }
            catch (DuplicatePoliciesMatchGroupException duplicatePoliciesMatchGroupException) {
                String string = StringUtils.convertStringArrayToString(duplicatePoliciesMatchGroupException.getMatchingRules());
                Tr.warning(TC, "HMGR0302", new Object[]{duplicatePoliciesMatchGroupException.getGroup(), string});
            }
            catch (HAException hAException) {
                Tr.warning(TC, "HMGR0301", groupName);
            }
            hAGroupImpl.updatePolicy(hAPolicyRule);
        }
        this.ivPinger.policiesChanged();
    }

    public synchronized void shutdown() {
        this.stopAllHAGroups();
    }

    synchronized void localGroupStateChanged(HAGroupImpl hAGroupImpl) {
        GroupName groupName = hAGroupImpl.getGroupName();
        GroupState groupState = hAGroupImpl.getGroupState();
        this.ivMessageCache.sendGroupStateUpdate(groupName, groupState);
    }

    synchronized void localGroupMembershipChanged(HAGroupImpl hAGroupImpl, boolean bl) {
        GroupState groupState;
        GroupName groupName = hAGroupImpl.getGroupName();
        if (bl) {
            groupState = new GroupState(hAGroupImpl.getStartTime(), null);
            this.ivLocalGroups.remove(groupName);
            this.ivPinger.removeGroup(hAGroupImpl);
            hAGroupImpl.doLeave();
        } else {
            groupState = hAGroupImpl.getGroupState();
        }
        if (this.ivPmi != null) {
            this.ivPmi.groupLeave(this.ivLocalGroups.size());
        }
        this.ivMessageCache.sendGroupStateUpdate(groupName, groupState);
    }

    boolean isHardwareQuorumEnforced(GroupName groupName) throws NoPolicyDefinedForGroupException, DuplicatePoliciesMatchGroupException, HAInternalStateException {
        return this.ivCoordinator.isHardwareQuorumEnforced(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateLocalMember(GroupName groupName) {
        HAGroupImpl hAGroupImpl = null;
        HAManagerImpl hAManagerImpl = this;
        synchronized (hAManagerImpl) {
            hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
        }
        if (hAGroupImpl == null) {
            Tr.info(TC, "HMGR0103", groupName);
            return;
        }
        hAGroupImpl.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateLocalMember(GroupName groupName) {
        HAGroupImpl hAGroupImpl = null;
        HAManagerImpl hAManagerImpl = this;
        synchronized (hAManagerImpl) {
            hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
        }
        if (hAGroupImpl == null) {
            Tr.info(TC, "HMGR0103", groupName);
            return;
        }
        hAGroupImpl.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableLocalMember(GroupName groupName) {
        HAGroupImpl hAGroupImpl = null;
        HAManagerImpl hAManagerImpl = this;
        synchronized (hAManagerImpl) {
            hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
        }
        if (hAGroupImpl == null) {
            Tr.info(TC, "HMGR0103", groupName);
            return;
        }
        hAGroupImpl.adminEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableLocalMember(GroupName groupName, GroupMemberState groupMemberState) {
        HAGroupImpl hAGroupImpl = null;
        HAManagerImpl hAManagerImpl = this;
        synchronized (hAManagerImpl) {
            hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
        }
        if (hAGroupImpl == null) {
            Tr.info(TC, "HMGR0103", groupName);
            return;
        }
        hAGroupImpl.adminDisable(groupMemberState);
    }

    private void stopAllHAGroups() {
        if (this.ivLocalGroups.size() > 0) {
            Set set = this.ivLocalGroups.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                GroupName groupName = (GroupName)iterator.next();
                HAGroupImpl hAGroupImpl = (HAGroupImpl)this.ivLocalGroups.get(groupName);
                hAGroupImpl.shutdown();
            }
        }
    }

    private final int getActiveCoordinatorIndex(GroupName groupName, int n) {
        return HAMUtil.calculateCoordinatorIndex(groupName, n);
    }

    private class IsAliveBucket {
        private int ivIsAlivePeriod;
        private Set ivGroups;

        IsAliveBucket(int n) {
            this.ivIsAlivePeriod = n;
            this.ivGroups = new HashSet();
        }

        synchronized void addGroup(HAGroupImpl hAGroupImpl) {
            this.ivGroups.add(hAGroupImpl);
        }

        synchronized void removeGroup(HAGroupImpl hAGroupImpl) {
            this.ivGroups.remove(hAGroupImpl);
        }

        synchronized boolean isEmpty() {
            return this.ivGroups.isEmpty();
        }

        int getTime() {
            return this.ivIsAlivePeriod;
        }

        synchronized void sendPings() {
            Object[] objectArray;
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{HAManagerImpl.this.ivPinger.ivCoreGroupName, new Integer(this.ivIsAlivePeriod)};
                Tr.debug(TC, "sending IsAlive", objectArray);
            }
            objectArray = this.ivGroups.iterator();
            while (objectArray.hasNext()) {
                HAGroupImpl hAGroupImpl = (HAGroupImpl)objectArray.next();
                if (hAGroupImpl.isAlivePending()) {
                    Tr.info(TC, "HMGR0131", hAGroupImpl.getGroupName());
                    HAManagerImpl.this.ivCoordinator.getJVMController().panicJVM("isAlive panic");
                }
                hAGroupImpl.isAlive();
            }
        }

        synchronized boolean reassignGroups() {
            Object[] objectArray;
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{HAManagerImpl.this.ivPinger.ivCoreGroupName, new Integer(this.ivIsAlivePeriod)};
                Tr.debug(TC, "reassigning Groups", objectArray);
            }
            objectArray = new ArrayList();
            Iterator iterator = this.ivGroups.iterator();
            while (iterator.hasNext()) {
                HAGroupImpl hAGroupImpl = (HAGroupImpl)iterator.next();
                int n = HAManagerImpl.this.ivPinger.getGroupIsAliveTime(hAGroupImpl);
                if (n == this.ivIsAlivePeriod) continue;
                objectArray.add(hAGroupImpl);
            }
            int n = objectArray.size();
            if (n == 0) {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                HAGroupImpl hAGroupImpl = (HAGroupImpl)objectArray.get(i);
                this.ivGroups.remove(hAGroupImpl);
                HAManagerImpl.this.ivPinger.addGroup(hAGroupImpl);
            }
            return this.ivGroups.isEmpty();
        }

        public String toString() {
            return "IsAliveBucket: " + this.ivIsAlivePeriod + " number of groups " + this.ivGroups.size();
        }
    }

    final class IsAliveManager
    implements AlarmListener {
        private String ivCoreGroupName;
        private int ivDefaultPeriod;
        private ArrayList ivBuckets;

        IsAliveManager(String string, int n, boolean bl) throws HAInternalStateException {
            this.ivCoreGroupName = string;
            this.ivBuckets = new ArrayList();
            this.ivDefaultPeriod = n < 0 ? -1 : n * 1000;
        }

        public void alarm(Object object) {
            try {
                IsAliveBucket isAliveBucket = (IsAliveBucket)object;
                boolean bl = this.checkBucket(isAliveBucket);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "isAlive", new Object[]{isAliveBucket, new Boolean(bl)});
                }
                if (!bl) {
                    isAliveBucket.sendPings();
                    AlarmManager.createNonDeferrable(isAliveBucket.getTime(), this, isAliveBucket);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, HAManagerImpl.svClassName, "734", this);
                Tr.error(TC, "HMGR0147", throwable);
            }
        }

        synchronized void addGroup(HAGroupImpl hAGroupImpl) {
            int n = this.getGroupIsAliveTime(hAGroupImpl);
            boolean bl = false;
            IsAliveBucket isAliveBucket = this.getBucket(n);
            if (isAliveBucket == null) {
                isAliveBucket = new IsAliveBucket(n);
                this.ivBuckets.add(isAliveBucket);
                bl = true;
                if (n > 0) {
                    AlarmManager.createNonDeferrable(n, this, isAliveBucket);
                }
            }
            isAliveBucket.addGroup(hAGroupImpl);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "isAlive addGroup", new Object[]{hAGroupImpl, isAliveBucket, new Boolean(bl)});
            }
        }

        synchronized void removeGroup(HAGroupImpl hAGroupImpl) {
            int n = this.getGroupIsAliveTime(hAGroupImpl);
            IsAliveBucket isAliveBucket = this.getBucket(n);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "isAlive removeGroup", new Object[]{hAGroupImpl, isAliveBucket});
            }
            if (isAliveBucket == null) {
                Tr.info(TC, "HMGR0146", hAGroupImpl);
                return;
            }
            isAliveBucket.removeGroup(hAGroupImpl);
        }

        synchronized void policiesChanged() {
            int n = this.ivBuckets.size();
            for (int i = 0; i < n; ++i) {
                IsAliveBucket isAliveBucket = (IsAliveBucket)this.ivBuckets.get(i);
                isAliveBucket.reassignGroups();
            }
        }

        int getGroupIsAliveTime(HAGroupImpl hAGroupImpl) {
            int n = hAGroupImpl.getIsAliveTime();
            if (n == 0) {
                return this.ivDefaultPeriod;
            }
            if (n < 0) {
                return -1;
            }
            return n * 1000;
        }

        private IsAliveBucket getBucket(int n) {
            int n2 = this.ivBuckets.size();
            for (int i = 0; i < n2; ++i) {
                IsAliveBucket isAliveBucket = (IsAliveBucket)this.ivBuckets.get(i);
                if (isAliveBucket.getTime() != n) continue;
                return isAliveBucket;
            }
            return null;
        }

        private synchronized boolean checkBucket(IsAliveBucket isAliveBucket) {
            if (isAliveBucket.isEmpty()) {
                this.ivBuckets.remove(isAliveBucket);
                return true;
            }
            return false;
        }
    }
}

