/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.HAMThreadPool;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.WorkQueue;
import com.ibm.ws.hamanager.impl.Worker;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import java.security.PrivilegedAction;
import java.util.LinkedList;

public class UserCallbacks {
    static final String svClassName = "com.ibm.ws.hamanager.impl.UserCallbacks";
    static final TraceComponent TC = Tr.register("com.ibm.ws.hamanager.impl.UserCallbacks", "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final int DEFAULT_DUMP_THRESHOLD = 10000;
    private static boolean svInitialized;
    private static HAMThreadPool svThreadPool;
    private static int svNumberOfQueues;
    private static WorkQueue[] svQueues;
    static LinkedList svReadyToRun;
    static int svReadyToDispatchCount;
    static boolean svWorking;
    static Thread svThread;
    private static boolean svServerShuttingDown;

    public static synchronized void initialize() throws HAException {
        int n;
        if (svInitialized) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("UserCallbacks already initialized");
            Tr.error(TC, "HMGR5011", hAInternalStateException);
            throw hAInternalStateException;
        }
        svThreadPool = Providers.getRuntimeProvider().getUserCallbacksThreadPool();
        int n2 = 10000;
        try {
            String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("websphere.hamanager.workqueue.threshold");
                }
            });
            if (string != null) {
                n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    n2 = Integer.MAX_VALUE;
                }
                Tr.info(TC, "HMGR3100", new Object[]{string});
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "142");
        }
        svNumberOfQueues = svThreadPool.getMaxThreads();
        svQueues = new WorkQueue[svNumberOfQueues];
        for (n = 0; n < svNumberOfQueues; ++n) {
            UserCallbacks.svQueues[n] = new WorkQueue(n, n2);
        }
        svThread = new Thread(new WorkDispatcher());
        svThread.setDaemon(true);
        svThread.start();
        if (TC.isDebugEnabled()) {
            n = svThreadPool.getMaxThreads();
            Tr.debug(TC, "UserCallbacks initialized (ThreadPool: min=" + n + ", max=" + svNumberOfQueues + ", num of queues=" + svNumberOfQueues + ")");
        }
    }

    public static void executeCallback(UserCallback userCallback) {
        int n = userCallback.getQueue(svNumberOfQueues);
        WorkQueue workQueue = svQueues[n];
        workQueue.scheduleCallback(userCallback);
    }

    public static void shutdown() {
        svServerShuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addWorkQueueToReadyToRunQueue(Worker worker) {
        LinkedList linkedList = svReadyToRun;
        synchronized (linkedList) {
            svReadyToRun.add(worker);
            if (++svReadyToDispatchCount == 1 && !svWorking) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Notify dispatch thread.");
                }
                svReadyToRun.notify();
            }
        }
    }

    static {
        svReadyToRun = new LinkedList();
        svReadyToDispatchCount = 0;
        svWorking = false;
        svServerShuttingDown = false;
    }

    private static final class WorkDispatcher
    implements Runnable {
        private WorkDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Worker worker = null;
            while (!svServerShuttingDown) {
                try {
                    LinkedList linkedList = svReadyToRun;
                    synchronized (linkedList) {
                        if (svReadyToDispatchCount == 0) {
                            svWorking = false;
                            svReadyToRun.wait();
                        }
                        worker = (Worker)svReadyToRun.remove(0);
                        --svReadyToDispatchCount;
                        svWorking = true;
                    }
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Dispatch Thread - dispatching " + worker);
                    }
                    svThreadPool.execute(worker);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, UserCallbacks.svClassName, "222", this);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, UserCallbacks.svClassName, "228", this);
                    Tr.error(TC, "HMGR0143", throwable);
                }
            }
        }
    }
}

