/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.ws.hamanager.partitionedmanager.PartitionedManagerGroupImpl;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.datastack.DataStackClosedException;
import com.ibm.wsspi.hamanager.datastack.DataStackEvent;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.Map;

public class ViewSynchronousHAGroup
implements HAGroup,
HAGroupCallback,
DataStackCallback {
    private HAGroupImpl haGroup = null;
    private String dataStackName = null;
    private DataStack VSDataStack = null;
    private HAGroupCallback haGroupCallback = null;
    private GroupName groupName = null;
    private boolean expectedTermination = false;
    private static final TraceComponent TC = Tr.register(ViewSynchronousHAGroup.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String className = ViewSynchronousHAGroup.class.getName();

    public ViewSynchronousHAGroup(GroupManager groupManager, GroupName groupName, Map map, String string, HAGroupCallback hAGroupCallback) throws HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, className, new Object[]{groupName, map, string});
        }
        this.groupName = groupName;
        this.haGroupCallback = hAGroupCallback;
        this.dataStackName = string;
        this.haGroup = (HAGroupImpl)groupManager.joinGroup(this.groupName, map, this);
        this.VSDataStack = this.haGroup.createDataStack(this.dataStackName, true, this);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, className);
        }
    }

    public GroupName getGroupName() {
        return this.haGroup.getGroupName();
    }

    public GroupMemberId getMemberName() throws HAGroupLeftException {
        return this.haGroup.getMemberName();
    }

    public synchronized GroupMemberState getMemberState() {
        return this.haGroup.getMemberState();
    }

    public synchronized void leave() throws HAGroupLeftException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "leave");
        }
        this.expectedTermination = true;
        if (this.VSDataStack == null) {
            return;
        }
        this.VSDataStack.terminateDataStack();
        try {
            while (this.VSDataStack != null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.hamanager.impl.ViewSynchronousHAGroup.leave", "208", this);
        }
        this.haGroup.leave();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "leave");
        }
    }

    public void setVersionString(String string) throws HAGroupLeftException, HAParameterRejectedException {
        this.haGroup.setVersionString(string);
    }

    public String getVersionString() throws HAGroupLeftException {
        return this.haGroup.getVersionString();
    }

    public void enableMember() throws HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        this.haGroup.enableMember();
    }

    public void disableMember(String string) throws HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        this.haGroup.disableMember(string);
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId groupMemberId, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DataStack dataStack = this.VSDataStack;
        if (dataStack == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        String string = groupMemberId.getServerName();
        dataStack.sendMessage(string, msgQoS, this.dataStackName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId[] groupMemberIdArray, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DataStack dataStack = this.VSDataStack;
        if (dataStack == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        String[] stringArray = HAMUtil.getServerNames(groupMemberIdArray);
        dataStack.sendMessage(stringArray, msgQoS, this.dataStackName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, byte[] byArray) throws DataStackException, HAParameterRejectedException {
        DataStack dataStack = this.VSDataStack;
        if (dataStack == null) {
            throw new DataStackClosedException("The DataStack has been terminated");
        }
        dataStack.sendMessage(msgQoS, this.dataStackName, byArray);
    }

    public boolean isHardwareQuorumEnforced() throws NoPolicyDefinedForGroupException, HAInternalStateException, DuplicatePoliciesMatchGroupException, IllegalStateException {
        return this.haGroup.isHardwareQuorumEnforced();
    }

    public void memberMayActivate(GroupName groupName) {
        this.haGroupCallback.memberMayActivate(groupName);
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        this.haGroupCallback.memberMayActivateCancelled(groupName);
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        this.haGroupCallback.memberIsActivated(groupName, asynchOperationComplete, object);
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        this.haGroupCallback.memberDeactivate(groupName, asynchOperationComplete, object);
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
    }

    public boolean isAlive(GroupName groupName) {
        return this.haGroupCallback.isAlive(groupName);
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
    }

    public void dataStackMessageReceived(GroupMemberId groupMemberId, String string, byte[] byArray) {
        this.haGroupCallback.onMessage(groupMemberId, byArray);
    }

    public void dataStackMembershipChanged(GroupMemberId[] groupMemberIdArray) {
        this.haGroupCallback.membershipChanged(this.groupName, groupMemberIdArray);
    }

    public synchronized void dataStackTerminated() {
        this.VSDataStack = null;
        if (this.expectedTermination) {
            this.expectedTermination = false;
            this.notifyAll();
            return;
        }
        try {
            this.haGroup.leave();
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, "com.ibm.ws.hamanager.impl.ViewSynchronousHAGroup.dataStackTerminated", "465", this);
        }
    }

    public void dataStackEvent(DataStackEvent dataStackEvent) {
        if (dataStackEvent == DataStackEvent.HIGH_WATERMARK_REACHED) {
            Tr.info(TC, "HMGR0503", this.dataStackName);
        }
    }

    public void dataStackViewAboutToChange() {
        ((PartitionedManagerGroupImpl)this.haGroupCallback).viewAboutToChange();
    }
}

