/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.impl.Worker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class WorkQueue {
    private int id;
    private LinkedList ivWorkItems;
    private boolean ivOnReadyToRunQueue;
    private int ivBaseThreshold;
    private int ivResetThreshold;
    private int ivDumpThreshold;
    private long ivNumCalledBack = 0L;
    private String ivLastCalledBack;
    private long ivMaxQueueDepth = 0L;

    WorkQueue(int n, int n2) {
        this.id = n;
        this.ivOnReadyToRunQueue = false;
        this.ivDumpThreshold = this.ivBaseThreshold = n2;
        this.ivResetThreshold = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCallback(UserCallback userCallback) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (!this.ivOnReadyToRunQueue) {
                this.ivOnReadyToRunQueue = true;
                bl = true;
                if (UserCallbacks.TC.isDebugEnabled()) {
                    Tr.debug(UserCallbacks.TC, "First piece of work for WorkQueue_" + this.id);
                }
            } else {
                if (this.ivWorkItems == null) {
                    this.ivWorkItems = new LinkedList();
                }
                if (UserCallbacks.TC.isDebugEnabled()) {
                    Tr.debug(UserCallbacks.TC, "adding work to WorkQueue_" + this.id, userCallback);
                }
                this.ivWorkItems.addLast(userCallback);
                if (UserCallbacks.TC.isDebugEnabled()) {
                    Tr.debug(UserCallbacks.TC, "Queue State: " + this);
                }
            }
            if (this.ivWorkItems != null) {
                if ((long)this.ivWorkItems.size() > this.ivMaxQueueDepth) {
                    this.ivMaxQueueDepth = this.ivWorkItems.size();
                }
                if (this.ivWorkItems.size() < this.ivResetThreshold) {
                    while (this.ivWorkItems.size() < this.ivResetThreshold) {
                        this.ivDumpThreshold -= this.ivBaseThreshold;
                        this.ivResetThreshold = (this.ivDumpThreshold - this.ivBaseThreshold) / 2;
                    }
                    Tr.info(UserCallbacks.TC, "HMGR3101", new Object[]{new Integer(this.ivDumpThreshold), new Integer(this.id), "void", "void"});
                } else if (this.ivWorkItems.size() >= this.ivDumpThreshold) {
                    HashMap<String, UserCallbackStats> hashMap = new HashMap<String, UserCallbackStats>();
                    Iterator iterator = this.ivWorkItems.iterator();
                    while (iterator.hasNext()) {
                        UserCallback userCallback2 = (UserCallback)iterator.next();
                        String string = userCallback2.getUserClassName();
                        UserCallbackStats userCallbackStats = (UserCallbackStats)hashMap.get(string);
                        if (userCallbackStats == null) {
                            userCallbackStats = new UserCallbackStats();
                            hashMap.put(string, userCallbackStats);
                        }
                        userCallbackStats.incrementCount();
                    }
                    int n = this.ivDumpThreshold;
                    this.ivDumpThreshold += this.ivBaseThreshold;
                    this.ivResetThreshold = (this.ivDumpThreshold - this.ivBaseThreshold) / 2;
                    Tr.info(UserCallbacks.TC, "HMGR3101", new Object[]{new Integer(this.ivDumpThreshold), new Integer(this.id), new Integer(n), hashMap.toString() + " Last called back: " + this.ivLastCalledBack + "#" + this.ivNumCalledBack + " Max depth: " + this.ivMaxQueueDepth});
                }
            }
        }
        if (bl) {
            object = new Worker(this, userCallback);
            UserCallbacks.addWorkQueueToReadyToRunQueue((Worker)object);
        }
    }

    synchronized UserCallback getNextWork() {
        if (this.ivWorkItems == null) {
            this.ivOnReadyToRunQueue = false;
            return null;
        }
        if (this.ivWorkItems.size() == 0) {
            this.ivOnReadyToRunQueue = false;
            return null;
        }
        UserCallback userCallback = (UserCallback)this.ivWorkItems.removeFirst();
        this.ivLastCalledBack = userCallback.getUserClassName();
        ++this.ivNumCalledBack;
        return userCallback;
    }

    public int getIdentifier() {
        return this.id;
    }

    public String toString() {
        int n = this.ivWorkItems == null ? 0 : this.ivWorkItems.size();
        return "WorkQueue_" + this.id + " (" + n + " items on queue)";
    }

    class UserCallbackStats {
        private int ivCount = 0;

        UserCallbackStats() {
        }

        public void incrementCount() {
            ++this.ivCount;
        }

        public String toString() {
            return this.ivCount + "";
        }
    }
}

