/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.impl.WorkQueue;

class Worker
implements Runnable {
    private WorkQueue ivQueue;
    private UserCallback ivWork;

    Worker(WorkQueue workQueue, UserCallback userCallback) {
        this.ivQueue = workQueue;
        this.ivWork = userCallback;
    }

    public void run() {
        while (this.ivWork != null) {
            try {
                this.ivWork.doCallback();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.impl.UserCallbacks", "281", this, new Object[]{this.ivWork});
                Tr.error(UserCallbacks.TC, "HMGR0142", throwable);
            }
            this.ivWork = this.ivQueue.getNextWork();
            if (!UserCallbacks.TC.isDebugEnabled()) continue;
            if (this.ivWork == null) {
                Tr.debug(UserCallbacks.TC, "Worker - no more work to do (WorkQueue_" + this.ivQueue.getIdentifier() + " is empty)");
                continue;
            }
            Tr.debug(UserCallbacks.TC, "Worker - get next work item from queue: " + this.ivWork);
            Tr.debug(UserCallbacks.TC, "Queue State: " + this.ivQueue);
        }
    }

    public String toString() {
        return "Worker for " + this.ivQueue;
    }
}

