/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.partitionedmanager;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.partitionedmanager.PartitionedManagerGroupImpl;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupData;
import com.ibm.wsspi.hamanager.partitionedmanager.MemberStateEnum;
import com.ibm.wsspi.hamanager.partitionedmanager.NoPartitionedManagerGroupException;
import com.ibm.wsspi.hamanager.partitionedmanager.NotReadyToSendMessageException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ManagedGroupDataImpl
implements ManagedGroupData {
    private static final String UNIVERSAL_CODE_SET_NAME = "UTF8";
    private static final String className = ManagedGroupDataImpl.class.getName();
    private String ivMgdName = null;
    private boolean ivManager = false;
    private boolean ivFixedManagers = false;
    private boolean ivRestrictToPreferred = false;
    private int ivNumberOfManagers = 0;
    private Map ivPreferredManagers = null;
    private ManagedGroupCallback ivManagerEvents = null;
    private String ivNoPMGError;
    private PartitionedManagerGroupImpl ivPMG = null;

    public ManagedGroupDataImpl(String string, boolean bl, boolean bl2, boolean bl3, int n, String[] stringArray, ManagedGroupCallback managedGroupCallback) throws HAParameterRejectedException {
        if (string == null) {
            throw new HAParameterRejectedException("A null ManagedGroupData name is not allowed.");
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw new HAParameterRejectedException("An empty manager set name is not allowed.");
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(UNIVERSAL_CODE_SET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, className, "107", this);
        }
        int n3 = byArray.length;
        if (n3 > 127) {
            String string2 = "ManagerSetName length of " + n3 + " is too long";
            throw new HAParameterRejectedException(string2);
        }
        if (n < 1) {
            throw new HAParameterRejectedException("Invalid number of managers " + n);
        }
        if (stringArray == null) {
            throw new HAParameterRejectedException("A null preferred managers array is not allowed.");
        }
        if (managedGroupCallback == null) {
            throw new HAParameterRejectedException("a null managed group callback object is not allowed.");
        }
        this.ivMgdName = string;
        this.ivManager = bl;
        this.ivFixedManagers = bl2;
        this.ivRestrictToPreferred = bl3;
        this.ivNumberOfManagers = n;
        this.ivPreferredManagers = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.ivPreferredManagers.put(stringArray[i], new Integer(i));
        }
        this.ivManagerEvents = managedGroupCallback;
        this.ivPMG = null;
        this.ivNoPMGError = "No partitioned manager group associated with the manager set named: " + this.ivMgdName;
    }

    public void setPartitionedManagerGroupImpl(PartitionedManagerGroupImpl partitionedManagerGroupImpl) throws HAParameterRejectedException {
        if (partitionedManagerGroupImpl == null) {
            throw new HAParameterRejectedException("A null partitioned manager group object is not allowed.");
        }
        this.ivPMG = partitionedManagerGroupImpl;
    }

    public void resetPartitionedManagerGroupImpl() {
        this.ivPMG = null;
    }

    public boolean attachedToAPartitionedManagerGroup() {
        return this.ivPMG != null;
    }

    public boolean isManager() {
        return this.ivManager;
    }

    public boolean isFixedManagers() {
        return this.ivFixedManagers;
    }

    public boolean isRestrictToPreferred() {
        return this.ivRestrictToPreferred;
    }

    public int getNumberOfManagers() {
        return this.ivNumberOfManagers;
    }

    public String getManagerSetName() {
        return this.ivMgdName;
    }

    public Map getPreferredManagers() {
        return this.ivPreferredManagers;
    }

    public ManagedGroupCallback getManagerEvents() {
        return this.ivManagerEvents;
    }

    public boolean isActive() throws NoPartitionedManagerGroupException, HAInternalStateException {
        if (this.ivPMG == null) {
            throw new NoPartitionedManagerGroupException(this.ivNoPMGError);
        }
        try {
            return this.ivPMG.isActive(this.ivMgdName);
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException(hAParameterRejectedException, className, "249");
            throw new HAInternalStateException("The associated PMG does not have a manager set named: " + this.ivMgdName, hAParameterRejectedException);
        }
    }

    public MemberStateEnum getState() throws NoPartitionedManagerGroupException, HAInternalStateException {
        if (this.ivPMG == null) {
            throw new NoPartitionedManagerGroupException(this.ivNoPMGError);
        }
        try {
            return this.ivPMG.getState(this.ivMgdName);
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException(hAParameterRejectedException, className, "269");
            throw new HAInternalStateException("The associated PMG does not have a manager set named: " + this.ivMgdName, hAParameterRejectedException);
        }
    }

    public void sendMessage(GroupMemberId groupMemberId, byte[] byArray) throws NoPartitionedManagerGroupException, HAParameterRejectedException, NotReadyToSendMessageException, DataStackException {
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("A null destination is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (this.ivPMG == null) {
            throw new NoPartitionedManagerGroupException(this.ivNoPMGError);
        }
        this.ivPMG.sendMessage(this.ivMgdName, groupMemberId, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ManagedGroupData : Name ");
        stringBuffer.append(this.ivMgdName);
        stringBuffer.append(", number of managers ");
        stringBuffer.append(this.ivNumberOfManagers);
        stringBuffer.append(", isManager ");
        stringBuffer.append(this.ivManager);
        stringBuffer.append(", Fixed Managers ");
        stringBuffer.append(this.ivFixedManagers);
        stringBuffer.append(", Restricted to preferred ");
        stringBuffer.append(this.ivRestrictToPreferred);
        stringBuffer.append(", preferred managers ");
        stringBuffer.append(this.ivPreferredManagers);
        return stringBuffer.toString();
    }
}

