/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.partitionedmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.impl.ViewSynchronousHAGroup;
import com.ibm.ws.hamanager.partitionedmanager.ManagedGroupDataImpl;
import com.ibm.ws.hamanager.partitionedmanager.SortableGroupMemberId;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.datastack.DataStackClosedException;
import com.ibm.wsspi.hamanager.datastack.DataStackCongestionException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import com.ibm.wsspi.hamanager.partitionedmanager.AlreadyBoundToAPartitionedManagerGroupException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupCallback;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupData;
import com.ibm.wsspi.hamanager.partitionedmanager.MemberStateEnum;
import com.ibm.wsspi.hamanager.partitionedmanager.NotReadyToSendMessageException;
import com.ibm.wsspi.hamanager.partitionedmanager.PartitionedManagerGroup;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartitionedManagerGroupImpl
implements PartitionedManagerGroup,
HAGroupCallback {
    private static final TraceComponent TC = Tr.register(PartitionedManagerGroupImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String className = PartitionedManagerGroupImpl.class.getName();
    static final int svPMGmembershipChanged = 0;
    private static final String PMG_IS_MANAGER = "IBM_PMG_IS_MGR:";
    private static final String DATA_STACK_NAME = "P";
    private static final String UNIVERSAL_CODE_SET_NAME = "UTF8";
    private static final String PMG_MESSAGE_HEADER = "__IBM_PMG_MSG_";
    private static final MsgQoS MSG_QOS = MsgQoS.VS_CURRENT;
    private Map ivCriteriaMap = new HashMap();
    private String[] ivMgdNames = null;
    private ManagedGroupCallback[] ivCallbacks = null;
    private GroupMemberId[] ivMembers;
    private GroupMemberId ivLocalMember;
    private String ivServerName = null;
    private ViewSynchronousHAGroup ivVsGroup = null;
    private static byte[] PMG_MESSAGE_HEADER_BYTES = null;
    private static int PMG_MESSAGE_HEADER_BYTES_LENGTH = 0;

    public PartitionedManagerGroupImpl(GroupManager groupManager, GroupName groupName, Map map, ManagedGroupData[] managedGroupDataArray) throws HAException {
        int n;
        if (groupManager == null) {
            throw new HAParameterRejectedException("A null GroupManager is not allowed.");
        }
        if (groupName == null) {
            throw new HAParameterRejectedException("A null group name object is not allowed.");
        }
        if (map == null) {
            throw new HAParameterRejectedException("A null member properties map is not allowed.");
        }
        if (managedGroupDataArray == null) {
            throw new HAParameterRejectedException("A null managed group data array is not allowed.");
        }
        if (managedGroupDataArray.length == 0) {
            throw new HAParameterRejectedException("An empty managed group data array is not allowed.");
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "PMG::ctor ==> number of managed group data elements: " + managedGroupDataArray.length);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        this.ivMgdNames = new String[managedGroupDataArray.length];
        this.ivCallbacks = new ManagedGroupCallback[managedGroupDataArray.length];
        ManagedGroupData managedGroupData = null;
        String string = null;
        String string2 = null;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < managedGroupDataArray.length; ++i) {
            managedGroupData = managedGroupDataArray[i];
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "PMG::ctor", managedGroupData);
            }
            if (managedGroupData == null) {
                throw new HAParameterRejectedException("The ManagerGroupData element at index " + i + " is null.");
            }
            this.ivCallbacks[i] = managedGroupData.getManagerEvents();
            this.ivMgdNames[i] = string = managedGroupData.getManagerSetName();
            n = hashSet.add(string) ? 1 : 0;
            if (n == 0) {
                throw new HAParameterRejectedException("The manager set name " + string + " is duplicated.");
            }
            if (((ManagedGroupDataImpl)managedGroupData).attachedToAPartitionedManagerGroup()) {
                String string3 = "The ManagedGroupData named " + string + " is already associated with a PMG.";
                throw new AlreadyBoundToAPartitionedManagerGroupException(string3);
            }
            string2 = PMG_IS_MANAGER + string;
            this.ivCriteriaMap.put(string, new ManagerSelectionCriteria(managedGroupData, string2));
            hashMap.put(string2, managedGroupData.isManager() ? "1" : "0");
            ((ManagedGroupDataImpl)managedGroupData).setPartitionedManagerGroupImpl(this);
        }
        this.ivMembers = new GroupMemberId[0];
        try {
            this.ivVsGroup = new ViewSynchronousHAGroup(groupManager, groupName, hashMap, DATA_STACK_NAME, this);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, className, "265", this);
            for (n = 0; n < managedGroupDataArray.length; ++n) {
                ((ManagedGroupDataImpl)managedGroupDataArray[n]).resetPartitionedManagerGroupImpl();
            }
            throw hAException;
        }
        this.ivLocalMember = this.ivVsGroup.getMemberName();
        this.ivServerName = this.ivLocalMember.getServerName();
        PMGCallback pMGCallback = new PMGCallback(0, groupName, new GroupMemberId[]{this.ivLocalMember});
        UserCallbacks.executeCallback(pMGCallback);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "PMG::ctor ==> Successful Construction.");
        }
    }

    public GroupName getGroupName() {
        return this.ivVsGroup.getGroupName();
    }

    public GroupMemberId getMemberName() throws HAGroupLeftException {
        return this.ivVsGroup.getMemberName();
    }

    public boolean isActive(String string) throws HAParameterRejectedException {
        ManagerSelectionCriteria managerSelectionCriteria = this.checkAndGetMgdName(string);
        return managerSelectionCriteria.getState().equals(MemberStateEnum.ACTIVE);
    }

    public MemberStateEnum getState(String string) throws HAParameterRejectedException {
        ManagerSelectionCriteria managerSelectionCriteria = this.checkAndGetMgdName(string);
        return managerSelectionCriteria.getState();
    }

    public void stop() throws HAGroupLeftException, HAInternalStateException {
        this.ivVsGroup.leave();
        for (int i = 0; i < this.ivMgdNames.length; ++i) {
            ManagerSelectionCriteria managerSelectionCriteria = this.getManagerSelectionCriteria(this.ivMgdNames[i]);
            ((ManagedGroupDataImpl)managerSelectionCriteria.getManagedGroupData()).resetPartitionedManagerGroupImpl();
        }
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public boolean isAlive(GroupName groupName) {
        for (int i = 0; i < this.ivCallbacks.length; ++i) {
            ManagedGroupCallback managedGroupCallback = this.ivCallbacks[i];
            try {
                if (managedGroupCallback.isAlive(groupName)) continue;
                Tr.info(TC, "HMGR2005", new Object[]{this.ivMgdNames[i], groupName});
                return false;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, className, "400", this);
                this.terminatePMG(this.ivMgdNames[i], "isAlive", "isAlive", throwable);
                return false;
            }
        }
        return true;
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "<membershipChanged>", groupMemberIdArray);
        }
        String string = null;
        ManagerSelectionCriteria managerSelectionCriteria = null;
        try {
            for (int i = 0; i < this.ivMgdNames.length; ++i) {
                string = this.ivMgdNames[i];
                managerSelectionCriteria = this.getManagerSelectionCriteria(string);
                managerSelectionCriteria.stateNotReady();
            }
            GroupMemberId[] groupMemberIdArray2 = this.ivMembers;
            this.ivMembers = groupMemberIdArray;
            for (int i = 0; i < this.ivMgdNames.length; ++i) {
                ManagedGroupCallback managedGroupCallback = this.ivCallbacks[i];
                string = this.ivMgdNames[i];
                managerSelectionCriteria = this.getManagerSelectionCriteria(string);
                boolean bl = managerSelectionCriteria.calculateManagers(groupMemberIdArray);
                boolean bl2 = managerSelectionCriteria.isServerAManager(this.ivServerName);
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{string, bl, bl2};
                    Tr.debug(TC, "membershipChanged - elected Managers", objectArray);
                }
                if (!bl2) {
                    this.nonManager(string, managerSelectionCriteria, managedGroupCallback, bl);
                } else if (bl) {
                    this.managerChange(string, managerSelectionCriteria, managedGroupCallback);
                } else {
                    this.noManagerChange(string, managerSelectionCriteria, managedGroupCallback, groupMemberIdArray2);
                }
                managedGroupCallback.membershipChanged(groupName, groupMemberIdArray);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, className, "471", this);
            this.terminatePMG(string, "membershipChanged", "unknown", throwable);
            return;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "<membershipChanged>");
        }
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        Object[] objectArray;
        DissectedMessage dissectedMessage;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "<onMessage>");
        }
        if (!(dissectedMessage = this.unpackMessage(byArray)).ivValidMgdName) {
            String string = dissectedMessage.ivMgdName;
            if (string == null) {
                Tr.error(TC, "HMGR2003");
            } else {
                Tr.error(TC, "HMGR2004", string);
            }
            return;
        }
        String string = dissectedMessage.ivMgdName;
        ManagerSelectionCriteria managerSelectionCriteria = this.getManagerSelectionCriteria(string);
        ManagedGroupCallback managedGroupCallback = managerSelectionCriteria.getManagedGroupData().getManagerEvents();
        MemberStateEnum memberStateEnum = managerSelectionCriteria.getState();
        boolean bl = managerSelectionCriteria.needStateFromMember(groupMemberId);
        if (TC.isDebugEnabled()) {
            objectArray = Boolean.valueOf(managerSelectionCriteria.isServerAManager(this.ivServerName));
            Boolean bl2 = bl;
            Tr.debug(TC, "onMessage - MGD State ", new Object[]{string, memberStateEnum, objectArray, bl2});
        }
        if (bl) {
            this.processStateMessage(string, managerSelectionCriteria, managedGroupCallback, groupMemberId, dissectedMessage);
        } else if (managerSelectionCriteria.waitingForState()) {
            managerSelectionCriteria.queueApplicationMessage(groupMemberId, dissectedMessage.ivMessage);
            if (TC.isDebugEnabled()) {
                int n = dissectedMessage.ivMessage.length;
                Tr.debug(TC, "onMessage queueing app message", new Object[]{string, groupMemberId, n});
            }
        } else {
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{string, dissectedMessage.ivMessage.length};
                Tr.debug(TC, "onMessage - delivering message to the app", objectArray);
            }
            managedGroupCallback.onMessage(groupMemberId, dissectedMessage.ivMessage);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "<onMessage>");
        }
    }

    public void viewAboutToChange() {
        String string = null;
        ManagerSelectionCriteria managerSelectionCriteria = null;
        for (int i = 0; i < this.ivMgdNames.length; ++i) {
            string = this.ivMgdNames[i];
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "mayUnstabilize() - mgdName=" + string);
            }
            this.ivCallbacks[i].mayUnstabilize();
            managerSelectionCriteria = this.getManagerSelectionCriteria(string);
            managerSelectionCriteria.stateNotReadyCC();
        }
    }

    public void sendMessage(String string, GroupMemberId groupMemberId, byte[] byArray) throws HAParameterRejectedException, NotReadyToSendMessageException, DataStackException {
        if (byArray == null) {
            throw new HAParameterRejectedException("The message is null");
        }
        ManagerSelectionCriteria managerSelectionCriteria = this.checkAndGetMgdName(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sending point to point message", new Object[]{string, groupMemberId});
        }
        managerSelectionCriteria.canUserSendMessage();
        this.ivVsGroup.sendMessage(MSG_QOS, groupMemberId, managerSelectionCriteria.attachMessageHeader(byArray));
    }

    public void sendMessage(String string, byte[] byArray) throws HAParameterRejectedException, NotReadyToSendMessageException, DataStackException {
        if (byArray == null) {
            throw new HAParameterRejectedException("The message is null");
        }
        ManagerSelectionCriteria managerSelectionCriteria = this.checkAndGetMgdName(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sending multicast message", string);
        }
        managerSelectionCriteria.canUserSendMessage();
        this.ivVsGroup.sendMessage(MSG_QOS, managerSelectionCriteria.attachMessageHeader(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagerSelectionCriteria checkAndGetMgdName(String string) throws HAParameterRejectedException {
        if (string == null) {
            throw new HAParameterRejectedException("A null manager set name is not allowed.");
        }
        if (string.length() == 0) {
            throw new HAParameterRejectedException("An empty manager set name is not allowed.");
        }
        Map map = this.ivCriteriaMap;
        synchronized (map) {
            ManagerSelectionCriteria managerSelectionCriteria = (ManagerSelectionCriteria)this.ivCriteriaMap.get(string);
            if (managerSelectionCriteria == null) {
                throw new HAParameterRejectedException("No ManagerSelectionCriteria found for " + string);
            }
            return managerSelectionCriteria;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagerSelectionCriteria getManagerSelectionCriteria(String string) {
        Map map = this.ivCriteriaMap;
        synchronized (map) {
            ManagerSelectionCriteria managerSelectionCriteria = (ManagerSelectionCriteria)this.ivCriteriaMap.get(string);
            return managerSelectionCriteria;
        }
    }

    private DissectedMessage unpackMessage(byte[] byArray) {
        if (byArray.length < PMG_MESSAGE_HEADER_BYTES_LENGTH + 1) {
            return new DissectedMessage(null, null);
        }
        byte[] byArray2 = new byte[PMG_MESSAGE_HEADER_BYTES_LENGTH];
        System.arraycopy(byArray, 0, byArray2, 0, PMG_MESSAGE_HEADER_BYTES_LENGTH);
        if (!Arrays.equals(PMG_MESSAGE_HEADER_BYTES, byArray2)) {
            return new DissectedMessage(null, null);
        }
        byte by = byArray[PMG_MESSAGE_HEADER_BYTES_LENGTH];
        if (by < 1) {
            return new DissectedMessage(null, null);
        }
        byte[] byArray3 = new byte[by];
        int n = PMG_MESSAGE_HEADER_BYTES_LENGTH + 1 + by;
        byte[] byArray4 = new byte[byArray.length - n];
        System.arraycopy(byArray, PMG_MESSAGE_HEADER_BYTES_LENGTH + 1, byArray3, 0, by);
        System.arraycopy(byArray, n, byArray4, 0, byArray4.length);
        String string = null;
        try {
            string = new String(byArray3, UNIVERSAL_CODE_SET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, className, "712", this);
        }
        return new DissectedMessage(string, byArray4);
    }

    private void nonManager(String string, ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback, boolean bl) throws HAParameterRejectedException {
        GroupMemberId[] groupMemberIdArray = managerSelectionCriteria.getCopyOfManagers();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "nonManager", groupMemberIdArray);
        }
        managedGroupCallback.notElectedAsManager(groupMemberIdArray);
        if (groupMemberIdArray.length == 0) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "nonManager - no managers available");
            }
        } else {
            if (bl) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "nonManager - sending local state to managers");
                }
                this.sendLocalStateToManagers(managerSelectionCriteria, managedGroupCallback);
            }
            managerSelectionCriteria.stateIdle();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "nonManager - stabilized(IDLE)- mgdName=" + string);
            }
            managedGroupCallback.stabilized(MemberStateEnum.IDLE);
        }
    }

    private void managerChange(String string, ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback) throws HAParameterRejectedException {
        GroupMemberId[] groupMemberIdArray = managerSelectionCriteria.getCopyOfManagers();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "managerChange", groupMemberIdArray);
        }
        HashSet<GroupMemberId> hashSet = new HashSet<GroupMemberId>();
        for (int i = 0; i < this.ivMembers.length; ++i) {
            hashSet.add(this.ivMembers[i]);
        }
        managerSelectionCriteria.stateActivating(hashSet);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "managerChangeAmManager - electedAsManagerBegin()- mgdName=" + string);
        }
        managedGroupCallback.electedAsManagerBegin();
        if (TC.isEventEnabled()) {
            Tr.event(TC, "managerChangeAmManager - Start ManagerStateRebuild", hashSet);
        }
        this.sendLocalStateToManagers(managerSelectionCriteria, managedGroupCallback);
    }

    private void noManagerChange(String string, ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback, GroupMemberId[] groupMemberIdArray) {
        int n;
        Object object;
        int n2;
        HashSet<GroupMemberId> hashSet = new HashSet<GroupMemberId>();
        HashSet<GroupMemberId> hashSet2 = new HashSet<GroupMemberId>();
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            hashSet.add(groupMemberIdArray[i]);
            hashSet2.add(groupMemberIdArray[i]);
        }
        HashSet<GroupMemberId> hashSet3 = new HashSet<GroupMemberId>();
        for (n2 = 0; n2 < this.ivMembers.length; ++n2) {
            hashSet2.remove(this.ivMembers[n2]);
            if (hashSet.contains(this.ivMembers[n2])) continue;
            hashSet3.add(this.ivMembers[n2]);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "noManagerChangeAmManager - removed", hashSet);
            Tr.debug(TC, "noManagerChangeAmManager - added", hashSet3);
        }
        n2 = 1;
        boolean bl = false;
        if (managerSelectionCriteria.waitingForState()) {
            Object object2;
            if (managerSelectionCriteria.isStateComplete(hashSet2)) {
                managerSelectionCriteria.removeDeadServerState(hashSet2);
                object2 = managerSelectionCriteria.getAllStateMessages();
                if (managerSelectionCriteria.isRebuildInProgress()) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "noManagerChangeAmManager complete electedAsManagerEnd()- mgdName=" + string);
                    }
                    managedGroupCallback.electedAsManagerEnd((Map)object2);
                    bl = true;
                    n2 = 0;
                } else if (!object2.isEmpty()) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "noManagerChangeAmManager complete newServersOnline()- mgdName=" + string);
                    }
                    managedGroupCallback.newServersOnline((Map)object2);
                    bl = true;
                }
            } else {
                object2 = managerSelectionCriteria.getStateNeededList();
                object = "mgdName=" + string + ", missing state from:" + object2;
                Object[] objectArray = new Object[]{"PartitionedManagerGroup", "noManagerChange", object};
                Tr.error(TC, "HMGR0108", objectArray);
            }
        }
        if (n2 != 0 && (n = hashSet2.size()) > 0) {
            object = new GroupMemberId[n];
            hashSet2.toArray((T[])object);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "noManagerChangeAmManager - removeDeadServers()- mgdName=" + string);
            }
            managedGroupCallback.removeDeadServers((GroupMemberId[])object);
        }
        if (hashSet3.size() > 0) {
            managerSelectionCriteria.stateNewServers(hashSet3);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "noManagerChangeAmManager - waitingForNewServers()- mgdName=" + string);
            }
            managedGroupCallback.waitingForNewServers();
        } else {
            managerSelectionCriteria.stateActive();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "noManagerChangeAmManager - stabilized(ACTIVE)- mgdName=" + string);
            }
            managedGroupCallback.stabilized(MemberStateEnum.ACTIVE);
            if (bl) {
                this.deliverQueuedAppMsgs(managerSelectionCriteria, managedGroupCallback);
            }
        }
    }

    private void sendLocalStateToManagers(ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback) throws HAParameterRejectedException {
        GroupMemberId[] groupMemberIdArray = managerSelectionCriteria.getCopyOfManagers();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "sendLocalStateToManagers", groupMemberIdArray);
        }
        byte[][] byArray = managedGroupCallback.getLocalState(groupMemberIdArray);
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            try {
                byte[] byArray2 = byArray[i];
                if (byArray2 == null) {
                    throw new HAParameterRejectedException("Null state message at index " + i);
                }
                byte[] byArray3 = managerSelectionCriteria.attachMessageHeader(byArray[i]);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "sendLocalStateToManagers - send " + byArray3.length + " bytes", groupMemberIdArray[i]);
                }
                boolean bl = false;
                while (!bl) {
                    try {
                        this.ivVsGroup.sendMessage(MSG_QOS, groupMemberIdArray[i], byArray3);
                        bl = true;
                    }
                    catch (DataStackCongestionException dataStackCongestionException) {
                        FFDCFilter.processException((Throwable)dataStackCongestionException, className, "791", this);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "sendLocalStateToManagers - congestion", dataStackCongestionException);
                        }
                        Thread.yield();
                    }
                }
                continue;
            }
            catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
                FFDCFilter.processException((Throwable)dataStackMembershipChangingException, className, "803", this);
                continue;
            }
            catch (DataStackMemberException dataStackMemberException) {
                FFDCFilter.processException((Throwable)dataStackMemberException, className, "807", this);
                Tr.info(TC, "HMGR2000", new Object[]{groupMemberIdArray[i], dataStackMemberException});
                continue;
            }
            catch (DataStackClosedException dataStackClosedException) {
                FFDCFilter.processException((Throwable)dataStackClosedException, className, "812", this);
                Tr.info(TC, "HMGR2000", new Object[]{groupMemberIdArray[i], dataStackClosedException});
                continue;
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, className, "818", this);
                Tr.error(TC, "HMGR2001", new Object[]{groupMemberIdArray[i], hAException});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStateMessage(String string, ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback, GroupMemberId groupMemberId, DissectedMessage dissectedMessage) {
        boolean bl;
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, groupMemberId, dissectedMessage.ivMessage.length};
            Tr.debug(TC, "processStateMessage - received state message", objectArray);
        }
        if (!(bl = managerSelectionCriteria.stateReceived(groupMemberId, dissectedMessage.ivMessage))) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processStateMessage - not last sender");
            }
        } else {
            Object object;
            Map map = managerSelectionCriteria.getAllStateMessages();
            if (TC.isDebugEnabled()) {
                object = this.convertStateMap(map);
                Tr.debug(TC, "processStateMessage", new Object[]{string, map.size(), object});
            }
            if (managerSelectionCriteria.isRebuildInProgress()) {
                managedGroupCallback.electedAsManagerEnd(map);
            } else {
                managedGroupCallback.newServersOnline(map);
            }
            object = managerSelectionCriteria.getState();
            ManagerSelectionCriteria managerSelectionCriteria2 = managerSelectionCriteria;
            synchronized (managerSelectionCriteria2) {
                managerSelectionCriteria.stateActive();
                if (((MemberStateEnum)object).equals(MemberStateEnum.NOT_READY_CC)) {
                    managerSelectionCriteria.stateNotReadyCC();
                }
            }
            object = managerSelectionCriteria.getState();
            if (((MemberStateEnum)object).equals(MemberStateEnum.ACTIVE)) {
                managedGroupCallback.stabilized(MemberStateEnum.ACTIVE);
            }
            this.deliverQueuedAppMsgs(managerSelectionCriteria, managedGroupCallback);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processStateMessage", "manager rebuild complete");
            }
        }
    }

    private void deliverQueuedAppMsgs(ManagerSelectionCriteria managerSelectionCriteria, ManagedGroupCallback managedGroupCallback) {
        LinkedList linkedList = managerSelectionCriteria.getQueuedMessages();
        if (linkedList != null) {
            int n = linkedList.size();
            for (int i = 0; i < n; ++i) {
                ApplicationMessage applicationMessage = (ApplicationMessage)linkedList.removeFirst();
                managedGroupCallback.onMessage(applicationMessage.ivSender, applicationMessage.ivMessage);
            }
        }
    }

    private void terminatePMG(String string, String string2, String string3, Throwable throwable) {
        Tr.error(TC, "HMGR2002", new Object[]{string, string2, string3, throwable});
        try {
            this.stop();
            for (int i = 0; i < this.ivCallbacks.length; ++i) {
                this.ivCallbacks[i].forcedToLeaveHAGroup(string2, string3, throwable);
            }
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException(throwable2, className, "990", this);
        }
    }

    private String convertStateMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = map.keySet();
        int n = 0;
        int n2 = 0;
        GroupMemberId groupMemberId = null;
        Iterator iterator = set.iterator();
        try {
            while (iterator.hasNext()) {
                groupMemberId = (GroupMemberId)iterator.next();
                n2 = ((byte[])map.get(groupMemberId)).length;
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(groupMemberId.getServerName());
                stringBuffer.append(" --> " + String.valueOf(n2) + " bytes");
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, className, "1026", this);
            return "Error while converting the statemap to a displayable form.";
        }
    }

    static {
        try {
            PMG_MESSAGE_HEADER_BYTES = PMG_MESSAGE_HEADER.getBytes(UNIVERSAL_CODE_SET_NAME);
            PMG_MESSAGE_HEADER_BYTES_LENGTH = PMG_MESSAGE_HEADER_BYTES.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException(unsupportedEncodingException, className, "161");
        }
    }

    private class PMGCallback
    implements UserCallback {
        private PartitionedManagerGroupImpl ivPMG;
        private int ivOperation;
        private String ivUserCallbackName;
        private GroupName ivGroupName;
        private GroupMemberId[] ivMembers1;

        PMGCallback(int n, GroupName groupName, GroupMemberId[] groupMemberIdArray) {
            this.ivPMG = PartitionedManagerGroupImpl.this;
            this.ivOperation = n;
            this.ivGroupName = groupName;
            this.ivMembers1 = groupMemberIdArray;
            this.ivUserCallbackName = className;
        }

        public void doCallback() {
            switch (this.ivOperation) {
                case 0: {
                    this.ivPMG.membershipChanged(this.ivGroupName, this.ivMembers1);
                }
            }
        }

        public int getQueue(int n) {
            int n2 = Math.abs(this.ivPMG.hashCode());
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n2 % n;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getQueue() - PMG hashcode=" + n2 + ", number of queues=" + n + ", hc % numberOfQueues=" + n3);
            }
            return n3;
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }
    }

    private class ApplicationMessage {
        private GroupMemberId ivSender;
        private byte[] ivMessage;

        public ApplicationMessage(GroupMemberId groupMemberId, byte[] byArray) {
            this.ivSender = groupMemberId;
            this.ivMessage = byArray;
        }
    }

    private class DissectedMessage {
        private String ivMgdName = null;
        private byte[] ivMessage = null;
        private boolean ivValidMgdName = false;

        public DissectedMessage(String string, byte[] byArray) {
            this.ivMgdName = string;
            this.ivMessage = byArray;
            this.ivValidMgdName = string == null ? false : PartitionedManagerGroupImpl.this.ivCriteriaMap.containsKey(string);
        }
    }

    private class ManagerSelectionCriteria {
        private ManagedGroupData ivMGD;
        private String ivMgdName;
        private byte[] ivMgdNameBytes = null;
        private String ivIsManagerKey = null;
        private GroupMemberId[] ivManagers = null;
        private MemberStateEnum ivState = null;
        private Map ivStateReceived;
        private Set ivStateNeeded;
        private boolean ivRebuildInProgress = false;
        private LinkedList ivQueuedApplicationMessages;

        public ManagerSelectionCriteria(ManagedGroupData managedGroupData, String string) {
            this.ivMGD = managedGroupData;
            this.ivMgdName = managedGroupData.getManagerSetName();
            this.ivIsManagerKey = string;
            try {
                this.ivMgdNameBytes = this.ivMgdName.getBytes(PartitionedManagerGroupImpl.UNIVERSAL_CODE_SET_NAME);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, className, "1086", this);
            }
            this.ivManagers = new GroupMemberId[0];
            this.ivState = MemberStateEnum.NOT_READY;
            this.ivQueuedApplicationMessages = new LinkedList();
        }

        ManagedGroupData getManagedGroupData() {
            return this.ivMGD;
        }

        synchronized GroupMemberId[] getCopyOfManagers() {
            GroupMemberId[] groupMemberIdArray = new GroupMemberId[this.ivManagers.length];
            System.arraycopy(this.ivManagers, 0, groupMemberIdArray, 0, this.ivManagers.length);
            return groupMemberIdArray;
        }

        synchronized MemberStateEnum getState() {
            return this.ivState;
        }

        synchronized void stateNotReady() {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "stateNotReady() - mgdName=" + this.ivMgdName + ", previous state=" + this.ivState);
            }
            this.ivState = MemberStateEnum.NOT_READY;
        }

        synchronized void stateNotReadyCC() {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "stateNotReadyCC() - mgdName=" + this.ivMgdName + ", previous state=" + this.ivState);
            }
            this.ivState = MemberStateEnum.NOT_READY_CC;
        }

        synchronized void stateIdle() {
            this.ivState = MemberStateEnum.IDLE;
            this.ivStateNeeded = null;
            this.ivStateReceived = null;
            this.ivRebuildInProgress = false;
        }

        synchronized void stateActive() {
            this.ivState = MemberStateEnum.ACTIVE;
            this.ivStateNeeded = null;
            this.ivStateReceived = null;
            this.ivRebuildInProgress = false;
        }

        synchronized void stateActivating(Set set) {
            this.ivState = MemberStateEnum.ACTIVATING;
            this.ivStateNeeded = set;
            this.ivStateReceived = new HashMap();
            this.ivRebuildInProgress = true;
        }

        synchronized void stateNewServers(Set set) {
            this.ivState = MemberStateEnum.NEW_SERVERS;
            this.ivStateNeeded = set;
            this.ivStateReceived = new HashMap();
            this.ivRebuildInProgress = false;
        }

        synchronized void canUserSendMessage() throws NotReadyToSendMessageException {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "canUserSendMessage() - mgdName=" + this.ivMgdName + ", state=" + this.ivState);
            }
            if (this.ivState.equals(MemberStateEnum.ACTIVE) || this.ivState.equals(MemberStateEnum.IDLE)) {
                return;
            }
            throw new NotReadyToSendMessageException("The PMG for " + this.ivMgdName + " is in state " + this.ivState);
        }

        synchronized boolean isServerAManager(String string) {
            for (int i = 0; i < this.ivManagers.length; ++i) {
                if (!this.ivManagers[i].getServerName().equals(string)) continue;
                return true;
            }
            return false;
        }

        synchronized boolean needStateFromMember(GroupMemberId groupMemberId) {
            if (this.ivStateNeeded == null) {
                return false;
            }
            return this.ivStateNeeded.contains(groupMemberId);
        }

        synchronized boolean stateReceived(GroupMemberId groupMemberId, byte[] byArray) {
            this.ivStateReceived.put(groupMemberId, byArray);
            this.ivStateNeeded.remove(groupMemberId);
            return this.ivStateNeeded.size() == 0;
        }

        synchronized Map getAllStateMessages() {
            Map map = this.ivStateReceived;
            this.ivStateReceived = null;
            return map;
        }

        synchronized boolean waitingForState() {
            return this.ivStateNeeded != null;
        }

        synchronized boolean isStateComplete(Set set) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.ivStateNeeded.remove(iterator.next());
            }
            return this.ivStateNeeded.size() == 0;
        }

        synchronized void removeDeadServerState(Set set) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.ivStateReceived.remove(iterator.next());
            }
        }

        synchronized boolean isRebuildInProgress() {
            return this.ivRebuildInProgress;
        }

        synchronized Set getStateNeededList() {
            if (this.ivStateNeeded != null) {
                return this.ivStateNeeded;
            }
            return new HashSet();
        }

        synchronized void queueApplicationMessage(GroupMemberId groupMemberId, byte[] byArray) {
            if (this.ivQueuedApplicationMessages == null) {
                this.ivQueuedApplicationMessages = new LinkedList();
            }
            this.ivQueuedApplicationMessages.addLast(new ApplicationMessage(groupMemberId, byArray));
        }

        synchronized LinkedList getQueuedMessages() {
            LinkedList linkedList = this.ivQueuedApplicationMessages;
            this.ivQueuedApplicationMessages = null;
            return linkedList;
        }

        byte[] attachMessageHeader(byte[] byArray) {
            int n = PMG_MESSAGE_HEADER_BYTES_LENGTH + 1 + this.ivMgdNameBytes.length + byArray.length;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            System.arraycopy(PMG_MESSAGE_HEADER_BYTES, 0, byArray2, n2, PMG_MESSAGE_HEADER_BYTES_LENGTH);
            byArray2[n2 += PMG_MESSAGE_HEADER_BYTES_LENGTH] = (byte)this.ivMgdName.length();
            System.arraycopy(this.ivMgdNameBytes, 0, byArray2, ++n2, this.ivMgdNameBytes.length);
            System.arraycopy(byArray, 0, byArray2, n2 += this.ivMgdNameBytes.length, byArray.length);
            return byArray2;
        }

        synchronized boolean calculateManagers(GroupMemberId[] groupMemberIdArray) {
            int n;
            int n2;
            int n3;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculateManagers", groupMemberIdArray);
            }
            Object[] objectArray = this.ivManagers;
            this.ivManagers = new GroupMemberId[0];
            ArrayList<GroupMemberId> arrayList = new ArrayList<GroupMemberId>(groupMemberIdArray.length);
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                if (this.ivMGD.isFixedManagers() && !this.isManager(groupMemberIdArray[i])) continue;
                arrayList.add(groupMemberIdArray[i]);
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculateManagers - candidate Managers", arrayList);
            }
            Object[] objectArray2 = new SortableGroupMemberId[arrayList.size()];
            int n4 = n3 = this.ivMGD.getPreferredManagers().size() + 1;
            Integer n5 = null;
            for (n2 = 0; n2 < arrayList.size(); n2 += 1) {
                GroupMemberId groupMemberId = (GroupMemberId)arrayList.get(n2);
                n5 = (Integer)this.ivMGD.getPreferredManagers().get(groupMemberId.getServerName());
                n4 = n5 == null ? n3 : n5;
                objectArray2[n2] = new SortableGroupMemberId(groupMemberId, n2, n4);
            }
            Arrays.sort(objectArray2);
            int n6 = n2 = objectArray2.length < this.ivMGD.getNumberOfManagers() ? objectArray2.length : this.ivMGD.getNumberOfManagers();
            if (this.ivMGD.isRestrictToPreferred()) {
                for (int i = 0; i < n2; i += 1) {
                    Object object = objectArray2[i];
                    if (((SortableGroupMemberId)object).getPriority() != this.ivMGD.getPreferredManagers().size() + 1) continue;
                    n2 = i;
                    break;
                }
            }
            this.ivManagers = new GroupMemberId[n2];
            for (n = 0; n < n2; n += 1) {
                this.ivManagers[n] = (GroupMemberId)arrayList.get(((SortableGroupMemberId)objectArray2[n]).getIndex());
            }
            int n7 = n = !Arrays.equals(objectArray, this.ivManagers) ? 1 : 0;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculateManagers - oldManagers ", objectArray);
                Tr.debug(TC, "calculateManagers - newManagers ", this.ivManagers);
                Tr.debug(TC, "calculateManagers - managers have changed", n != 0);
            }
            return n != 0;
        }

        private boolean isManager(GroupMemberId groupMemberId) {
            String string = (String)groupMemberId.getMemberProperties().get(this.ivIsManagerKey);
            if (string == null) {
                String string2 = DebugUtils.dumpMap("memberProperties", groupMemberId.getMemberProperties());
                System.err.println("The MemberMap for " + this.ivMgdName + " does not contain key " + this.ivIsManagerKey + " in " + string2);
                return false;
            }
            return string.equals("1");
        }
    }
}

