/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.pmi;

import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.ws.pmi.server.PmiRegistry;

public final class HAManagerPerfModule
extends PmiAbstractModule
implements HAManagerPerf {
    private static final long serialVersionUID = -7961101465444694924L;
    public static final String moduleID = "hamanagerModule";
    private static final int defaultLevel = 0;
    private SpdLoad numLocalGroups = null;
    private SpdStat rebuildTime = null;
    private SpdLoad bbMgrNumSubjects = null;
    private SpdLoad bbMgrNumSubscriptions = null;
    private SpdStat bbMgrRebuildTime = null;
    private SpdLoad bbLocalNumSubjects = null;
    private SpdLoad bbLocalNumSubscriptions = null;

    public HAManagerPerfModule(String string) {
        super(moduleID, string);
        if (!PmiRegistry.isDisabled()) {
            this.registerModule(this);
        }
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 1: {
                this.numLocalGroups = spdLoad;
                return true;
            }
            case 3: {
                this.bbMgrNumSubjects = spdLoad;
                return true;
            }
            case 4: {
                this.bbMgrNumSubscriptions = spdLoad;
                return true;
            }
            case 6: {
                this.bbLocalNumSubjects = spdLoad;
                return true;
            }
            case 7: {
                this.bbLocalNumSubscriptions = spdLoad;
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 2: {
                this.rebuildTime = spdStat;
                return true;
            }
            case 5: {
                this.bbMgrRebuildTime = spdStat;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void groupJoin(int n) {
        if (this.numLocalGroups != null) {
            this.numLocalGroups.add(n);
        }
    }

    public void groupLeave(int n) {
        if (this.numLocalGroups != null) {
            this.numLocalGroups.add(n);
        }
    }

    public void groupServicesRebuildComplete(long l) {
        if (this.rebuildTime != null) {
            this.rebuildTime.add(l);
        }
    }

    public void bbRebuildComplete(long l) {
        if (this.bbMgrRebuildTime != null) {
            this.bbMgrRebuildTime.add(l);
        }
    }

    public void bbReportPopulation(int n, int n2) {
        if (this.bbMgrNumSubjects != null) {
            this.bbMgrNumSubjects.add(n);
        }
        if (this.bbMgrNumSubscriptions != null) {
            this.bbMgrNumSubscriptions.add(n2);
        }
    }

    public void bbLocalReportSubjects(int n) {
        if (this.bbLocalNumSubjects != null) {
            this.bbLocalNumSubjects.add(n);
        }
    }

    public void bbLocalReportSubscriptions(int n) {
        if (this.bbLocalNumSubscriptions != null) {
            this.bbLocalNumSubscriptions.add(n);
        }
    }

    public boolean isGroupServiceRebuildTimeEnabled() {
        return this.rebuildTime != null;
    }

    public boolean isBulletinBoardRebuildTimeEnabled() {
        return this.bbMgrRebuildTime != null;
    }
}

