/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.proxy.ControllerHAGroupManager;
import com.ibm.ws.hamanager.proxy.ControllerProxiedGroup;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.JVMListenerInterface;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAGroupMemberAlreadyExistsException;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.HARuntimeException;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.rmi.PortableRemoteObject;

public class ControllerHAGroupManagerImpl
extends PortableRemoteObject
implements ControllerHAGroupManager,
HAGroupCallback,
JVMListenerInterface {
    private static final TraceComponent TC = Tr.register(ControllerHAGroupManagerImpl.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    GroupManager groupManager;
    HashMap groupNameToGroupMap;

    public ControllerHAGroupManagerImpl(CoreStack coreStack) throws RemoteException {
        this.groupManager = coreStack.getGroupManager();
        this.groupNameToGroupMap = new HashMap();
        AdminHelper.getPlatformHelper().register_initial_reference("ControllerHAGroupManager", this);
        AdminHelper.getPlatformHelper().registerListener(this);
    }

    public String getServerName() throws RemoteException {
        return this.groupManager.getServerName();
    }

    public GroupName createGroupName(Map map) throws RemoteException, HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.createGroupName", map);
        }
        GroupName groupName = this.groupManager.createGroupName(map);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.createGroupName", groupName);
        }
        return groupName;
    }

    public synchronized void joinGroup(String string, GroupName groupName, Map map, boolean bl) throws RemoteException, HAException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.joinGroup", new Object[]{string, groupName, map, new Boolean(bl)});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            if (controllerProxiedGroup.processStoken.equals(string)) {
                throw new HAGroupMemberAlreadyExistsException("The member already exists");
            }
            try {
                this.leave(controllerProxiedGroup.processStoken, groupName);
            }
            catch (HAGroupLeftException hAGroupLeftException) {
                FFDCFilter.processException((Throwable)hAGroupLeftException, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.joinGroup", "126", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ControllerHAGroupManagerImpl.joinGroup", "Out of sync condition cleaning up group " + groupName);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.joinGroup", "132", this);
                Tr.event(TC, "ControllerHAGroupManagerImpl.joinGroup", exception);
            }
        }
        controllerProxiedGroup = new ControllerProxiedGroup(string);
        this.addGroupName(groupName, controllerProxiedGroup);
        if (bl) {
            try {
                controllerProxiedGroup.setupForCallbacks();
                controllerProxiedGroup.controllerGroup = this.groupManager.joinGroup(groupName, map, this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.joinGroup", "169", this);
                this.removeGroupName(groupName);
                throw new HAException("Error during joinGroup processing", throwable);
            }
        } else {
            controllerProxiedGroup.memberProps = map;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.joinGroup");
        }
    }

    public GroupMemberId getMemberName(GroupName groupName) throws RemoteException, HAGroupLeftException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.getMemberName", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.getMemberName", "Method called on a proxied HAGroup that has been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has been left " + groupName);
        }
        GroupMemberId groupMemberId = controllerProxiedGroup.controllerGroup.getMemberName();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.getMemberName", groupMemberId);
        }
        return groupMemberId;
    }

    public GroupMemberState getMemberState(GroupName groupName) throws RemoteException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.getMemberState", groupName);
        }
        GroupMemberState groupMemberState = (controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null ? controllerProxiedGroup.controllerGroup.getMemberState() : GroupMemberState.LEFT;
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.getMemberState", groupMemberState);
        }
        return groupMemberState;
    }

    public synchronized void leave(String string, GroupName groupName) throws RemoteException, HAGroupLeftException, HAInternalStateException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.leave", new Object[]{string, groupName});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            this.removeGroupName(groupName);
            if (controllerProxiedGroup.controllerGroup != null) {
                controllerProxiedGroup.controllerGroup.leave();
            }
        } else {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.leave", "Method called on a proxied HAGroup that has already been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has already been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.leave");
        }
    }

    public void setVersionString(GroupName groupName, String string) throws RemoteException, HAGroupLeftException, HAParameterRejectedException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.setVersionString", new Object[]{groupName, string});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.setVersionString", "Method called on a proxied HAGroup that has been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has already been left " + groupName);
        }
        controllerProxiedGroup.controllerGroup.setVersionString(string);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.setVersionString");
        }
    }

    public String getVersionString(GroupName groupName) throws RemoteException, HAGroupLeftException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.getVersionString", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.getVersionString", "Method called on a proxied HAGroup that has been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has been left " + groupName);
        }
        String string = controllerProxiedGroup.controllerGroup.getVersionString();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.getVersionString", string);
        }
        return string;
    }

    public void enableMember(GroupName groupName) throws RemoteException, HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.enableMember", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.enableMember", "Method called on a proxied HAGroup that has been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has been left " + groupName);
        }
        controllerProxiedGroup.controllerGroup.enableMember();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.enableMember");
        }
    }

    public void disableMember(GroupName groupName, String string) throws RemoteException, HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.disableMember", new Object[]{groupName, string});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "ControllerHAGroupManagerImpl.disableMember", "Method called on a proxied HAGroup that has been left " + groupName);
            }
            throw new HAGroupLeftException("Method called on a proxied HAGroup that has been left " + groupName);
        }
        controllerProxiedGroup.controllerGroup.disableMember(string);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.disableMember");
        }
    }

    public void memberMayActivate(GroupName groupName) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.memberMayActivate", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.memberMayActivate(groupName);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.memberMayActivate", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.memberMayActivate");
        }
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.memberMayActivateCancelled", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.memberMayActivateCancelled(groupName);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.memberMayActivateCancelled", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.memberMayActivateCancelled");
        }
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.memberIsActivated", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.activateProcess(groupName, asynchOperationComplete, object);
        } else {
            try {
                asynchOperationComplete.failed(object, "Adjunct process left group", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.memberIsActivated", "446", this);
                Tr.event(TC, "ControllerHAGroupManagerImpl.memberIsActivated", exception);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.memberIsActivated");
        }
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.memberDeactivated", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.deactivateProcess(groupName, asynchOperationComplete, object);
        } else {
            try {
                asynchOperationComplete.failed(object, "Adjunct process left group", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.memberDeactivate", "481", this);
                Tr.event(TC, "ControllerHAGroupManagerImpl.memberDeactivated", exception);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.memberDeactivated");
        }
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.membershipChanged", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.membershipChanged(groupName, groupMemberIdArray);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.membershipChanged", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.membershipChanged");
        }
    }

    public boolean isAlive(GroupName groupName) {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.isAlive", groupName);
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            try {
                controllerProxiedGroup.isAlive(groupName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.isAlive", "552", this);
                Tr.event(TC, "ControllerHAGroupManagerImpl.isAlive", exception);
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.isAlive", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.isAlive");
        }
        return true;
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.onMessage", new Object[]{groupMemberId, byArray});
        }
        throw new HARuntimeException("onMessage not supported by proxy");
    }

    public void success(GroupName groupName, Object object, int n) throws RemoteException, HAParameterRejectedException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.success", new Object[]{groupName, object, new Integer(n)});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.callbackSucceeded(groupName, object, n);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.success", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.success");
        }
    }

    public void failed(GroupName groupName, String string, Object object, int n) throws RemoteException, HAParameterRejectedException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Object,int)", new Object[]{groupName, string, object, new Integer(n)});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.callbackFailed(groupName, string, object, n);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Object,int)", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Object,int)");
        }
    }

    public void failed(GroupName groupName, String string, Throwable throwable, Object object, int n) throws RemoteException, HAParameterRejectedException {
        ControllerProxiedGroup controllerProxiedGroup;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Throwable,Object,int)", new Object[]{groupName, string, throwable, object, new Integer(n)});
        }
        if ((controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName)) != null) {
            controllerProxiedGroup.callbackFailed(groupName, string, throwable, object, n);
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Throwable,Object,int)", "Method called on a proxied HAGroup that has been left " + groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.failed(GroupName,String,Throwable,Object,int)");
        }
    }

    public synchronized void servantInitialized(String string) throws RemoteException, HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.servantInitialized", string);
        }
        try {
            Iterator iterator = this.groupNameToGroupMap.keySet().iterator();
            while (iterator.hasNext()) {
                GroupName groupName = (GroupName)iterator.next();
                ControllerProxiedGroup controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ControllerHAGroupManagerImpl.servantInitialized", "Checking process stoken=" + controllerProxiedGroup.processStoken + " group=" + groupName);
                }
                if (!controllerProxiedGroup.processStoken.equals(string) || controllerProxiedGroup.controllerGroup != null) continue;
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ControllerHAGroupManagerImpl.servantInitialized", "Joining real HA group");
                }
                controllerProxiedGroup.setupForCallbacks();
                controllerProxiedGroup.controllerGroup = this.groupManager.joinGroup(groupName, controllerProxiedGroup.memberProps, this);
                controllerProxiedGroup.memberProps = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.servantInitialized", "680", this);
            Tr.event(TC, "ControllerHAGroupManagerImpl.servantInitialized", exception);
            throw new HAException("Error during servantInitialized processing", exception);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.servantInitialized");
        }
    }

    public synchronized void servantTerminated(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "ControllerHAGroupManagerImpl.servantTerminated", string);
        }
        Iterator iterator = this.groupNameToGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            GroupName groupName = (GroupName)iterator.next();
            ControllerProxiedGroup controllerProxiedGroup = (ControllerProxiedGroup)this.groupNameToGroupMap.get(groupName);
            try {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ControllerHAGroupManagerImpl.servantTerminated", "Checking process stoken=" + controllerProxiedGroup.processStoken + " group=" + groupName);
                }
                if (!controllerProxiedGroup.processStoken.equals(string)) continue;
                iterator.remove();
                if (controllerProxiedGroup.controllerGroup == null) continue;
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ControllerHAGroupManagerImpl.servantTerminated", "Leaving group for ended process");
                }
                controllerProxiedGroup.controllerGroup.leave();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl.servantTerminated", "744", this);
                Tr.event(TC, "ControllerHAGroupManagerImpl.servantTerminated", exception);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "ControllerHAGroupManagerImpl.servantTerminated");
        }
    }

    private void addGroupName(GroupName groupName, ControllerProxiedGroup controllerProxiedGroup) {
        this.groupNameToGroupMap.put(groupName, controllerProxiedGroup);
    }

    private void removeGroupName(GroupName groupName) {
        this.groupNameToGroupMap.remove(groupName);
    }
}

