/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.proxy.ControllerHAGroupManager;
import com.ibm.ws.hamanager.proxy.HAGroupProxyImpl;
import com.ibm.ws.hamanager.proxy.ProxyHelper;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HARuntimeException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupData;
import com.ibm.wsspi.hamanager.partitionedmanager.PartitionedManagerGroup;
import java.rmi.RemoteException;
import java.util.Map;

public class GroupManagerProxyImpl
implements GroupManager,
ServantInitializationListener {
    private static final TraceComponent TC = Tr.register(GroupManagerProxyImpl.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    ControllerHAGroupManager controller;
    boolean processInitialized = false;

    public GroupManagerProxyImpl() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.<init>");
        }
        this.controller = ProxyHelper.getController();
        try {
            AdminHelper.getPlatformHelper().registerListener(this);
        }
        catch (ServantInitializedException servantInitializedException) {
            FFDCFilter.processException((Throwable)servantInitializedException, "com.ibm.ws.hamanager.proxy.GroupManagerProxyImpl.GroupManagerProxyImpl", "68", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "GroupManagerProxyImpl.<init>", servantInitializedException);
            }
            this.processInitialized = true;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "GroupManagerProxyImpl.<init>");
        }
    }

    public String getServerName() {
        String string;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.getServerName");
        }
        try {
            string = this.controller.getServerName();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.GroupManagerProxyImpl.getServerName", "91", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in GroupManagerProxyImpl.getServerName", remoteException);
            }
            throw new HARuntimeException("RemoteException in GroupManagerProxyImpl.getServerName", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "GroupManagerProxyImpl.getServerName", string);
        }
        return string;
    }

    public GroupName createGroupName(Map map) throws HAException {
        GroupName groupName;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.createGroupName", map);
        }
        try {
            groupName = this.controller.createGroupName(map);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.GroupManagerProxyImpl.createGroupName", "118", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in GroupManagerProxyImpl.createGroupName", remoteException);
            }
            throw new HAException("RemoteException in GroupManagerProxyImpl.createGroupName", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "GroupManagerProxyImpl.createGroupName", groupName);
        }
        return groupName;
    }

    public synchronized HAGroup joinGroup(GroupName groupName, Map map, HAGroupCallback hAGroupCallback) throws HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.joinGroup", new Object[]{groupName, map, hAGroupCallback});
        }
        ProxyHelper.addCallback(groupName, hAGroupCallback);
        String string = ServerName.getPrintableStoken();
        try {
            this.controller.joinGroup(string, groupName, map, this.processInitialized);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.proxy.GroupManagerProxyImpl.joinGroup", "152", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Exception in GroupManagerProxyImpl.joinGroup", throwable);
            }
            ProxyHelper.removeCallback(groupName);
            throw new HAException("Exception in GroupManagerProxyImpl.joinGroup", throwable);
        }
        HAGroupProxyImpl hAGroupProxyImpl = new HAGroupProxyImpl(groupName, string, this.controller);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "GroupManagerProxyImpl.joinGroup");
        }
        return hAGroupProxyImpl;
    }

    public PartitionedManagerGroup createPartitionedManagerGroup(GroupName groupName, Map map, ManagedGroupData[] managedGroupDataArray) throws HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.createPartitionedManagerGroup");
        }
        throw new HAException("createPartitionedManagerGroup not supported by proxy");
    }

    public synchronized void servantInitialized(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "GroupManagerProxyImpl.servantInitialized");
        }
        this.processInitialized = true;
        try {
            this.controller.servantInitialized(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.proxy.GroupManagerProxyImpl.servantInitialized", "199", this);
            Tr.info(TC, "HMGR5015", exception);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "GroupManagerProxyImpl.servantInitialized");
        }
    }
}

