/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.proxy.ControllerHAGroupManager;
import com.ibm.ws.hamanager.proxy.ProxyHelper;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.HARuntimeException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.rmi.RemoteException;

public class HAGroupProxyImpl
implements HAGroup {
    private static final TraceComponent TC = Tr.register(HAGroupProxyImpl.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    GroupName groupName;
    String stoken;
    ControllerHAGroupManager controller;

    HAGroupProxyImpl(GroupName groupName, String string, ControllerHAGroupManager controllerHAGroupManager) {
        this.groupName = groupName;
        this.stoken = string;
        this.controller = controllerHAGroupManager;
    }

    public GroupName getGroupName() {
        return this.groupName;
    }

    public GroupMemberId getMemberName() throws HAGroupLeftException {
        GroupMemberId groupMemberId;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.getMemberName");
        }
        try {
            groupMemberId = this.controller.getMemberName(this.groupName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.getMemberName", "76", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.getMemberName", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.getMemberName", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.getMemberName");
        }
        return groupMemberId;
    }

    public GroupMemberState getMemberState() {
        GroupMemberState groupMemberState;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.getMemberState");
        }
        try {
            groupMemberState = this.controller.getMemberState(this.groupName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.getMemberState", "103", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.getMemberState", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.getMemberState", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.getMemberState");
        }
        return groupMemberState;
    }

    public void leave() throws HAGroupLeftException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.leave");
        }
        try {
            this.controller.leave(this.stoken, this.groupName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.leave", "129", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.leave", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.leave", remoteException);
        }
        finally {
            ProxyHelper.removeCallback(this.groupName);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.leave");
        }
    }

    public void setVersionString(String string) throws HAGroupLeftException, HAParameterRejectedException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.setVersionString", string);
        }
        try {
            this.controller.setVersionString(this.groupName, string);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.setVersionString", "156", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.setVersionString", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.setVersionString", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.setVersionString");
        }
    }

    public String getVersionString() throws HAGroupLeftException {
        String string;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.getVersionString");
        }
        try {
            string = this.controller.getVersionString(this.groupName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.getVersionString", "181", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.getVersionString", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.getVersionString", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.getVersionString", string);
        }
        return string;
    }

    public void enableMember() throws HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.enableMember");
        }
        try {
            this.controller.enableMember(this.groupName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.enableMember", "207", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.enableMember", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.enableMember", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.enableMember");
        }
    }

    public void disableMember(String string) throws HAIllegalRequestException, HAGroupLeftException, HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.disableMember", string);
        }
        try {
            this.controller.disableMember(this.groupName, string);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.hamanager.proxy.HAGroupProxyImpl.disableMember", "231", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "RemoteException in HAGroupProxyImpl.disableMember", remoteException);
            }
            throw new HARuntimeException("RemoteException in HAGroupProxyImpl.disableMember", remoteException);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "HAGroupProxyImpl.disableMember");
        }
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId groupMemberId, byte[] byArray) throws DataStackException, HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.sendMessage(MsgQoS, GroupMemberId, byte[])");
        }
        throw new HAException("sendMessage not supported by proxy");
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId[] groupMemberIdArray, byte[] byArray) throws DataStackException, HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.sendMessage(MsgQoS, GroupMemberId[], byte[])");
        }
        throw new HAException("sendMessage not supported by proxy");
    }

    public void sendMessage(MsgQoS msgQoS, byte[] byArray) throws DataStackException, HAException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.sendMessage(MsgQoS, byte[])");
        }
        throw new HAException("sendMessage not supported by proxy");
    }

    public boolean isHardwareQuorumEnforced() throws NoPolicyDefinedForGroupException, HAInternalStateException, DuplicatePoliciesMatchGroupException, IllegalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "HAGroupProxyImpl.isHardwareQuorumEnforced");
        }
        throw new HARuntimeException("isHardwareQuorumEnforced not supported by proxy");
    }
}

