/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.quorum;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.quorum.QuorumProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class QuorumProviderImpl
implements QuorumProvider {
    private static final TraceComponent TC = Tr.register(QuorumProviderImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "QuorumProviderImpl";
    private String ivClusterName;
    private String[] ivClusterMembers;
    private int ivClusterSize;
    private int ivQuorumSize;
    private Map ivMemberWeights;
    private boolean ivHasQuorum;
    private Set ivOnlineClusterMembers;
    private Set ivRemovedServers;
    private boolean ivServersPoweredDown = false;

    QuorumProviderImpl(String string) {
        this.ivClusterName = string;
        this.ivOnlineClusterMembers = new HashSet();
        this.ivRemovedServers = new HashSet();
    }

    public void initialize(String[] stringArray, String[] stringArray2) throws HAException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "initialize - cluster members", stringArray);
            Tr.debug(TC, "initialize - view members", stringArray2);
        }
        try {
            if (stringArray == null || stringArray.length == 0) {
                throw new HAInternalStateException("QuorumProviderImpl - no members in cluster " + this.ivClusterName);
            }
            this.ivClusterMembers = stringArray;
            this.ivClusterSize = stringArray.length;
            this.ivQuorumSize = this.ivClusterSize / 2 + 1;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "group size and quorum size", new Object[]{new Integer(this.ivClusterSize), new Integer(this.ivQuorumSize)});
            }
            this.ivMemberWeights = new HashMap();
            for (int i = 0; i < stringArray.length; ++i) {
                this.ivMemberWeights.put(stringArray[i], new Integer(1));
            }
            if (this.ivClusterSize % 2 == 0) {
                Object[] objectArray = new String[stringArray.length];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                Arrays.sort(objectArray);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "assigning extra vote", objectArray[0]);
                }
                this.ivMemberWeights.put(objectArray[0], new Integer(2));
            }
            this.updateOnlineClusterMembers(stringArray2);
            this.calculateQuorum();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "123", this);
            throw new HAInternalStateException("Unable to initialize QuorumProviderImpl", throwable);
        }
    }

    public Collection getOffLineMembers() {
        LinkedList linkedList = new LinkedList(this.ivMemberWeights.keySet());
        linkedList.removeAll(this.ivOnlineClusterMembers);
        return linkedList;
    }

    public Collection getFailedServers() {
        return this.ivRemovedServers;
    }

    public boolean wasServerPowerDownPerformed() {
        return this.ivServersPoweredDown;
    }

    public void serverPowerDownComplete() {
        this.ivServersPoweredDown = true;
    }

    public void recalcQuorum(String[] stringArray, Set set) throws HAException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "recalcQuorum - members", stringArray);
        }
        this.ivRemovedServers.clear();
        this.ivServersPoweredDown = false;
        boolean bl = this.updateOnlineClusterMembers(stringArray);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "member set changed", new Boolean(bl));
        }
        if (!bl) {
            return;
        }
        int n = this.calculateQuorum();
        if (!this.ivHasQuorum) {
            int n2 = this.ivOnlineClusterMembers.size();
            Tr.info(TC, "HMGR0134", new Object[]{this.ivClusterName, new Integer(n2), new Integer(n), new Integer(this.ivQuorumSize)});
        } else {
            Tr.info(TC, "HMGR0135", new Object[]{this.ivClusterName});
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.ivMemberWeights.containsKey(string)) continue;
                this.ivRemovedServers.add(string);
            }
        }
    }

    public boolean hasQuorum() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "hasQuorum", new Object[]{this.ivClusterName, new Boolean(this.ivHasQuorum), new Integer(this.ivClusterSize)});
        }
        return this.ivHasQuorum;
    }

    private int calculateQuorum() throws HAException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "calculateQuorum", this.ivOnlineClusterMembers);
        }
        if (this.ivMemberWeights == null) {
            throw new HAException("QuorumProvider - Member Weights not initialized");
        }
        if (this.ivOnlineClusterMembers.size() == 0) {
            this.ivHasQuorum = false;
            return 0;
        }
        int n = 0;
        Iterator iterator = this.ivOnlineClusterMembers.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n += ((Integer)this.ivMemberWeights.get(string)).intValue();
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "number of votes", new Integer(n));
        }
        boolean bl = this.ivHasQuorum = n >= this.ivQuorumSize;
        if (n == this.ivQuorumSize) {
            Tr.warning(TC, "HMGR0145", this.ivClusterName);
        }
        return n;
    }

    private boolean updateOnlineClusterMembers(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.ivClusterMembers.length;
        for (int i = 0; i < n; ++i) {
            String string = this.ivClusterMembers[i];
            if (!StringUtils.arrayContainsString(string, stringArray)) continue;
            hashSet.add(string);
        }
        if (this.ivOnlineClusterMembers.size() != hashSet.size()) {
            this.ivOnlineClusterMembers = hashSet;
            return true;
        }
        if (((Object)this.ivOnlineClusterMembers).equals(hashSet)) {
            return false;
        }
        this.ivOnlineClusterMembers = hashSet;
        return true;
    }
}

