/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.bboard.BulletinBoardJMXImpl;
import com.ibm.ws.hamanager.coordinator.StateExchangeListener;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackFactoryImpl;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.jmx.CoordinatorJMXImpl;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.ws.hamanager.pmi.HAManagerPerfModule;
import com.ibm.ws.hamanager.proxy.ControllerHAGroupManagerImpl;
import com.ibm.ws.hamanager.runtime.ConfigProviderImpl;
import com.ibm.ws.hamanager.runtime.DiagnosticMod;
import com.ibm.ws.hamanager.runtime.RuntimeProviderImpl;
import com.ibm.ws.hamanager.runtime.SecurityProviderImpl;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.ConfigDocChangeListener;
import com.ibm.ws.hamanager.runtime.config.StateBlobBuilder;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.agent.AgentClassFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardListener;
import com.ibm.wsspi.hamanager.bboard.CoreGroupBridgeUtilities;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackListener;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMembershipChangingException;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupDataFactory;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class CoordinatorComponentImpl
extends WsComponentImpl
implements CoreStack,
CoreStackListener,
StateExchangeListener {
    private static final TraceComponent TC = Tr.register(CoordinatorComponentImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = CoordinatorComponentImpl.class.getName();
    private static final String PMI_STATS_CLASSNAME = "com.ibm.ws.pmi.preprocess.hamanager_impl_StatsTemplateLookup";
    private static boolean svPMIStatsRegistered = false;
    private static CoordinatorImpl svCoordinator;
    private String ivCoreGroupName;
    private boolean ivIsInCoreGroup = false;
    private ConfigDocChangeListener ivConfigRepositoryListener;
    private StateBlob ivLastForwardedConfig;
    private StateBlob ivPendingConfig;
    private int ivDefinedSetUpdateContext = 0;
    private InconsistentDefinedSetHandler ivInconsistentDSHandler;
    private ThreadSchedulerDelayDetector ivSched;
    private Thread ivSchedDelayThread;
    private ControllerHAGroupManagerImpl ivZOScontroller;
    private EndPointMgr ivEndPointMgr;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "initialize()", object);
        }
        boolean bl = this.isSingleServer();
        boolean bl2 = this.isDeploymentManager();
        boolean bl3 = false;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                return;
            }
            bl3 = true;
        }
        try {
            DiagnosticMod diagnosticMod = DiagnosticMod.instance();
            diagnosticMod.registerWithFFDCService();
            Repository repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
            VariableMap variableMap = (VariableMap)WsServiceRegistry.getService((Object)this, (Class)VariableMap.class);
            Config.initialize(repository2, bl, bl2, bl3, variableMap);
            String string = Config.getBaseCoreGroupMemberName();
            if (!Config.isServerInBaseCoreGroup(string)) {
                this.ivIsInCoreGroup = false;
                Tr.error(TC, "HMGR0002");
                return;
            }
            this.ivIsInCoreGroup = true;
            this.ivCoreGroupName = Config.getBaseCoreGroupName();
            ConfigProviderImpl configProviderImpl = new ConfigProviderImpl();
            Providers.setConfigProvider(configProviderImpl);
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, (Class)ChannelFrameworkService.class);
            ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)WsServiceRegistry.getService((Object)this, (Class)ThreadPoolMgr.class);
            RuntimeProviderImpl runtimeProviderImpl = new RuntimeProviderImpl(threadPoolMgr, channelFrameworkService);
            Providers.setRuntimeProvider(runtimeProviderImpl);
            this.ivEndPointMgr = (EndPointMgr)WsServiceRegistry.getService((Object)this, (Class)EndPointMgr.class);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "initialize()");
            }
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, svClassName, "181", this);
            throw configurationError;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "185", this);
            throw new ConfigurationError("unable to initialize the CoordinatorComponentImpl", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeWarning, RuntimeError {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "start()");
        }
        if (this.ivIsInCoreGroup) {
            try {
                String string = Config.getBaseCoreGroupMemberName();
                CoreStackFactoryImpl coreStackFactoryImpl = new CoreStackFactoryImpl();
                StateBlob stateBlob = Config.getCoreGroupConfig();
                CoreStackMemberInfo[] coreStackMemberInfoArray = Config.getCoreGroupMemberInfo(stateBlob);
                CoreStackInfo coreStackInfo = Config.getBaseCoreStackInfo(string);
                SecurityService securityService = (SecurityService)WsServiceRegistry.getService((Object)this, (Class)SecurityService.class);
                CoreGroupBridgeUtilities coreGroupBridgeUtilities = (CoreGroupBridgeUtilities)WsServiceRegistry.getService((Object)this, (Class)CoreGroupBridgeUtilities.class);
                Set set = coreGroupBridgeUtilities != null ? coreGroupBridgeUtilities.getConfiguredBridges(coreStackInfo.getName()) : new HashSet();
                CoordinatorComponentImpl coordinatorComponentImpl = this;
                synchronized (coordinatorComponentImpl) {
                    SecurityProviderImpl securityProviderImpl = new SecurityProviderImpl(securityService);
                    Providers.setSecurityProvider(securityProviderImpl);
                    this.ivLastForwardedConfig = Config.getCoreGroupConfig();
                    svCoordinator = (CoordinatorImpl)coreStackFactoryImpl.createDefaultCoreStack(coreStackInfo, coreStackMemberInfoArray, this, this, Config.getCoreGroupConfig(), set);
                    if (Config.isZControlRegion()) {
                        this.ivZOScontroller = new ControllerHAGroupManagerImpl(svCoordinator);
                    }
                    if (Config.isDmgr()) {
                        this.ivConfigRepositoryListener = new ConfigDocChangeListener(this);
                    }
                }
                WsServiceRegistry.addService((Object)this, (Class)CoreStack.class);
                this.startManagement();
                if (!Config.isSingleServer()) {
                    this.ivSched = new ThreadSchedulerDelayDetector();
                    this.ivSchedDelayThread = new Thread(this.ivSched);
                    this.ivSchedDelayThread.setDaemon(true);
                    this.ivSchedDelayThread.start();
                }
            }
            catch (RuntimeError runtimeError) {
                FFDCFilter.processException((Throwable)runtimeError, svClassName, "230", this);
                throw runtimeError;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "234", this);
                throw new RuntimeError("Unable to start the CoordinatorComponentImpl", throwable);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "start()");
        }
    }

    public void stop() {
        if (this.ivIsInCoreGroup) {
            if (this.ivSched != null) {
                this.ivSched.stop();
            }
            if (svCoordinator != null) {
                svCoordinator.stopDefaultCoreStack();
            }
        }
    }

    public void destroy() {
    }

    public CoreStackFactory getCoreStackFactory() {
        return svCoordinator.getCoreStackFactory();
    }

    public AgentClassFactory getAgentClassFactory() {
        return svCoordinator.getAgentClassFactory();
    }

    public BulletinBoardFactory getBulletinboardFactory() {
        return svCoordinator.getBulletinboardFactory();
    }

    public void addBulletinBoardListener(BulletinBoardListener bulletinBoardListener) {
        svCoordinator.addBulletinBoardListener(bulletinBoardListener);
    }

    public void removeBulletinBoardListener(BulletinBoardListener bulletinBoardListener) {
        svCoordinator.removeBulletinBoardListener(bulletinBoardListener);
    }

    public ManagedGroupDataFactory getManagedGroupDataFactory() {
        return svCoordinator.getManagedGroupDataFactory();
    }

    public GroupManager getGroupManager() {
        return svCoordinator.getGroupManager();
    }

    public int updateCoreStackMembers(CoreStackMemberInfo[] coreStackMemberInfoArray, int n) throws DataStackException {
        return svCoordinator.updateCoreStackMembers(coreStackMemberInfoArray, n);
    }

    public int addDefined(CoreStackMemberInfo coreStackMemberInfo, int n) throws DataStackException {
        return svCoordinator.addDefined(coreStackMemberInfo, n);
    }

    public int removeDefined(String string, int n) throws DataStackException {
        return svCoordinator.removeDefined(string, n);
    }

    public void updateProtocolVersions(Map map) throws DataStackException {
        svCoordinator.updateProtocolVersions(map);
    }

    public void bridgeStateSynchronized(Set set) throws HAException {
        svCoordinator.bridgeStateSynchronized(set);
    }

    public void bridgeStateUnsychronized(Set set) throws HAException {
        svCoordinator.bridgeStateUnsychronized(set);
    }

    public boolean transparentBridgeFailoverEnabled() {
        return svCoordinator.transparentBridgeFailoverEnabled();
    }

    public void shutdown() {
    }

    public void viewAboutToChange() {
    }

    public void viewChangeCompleted(String[] stringArray) {
        if (this.ivPendingConfig != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "viewChangeCompleted - sending pending config", this.ivPendingConfig);
            }
            StateBlob stateBlob = this.ivPendingConfig;
            this.ivPendingConfig = null;
            this.coreGroupConfigurationAvailable(stateBlob);
        }
    }

    public synchronized void inconsistentDefinedMembers(String[] stringArray, String[] stringArray2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "inconsistentDefinedMembers - local", stringArray);
            Tr.debug(TC, "inconsistentDefinedMembers - remote", stringArray2);
        }
        this.updateInconsistentConfiguration();
    }

    public synchronized void undefinedMember(String string, InetAddress inetAddress, int n) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "undefinedMember", string);
        }
        this.updateInconsistentConfiguration();
    }

    public synchronized void inconsistentMember(String string, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "inconsistentMember", string);
        }
        this.updateInconsistentConfiguration();
    }

    public void changeDefinedCompleted(int n) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "changeDefinedCompleted", new Integer(n));
        }
    }

    public void terminated(int n) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "terminated", new Integer(n));
        }
        if (n == 1) {
            svCoordinator.getJVMController().panicJVM("DCS requested panic");
        }
        if (n == 2) {
            svCoordinator.getJVMController().panicJVM("Default core stack stopped due to removeDefined");
        }
    }

    public void stateReceived(StateBlob stateBlob) {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "stateReceived", new Object[]{Config.getCoreGroupConfig(), stateBlob});
            }
            if (!Config.isCompatibleConfigImpl(stateBlob)) {
                Config.replaceConfiguration(stateBlob);
                this.updateProtocolVersions(Config.getProtocolVersions());
            } else {
                boolean bl = Config.isSameConfigRepositoryDocument(stateBlob);
                if (bl) {
                    boolean bl2 = Config.updateStateVersionInformation(stateBlob);
                    if (!bl2) {
                        Tr.info(TC, "HMGR0085");
                    }
                    return;
                }
                this.installConfig(stateBlob);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "533");
            Tr.error(TC, "HMGR0087", new Object[]{stateBlob, throwable});
        }
    }

    public String getServerProperty(String string, String string2) {
        return Config.getServerProperty(string, string2);
    }

    public String getCoreGroupProperty(String string) {
        return Config.getCoreGroupProperty(string);
    }

    public synchronized void coreGroupConfigurationAvailable(StateBlob stateBlob) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "coreGroupConfigurationAvailable", new Object[]{stateBlob});
        }
        try {
            int n = stateBlob.getVersion().compareTo(this.ivLastForwardedConfig);
            if (n > 0) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "coreGroupConfigurationAvailable", "sending");
                }
                svCoordinator.distributeDefaultCoreStackConfiguration(stateBlob);
                this.ivLastForwardedConfig = stateBlob;
                return;
            }
            boolean bl = Config.configReadOnDmgr(Config.getCoreGroupConfig());
            boolean bl2 = Config.configReadOnDmgr(stateBlob);
            if (bl && !bl2) {
                CoreStackMemberInfo[] coreStackMemberInfoArray = Config.getCoreGroupMemberInfo(stateBlob);
                this.ivDefinedSetUpdateContext = this.updateCoreStackMembers(coreStackMemberInfoArray, this.ivDefinedSetUpdateContext);
            } else {
                Tr.info(TC, "HMGR0091", new Object[]{this.ivLastForwardedConfig, stateBlob});
            }
        }
        catch (DataStackMembershipChangingException dataStackMembershipChangingException) {
            FFDCFilter.processException((Throwable)dataStackMembershipChangingException, svClassName, "561", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "CoreGroupConfigurationAvailable", dataStackMembershipChangingException);
            }
            this.ivPendingConfig = stateBlob;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "568", this);
            Tr.error(TC, "HMGR0089", new Object[]{stateBlob, throwable});
        }
    }

    private StateBlob getCoreGroupConfigFromDm(final String string) {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    StateBlob stateBlob = null;
                    try {
                        AdminClient adminClient = CoordinatorComponentImpl.this.getDmAdminConnection();
                        String string3 = adminClient.getDomainName() + ":*,type=HAManager,process=dmgr";
                        ObjectName objectName = new ObjectName(string3);
                        Set set = adminClient.queryNames(objectName, null);
                        if (set.size() < 1) {
                            Tr.error(TC, "HMGR0092", new Object[]{objectName});
                            return stateBlob;
                        }
                        ObjectName objectName2 = (ObjectName)set.iterator().next();
                        String string2 = "getCoreGroupConfig";
                        Object[] objectArray = new Object[]{string};
                        String[] stringArray = new String[]{"java.lang.String"};
                        stateBlob = (StateBlob)adminClient.invoke(objectName2, string2, objectArray, stringArray);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "getCoreGroupConfigFromDm", new Object[]{string, stateBlob});
                        }
                    }
                    catch (ConnectorException connectorException) {
                        return stateBlob;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, svClassName, "719", this);
                        Tr.error(TC, "HMGR0096", new Object[]{throwable});
                    }
                    return stateBlob;
                }
            };
            return (StateBlob)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "702", this);
            Tr.error(TC, "HMGR0096", new Object[]{throwable});
            return null;
        }
    }

    private AdminClient getDmAdminConnection() throws Exception, ConnectorException {
        Object object;
        String string = null;
        String string2 = null;
        Map map = this.ivEndPointMgr.getNodeEndPoints();
        Iterator iterator = map.values().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            object = (EndPointMgr.NodeEndPoints)iterator.next();
            Map map2 = object.getServerEndPoints();
            Iterator iterator2 = map2.values().iterator();
            while (iterator2.hasNext() && !bl) {
                EndPointMgr.ServerEndPoints serverEndPoints = (EndPointMgr.ServerEndPoints)iterator2.next();
                if (!serverEndPoints.getType().equals("DEPLOYMENT_MANAGER")) continue;
                EndPoint endPoint = serverEndPoints.getEndPoint("SOAP_CONNECTOR_ADDRESS");
                string = endPoint.getHost();
                string2 = new Integer(endPoint.getPort()).toString();
                bl = true;
            }
        }
        if (string == null || string2 == null || !bl) {
            throw new HAException("dmHost: " + string + " or dmPort: " + string2 + " data from epmgr is null.");
        }
        object = new Properties();
        ((Properties)object).setProperty("type", "SOAP");
        ((Properties)object).setProperty("host", string);
        ((Properties)object).setProperty("port", string2);
        ((Properties)object).setProperty("isInternal", "true");
        return AdminClientFactory.createAdminClient((Properties)object);
    }

    private void updateInconsistentConfiguration() {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "UpdateInconsistentConfiguration");
            }
            if (this.ivInconsistentDSHandler != null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "UpdateInconsistentConfiguration", "handler running");
                }
                return;
            }
            this.ivInconsistentDSHandler = new InconsistentDefinedSetHandler();
            Thread thread = new Thread(this.ivInconsistentDSHandler);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "628", this);
            Tr.error(TC, "HMGR0140", throwable);
        }
    }

    private void installConfig(StateBlob stateBlob) {
        try {
            boolean bl = Config.updateProtocolVersions(stateBlob);
            Config.updateStateVersionInformation(stateBlob);
            Config.updateCoordinator(stateBlob);
            Config.updateTransport(stateBlob);
            Map map = Config.updatePolicies(stateBlob);
            boolean bl2 = Config.updateProcesses(stateBlob);
            int n = Config.getNumberOfActiveCoordinators();
            String[] stringArray = Config.getPreferredCoordinators();
            String string = Config.getSharedSecret();
            Config.updateCoreGroupCustomProperties(stateBlob);
            svCoordinator.installDefaultCoreStackConfig(n, stringArray, string, map, bl2);
            if (bl2) {
                StateBlob stateBlob2 = Config.getCoreGroupConfig();
                CoreStackMemberInfo[] coreStackMemberInfoArray = Config.getCoreGroupMemberInfo(stateBlob2);
                this.ivDefinedSetUpdateContext = this.updateCoreStackMembers(coreStackMemberInfoArray, this.ivDefinedSetUpdateContext);
            }
            if (bl) {
                this.updateProtocolVersions(Config.getProtocolVersions());
            }
            Tr.info(TC, "HMGR0086", stateBlob);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "679", this);
            Tr.error(TC, "HMGR0087", new Object[]{stateBlob, throwable});
        }
    }

    private void startManagement() throws RuntimeWarning, RuntimeError {
        Serializable serializable;
        Object object;
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        CoordinatorJMXImpl coordinatorJMXImpl = new CoordinatorJMXImpl(svCoordinator, this, Config.isSingleServer());
        try {
            object = new Properties();
            ((Properties)object).put("coregroup", this.ivCoreGroupName);
            mBeanFactory.activateMBean("HAManager", coordinatorJMXImpl, "HAManager", "com/ibm/ws/management/descriptor/xml/HAManager.xml", (Properties)object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "704", this);
            Tr.error(TC, "HMGR0004", new Object[]{"HAManager", throwable});
            throw new RuntimeError("unable to start HAManager Mbean", throwable);
        }
        object = new BulletinBoardJMXImpl(svCoordinator);
        try {
            serializable = new Properties();
            ((Properties)serializable).put("coregroup", this.ivCoreGroupName);
            mBeanFactory.activateMBean("BulletinBoard", (RuntimeCollaborator)object, "BulletinBoard", "com/ibm/ws/management/descriptor/xml/BulletinBoard.xml", (Properties)serializable);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "714", this);
            Tr.error(TC, "HMGR0004", new Object[]{"BulletinBoard", throwable});
            throw new RuntimeError("unable to start BulletinBoard Mbean", throwable);
        }
        try {
            if (!PmiRegistry.isDisabled()) {
                if (!svPMIStatsRegistered) {
                    svPMIStatsRegistered = true;
                    serializable = Class.forName(PMI_STATS_CLASSNAME);
                    StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((Class)serializable).newInstance());
                }
                serializable = new HAManagerPerfModule("HAManagerMBean");
                svCoordinator.setPMI((HAManagerPerf)((Object)serializable));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "722", this);
            Tr.warning(TC, "HMGR0007", throwable);
        }
    }

    private boolean isSingleServer() {
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String string = adminService.getProcessType();
                    if ("UnManagedProcess".equals(string)) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
            });
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "744", this);
            return false;
        }
    }

    private boolean isDeploymentManager() {
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String string = adminService.getProcessType();
                    if ("DeploymentManager".equals(string)) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
            });
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "772", this);
            return false;
        }
    }

    class ThreadSchedulerDelayDetector
    implements Runnable {
        private int ivPeriod = 30;
        private long ivAllowable = 35L;
        private long ivStartTime;
        private boolean ivShutdown = false;

        ThreadSchedulerDelayDetector() {
            String string;
            try {
                string = Config.getLocalServerProperty("IBM_CS_LS_THREAD_SCHED_DETECT_PERIOD");
                if (string == null) {
                    string = Config.getCoreGroupProperty("IBM_CS_THREAD_SCHED_DETECT_PERIOD");
                }
                this.ivPeriod = string == null ? 30 : Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "888", this);
                this.ivPeriod = 30;
            }
            string = null;
            try {
                string = Config.getLocalServerProperty("IBM_CS_LS_THREAD_SCHED_DETECT_ERROR");
                if (string == null) {
                    string = Config.getCoreGroupProperty("IBM_CS_THREAD_SCHED_DETECT_ERROR");
                }
                this.ivAllowable = string == null ? (long)(this.ivPeriod + 5) : (long)this.ivPeriod + Long.parseLong(string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "907", this);
                this.ivAllowable = this.ivPeriod + 5;
            }
            if (this.ivPeriod < 1) {
                this.ivShutdown = true;
            } else {
                this.ivPeriod *= 1000;
                this.ivAllowable *= 1000L;
                this.ivStartTime = System.currentTimeMillis();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "ThreadSchedulingDelayDetector", new Object[]{new Integer(this.ivPeriod), new Long(this.ivAllowable)});
                }
            }
        }

        public void run() {
            try {
                while (!this.ivShutdown) {
                    try {
                        Thread.sleep(this.ivPeriod);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l = System.currentTimeMillis();
                    long l2 = l - this.ivStartTime;
                    if (l2 > this.ivAllowable) {
                        long l3 = l2 - (long)this.ivPeriod;
                        Tr.warning(TC, "HMGR0152", new Long(l3 / 1000L));
                    }
                    this.ivStartTime = l;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "953", this);
            }
        }

        void stop() {
            this.ivShutdown = true;
        }
    }

    class InconsistentDefinedSetHandler
    implements Runnable {
        InconsistentDefinedSetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string;
            try {
                string = Config.getBaseCoreGroupName();
            }
            catch (HAInternalStateException hAInternalStateException) {
                FFDCFilter.processException((Throwable)hAInternalStateException, "com.ibm.ws.hamanager.runtime.CoordinatorComponentImpl.InconsistentDefinedSetHandler.run", "970", this);
                return;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "InconsistentDefinedSetHandler - created");
            }
            try {
                long l = 30000L;
                int n = 10;
                for (int i = 0; i < n; ++i) {
                    StateBlob stateBlob = CoordinatorComponentImpl.this.getCoreGroupConfigFromDm(string);
                    if (stateBlob != null) {
                        CoordinatorComponentImpl.this.coreGroupConfigurationAvailable(stateBlob);
                        return;
                    }
                    stateBlob = StateBlobBuilder.buildBlob(string, false, true);
                    if (stateBlob != null && !Config.isSameConfigRepositoryDocument(stateBlob)) {
                        CoordinatorComponentImpl.this.coreGroupConfigurationAvailable(stateBlob);
                        return;
                    }
                    Thread.sleep(l);
                }
                Tr.warning(TC, "HMGR0090");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "830", this);
                Tr.error(TC, "HMGR0140", throwable);
            }
            finally {
                CoordinatorComponentImpl coordinatorComponentImpl = CoordinatorComponentImpl.this;
                synchronized (coordinatorComponentImpl) {
                    CoordinatorComponentImpl.this.ivInconsistentDSHandler = null;
                }
            }
        }
    }
}

