/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.SecurityProvider;
import com.ibm.ws.hamanager.coordinator.dcs.ConnectionTokenProvider;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

class DefaultTokenProvider
implements ConnectionTokenProvider {
    private static final TraceComponent TC = Tr.register(DefaultTokenProvider.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = DefaultTokenProvider.class.getName();
    private static final String svSSKey = "cgSharedSecret";
    private static final String svDis = "Disabled";
    private static final String svEn = "Enabled";
    private String ivSecret;
    private boolean ivUseSecureTokens;
    private SecurityProvider ivSecurity;
    private ContextManager ivContextMgr;
    private WSCredential ivWsServerCred = null;
    private SingleSignonToken ivSSOToken = null;
    private Set ivRejected;
    private long ivCushion;

    DefaultTokenProvider(String string, boolean bl, SecurityProvider securityProvider) {
        this.ivSecret = string;
        this.ivUseSecureTokens = bl;
        this.ivSecurity = securityProvider;
        this.ivRejected = new HashSet();
        this.ivContextMgr = ContextManagerFactory.getInstance();
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new Boolean(this.ivUseSecureTokens), new Boolean(this.ivSecurity.isSecurityEnabled()), string};
            Tr.debug(TC, "create DefaultTokenProvider", objectArray);
        }
    }

    public byte[] getToken(String string, String string2) {
        Object[] objectArray;
        if (TC.isDebugEnabled()) {
            objectArray = new Object[]{new Boolean(this.ivUseSecureTokens), string, string2, this.ivSecret};
            Tr.debug(TC, "getToken", objectArray);
        }
        if (!this.ivUseSecureTokens) {
            return this.ivSecret.getBytes();
        }
        if (!this.ivSecurity.isSecurityStarted()) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getToken - security not initialized");
            }
            return null;
        }
        try {
            long l;
            if (this.ivWsServerCred == null || !this.ivWsServerCred.isCurrent()) {
                this.ivSSOToken = null;
                objectArray = this.ivContextMgr.getServerSubject();
                this.ivWsServerCred = SubjectHelper.getWSCredentialFromSubject((Subject)objectArray);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "initializing connection credential", new Object[]{objectArray, this.ivWsServerCred});
                }
            }
            if (this.ivWsServerCred == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "returning connection credential", "unitialized");
                }
                throw new Exception("WS Credential is null");
            }
            if (this.ivSSOToken != null && (l = this.ivSSOToken.getExpiration() - System.currentTimeMillis() - this.ivCushion) < 0L) {
                this.ivSSOToken = null;
            }
            if (this.ivSSOToken == null) {
                this.ivSSOToken = this.ivContextMgr.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.ivWsServerCred);
                this.ivSSOToken.addAttribute(svSSKey, this.ivSecret);
                long l2 = this.ivSSOToken.getExpiration();
                long l3 = l2 - System.currentTimeMillis();
                this.ivCushion = (long)((double)l3 * 0.2);
            }
            byte[] byArray = this.ivSSOToken.getBytes();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "returning secure Token", new Integer(byArray.length));
            }
            return byArray;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "159", this);
            Tr.error(TC, "HMGR0150", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateMember(String string, String string2, byte[] byArray, InetAddress inetAddress) {
        String string3;
        Object object;
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new Boolean(this.ivUseSecureTokens), new Integer(byArray.length), string, string2, inetAddress};
            Tr.debug(TC, "authenticateConnection", objectArray);
        }
        boolean bl = false;
        try {
            if (!this.ivUseSecureTokens) {
                String string4 = new String(byArray);
                bl = this.ivSecret.equals(string4);
                if (bl) {
                    this.ivRejected.remove(string2);
                } else if (!this.ivRejected.contains(string2)) {
                    this.ivRejected.add(string2);
                    String string5 = this.getSenderSecurityState(byArray);
                    String string6 = this.getTokenFirstBytes(byArray);
                    Object[] objectArray = new Object[]{string, string2, inetAddress, svDis, string5, string6, null};
                    Tr.info(TC, "HMGR0149", objectArray);
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (!this.ivSecurity.isSecurityStarted()) {
                boolean bl3 = false;
                return bl3;
            }
            Token token = this.ivContextMgr.getWSCredTokenMapper().validateLTPAToken(byArray);
            object = token.getAttributes(svSSKey);
            string3 = "null";
            if (object != null && object[0] != null && this.ivSecret.equals(string3 = object[0])) {
                this.ivRejected.remove(string2);
                boolean bl4 = bl = true;
                return bl4;
            }
            if (!this.ivRejected.contains(string2)) {
                this.ivRejected.add(string2);
                Object[] objectArray = new Object[]{string, string2, inetAddress, svEn, svEn, string3, null};
                Tr.info(TC, "HMGR0149", objectArray);
            }
            boolean bl5 = bl = false;
            return bl5;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "238", this);
            if (!this.ivRejected.contains(string2)) {
                this.ivRejected.add(string2);
                object = svEn;
                if (!this.ivUseSecureTokens) {
                    object = svDis;
                }
                string3 = this.getSenderSecurityState(byArray);
                String string7 = this.getTokenFirstBytes(byArray);
                Object[] objectArray = new Object[]{string, string2, inetAddress, object, string3, string7, throwable};
                Tr.error(TC, "HMGR0149", objectArray);
            }
            boolean bl6 = bl = false;
            return bl6;
        }
        finally {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "authenticateConnection", new Boolean(bl));
            }
        }
    }

    private String getSenderSecurityState(byte[] byArray) {
        if (byArray.length < 250) {
            return svDis;
        }
        return svEn;
    }

    private String getTokenFirstBytes(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length > 25) {
            byArray2 = new byte[25];
            System.arraycopy(byArray, 0, byArray2, 0, 25);
        }
        return new String(byArray2);
    }
}

