/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime;

import com.ibm.ws.hamanager.HAMThreadPool;
import com.ibm.ws.hamanager.RuntimeProvider;
import com.ibm.ws.hamanager.runtime.HAMThreadPoolImpl;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;

public class RuntimeProviderImpl
implements RuntimeProvider {
    private static final int USER_CALLBACKS_MIN_THREADS = 2;
    private HAMThreadPoolImpl ivUserCallbacksTP;
    private ChannelFrameworkService ivChfw;

    RuntimeProviderImpl(ThreadPoolMgr threadPoolMgr, ChannelFrameworkService channelFrameworkService) throws HAException {
        if (threadPoolMgr == null) {
            throw new HAException("ThreadPoolMgr service is null");
        }
        if (channelFrameworkService == null) {
            throw new HAException("ChannelFrameworkService is null");
        }
        this.ivUserCallbacksTP = this.createUserCallbacksThreadPool(threadPoolMgr);
        this.ivChfw = channelFrameworkService;
    }

    public HAMThreadPool getUserCallbacksThreadPool() {
        return this.ivUserCallbacksTP;
    }

    public ChannelFrameworkService getChannelFramework() throws HAException {
        return this.ivChfw;
    }

    private HAMThreadPoolImpl createUserCallbacksThreadPool(ThreadPoolMgr threadPoolMgr) throws HAInternalStateException {
        int n = Config.getMaxThreads();
        int n2 = Config.getMinThreads();
        if (n2 < 2) {
            n2 = 2;
        }
        if (n < n2) {
            n = n2;
        }
        ThreadPool threadPool = threadPoolMgr.getThreadPool("HAManager.thread.pool", null);
        threadPool.setMaximumPoolSize(n);
        threadPool.setMinimumPoolSize(n2);
        threadPool.setGrowAsNeeded(false);
        threadPool.setKeepAliveTime(Config.getThreadInactiveTime());
        HAMThreadPoolImpl hAMThreadPoolImpl = new HAMThreadPoolImpl(threadPool, n2, n);
        return hAMThreadPoolImpl;
    }
}

