/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime;

import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.hamanager.coordinator.SecurityProvider;
import com.ibm.ws.hamanager.coordinator.dcs.ConnectionTokenProvider;
import com.ibm.ws.hamanager.runtime.DefaultTokenProvider;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.wsspi.hamanager.HAException;

class SecurityProviderImpl
implements SecurityProvider,
SecurityServiceListener {
    private SecurityService ivSecurity;
    private boolean ivSecurityStarted;

    SecurityProviderImpl(SecurityService securityService) throws HAException {
        if (securityService == null) {
            throw new HAException("SecurityService is null");
        }
        this.ivSecurity = securityService;
        this.ivSecurityStarted = false;
        securityService.addListener(this);
    }

    public boolean isSecurityEnabled() {
        return WSSecurityHelper.isGlobalSecurityEnabled();
    }

    public boolean isSecurityStarted() {
        return this.ivSecurityStarted;
    }

    public ConnectionTokenProvider getConnectionTokenProvider(String string, boolean bl) {
        return new DefaultTokenProvider(string, bl, this);
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        int n = securityServiceEvent.getState();
        if (n == 1) {
            this.ivSecurityStarted = true;
        } else if (n == 2) {
            this.ivSecurityStarted = false;
        }
    }
}

