/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackFactoryImpl;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackInfoImpl;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackTransportType;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.CoreGroupClusters;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfig;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfigV2;
import com.ibm.ws.hamanager.runtime.config.CoreGroupCoordinator;
import com.ibm.ws.hamanager.runtime.config.CoreGroupPolicies;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcess;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcesses;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcessesV2;
import com.ibm.ws.hamanager.runtime.config.CoreGroupTransport;
import com.ibm.ws.hamanager.runtime.config.HAParseException;
import com.ibm.ws.hamanager.runtime.config.LocalServer;
import com.ibm.ws.hamanager.runtime.config.StateBlobBuilder;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.quorum.ServerPowerController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class Config {
    static final TraceComponent TC = Tr.register(Config.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    static String svClassName = Config.class.getName();
    static final String svCgContext = "coregroups";
    static final String svCgFile = "coregroup.xml";
    static final String svHAServiceFile = "hamanagerservice.xml";
    public static final String svCoreGroupDocument = "coregroup.xml";
    public static String svCoreGroupDocumentPath;
    private static Repository svRepository;
    private static String svCell;
    private static String svNode;
    private static String svServer;
    private static String svCoreGroupName;
    private static String svFqServerName;
    private static LocalServer svServerConfig;
    private static StateBlob svCoreGroupConfig;
    private static ConfigRepository svConfigRepository;
    private static CoreStackFactory svCoreStackFactory;
    private static boolean svSingleServer;
    private static boolean svDmgr;
    private static boolean svIsZControlRegion;
    private static VariableMap svVarExpansionService;

    public static synchronized void initialize(Repository repository2, boolean bl, boolean bl2, boolean bl3, VariableMap variableMap) throws ConfigurationError {
        svRepository = repository2;
        svSingleServer = bl;
        svDmgr = bl2;
        svIsZControlRegion = bl3;
        svVarExpansionService = variableMap;
        svCell = repository2.getCellName();
        if (svCell == null) {
            throw new ConfigurationError("A null cell name was retrieved from the configuration Repository");
        }
        svCoreGroupDocumentPath = "cells/" + svCell + "/coregroups";
        svNode = repository2.getNodeName();
        if (svNode == null) {
            throw new ConfigurationError("A null node name was retrieved from the configuration Repository");
        }
        svServer = repository2.getServerName();
        if (svServer == null) {
            throw new ConfigurationError("A null server name was retrieved from the configuration Repository");
        }
        svFqServerName = HAMUtil.createFullyQualifiedServerName(svCell, svNode, svServer);
        svConfigRepository = ConfigRepositoryFactory.getConfigRepository();
        if (svConfigRepository == null) {
            Tr.error(TC, "HMGR0080");
            throw new ConfigurationError("Unable to obtain a reference to the ConfigRepository");
        }
        StateBlobBuilder.initialize(svConfigRepository);
        try {
            Config.loadHAManagerServiceConfig(false);
            if (!svSingleServer && !svServerConfig.isEnabled()) {
                svSingleServer = true;
            }
            boolean bl4 = !svSingleServer;
            svCoreGroupConfig = StateBlobBuilder.buildBlob(svCoreGroupName, true, bl4);
        }
        catch (HAException hAException) {
            FFDCFilter.processException(hAException, svClassName, "144");
            throw new ConfigurationError(hAException);
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new Boolean(svSingleServer), new Boolean(bl2), new Boolean(bl3)};
            Tr.debug(TC, "initialize", objectArray);
        }
    }

    public static Resource getCellRelativeConfigDoc(String string) throws HAException {
        Resource resource = null;
        ConfigRoot configRoot = svRepository.getConfigRoot();
        try {
            resource = configRoot.getResource(0, string, true);
            return resource;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "244");
            Tr.error(TC, "HMGR0021", throwable);
            throw new HAException("Error parsing uri " + string, throwable);
        }
    }

    public static Resource getServerRelativeConfigDoc(String string) throws HAException {
        Resource resource = null;
        ConfigRoot configRoot = svRepository.getConfigRoot();
        try {
            resource = configRoot.getResource(4, string, true);
            return resource;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "257");
            Tr.error(TC, "HMGR0021", throwable);
            throw new HAException("Error parsing uri " + string, throwable);
        }
    }

    public static synchronized void replaceConfiguration(StateBlob stateBlob) {
        svCoreGroupConfig = stateBlob;
    }

    public static boolean isSingleServer() {
        return svSingleServer;
    }

    public static boolean isDmgr() {
        return svDmgr;
    }

    public static boolean isZControlRegion() {
        return svIsZControlRegion;
    }

    public static synchronized String getBaseCoreGroupName() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupName);
        return svCoreGroupName;
    }

    public static synchronized String getBaseCoreGroupMemberName() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svFqServerName);
        return svFqServerName;
    }

    public static synchronized boolean isServerInBaseCoreGroup(String string) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.isServerInCoreGroup(string);
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.isServerInCoreGroup(string);
        }
        Config.unsupportedStateBlob();
        return false;
    }

    public static StateBlob getCoreGroupConfig() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        return svCoreGroupConfig;
    }

    public static boolean configReadOnDmgr(StateBlob stateBlob) throws HAInternalStateException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "configReadOnDmgr", stateBlob);
        }
        if (stateBlob instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
            return coreGroupConfig.configReadOnDmgr();
        }
        if (stateBlob instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
            return coreGroupConfigV2.configReadOnDmgr();
        }
        Config.unsupportedStateBlob(stateBlob);
        return false;
    }

    public static synchronized boolean isSameConfigRepositoryDocument(StateBlob stateBlob) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "isDifferentConfigDocument", new Object[]{svCoreGroupConfig, stateBlob});
        }
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                return ((Object)coreGroupConfig2.getDigest()).equals(coreGroupConfig.getDigest());
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                return ((Object)coreGroupConfigV22.getDigest()).equals(coreGroupConfigV2.getDigest());
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "351");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
        return false;
    }

    public static synchronized boolean isCompatibleConfigImpl(StateBlob stateBlob) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (TC.isDebugEnabled()) {
            String string = svCoreGroupConfig.getClass().getName();
            String string2 = stateBlob.getClass().getName();
            Tr.debug(TC, "isCompatibleConfigImpl", new Object[]{string, string2});
        }
        if (stateBlob instanceof CoreGroupConfig) {
            return svCoreGroupConfig instanceof CoreGroupConfig;
        }
        if (stateBlob instanceof CoreGroupConfigV2) {
            return svCoreGroupConfig instanceof CoreGroupConfigV2;
        }
        Config.unsupportedStateBlob(stateBlob);
        return false;
    }

    public static synchronized int getNumberOfActiveCoordinators() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getCoordinator().getNumberOfActiveCoordinators();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getCoordinator().getNumberOfActiveCoordinators();
        }
        Config.unsupportedStateBlob();
        return 1;
    }

    public static synchronized String[] getPreferredCoordinators() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getCoordinator().getPreferredCoordinators();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getCoordinator().getPreferredCoordinators();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    public static synchronized String getSharedSecret() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getTransport().getSharedSecret();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getTransport().getSharedSecret();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    public static synchronized Map getBaseCoreGroupPolicyRules() throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getPolicies().getPolicyRules();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getPolicies().getPolicyRules();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    public static synchronized Map getProtocolVersions() throws HAInternalStateException {
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getProtocolVersions();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getProtocolVersions();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    public static synchronized boolean updateStateVersionInformation(StateBlob stateBlob) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "updateVersionInformation", new Object[]{svCoreGroupConfig, stateBlob});
        }
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                return coreGroupConfig2.updateVersionInformation(coreGroupConfig);
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                return coreGroupConfigV22.updateVersionInformation(coreGroupConfigV2);
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "507");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
        return false;
    }

    public static synchronized void updateCoordinator(StateBlob stateBlob) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                coreGroupConfig2.setCoordinator(coreGroupConfig.getCoordinator());
                return;
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                coreGroupConfigV22.setCoordinator(coreGroupConfigV2.getCoordinator());
                return;
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "546");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
    }

    public static synchronized Map updatePolicies(StateBlob stateBlob) throws HAInternalStateException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                CoreGroupPolicies coreGroupPolicies = coreGroupConfig.getPolicies();
                CoreGroupPolicies coreGroupPolicies2 = coreGroupConfig2.getPolicies();
                return coreGroupPolicies2.merge(coreGroupPolicies);
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                CoreGroupPolicies coreGroupPolicies = coreGroupConfigV2.getPolicies();
                CoreGroupPolicies coreGroupPolicies3 = coreGroupConfigV22.getPolicies();
                return coreGroupPolicies3.merge(coreGroupPolicies);
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "584");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
        return null;
    }

    public static boolean updateProcesses(StateBlob stateBlob) throws HAException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                CoreGroupProcesses coreGroupProcesses = coreGroupConfig.getProcesses();
                return coreGroupConfig2.getProcesses().merge(coreGroupProcesses);
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                CoreGroupProcessesV2 coreGroupProcessesV2 = coreGroupConfigV2.getProcesses();
                return coreGroupConfigV22.getProcesses().merge(coreGroupProcessesV2);
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "624");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
        return false;
    }

    public static void updateTransport(StateBlob stateBlob) throws HAException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                coreGroupConfig2.setTransport(coreGroupConfig.getTransport());
                return;
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                coreGroupConfigV22.setTransport(coreGroupConfigV2.getTransport());
                return;
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "663");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
    }

    public static void updateCoreGroupCustomProperties(StateBlob stateBlob) throws HAException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                coreGroupConfig2.setCustomProperties(coreGroupConfig.getCustomProperties());
                return;
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                coreGroupConfigV22.setCustomProperties(coreGroupConfigV2.getCustomProperties());
                return;
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "663");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
    }

    public static boolean updateProtocolVersions(StateBlob stateBlob) throws HAException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        try {
            if (stateBlob instanceof CoreGroupConfig) {
                CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
                CoreGroupConfig coreGroupConfig2 = (CoreGroupConfig)svCoreGroupConfig;
                return coreGroupConfig2.setProtocolVersions(coreGroupConfig.getCustomProperties());
            }
            if (stateBlob instanceof CoreGroupConfigV2) {
                CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
                CoreGroupConfigV2 coreGroupConfigV22 = (CoreGroupConfigV2)svCoreGroupConfig;
                return coreGroupConfigV22.setProtocolVersions(coreGroupConfigV2.getProtocolVersions());
            }
            Config.unsupportedStateBlob(stateBlob);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, svClassName, "663");
            Config.unsupportedStateBlob(stateBlob, classCastException);
        }
        return false;
    }

    public static synchronized String[] getClusterMembers(String string) throws HAException {
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        return CoreGroupClusters.getClusterMembers(string);
    }

    public static synchronized int getDefaultIsAliveTime() throws HAInternalStateException {
        return svServerConfig.getIsAlivePeriod();
    }

    public static synchronized int getMaxThreads() throws HAInternalStateException {
        return svServerConfig.getThreadPoolMaxSize();
    }

    public static synchronized int getMinThreads() throws HAInternalStateException {
        return svServerConfig.getThreadPoolMinSize();
    }

    public static synchronized boolean startAsActiveCooordinator() {
        if (Config.isSingleServer()) {
            return true;
        }
        String string = "IBM_CS_START_AS_COORDINATOR";
        String string2 = Config.getCoreGroupProperty(string);
        if (string2 != null && string2.length() > 0) {
            boolean bl = Boolean.valueOf(string2);
            Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(bl)});
            return bl;
        }
        return false;
    }

    public static synchronized int getThreadInactiveTime() throws HAInternalStateException {
        return svServerConfig.getThreadPoolInactivityTime();
    }

    public static String getServerProperty(String string, String string2) {
        Object object;
        CoreGroupProcess coreGroupProcess = null;
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            object = (CoreGroupConfig)svCoreGroupConfig;
            coreGroupProcess = ((CoreGroupConfig)object).getProcesses().getCoreGroupProcess(string);
        } else if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            object = (CoreGroupConfigV2)svCoreGroupConfig;
            coreGroupProcess = ((CoreGroupConfigV2)object).getProcesses().getCoreGroupProcess(string);
        } else {
            return null;
        }
        if (coreGroupProcess == null) {
            return null;
        }
        object = coreGroupProcess.getCustomProperties();
        if (object == null) {
            return null;
        }
        return (String)object.get(string2);
    }

    public static synchronized String getCoreGroupProperty(String string) {
        if (string == null) {
            return null;
        }
        Map map = Config.getCustomProperties();
        if (map == null) {
            return null;
        }
        return (String)map.get(string);
    }

    public static synchronized String getLocalServerProperty(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = svServerConfig.getCustomProperties();
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get(string);
    }

    public static synchronized CoreStackMemberInfo[] getCoreGroupMemberInfo(StateBlob stateBlob) throws HAInternalStateException {
        if (stateBlob instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)stateBlob;
            return Config.getCoreGroupMemberInfo(coreGroupConfig);
        }
        if (stateBlob instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)stateBlob;
            return Config.getCoreGroupMemberInfo(coreGroupConfigV2);
        }
        Config.unsupportedStateBlob(stateBlob);
        return null;
    }

    public static synchronized CoreStackInfo getBaseCoreStackInfo(String string) throws HAInternalStateException, HAParameterRejectedException {
        Object object;
        Config.checkForNullConfigurationObject(svCoreGroupConfig);
        CoreStackInfoImpl coreStackInfoImpl = new CoreStackInfoImpl();
        coreStackInfoImpl.setName(svCoreGroupName);
        coreStackInfoImpl.setServerName(string);
        CoreGroupCoordinator coreGroupCoordinator = Config.getCoordinator();
        coreStackInfoImpl.setNumCoordinators(coreGroupCoordinator.getNumberOfActiveCoordinators());
        coreStackInfoImpl.setPreferredCoordinators(coreGroupCoordinator.getPreferredCoordinators());
        coreStackInfoImpl.setTransportBufferSize(svServerConfig.getTransportBufferSize());
        coreStackInfoImpl.setIsAliveTime(svServerConfig.getIsAlivePeriod());
        coreStackInfoImpl.setNumberOfThreads(svServerConfig.getNumberOfDCSThreads());
        coreStackInfoImpl.setCachedUpdateFrequency(250);
        CoreGroupTransport coreGroupTransport = Config.getTransport();
        CoreStackTransportType coreStackTransportType = coreGroupTransport.getTransportType();
        coreStackInfoImpl.setTransportType(coreStackTransportType);
        coreStackInfoImpl.setSharedSecret(coreGroupTransport.getSharedSecret());
        if (coreStackTransportType.equals(CoreStackTransportType.MULTICAST)) {
            object = coreGroupTransport.getMultiCastGroupIpStart();
            String string2 = coreGroupTransport.getMultiCastGroupIpEnd();
            int n = coreGroupTransport.getMultiCastPort();
            coreStackInfoImpl.setMulticastAttributes((String)object, string2, n);
        } else if (coreStackTransportType.equals(CoreStackTransportType.CHANNEL_FW)) {
            coreStackInfoImpl.setChannelChainName(coreGroupTransport.getChannelChainName());
        }
        coreStackInfoImpl.setProtocolVersions(Config.getProtocolVersions());
        object = Config.getCustomProperties();
        if (object != null) {
            Config.addSecondTierCoreGroupProperties(coreStackInfoImpl, (Map)object);
        }
        if ((object = svServerConfig.getCustomProperties()) != null) {
            Config.addSecondTierServerProperties(coreStackInfoImpl, (Map)object);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getBaseCoreStackInfo", coreStackInfoImpl);
        }
        return coreStackInfoImpl;
    }

    public static synchronized String calculateViewLeader(String[] stringArray) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "calculateViewLeader", stringArray);
        }
        int n = stringArray.length;
        String string = null;
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            CoreGroupProcesses coreGroupProcesses = coreGroupConfig.getProcesses();
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (coreGroupProcesses.isDmgr(string2)) {
                    string = string2;
                    break;
                }
                if (!coreGroupProcesses.isNodeAgent(string2) || string != null) continue;
                string = string2;
            }
        } else {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            CoreGroupProcessesV2 coreGroupProcessesV2 = coreGroupConfigV2.getProcesses();
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i];
                if (coreGroupProcessesV2.isDmgr(string3)) {
                    string = string3;
                    break;
                }
                if (!coreGroupProcessesV2.isNodeAgent(string3) || string != null) continue;
                string = string3;
            }
        }
        if (string == null) {
            string = stringArray[0];
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "calculateViewLeader - elected", string);
        }
        return string;
    }

    public static String expandVariables(String string) {
        String string2 = string != null && !string.equals("") ? svVarExpansionService.expand(string) : string;
        return string2;
    }

    static String getCell() {
        return svCell;
    }

    static String getNode() {
        return svNode;
    }

    static String getServer() {
        return svServer;
    }

    static synchronized boolean loadHAManagerServiceConfig(boolean bl) throws HAException {
        boolean bl2 = false;
        try {
            Resource resource = Config.getServerRelativeConfigDoc(svHAServiceFile);
            HAManagerService hAManagerService = (HAManagerService)resource.getContents().get(0);
            if (hAManagerService == null) {
                Tr.error(TC, "HMGR0020", "hamanagerservice");
                throw new HAParseException("Unable to read the hamanagerservice.xml document");
            }
            String string = hAManagerService.getCoreGroupName();
            if (string == null) {
                Tr.error(TC, "HMGR0081");
                throw new HAParseException("The coreGroupName in the HAManagerService is null");
            }
            if (bl && !string.equals(svCoreGroupName)) {
                bl2 = true;
            }
            svCoreGroupName = string;
            LocalServer localServer = new LocalServer(hAManagerService);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "loadHAManagerConfig", new Object[]{localServer, new Boolean(bl)});
            }
            if (svServerConfig == null) {
                svServerConfig = localServer;
            } else {
                svServerConfig.merge(localServer);
            }
            return bl2;
        }
        catch (HAException hAException) {
            FFDCFilter.processException(hAException, svClassName, "1045");
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1049");
            Tr.error(TC, "HMGR0070", throwable);
            throw new HAException("problem parsing the HAManagerService document", throwable);
        }
    }

    protected static String getDCSProtocolVersion(CoreGroup coreGroup) {
        String string = coreGroup.getProtocolVersion();
        String string2 = null;
        String string3 = "IBM_CS_WIRE_FORMAT_VERSION";
        try {
            HashMap hashMap;
            EList eList = coreGroup.getCustomProperties();
            if (eList != null && (hashMap = ConfigUtils.extractUntypedProperties((List)eList)) != null) {
                string2 = (String)hashMap.get(string3);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1076");
            Tr.error(TC, "HMGR0023", new Object[]{string3, null, "String", throwable});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getDCSProtocolVersion", new Object[]{string, string2});
        }
        if (string2 == null) {
            if (string == null) {
                return "6.0.0";
            }
            return string;
        }
        if (string == null || "6.0.0".equals(string)) {
            return string2;
        }
        return string;
    }

    protected static String getHamProtocolVersion(CoreGroup coreGroup, String string) {
        Object object;
        String string2 = null;
        String string3 = "IBM_CS_HAM_PROTOCOL_VERSION";
        try {
            HashMap hashMap;
            object = coreGroup.getCustomProperties();
            if (object != null && (hashMap = ConfigUtils.extractUntypedProperties((List)object)) != null) {
                string2 = (String)hashMap.get(string3);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1392");
            Tr.error(TC, "HMGR0023", new Object[]{string3, null, "String", throwable});
        }
        object = "6.0.0";
        if (!string.equals("6.0.0")) {
            object = "6.0.2.9";
        }
        if (string2 != null) {
            if (string2.equals("6.0.2.31")) {
                object = "6.0.2.31";
            } else {
                Tr.error(TC, "HMGR0224", new Object[]{"IBM_CS_HAM_PROTOCOL_VERSION", string2});
            }
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getHamProtocolVersion", object);
        }
        return object;
    }

    private static CoreGroupCoordinator getCoordinator() throws HAInternalStateException {
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getCoordinator();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getCoordinator();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    private static CoreGroupTransport getTransport() throws HAInternalStateException {
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getTransport();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getTransport();
        }
        Config.unsupportedStateBlob();
        return null;
    }

    private static Map getCustomProperties() {
        if (svCoreGroupConfig == null) {
            return null;
        }
        if (svCoreGroupConfig instanceof CoreGroupConfig) {
            CoreGroupConfig coreGroupConfig = (CoreGroupConfig)svCoreGroupConfig;
            return coreGroupConfig.getCustomProperties();
        }
        if (svCoreGroupConfig instanceof CoreGroupConfigV2) {
            CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)svCoreGroupConfig;
            return coreGroupConfigV2.getCustomProperties();
        }
        return null;
    }

    private static void checkForNullConfigurationObject(Object object) throws HAInternalStateException {
        if (object == null) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("Configuration not initialized.");
            Tr.error(TC, "HMGR5000", hAInternalStateException);
            throw hAInternalStateException;
        }
    }

    private static void unsupportedStateBlob() throws HAInternalStateException {
        String string = svCoreGroupConfig.getClass().getName();
        String string2 = "The configuration state blob is invalid. The class is  " + string;
        HAInternalStateException hAInternalStateException = new HAInternalStateException(string2);
        Tr.error(TC, "HMGR5000", hAInternalStateException);
        throw hAInternalStateException;
    }

    private static void unsupportedStateBlob(StateBlob stateBlob) throws HAInternalStateException {
        String string = svCoreGroupConfig.getClass().getName();
        String string2 = stateBlob.getClass().getName();
        String string3 = "The current state blob is of class " + string + ", the passed state blob is of class " + string2;
        HAInternalStateException hAInternalStateException = new HAInternalStateException(string3);
        Tr.error(TC, "HMGR5000", hAInternalStateException);
        throw hAInternalStateException;
    }

    private static void unsupportedStateBlob(StateBlob stateBlob, Throwable throwable) throws HAInternalStateException {
        String string = svCoreGroupConfig.getClass().getName();
        String string2 = stateBlob.getClass().getName();
        String string3 = "The current state blob is of class " + string + ", the passed state blob is of class " + string2;
        HAInternalStateException hAInternalStateException = new HAInternalStateException(string3, throwable);
        Tr.error(TC, "HMGR5000", hAInternalStateException);
        throw hAInternalStateException;
    }

    private static CoreStackMemberInfo[] getCoreGroupMemberInfo(CoreGroupConfig coreGroupConfig) throws HAInternalStateException {
        CoreStackMemberInfo[] coreStackMemberInfoArray;
        int n;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getCoreGroupMemberInfo", coreGroupConfig);
        }
        CoreGroupProcess[] coreGroupProcessArray = coreGroupConfig.getProcesses().getCoreGroupProcesses();
        int n2 = coreGroupProcessArray.length;
        ArrayList<CoreStackMemberInfo> arrayList = new ArrayList<CoreStackMemberInfo>();
        for (n = 0; n < n2; ++n) {
            coreStackMemberInfoArray = coreGroupProcessArray[n];
            try {
                CoreStackMemberInfo coreStackMemberInfo = svCoreStackFactory.createCoreStackMemberInfo();
                String string = coreStackMemberInfoArray.getProcessName();
                coreStackMemberInfo.setServerName(string);
                String string2 = coreStackMemberInfoArray.getIPIdentifier();
                String string3 = coreStackMemberInfoArray.getHostName();
                int n3 = coreStackMemberInfoArray.getPort();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "getCoreGroupMemberInfo", new Object[]{string3, string2, new Integer(n3)});
                }
                if (string2.equals("*")) {
                    coreStackMemberInfo.setIPIdentifier(string3);
                    coreStackMemberInfo.setLocalInterface(string2);
                } else {
                    coreStackMemberInfo.setIPIdentifier(string2);
                    coreStackMemberInfo.setLocalInterface(string2);
                }
                coreStackMemberInfo.setPort(coreStackMemberInfoArray.getPort());
                arrayList.add(coreStackMemberInfo);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "1257");
                throw new HAInternalStateException("lookup of core group member failed", throwable);
            }
        }
        n = arrayList.size();
        coreStackMemberInfoArray = new CoreStackMemberInfo[n];
        coreStackMemberInfoArray = arrayList.toArray(coreStackMemberInfoArray);
        return coreStackMemberInfoArray;
    }

    private static CoreStackMemberInfo[] getCoreGroupMemberInfo(CoreGroupConfigV2 coreGroupConfigV2) throws HAInternalStateException {
        CoreStackMemberInfo[] coreStackMemberInfoArray;
        int n;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getCoreGroupMemberInfoV2", coreGroupConfigV2);
        }
        CoreGroupProcess[] coreGroupProcessArray = coreGroupConfigV2.getProcesses().getCoreGroupProcesses();
        int n2 = coreGroupProcessArray.length;
        ArrayList<CoreStackMemberInfo> arrayList = new ArrayList<CoreStackMemberInfo>();
        for (n = 0; n < n2; ++n) {
            coreStackMemberInfoArray = coreGroupProcessArray[n];
            try {
                CoreStackMemberInfo coreStackMemberInfo = svCoreStackFactory.createCoreStackMemberInfo();
                String string = coreStackMemberInfoArray.getProcessName();
                coreStackMemberInfo.setServerName(string);
                String string2 = coreStackMemberInfoArray.getIPIdentifier();
                String string3 = coreStackMemberInfoArray.getHostName();
                int n3 = coreStackMemberInfoArray.getPort();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "getCoreGroupMemberInfo", new Object[]{string3, string2, new Integer(n3)});
                }
                if (string2.equals("*")) {
                    coreStackMemberInfo.setIPIdentifier(string3);
                    coreStackMemberInfo.setLocalInterface(string2);
                } else {
                    coreStackMemberInfo.setIPIdentifier(string2);
                    coreStackMemberInfo.setLocalInterface(string2);
                }
                coreStackMemberInfo.setPort(coreStackMemberInfoArray.getPort());
                arrayList.add(coreStackMemberInfo);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "1309");
                throw new HAInternalStateException("lookup of core group member failed", throwable);
            }
        }
        n = arrayList.size();
        coreStackMemberInfoArray = new CoreStackMemberInfo[n];
        coreStackMemberInfoArray = arrayList.toArray(coreStackMemberInfoArray);
        return coreStackMemberInfoArray;
    }

    private static void addSecondTierCoreGroupProperties(CoreStackInfoImpl coreStackInfoImpl, Map map) {
        String string = null;
        String string2 = null;
        try {
            int n;
            boolean bl = false;
            string = "IBM_CS_FD_PERIOD_MILLIS";
            string2 = (String)map.get(string);
            if (string2 != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 0) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setFailureDetectorTransmissionInterval(n);
                    bl = true;
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if (!bl && (string2 = (String)map.get(string = "IBM_CS_FD_PERIOD_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 0) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                    coreStackInfoImpl.setFailureDetectorTransmissionInterval(n *= 1000);
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_FD_CONSECUTIVE_MISSED")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setFailureDetectorTimeout(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_CACHE_PERIOD_MILLIS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 250 || n > 30000) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setCachedUpdateFrequency(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_MAX_TRANSPORT_MEG")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setMaximumTransportMemorySize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_SOCKET_BUFFER_SIZE")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 0 || n > 3) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setSocketBufferSize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_DATASTACK_MEG")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setDataStackMemory(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_USE_POOLED_MEMORY")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfoImpl.setUsePooledMemory(n != 0);
                Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(n != 0)});
            }
            if ((string2 = (String)map.get(string = "IBM_CS_MESSAGE_SIZE")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1024) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setExpectedMessageSize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_BRINGUP_TIME_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setMemberBringupTimeSecs(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_COMPLETENESS_VS_SPEED")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1 || n > 5) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setCompletenessVsSpeed(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_UNICAST_DISCOVERY_INTERVAL_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setDiscoveryIntervalSecs(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_FIREWALL_UNICAST_DISCOVERY_INTERVAL_SECS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setFirewallDiscoveryIntervalSecs(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_SS_MAX_TOKEN_BYTES")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1024) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setSharedSecretTokenSize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_SS_SECURE_TOKEN")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfoImpl.setUseSecureConnections(n != 0);
                Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(n != 0)});
            }
            if ((string2 = (String)map.get(string = "IBM_CS_IP_REFRESH_MINUTES")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setIPCacheRefreshInterval(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_MCAST_TTL")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setMulticastTTL(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_DCS_DIAGNOSTICS")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfoImpl.setEnableTransportDiagnostics(n != 0);
                Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(n != 0)});
            }
            if ((string2 = (String)map.get(string = "IBM_CS_ENABLE_DCS_CONFIG_CHECKS")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfoImpl.setEnableCoreStackConfigChecks(n != 0);
                Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(n != 0)});
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1520");
            Tr.error(TC, "HMGR0225", new Object[]{string, string2, throwable});
        }
        String string3 = null;
        try {
            string = "IBM_CS_HW_SERVER_POWER_CONTROLLER";
            string3 = (String)map.get(string);
            if (string3 != null && string3.length() > 0) {
                ServerPowerController serverPowerController = (ServerPowerController)Class.forName(string3).newInstance();
                coreStackInfoImpl.setServerPowerController(serverPowerController);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1534");
            Tr.error(TC, "HMGR5015", new Object[]{string3, throwable});
        }
    }

    private static void addSecondTierServerProperties(CoreStackInfoImpl coreStackInfoImpl, Map map) {
        String string = null;
        String string2 = null;
        try {
            int n;
            string = "IBM_CS_LS_MAX_TRANSPORT_MEG";
            string2 = (String)map.get(string);
            if (string2 != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setMaximumTransportMemorySize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_LS_DATASTACK_MEG")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 1) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setDataStackMemory(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_CACHE_PERIOD_MILLIS")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 250 || n > 30000) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setCachedUpdateFrequency(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
            if ((string2 = (String)map.get(string = "IBM_CS_LS_USE_POOLED_MEMORY")) != null && string2.length() > 0) {
                n = Boolean.valueOf(string2).booleanValue() ? 1 : 0;
                coreStackInfoImpl.setUsePooledMemory(n != 0);
                Tr.info(TC, "HMGR0226", new Object[]{string, new Boolean(n != 0)});
            }
            if ((string2 = (String)map.get(string = "IBM_CS_LS_SOCKET_BUFFER_SIZE")) != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
                if (n < 0 || n > 3) {
                    Tr.error(TC, "HMGR0224", new Object[]{string, new Integer(n)});
                } else {
                    coreStackInfoImpl.setSocketBufferSize(n);
                    Tr.info(TC, "HMGR0226", new Object[]{string, new Integer(n)});
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1607");
            Tr.error(TC, "HMGR0225", new Object[]{string, string2, throwable});
        }
    }

    static {
        svCoreStackFactory = new CoreStackFactoryImpl();
    }
}

