/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.CoordinatorComponentImpl;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfig;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfigV2;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcesses;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcessesV2;
import com.ibm.ws.hamanager.runtime.config.StateBlobBuilder;
import com.ibm.ws.hamanager.utils.JMXUtils;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.hamanager.HAException;
import java.security.PrivilegedExceptionAction;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;

public class ConfigDocChangeListener
implements ConfigRepositoryListener {
    private static final TraceComponent TC = Tr.register(ConfigDocChangeListener.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "ConfigDocChangeListener";
    private CoordinatorComponentImpl ivCoordinatorComp;
    private ConfigRepository ivConfigRepository;

    public ConfigDocChangeListener(CoordinatorComponentImpl coordinatorComponentImpl) throws Exception {
        this.ivCoordinatorComp = coordinatorComponentImpl;
        this.ivConfigRepository = ConfigRepositoryFactory.getConfigRepository();
        if (this.ivConfigRepository == null) {
            Tr.error(TC, "HMGR0080");
            throw new Exception("Unable to obtain a reference to the ConfigRepository");
        }
        this.ivConfigRepository.addListener(this);
    }

    public void disable() {
        this.ivConfigRepository.removeListener(this);
    }

    public void onRepositoryLock() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "repository locked");
        }
    }

    public void onRepositoryUnlock() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "repository unlocked");
        }
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "onChangeStart");
        }
    }

    public synchronized void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "onChangeCompletion");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        int n = configChangeNotifierArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            String string = configChangeNotifier.getUri();
            if (!string.startsWith(Config.svCoreGroupDocumentPath) || !string.endsWith("coregroup.xml")) continue;
            int n2 = configChangeNotifier.getChangeType();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processing changed uri", new Object[]{string, new Integer(n2)});
            }
            try {
                String string2 = this.getCoreGroupNameFromcoregroupxmlUri(string);
                StateBlob stateBlob = StateBlobBuilder.buildBlob(string2, false, true);
                this.sendCGChangeViaJMX(string2, stateBlob);
                continue;
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, "com.ibm.ws.hamanager.runtime.config.ConfigDocChangeListener.onChangeCompletion", "157", this);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "onChangeCompletion");
        }
    }

    public void onRepositoryEpochRefresh() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "onRepositoryEpochRefresh");
        }
    }

    private String getCoreGroupNameFromcoregroupxmlUri(String string) {
        String[] stringArray = string.split("/");
        return stringArray[stringArray.length - 2];
    }

    private void sendCGChangeViaJMX(final String string, final StateBlob stateBlob) {
        String[] stringArray;
        Object object;
        if (stateBlob instanceof CoreGroupConfig) {
            object = (CoreGroupConfig)stateBlob;
            CoreGroupProcesses coreGroupProcesses = ((CoreGroupConfig)object).getProcesses();
            stringArray = coreGroupProcesses.getCoreGroupMembers();
        } else {
            object = (CoreGroupConfigV2)stateBlob;
            CoreGroupProcessesV2 coreGroupProcessesV2 = ((CoreGroupConfigV2)object).getProcesses();
            stringArray = coreGroupProcessesV2.getCoreGroupMembers();
        }
        try {
            object = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        if (adminService == null) {
                            Tr.error(TC, "HMGR0098");
                            throw new Exception("Unable to obtain a reference to the AdminService");
                        }
                        QueryExp queryExp = Query.and(Query.eq(Query.attr("supportsDynamicCGReload"), Query.value(true)), Query.eq(Query.attr("isInSingleServerMode"), Query.value(false)));
                        ObjectName objectName = JMXUtils.findHAMBeanForCG(adminService, string, stringArray, queryExp);
                        if (objectName == null) {
                            Tr.info(TC, "HMGR0095", new Object[]{string});
                            return null;
                        }
                        String string2 = "updateRuntimeConfig";
                        Object[] objectArray = new Object[]{stateBlob};
                        String[] stringArray2 = new String[]{"java.io.Serializable"};
                        adminService.invoke(objectName, string2, objectArray, stringArray2);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, ConfigDocChangeListener.svClassName, "247");
                        Tr.warning(TC, "HMGR0097", new Object[]{string, throwable});
                    }
                    return null;
                }
            };
            ContextManagerFactory.getInstance().runAsSystem((PrivilegedExceptionAction)object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "257");
            Tr.warning(TC, "HMGR0097", new Object[]{string, throwable});
        }
    }
}

