/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.HAException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class CoreGroupClusters {
    private static final TraceComponent TC = Tr.register(CoreGroupClusters.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupClusters.class.getName();

    static String[] getClusterMembers(String string) throws HAException {
        String string2 = "cluster.xml";
        String string3 = "clusters/" + string + "/" + string2;
        Resource resource = null;
        try {
            resource = Config.getCellRelativeConfigDoc(string3);
        }
        catch (HAException hAException) {
            FFDCFilter.processException(hAException, svClassName, "58");
            Tr.info(TC, "HMGR0136", new Object[]{string});
            return null;
        }
        ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
        EList eList = serverCluster.getMembers();
        String[] stringArray = new String[eList.size()];
        Iterator iterator = eList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ClusterMember clusterMember = (ClusterMember)iterator.next();
            stringArray[n++] = HAMUtil.createFullyQualifiedServerName(Config.getCell(), clusterMember.getNodeName(), clusterMember.getMemberName());
        }
        return stringArray;
    }
}

