/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfigV2;
import com.ibm.ws.hamanager.runtime.config.CoreGroupCoordinator;
import com.ibm.ws.hamanager.runtime.config.CoreGroupPolicies;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcesses;
import com.ibm.ws.hamanager.runtime.config.CoreGroupTransport;
import com.ibm.wsspi.hamanager.HAException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class CoreGroupConfig
implements Serializable,
StateBlob,
StateVersion {
    private static final long serialVersionUID = -8903372689879467519L;
    private static final TraceComponent TC = Tr.register(CoreGroupConfig.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupConfig.class.getName();
    private DocumentDigest ivDigest;
    private CoreGroupCoordinator ivCoordinator;
    private CoreGroupProcesses ivProcesses;
    private CoreGroupPolicies ivPolicies;
    private CoreGroupTransport ivTransport;
    private boolean ivReadOnDmgr;
    private long ivTimeRead;
    private String ivMemberName;
    private Map ivCustomProperties;

    CoreGroupConfig(DocumentDigest documentDigest, String string, CoreGroup coreGroup, String string2, boolean bl) throws HAException {
        try {
            EList eList = coreGroup.getCustomProperties();
            if (eList != null) {
                this.ivCustomProperties = ConfigUtils.extractUntypedProperties((List)eList);
            }
            this.ivCoordinator = new CoreGroupCoordinator(string, coreGroup);
            this.ivProcesses = new CoreGroupProcesses(string, coreGroup, bl);
            this.ivPolicies = new CoreGroupPolicies(string, coreGroup, true);
            this.ivTransport = new CoreGroupTransport(string, coreGroup);
            if (Config.isDmgr()) {
                this.ivReadOnDmgr = true;
            }
            this.ivMemberName = string2;
            DocumentDigest documentDigest2 = this.getDocumentDigest();
            this.ivDigest = documentDigest2 != null ? documentDigest2 : documentDigest;
            this.ivTimeRead = System.currentTimeMillis();
        }
        catch (HAException hAException) {
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "94", this);
            Tr.error(TC, "HMGR0021", throwable);
            throw new HAException("Error parsing a CoreGroup document", throwable);
        }
    }

    public CoreGroupConfig() {
    }

    public DocumentDigest getDigest() {
        return this.ivDigest;
    }

    public StateVersion getVersion() {
        return this;
    }

    public boolean configReadOnDmgr() {
        return this.ivReadOnDmgr;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CoreGroupConfig)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(Object object) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "compareTo - source, target", new Object[]{this, object});
        }
        if (object instanceof CoreGroupConfigV2) {
            return -1;
        }
        CoreGroupConfig coreGroupConfig = (CoreGroupConfig)object;
        int n = 0;
        try {
            if (((Object)this.ivDigest).equals(coreGroupConfig.ivDigest)) {
                if (this.ivReadOnDmgr && !coreGroupConfig.ivReadOnDmgr) {
                    int n2 = n = 1;
                    return n2;
                }
                if (!this.ivReadOnDmgr && coreGroupConfig.ivReadOnDmgr) {
                    int n3 = n = -1;
                    return n3;
                }
                int n4 = n = 0;
                return n4;
            }
            if (this.ivReadOnDmgr && !coreGroupConfig.ivReadOnDmgr) {
                int n5 = n = 1;
                return n5;
            }
            if (!this.ivReadOnDmgr && coreGroupConfig.ivReadOnDmgr) {
                int n6 = n = -1;
                return n6;
            }
            Date date = new Date(this.ivTimeRead);
            Date date2 = new Date(coreGroupConfig.ivTimeRead);
            int n7 = date.compareTo(date2);
            if (n7 != 0) {
                int n8 = n = n7;
                return n8;
            }
            int n9 = n = this.ivMemberName.compareTo(coreGroupConfig.ivMemberName);
            return n9;
        }
        finally {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "compareTo - return value", new Integer(n));
            }
        }
    }

    CoreGroupCoordinator getCoordinator() {
        return this.ivCoordinator;
    }

    CoreGroupProcesses getProcesses() {
        return this.ivProcesses;
    }

    CoreGroupPolicies getPolicies() {
        return this.ivPolicies;
    }

    CoreGroupTransport getTransport() {
        return this.ivTransport;
    }

    String getProtocolVersion() {
        throw new RuntimeException("CoreGroupConfig.getProtocolVersion must not be called");
    }

    Map getProtocolVersions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DCS_PROTOCOL", "6.0.0");
        String string = "6.0.0";
        if (this.ivCustomProperties != null) {
            String string2 = (String)this.ivCustomProperties.get("IBM_CS_WIRE_FORMAT_VERSION");
            if (string2 != null && !string2.equals("6.0.0")) {
                string = "6.0.2.9";
            }
            if ((string2 = (String)this.ivCustomProperties.get("IBM_CS_HAM_PROTOCOL_VERSION")) != null) {
                if (string2.equals("6.0.2.31")) {
                    string = "6.0.2.31";
                } else {
                    Tr.error(TC, "HMGR0224", new Object[]{"IBM_CS_HAM_PROTOCOL_VERSION", string2});
                }
            }
        }
        hashMap.put("HAM_PROTOCOL", string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getProtocolVersions", hashMap);
        }
        return hashMap;
    }

    boolean setProtocolVersions(Map map) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "setProtocolVersions - Local initial", this.ivCustomProperties);
            Tr.debug(TC, "setProtocolVersions - input", map);
        }
        String string = null;
        String string2 = null;
        if (this.ivCustomProperties != null) {
            string = (String)this.ivCustomProperties.get("IBM_CS_WIRE_FORMAT_VERSION");
            string2 = (String)this.ivCustomProperties.get("IBM_CS_HAM_PROTOCOL_VERSION");
        }
        String string3 = null;
        String string4 = null;
        if (map != null) {
            string3 = (String)map.get("IBM_CS_WIRE_FORMAT_VERSION");
            string4 = (String)map.get("IBM_CS_HAM_PROTOCOL_VERSION");
        }
        boolean bl = this.propertyChanged(string, string3);
        boolean bl2 = this.propertyChanged(string2, string4);
        if (bl || bl2) {
            if (this.ivCustomProperties == null) {
                this.ivCustomProperties = new HashMap();
            }
            if (string3 != null) {
                this.ivCustomProperties.put("IBM_CS_WIRE_FORMAT_VERSION", string3);
            }
            if (string4 != null) {
                this.ivCustomProperties.put("IBM_CS_HAM_PROTOCOL_VERSION", string4);
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "setProtocolVersions - Local final", this.ivCustomProperties);
            }
            return true;
        }
        return false;
    }

    void setCoordinator(CoreGroupCoordinator coreGroupCoordinator) {
        this.ivCoordinator = coreGroupCoordinator;
    }

    void setTransport(CoreGroupTransport coreGroupTransport) {
        this.ivTransport = coreGroupTransport;
    }

    Map getCustomProperties() {
        return this.ivCustomProperties;
    }

    void setCustomProperties(Map map) {
        this.ivCustomProperties = map;
    }

    boolean isServerInCoreGroup(String string) {
        return this.ivProcesses.IsServerInCoreGroup(string);
    }

    boolean updateVersionInformation(CoreGroupConfig coreGroupConfig) {
        boolean bl = false;
        if (!((Object)this.ivDigest).equals(coreGroupConfig.ivDigest)) {
            this.ivDigest = coreGroupConfig.ivDigest;
            bl = true;
        }
        if (this.ivReadOnDmgr != coreGroupConfig.ivReadOnDmgr) {
            this.ivReadOnDmgr = coreGroupConfig.ivReadOnDmgr;
            bl = true;
        }
        if (this.ivTimeRead != coreGroupConfig.ivTimeRead) {
            this.ivTimeRead = coreGroupConfig.ivTimeRead;
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CoreGroupConfig : MemberName ");
        stringBuffer.append(this.ivMemberName);
        stringBuffer.append(", DMGR ");
        stringBuffer.append(this.ivReadOnDmgr);
        stringBuffer.append(", time read ");
        stringBuffer.append(this.ivTimeRead);
        stringBuffer.append(", number coordinators ");
        stringBuffer.append(this.ivCoordinator.getNumberOfActiveCoordinators());
        stringBuffer.append(", numberPreferred ");
        stringBuffer.append(this.ivCoordinator.getPreferredCoordinators().length);
        stringBuffer.append(", numberProcesses ");
        stringBuffer.append(this.ivProcesses.getCoreGroupMembers().length);
        stringBuffer.append(", version ");
        stringBuffer.append(this.ivDigest);
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.ivDigest = (DocumentDigest)objectInputStream.readObject();
        this.ivCoordinator = (CoreGroupCoordinator)objectInputStream.readObject();
        this.ivProcesses = (CoreGroupProcesses)objectInputStream.readObject();
        this.ivPolicies = (CoreGroupPolicies)objectInputStream.readObject();
        this.ivTransport = (CoreGroupTransport)objectInputStream.readObject();
        this.ivReadOnDmgr = objectInputStream.readBoolean();
        this.ivTimeRead = objectInputStream.readLong();
        this.ivMemberName = objectInputStream.readUTF();
        this.ivCustomProperties = (Map)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ivDigest);
        objectOutputStream.writeObject(this.ivCoordinator);
        objectOutputStream.writeObject(this.ivProcesses);
        objectOutputStream.writeObject(this.ivPolicies);
        objectOutputStream.writeObject(this.ivTransport);
        objectOutputStream.writeBoolean(this.ivReadOnDmgr);
        objectOutputStream.writeLong(this.ivTimeRead);
        objectOutputStream.writeUTF(this.ivMemberName);
        objectOutputStream.writeObject(this.ivCustomProperties);
    }

    private boolean propertyChanged(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        if (string2 == null) {
            return true;
        }
        return !string.equals(string2);
    }

    private DocumentDigest getDocumentDigest() {
        DocumentDigest documentDigest;
        block2: {
            documentDigest = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.repository.DocumentDigestImpl");
                Constructor<?> constructor = clazz.getDeclaredConstructor([B.class);
                constructor.setAccessible(true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                documentDigest = (DocumentDigest)constructor.newInstance(new Object[]{byArray});
            }
            catch (Throwable throwable) {
                if (!TC.isDebugEnabled()) break block2;
                Tr.debug(TC, "getDocumentDigest - caught exception", new Object[]{throwable, documentDigest});
            }
        }
        return documentDigest;
    }
}

