/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfig;
import com.ibm.ws.hamanager.runtime.config.CoreGroupCoordinator;
import com.ibm.ws.hamanager.runtime.config.CoreGroupPolicies;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcessesV2;
import com.ibm.ws.hamanager.runtime.config.CoreGroupTransport;
import com.ibm.wsspi.hamanager.HAException;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class CoreGroupConfigV2
implements Externalizable,
StateBlob,
StateVersion {
    private static final long serialVersionUID = -8903372689879467519L;
    private static final TraceComponent TC = Tr.register(CoreGroupConfigV2.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupConfigV2.class.getName();
    private static int svVersion = 2;
    private DocumentDigest ivDigest;
    private CoreGroupCoordinator ivCoordinator;
    private CoreGroupProcessesV2 ivProcesses;
    private CoreGroupPolicies ivPolicies;
    private CoreGroupTransport ivTransport;
    private String ivWireFormatVersion;
    private boolean ivReadOnDmgr;
    private long ivTimeRead;
    private String ivMemberName;
    private Map ivCustomProperties;
    private String ivHamVersion;

    CoreGroupConfigV2(DocumentDigest documentDigest, String string, CoreGroup coreGroup, String string2, boolean bl, String string3) throws HAException {
        throw new HAException("CoreGroupConfigV2 - wrong ctor called.");
    }

    CoreGroupConfigV2(DocumentDigest documentDigest, String string, CoreGroup coreGroup, String string2, boolean bl, String string3, String string4) throws HAException {
        try {
            EList eList = coreGroup.getCustomProperties();
            if (eList != null) {
                this.ivCustomProperties = ConfigUtils.extractUntypedProperties((List)eList);
            }
            this.ivCoordinator = new CoreGroupCoordinator(string, coreGroup);
            this.ivProcesses = new CoreGroupProcessesV2(string, coreGroup, bl);
            this.ivPolicies = new CoreGroupPolicies(string, coreGroup, true);
            this.ivTransport = new CoreGroupTransport(string, coreGroup);
            if (Config.isDmgr()) {
                this.ivReadOnDmgr = true;
            }
            this.ivMemberName = string2;
            this.ivWireFormatVersion = string3;
            this.ivHamVersion = string4;
            DocumentDigest documentDigest2 = this.getDocumentDigest();
            this.ivDigest = documentDigest2 != null ? documentDigest2 : documentDigest;
            this.ivTimeRead = System.currentTimeMillis();
        }
        catch (HAException hAException) {
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "94", this);
            Tr.error(TC, "HMGR0021", throwable);
            throw new HAException("Error parsing a CoreGroup document", throwable);
        }
    }

    public CoreGroupConfigV2() {
    }

    public DocumentDigest getDigest() {
        return this.ivDigest;
    }

    public StateVersion getVersion() {
        return this;
    }

    public boolean configReadOnDmgr() {
        return this.ivReadOnDmgr;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CoreGroupConfigV2)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(Object object) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "compareTo - source, target", new Object[]{this, object});
        }
        if (object instanceof CoreGroupConfig) {
            return 1;
        }
        CoreGroupConfigV2 coreGroupConfigV2 = (CoreGroupConfigV2)object;
        int n = 0;
        try {
            if (((Object)this.ivDigest).equals(coreGroupConfigV2.ivDigest)) {
                if (this.ivReadOnDmgr && !coreGroupConfigV2.ivReadOnDmgr) {
                    int n2 = n = 1;
                    return n2;
                }
                if (!this.ivReadOnDmgr && coreGroupConfigV2.ivReadOnDmgr) {
                    int n3 = n = -1;
                    return n3;
                }
                int n4 = n = 0;
                return n4;
            }
            if (this.ivReadOnDmgr && !coreGroupConfigV2.ivReadOnDmgr) {
                int n5 = n = 1;
                return n5;
            }
            if (!this.ivReadOnDmgr && coreGroupConfigV2.ivReadOnDmgr) {
                int n6 = n = -1;
                return n6;
            }
            Date date = new Date(this.ivTimeRead);
            Date date2 = new Date(coreGroupConfigV2.ivTimeRead);
            int n7 = date.compareTo(date2);
            if (n7 != 0) {
                int n8 = n = n7;
                return n8;
            }
            int n9 = n = this.ivMemberName.compareTo(coreGroupConfigV2.ivMemberName);
            return n9;
        }
        finally {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "compareTo - return value", new Integer(n));
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivDigest = (DocumentDigest)objectInput.readObject();
        this.ivCoordinator = (CoreGroupCoordinator)objectInput.readObject();
        this.ivProcesses = (CoreGroupProcessesV2)objectInput.readObject();
        this.ivPolicies = (CoreGroupPolicies)objectInput.readObject();
        this.ivTransport = (CoreGroupTransport)objectInput.readObject();
        this.ivReadOnDmgr = objectInput.readBoolean();
        this.ivTimeRead = objectInput.readLong();
        this.ivMemberName = objectInput.readUTF();
        this.ivWireFormatVersion = objectInput.readUTF();
        this.ivCustomProperties = (Map)objectInput.readObject();
        this.ivHamVersion = n > 1 ? objectInput.readUTF() : "6.0.2.9";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(svVersion);
        objectOutput.writeObject(this.ivDigest);
        objectOutput.writeObject(this.ivCoordinator);
        objectOutput.writeObject(this.ivProcesses);
        objectOutput.writeObject(this.ivPolicies);
        objectOutput.writeObject(this.ivTransport);
        objectOutput.writeBoolean(this.ivReadOnDmgr);
        objectOutput.writeLong(this.ivTimeRead);
        objectOutput.writeUTF(this.ivMemberName);
        objectOutput.writeUTF(this.ivWireFormatVersion);
        objectOutput.writeObject(this.ivCustomProperties);
        objectOutput.writeUTF(this.ivHamVersion);
    }

    CoreGroupCoordinator getCoordinator() {
        return this.ivCoordinator;
    }

    CoreGroupProcessesV2 getProcesses() {
        return this.ivProcesses;
    }

    CoreGroupPolicies getPolicies() {
        return this.ivPolicies;
    }

    CoreGroupTransport getTransport() {
        return this.ivTransport;
    }

    String getProtocolVersion() {
        throw new RuntimeException("CoreGroupConfigV2.getProtocolVersion must not be called");
    }

    Map getProtocolVersions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DCS_PROTOCOL", this.ivWireFormatVersion);
        hashMap.put("HAM_PROTOCOL", this.ivHamVersion);
        return hashMap;
    }

    boolean setProtocolVersions(Map map) {
        boolean bl = false;
        String string = (String)map.get("DCS_PROTOCOL");
        if (!this.ivWireFormatVersion.equals(string)) {
            this.ivWireFormatVersion = string;
            bl = true;
        }
        if (!this.ivHamVersion.equals(string = (String)map.get("HAM_PROTOCOL"))) {
            this.ivHamVersion = string;
            bl = true;
        }
        return bl;
    }

    void setCoordinator(CoreGroupCoordinator coreGroupCoordinator) {
        this.ivCoordinator = coreGroupCoordinator;
    }

    void setTransport(CoreGroupTransport coreGroupTransport) {
        this.ivTransport = coreGroupTransport;
    }

    Map getCustomProperties() {
        return this.ivCustomProperties;
    }

    void setCustomProperties(Map map) {
        this.ivCustomProperties = map;
    }

    boolean isServerInCoreGroup(String string) {
        return this.ivProcesses.IsServerInCoreGroup(string);
    }

    boolean updateVersionInformation(CoreGroupConfigV2 coreGroupConfigV2) {
        boolean bl = false;
        if (!((Object)this.ivDigest).equals(coreGroupConfigV2.ivDigest)) {
            this.ivDigest = coreGroupConfigV2.ivDigest;
            bl = true;
        }
        if (this.ivReadOnDmgr != coreGroupConfigV2.ivReadOnDmgr) {
            this.ivReadOnDmgr = coreGroupConfigV2.ivReadOnDmgr;
            bl = true;
        }
        if (this.ivTimeRead != coreGroupConfigV2.ivTimeRead) {
            this.ivTimeRead = coreGroupConfigV2.ivTimeRead;
            bl = true;
        }
        return bl;
    }

    private DocumentDigest getDocumentDigest() {
        DocumentDigest documentDigest;
        block2: {
            documentDigest = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.repository.DocumentDigestImpl");
                Constructor<?> constructor = clazz.getDeclaredConstructor([B.class);
                constructor.setAccessible(true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                documentDigest = (DocumentDigest)constructor.newInstance(new Object[]{byArray});
            }
            catch (Throwable throwable) {
                if (!TC.isDebugEnabled()) break block2;
                Tr.debug(TC, "getDocumentDigest - caught exception", new Object[]{throwable, documentDigest});
            }
        }
        return documentDigest;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CoreGroupConfigV2 : MemberName ");
        stringBuffer.append(this.ivMemberName);
        stringBuffer.append(", DMGR ");
        stringBuffer.append(this.ivReadOnDmgr);
        stringBuffer.append(", time read ");
        stringBuffer.append(this.ivTimeRead);
        stringBuffer.append(", number coordinators ");
        stringBuffer.append(this.ivCoordinator.getNumberOfActiveCoordinators());
        stringBuffer.append(", numberPreferred ");
        stringBuffer.append(this.ivCoordinator.getPreferredCoordinators().length);
        stringBuffer.append(", numberProcesses ");
        stringBuffer.append(this.ivProcesses.getCoreGroupMembers().length);
        stringBuffer.append(", version ");
        stringBuffer.append(this.ivDigest);
        stringBuffer.append(", dcs protocol version ");
        stringBuffer.append(this.ivWireFormatVersion);
        stringBuffer.append(", ham protocol version ");
        stringBuffer.append(this.ivHamVersion);
        return stringBuffer.toString();
    }
}

