/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.HAException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class CoreGroupCoordinator
implements Externalizable {
    private static final long serialVersionUID = 6790209490090908151L;
    private static final TraceComponent TC = Tr.register(CoreGroupCoordinator.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupCoordinator.class.getName();
    private static final int svVersion = 1;
    private int ivActiveCoordinators;
    private String[] ivPreferredCoordinators;
    private HashMap ivCustomProperties;

    CoreGroupCoordinator(String string, CoreGroup coreGroup) throws HAException {
        EList eList;
        int n = coreGroup.getNumCoordinators();
        if (n < 1) {
            Tr.info(TC, "HMGR0025", new Object[]{"CoreGroup", "number of active coordinators", new Integer(n)});
            this.ivActiveCoordinators = 1;
        } else {
            this.ivActiveCoordinators = n;
        }
        EList eList2 = coreGroup.getPreferredCoordinatorServers();
        this.ivPreferredCoordinators = ConfigUtils.convertCoreGroupServerListToStringArray(string, (List)eList2);
        if (this.ivPreferredCoordinators == null) {
            this.ivPreferredCoordinators = new String[0];
        }
        if ((eList = coreGroup.getCustomProperties()) != null) {
            this.ivCustomProperties = ConfigUtils.extractUntypedProperties((List)eList);
        }
    }

    public CoreGroupCoordinator() {
    }

    public int getNumberOfActiveCoordinators() {
        return this.ivActiveCoordinators;
    }

    public String[] getPreferredCoordinators() {
        return this.ivPreferredCoordinators;
    }

    public HashMap getCoreGroupCustomProperties() {
        return this.ivCustomProperties;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivActiveCoordinators = objectInput.readInt();
        this.ivPreferredCoordinators = StringUtils.readStringArrayFromStream(objectInput);
        this.ivCustomProperties = MapUtils.readMapFromStream(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeInt(this.ivActiveCoordinators);
        StringUtils.writeStringArrayToStream(objectOutput, this.ivPreferredCoordinators);
        MapUtils.writeMapToStream(objectOutput, this.ivCustomProperties);
    }

    synchronized void merge(CoreGroupCoordinator coreGroupCoordinator) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "merging coordinator information");
        }
        boolean bl = false;
        try {
            boolean bl2 = StringUtils.compareStringArraysForExactEquality(this.ivPreferredCoordinators, coreGroupCoordinator.ivPreferredCoordinators);
            if (!bl2) {
                this.ivPreferredCoordinators = coreGroupCoordinator.ivPreferredCoordinators;
                bl = true;
            }
            if (this.ivActiveCoordinators != coreGroupCoordinator.ivActiveCoordinators) {
                this.ivActiveCoordinators = coreGroupCoordinator.ivActiveCoordinators;
                bl = true;
            }
            if (!(bl2 = MapUtils.compareMaps(this.ivCustomProperties, coreGroupCoordinator.ivCustomProperties))) {
                this.ivCustomProperties = coreGroupCoordinator.ivCustomProperties;
                bl = true;
            }
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "148", this);
            Tr.error(TC, "HMGR0083", new Object[]{"CoreGroupCoordinator", hAException});
        }
    }
}

