/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.HAManagerPolicy;
import com.ibm.websphere.models.config.coregroup.MOfNPolicy;
import com.ibm.websphere.models.config.coregroup.MatchCriteria;
import com.ibm.websphere.models.config.coregroup.PreferredServerPolicy;
import com.ibm.websphere.models.config.coregroup.StaticPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.coordinator.impl.HAPolicyRuleImpl;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.HAParseException;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.HAException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class CoreGroupPolicies
implements Externalizable {
    private static final long serialVersionUID = 7022603100680342964L;
    private static final TraceComponent TC = Tr.register(CoreGroupPolicies.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = CoreGroupPolicies.class.getName();
    private static final int svVersion = 1;
    private Map ivPolicyRules = new HashMap();
    private int ivParsingErrors;

    CoreGroupPolicies(String string, CoreGroup coreGroup, boolean bl) throws HAException {
        try {
            EList eList = coreGroup.getPolicies();
            int n = eList.size();
            if (n == 0) {
                Tr.info(TC, "HMGR0040");
                return;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = null;
                try {
                    HAManagerPolicy hAManagerPolicy = (HAManagerPolicy)eList.get(i);
                    string2 = hAManagerPolicy.getName();
                    if (string2 == null || string2.equals("")) {
                        Tr.error(TC, "HMGR0041");
                        ++this.ivParsingErrors;
                        if (bl) continue;
                        throw new HAParseException("A policy without a name was found in the coregroup");
                    }
                    HAPolicyRuleImpl hAPolicyRuleImpl = this.createBaseRule(string2, hAManagerPolicy);
                    this.appendPolicySpecificProperties(string, hAManagerPolicy, hAPolicyRuleImpl);
                    this.addRule(string2, hAPolicyRuleImpl);
                    continue;
                }
                catch (HAParseException hAParseException) {
                    FFDCFilter.processException((Throwable)hAParseException, svClassName, "112", this);
                    Tr.warning(TC, "HMGR0042", string2);
                    if (bl) continue;
                    throw hAParseException;
                }
            }
            if (this.ivPolicyRules.size() == 0) {
                Tr.error(TC, "HMGR0043");
                if (!bl) {
                    throw new HAException("No HA Policies were successfully loaded.");
                }
            }
        }
        catch (HAParseException hAParseException) {
            FFDCFilter.processException((Throwable)hAParseException, svClassName, "128", this);
            throw hAParseException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "132", this);
            ++this.ivParsingErrors;
            FFDCFilter.processException(throwable, svClassName, "135", this);
            Tr.error(TC, "HMGR0044", throwable);
            throw new HAException("Unknown error initializing policies", throwable);
        }
    }

    public CoreGroupPolicies() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivParsingErrors = objectInput.readInt();
        this.ivPolicyRules = MapUtils.readMapFromStream(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeInt(this.ivParsingErrors);
        MapUtils.writeMapToStream(objectOutput, this.ivPolicyRules);
    }

    Map getPolicyRules() {
        return this.ivPolicyRules;
    }

    synchronized Map merge(CoreGroupPolicies coreGroupPolicies) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "merging policy information");
        }
        if (coreGroupPolicies.ivParsingErrors > 0) {
            Tr.info(TC, "HMGR0088", new Integer(coreGroupPolicies.ivParsingErrors));
            return null;
        }
        this.ivPolicyRules = coreGroupPolicies.ivPolicyRules;
        return this.ivPolicyRules;
    }

    private HAPolicyRuleImpl createBaseRule(String string, HAManagerPolicy hAManagerPolicy) throws HAParseException {
        String string2 = this.getGroupPolicyFactory(string, hAManagerPolicy);
        HashMap hashMap = this.extractMatchSet(string, hAManagerPolicy);
        HashMap hashMap2 = this.extractCustomProperties(string, hAManagerPolicy);
        boolean bl = hAManagerPolicy.isQuorumEnabled();
        int n = hAManagerPolicy.getIsAlivePeriodSec();
        try {
            HAPolicyRuleImpl hAPolicyRuleImpl = new HAPolicyRuleImpl(string, string2, hashMap, hashMap2, bl, n);
            return hAPolicyRuleImpl;
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "222", this);
            throw new HAParseException("Error creating HAPolicyRule", hAException);
        }
    }

    private void appendPolicySpecificProperties(String string, HAManagerPolicy hAManagerPolicy, HAPolicyRuleImpl hAPolicyRuleImpl) throws HAParseException {
        if (hAManagerPolicy instanceof StaticPolicy) {
            StaticPolicy staticPolicy = (StaticPolicy)hAManagerPolicy;
            EList eList = staticPolicy.getServers();
            String[] stringArray = ConfigUtils.convertCoreGroupServerListToStringArray(string, (List)eList);
            hAPolicyRuleImpl.setServerAttributes(stringArray);
            if (stringArray == null) {
                String string2 = hAManagerPolicy.getName();
                Tr.warning(TC, "HMGR0045", string2);
            }
        } else if (hAManagerPolicy instanceof PreferredServerPolicy) {
            PreferredServerPolicy preferredServerPolicy = (PreferredServerPolicy)hAManagerPolicy;
            EList eList = preferredServerPolicy.getPreferredServers();
            String[] stringArray = ConfigUtils.convertCoreGroupServerListToStringArray(string, (List)eList);
            hAPolicyRuleImpl.setPreferredServerAttributes(stringArray);
            hAPolicyRuleImpl.setForcePreferred(preferredServerPolicy.isFailback());
            hAPolicyRuleImpl.setPreferredOnly(preferredServerPolicy.isPreferredOnly());
            if (preferredServerPolicy.isPreferredOnly() && stringArray == null) {
                String string3 = hAManagerPolicy.getName();
                Tr.warning(TC, "HMGR0045", string3);
            }
            if (hAManagerPolicy instanceof MOfNPolicy) {
                hAPolicyRuleImpl.setNumActive(((MOfNPolicy)hAManagerPolicy).getNumActive());
            }
        }
    }

    private String getGroupPolicyFactory(String string, HAManagerPolicy hAManagerPolicy) throws HAParseException {
        String string2 = hAManagerPolicy.getPolicyFactory();
        if (string2 == null || string2.equals("")) {
            ++this.ivParsingErrors;
            throw new HAParseException("The policy factory name for policy: " + string + " is illegal");
        }
        return string2;
    }

    private HashMap extractMatchSet(String string, HAManagerPolicy hAManagerPolicy) throws HAParseException {
        EList eList = hAManagerPolicy.getMatchCriteria();
        if (eList == null) {
            ++this.ivParsingErrors;
            throw new HAParseException("The match set for policy " + string + " is null.");
        }
        int n = eList.size();
        if (n == 0) {
            ++this.ivParsingErrors;
            throw new HAParseException("The match set for policy " + string + " is empty.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            MatchCriteria matchCriteria = (MatchCriteria)eList.get(i);
            String string2 = matchCriteria.getName();
            String string3 = matchCriteria.getValue();
            hashMap.put(string2, string3);
        }
        if (hashMap == null || hashMap.size() == 0) {
            ++this.ivParsingErrors;
            throw new HAParseException("The match set for policy " + string + " is null or empty");
        }
        return hashMap;
    }

    private HashMap extractCustomProperties(String string, HAManagerPolicy hAManagerPolicy) {
        EList eList = hAManagerPolicy.getCustomProperties();
        if (eList == null) {
            return null;
        }
        HashMap hashMap = ConfigUtils.extractUntypedProperties((List)eList);
        return hashMap;
    }

    private void addRule(String string, HAPolicyRuleImpl hAPolicyRuleImpl) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "Adding Policy Rule", new Object[]{string, hAPolicyRuleImpl});
        }
        if (this.ivPolicyRules.containsKey(string)) {
            Tr.error(TC, "HMGR0049", string);
        } else {
            this.ivPolicyRules.put(string, hAPolicyRuleImpl);
        }
    }
}

