/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

class CoreGroupProcess
implements Externalizable {
    private static final long serialVersionUID = 2132734116030148655L;
    private static TraceComponent TC = Tr.register(CoreGroupProcess.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final int svVersion = 1;
    private String ivHostName;
    private String ivProcessName;
    private int ivPort;
    private String ivEpIp;
    private HashMap ivCustomProperties;

    CoreGroupProcess(String string, String string2, int n, String string3, HashMap hashMap) {
        this.ivProcessName = string;
        this.ivHostName = string2;
        this.ivPort = n;
        this.ivEpIp = string3;
        this.ivCustomProperties = hashMap;
    }

    public CoreGroupProcess() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivProcessName = objectInput.readUTF();
        this.ivHostName = objectInput.readUTF();
        this.ivPort = objectInput.readInt();
        this.ivEpIp = objectInput.readUTF();
        this.ivCustomProperties = MapUtils.readMapFromStream(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeUTF(this.ivProcessName);
        objectOutput.writeUTF(this.ivHostName);
        objectOutput.writeInt(this.ivPort);
        objectOutput.writeUTF(this.ivEpIp);
        MapUtils.writeMapToStream(objectOutput, this.ivCustomProperties);
    }

    String getHostName() {
        return this.ivHostName;
    }

    String getIPIdentifier() {
        return this.ivEpIp;
    }

    String getProcessName() {
        return this.ivProcessName;
    }

    int getPort() {
        return this.ivPort;
    }

    Map getCustomProperties() {
        return this.ivCustomProperties;
    }

    boolean merge(CoreGroupProcess coreGroupProcess) throws HAException {
        boolean bl = false;
        if (!this.ivProcessName.equals(coreGroupProcess.ivProcessName)) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("Can't merge process " + this.ivProcessName + " with " + coreGroupProcess.ivProcessName);
            Tr.error(TC, "HMGR5009", hAInternalStateException);
            throw hAInternalStateException;
        }
        if (!this.ivHostName.equals(coreGroupProcess.ivHostName)) {
            return true;
        }
        if (this.ivPort != coreGroupProcess.ivPort) {
            return true;
        }
        if (!this.ivEpIp.equals(coreGroupProcess.ivEpIp)) {
            return true;
        }
        boolean bl2 = MapUtils.compareMaps(this.ivCustomProperties, coreGroupProcess.ivCustomProperties);
        if (!bl2) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CoreGroupProcess : ");
        stringBuffer.append(this.ivProcessName);
        stringBuffer.append(", HostName ");
        stringBuffer.append(this.ivHostName);
        stringBuffer.append(", port ");
        stringBuffer.append(this.ivPort);
        stringBuffer.append(", endpoint IP");
        stringBuffer.append(this.ivEpIp);
        return stringBuffer.toString();
    }
}

