/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.CoreGroupProcess;
import com.ibm.ws.hamanager.runtime.config.ServerIndexNodeException;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.HAException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class CoreGroupProcessesV2
implements Externalizable {
    private static final TraceComponent TC = Tr.register(CoreGroupProcessesV2.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupProcessesV2.class.getName();
    private static final int svVersion = 1;
    private String ivCell;
    private HashMap ivProcesses = new HashMap();
    private String[] ivCoreGroupMembers;
    private String ivDmgrName = "";
    private Set ivNodeAgentNames;

    CoreGroupProcessesV2(String string, CoreGroup coreGroup, boolean bl) throws ServerIndexNodeException, HAException {
        this.ivCell = string;
        this.ivNodeAgentNames = new HashSet();
        ServerIndexParser serverIndexParser = new ServerIndexParser();
        EList eList = coreGroup.getCoreGroupServers();
        int n = eList.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            CoreGroupServer coreGroupServer = (CoreGroupServer)eList.get(i);
            String string2 = coreGroupServer.getNodeName();
            String string3 = coreGroupServer.getServerName();
            String string4 = HAMUtil.createFullyQualifiedServerName(string, string2, string3);
            HashMap hashMap = null;
            EList eList2 = coreGroupServer.getCustomProperties();
            if (eList2 != null) {
                hashMap = ConfigUtils.extractUntypedProperties((List)eList2);
            }
            try {
                NodeServer nodeServer = serverIndexParser.getServerIndexForServer(string2, string3);
                CoreGroupProcess coreGroupProcess = new CoreGroupProcess(string4, nodeServer.host, nodeServer.port, nodeServer.ip, hashMap);
                this.ivProcesses.put(coreGroupProcess.getProcessName(), coreGroupProcess);
                vector.addElement(string4);
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "Successfully processed server config", new Object[]{string4, coreGroupProcess});
                continue;
            }
            catch (ServerIndexNodeException serverIndexNodeException) {
                FFDCFilter.processException((Throwable)serverIndexNodeException, svClassName, "123", this);
                Tr.warning(TC, "HMGR0060", new Object[]{string3, string2});
                if (bl) continue;
                throw serverIndexNodeException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "130", this);
                Tr.error(TC, "HMGR0061", new Object[]{string3, string2, throwable});
                throw new HAException("Unrecoverable error in the coregroup document", throwable);
            }
        }
        this.ivCoreGroupMembers = new String[vector.size()];
        vector.toArray(this.ivCoreGroupMembers);
    }

    public CoreGroupProcessesV2() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivCell = objectInput.readUTF();
        this.ivDmgrName = objectInput.readUTF();
        this.ivProcesses = MapUtils.readMapFromStream(objectInput);
        this.ivCoreGroupMembers = StringUtils.readStringArrayFromStream(objectInput);
        this.ivNodeAgentNames = (Set)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeUTF(this.ivCell);
        objectOutput.writeUTF(this.ivDmgrName);
        MapUtils.writeMapToStream(objectOutput, this.ivProcesses);
        StringUtils.writeStringArrayToStream(objectOutput, this.ivCoreGroupMembers);
        objectOutput.writeObject(this.ivNodeAgentNames);
    }

    String[] getCoreGroupMembers() {
        return this.ivCoreGroupMembers;
    }

    CoreGroupProcess[] getCoreGroupProcesses() {
        int n = this.ivProcesses.size();
        CoreGroupProcess[] coreGroupProcessArray = new CoreGroupProcess[n];
        this.ivProcesses.values().toArray(coreGroupProcessArray);
        return coreGroupProcessArray;
    }

    CoreGroupProcess getCoreGroupProcess(String string) {
        return (CoreGroupProcess)this.ivProcesses.get(string);
    }

    boolean isDmgr(String string) {
        if (this.ivDmgrName == null) {
            return false;
        }
        return this.ivDmgrName.equals(string);
    }

    boolean isNodeAgent(String string) {
        return this.ivNodeAgentNames.contains(string);
    }

    boolean IsServerInCoreGroup(String string) {
        if (this.ivCoreGroupMembers == null) {
            return false;
        }
        int n = this.ivCoreGroupMembers.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.ivCoreGroupMembers[i])) continue;
            return true;
        }
        return false;
    }

    synchronized boolean merge(CoreGroupProcessesV2 coreGroupProcessesV2) throws HAException {
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{new Integer(this.ivProcesses.size()), new Integer(coreGroupProcessesV2.ivProcesses.size())};
            Tr.debug(TC, "merging core group process information", objectArray);
        }
        boolean bl = false;
        try {
            if (coreGroupProcessesV2.ivProcesses.size() != this.ivProcesses.size()) {
                bl = true;
            }
            Iterator iterator = this.ivProcesses.keySet().iterator();
            while (iterator.hasNext()) {
                CoreGroupProcess coreGroupProcess;
                String string = (String)iterator.next();
                if (!coreGroupProcessesV2.ivProcesses.containsKey(string)) {
                    bl = true;
                    continue;
                }
                CoreGroupProcess coreGroupProcess2 = (CoreGroupProcess)coreGroupProcessesV2.ivProcesses.get(string);
                boolean bl2 = coreGroupProcess2.merge(coreGroupProcess = (CoreGroupProcess)this.ivProcesses.get(string));
                if (bl2) {
                    bl = true;
                }
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "merging process", new Object[]{string, new Boolean(bl2)});
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "277", this);
            Tr.error(TC, "HMGR0083", new Object[]{"HAProcesses", throwable});
            throw new HAException("Error merging core group process information");
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "merged core group processes", new Boolean(bl));
        }
        if (bl) {
            this.ivProcesses = coreGroupProcessesV2.ivProcesses;
            this.ivCoreGroupMembers = coreGroupProcessesV2.ivCoreGroupMembers;
        }
        return bl;
    }

    class ServerIndexParser {
        private String DCS_UNICAST_ADDRESS = "DCS_UNICAST_ADDRESS";
        private String FILE_NAME = "serverindex.xml";
        private HashMap ivNodeMap = new HashMap();

        ServerIndexParser() {
        }

        NodeServer getServerIndexForServer(String string, String string2) throws ServerIndexNodeException {
            HashMap hashMap = this.getNodeEntry(string);
            NodeServer nodeServer = (NodeServer)hashMap.get(string2);
            if (nodeServer == null) {
                String string3 = "serverindex for node " + string + " does not contain server " + string2;
                throw new ServerIndexNodeException(string3, string);
            }
            return nodeServer;
        }

        private HashMap getNodeEntry(String string) throws ServerIndexNodeException {
            Object object;
            HashMap<String, NodeServer> hashMap = (HashMap<String, NodeServer>)this.ivNodeMap.get(string);
            if (hashMap != null) {
                return hashMap;
            }
            hashMap = new HashMap<String, NodeServer>();
            String string2 = "nodes/" + string + "/" + this.FILE_NAME;
            ServerIndex serverIndex = null;
            try {
                object = Config.getCellRelativeConfigDoc(string2);
                serverIndex = (ServerIndex)object.getContents().get(0);
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, svClassName, "396", this);
                throw new ServerIndexNodeException("Unable to read serverindex for node " + string, string);
            }
            if (serverIndex == null) {
                throw new ServerIndexNodeException("Unable to read serverindex for node " + string, string);
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Found serverindex for node", new Object[]{string, string2});
            }
            object = Config.expandVariables(serverIndex.getHostName());
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Parsing serverindex for node, found host", new Object[]{string, object});
            }
            EList eList = serverIndex.getServerEntries();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string4 = serverEntry.getServerName();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Parsing serverindex for node, server", new Object[]{string, string4});
                }
                if ((string3 = serverEntry.getServerType()).equals("DEPLOYMENT_MANAGER")) {
                    CoreGroupProcessesV2.this.ivDmgrName = HAMUtil.createFullyQualifiedServerName(CoreGroupProcessesV2.this.ivCell, string, string4);
                } else if (string3.equals("NODE_AGENT")) {
                    CoreGroupProcessesV2.this.ivNodeAgentNames.add(HAMUtil.createFullyQualifiedServerName(CoreGroupProcessesV2.this.ivCell, string, string4));
                }
                EList eList2 = serverEntry.getSpecialEndpoints();
                int n2 = eList2.size();
                boolean bl = false;
                int n3 = 0;
                String string5 = null;
                for (int j = 0; j < n2; ++j) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                    String string6 = namedEndPoint.getEndPointName();
                    if (!this.DCS_UNICAST_ADDRESS.equals(string6)) continue;
                    bl = true;
                    EndPoint endPoint = namedEndPoint.getEndPoint();
                    n3 = endPoint.getPort();
                    string5 = Config.expandVariables(endPoint.getHost());
                    if (string5 != null && !string5.equals("")) break;
                    string5 = object;
                    Object[] objectArray = new Object[]{string4, string, object};
                    Tr.warning(TC, "HMGR0063", objectArray);
                    break;
                }
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{string, string4, object, new Integer(n3), string5};
                    Tr.debug(TC, "Creating entry for node, server, hostName, port, IP", objectArray);
                }
                if (!bl) continue;
                NodeServer nodeServer = new NodeServer((String)object, n3, string5);
                hashMap.put(string4, nodeServer);
            }
            this.ivNodeMap.put(string, hashMap);
            return hashMap;
        }
    }

    private class NodeServer {
        String host;
        String ip;
        int port;

        NodeServer(String string, int n, String string2) {
            this.host = string;
            this.port = n;
            this.ip = string2;
        }
    }
}

