/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.TransportType;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackTransportType;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.HAException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

class CoreGroupTransport
implements Externalizable {
    private static final long serialVersionUID = -8530224260158913626L;
    private static final TraceComponent TC = Tr.register(CoreGroupTransport.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = CoreGroupTransport.class.getName();
    private static final int svVersion = 1;
    private CoreStackTransportType ivTransportType;
    private String ivChainName;
    private String ivSharedSecret;
    private int ivMultiCastPort;
    private String ivMultiCastGroupIpStart;
    private String ivMultiCastGroupIpEnd;
    private HashMap ivCustomProperties;

    CoreGroupTransport(String string, CoreGroup coreGroup) throws HAException {
        EList eList;
        this.ivChainName = coreGroup.getChannelChainName();
        if (this.ivChainName == null) {
            this.ivChainName = "";
        }
        this.ivSharedSecret = coreGroup.getCoreGroupUID();
        if (this.ivSharedSecret == null) {
            throw new HAException("A null CoreGroupUID field was found in the coregroup.xml");
        }
        this.ivMultiCastPort = coreGroup.getMultiCastPort();
        TransportType transportType = coreGroup.getTransportType();
        int n = transportType.getValue();
        switch (n) {
            case 0: {
                this.ivTransportType = CoreStackTransportType.CHANNEL_FW;
                break;
            }
            case 2: {
                this.ivTransportType = CoreStackTransportType.MULTICAST;
                break;
            }
            case 1: {
                this.ivTransportType = CoreStackTransportType.UNICAST;
                break;
            }
            default: {
                throw new HAException("invalid transport type " + n + " in coregroup.xml");
            }
        }
        this.ivMultiCastGroupIpStart = coreGroup.getMultiCastGroupIPStart();
        if (this.ivMultiCastGroupIpStart == null) {
            this.ivMultiCastGroupIpStart = "";
        }
        this.ivMultiCastGroupIpEnd = coreGroup.getMultiCastGroupIPEnd();
        if (this.ivMultiCastGroupIpEnd == null) {
            this.ivMultiCastGroupIpEnd = "";
        }
        if ((eList = coreGroup.getCustomProperties()) != null) {
            this.ivCustomProperties = ConfigUtils.extractUntypedProperties((List)eList);
        }
    }

    public CoreGroupTransport() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivTransportType = (CoreStackTransportType)objectInput.readObject();
        this.ivChainName = objectInput.readUTF();
        this.ivSharedSecret = objectInput.readUTF();
        this.ivMultiCastPort = objectInput.readInt();
        this.ivMultiCastGroupIpStart = objectInput.readUTF();
        this.ivMultiCastGroupIpEnd = objectInput.readUTF();
        this.ivCustomProperties = MapUtils.readMapFromStream(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.ivTransportType);
        objectOutput.writeUTF(this.ivChainName);
        objectOutput.writeUTF(this.ivSharedSecret);
        objectOutput.writeInt(this.ivMultiCastPort);
        objectOutput.writeUTF(this.ivMultiCastGroupIpStart);
        objectOutput.writeUTF(this.ivMultiCastGroupIpEnd);
        MapUtils.writeMapToStream(objectOutput, this.ivCustomProperties);
    }

    CoreStackTransportType getTransportType() {
        return this.ivTransportType;
    }

    String getChannelChainName() {
        return this.ivChainName;
    }

    String getSharedSecret() {
        return this.ivSharedSecret;
    }

    int getMultiCastPort() {
        return this.ivMultiCastPort;
    }

    String getMultiCastGroupIpStart() {
        return this.ivMultiCastGroupIpStart;
    }

    String getMultiCastGroupIpEnd() {
        return this.ivMultiCastGroupIpEnd;
    }

    HashMap getCoreGroupCustomProperties() {
        return this.ivCustomProperties;
    }
}

